/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.datasetflow;

import com.ez.graphs.viewer.callgraph.Activator;
import com.ez.graphs.viewer.callgraph.datasetflow.TSENodeComparator;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowResults;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowTSGraphBuilder;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetFlowGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetFlowGraphModel.class);
    private static final String SCREEN_OCCUR_ID_ATTRIBUTE = "ScreenOccurId Attribute";
    private static final String SCREEN_ID = "ScreenID attribute";
    private static final String BOUNDS = "Bounds";
    private static final String HAS_PROPERTIES_IN_PROPVIEW = "HAS_PROPERTIES_IN_PROPVIEW";
    private static final String VERTEX_ID = "VERTEX_ID";
    private static final String NODE_MAINFRAME = "Node_Mainframe";
    private static final String APPLICABLE_INPUT = "APPLICABLE_INPUT";
    private ProjectInfo ezsourcePrj;
    DSFlowResults flowResults;
    private Set<String> inputs;

    public DatasetFlowGraphModel(AnalysisGraphManager graphManager, ProjectInfo prjInfo) {
        this.graphManager = graphManager;
        this.ezsourcePrj = prjInfo;
    }

    public void setFlowResults(DSFlowResults flowResults) {
        this.flowResults = flowResults;
    }

    public void setInputs(Set<String> inputDSNames) {
        this.inputs = inputDSNames;
    }

    public void loadGraph(IProgressMonitor pMonitor) {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
        monitor.setTaskName(Messages.getString(DatasetFlowGraphModel.class, "loading.graph"));
        this.initGraph();
        Runnable stopCode = new Runnable(){

            @Override
            public void run() {
                if (monitor.isCanceled()) {
                    throw new CanceledException("DatasetFlow graph was canceled");
                }
            }
        };
        DSFlowTSGraphBuilder graphBuilder = new DSFlowTSGraphBuilder(stopCode, this.graphManager);
        graphBuilder.setProject(this.ezsourcePrj);
        graphBuilder.setEdgeTypes4Legend(this.edgeTypesSetForLegend);
        graphBuilder.setNodeTypes4Legend(this.nodeTypesSetForLegend);
        graphBuilder.setRestrictionNodes4Legend(this.restrictionTypesSetForLegend);
        try {
            boolean hasGraph = graphBuilder.fillTSGraph(this.inputs, this.flowResults, this.graph, this.outForGISV, (IProgressMonitor)monitor.newChild(100));
            if (!hasGraph) {
                L.debug("no dataset flow graph for inputNames: " + this.inputs);
            } else {
                this.cleanFlowResults();
            }
        }
        catch (CanceledException canceledException) {
            LogUtil.displayErrorMessage(null, (String)"Datasetflow graph was canceled", (String)"", (Plugin)Activator.getDefault(), (boolean)false);
            L.info("Datasetflow graph was canceled by user");
            this.cleanFlowResults();
        }
    }

    private void cleanFlowResults() {
        if (this.flowResults != null) {
            this.flowResults.clear();
            this.flowResults = null;
        }
    }

    private void initGraph() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute(APPLICABLE_INPUT)) {
            objType = (EZObjectType)gNode.getAttributeValue(APPLICABLE_INPUT);
        }
        return objType;
    }

    public void dispose() {
        this.ezsourcePrj = null;
        if (this.inputs != null) {
            this.inputs.clear();
            this.inputs = null;
        }
        this.cleanFlowResults();
        super.dispose();
    }

    void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        String newLine = System.getProperty("line.separator");
        String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
        try {
            FileWriter fw;
            File f;
            File firstProg;
            boolean found;
            if (!System.getProperty("test").trim().equals("")) {
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                fw = new FileWriter(pathToWrite, true);
                fw.write(newLine);
                fw.write("Program name :" + fileName);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
            } else {
                File file;
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
            }
            List graphNodes = graph.nodes();
            TSENodeComparator comparator = new TSENodeComparator();
            Collections.sort(graphNodes, comparator);
            for (TSENode node : graphNodes) {
                String name = node.getText();
                fw.write(newLine);
                fw.write(name);
                for (Object allAttrNames : node.getAttributeNames()) {
                    if (allAttrNames.toString().equals("FILE")) {
                        Set locations = (Set)node.getAttributeValue("FILE");
                        if (locations == null) continue;
                        for (TextSelectionInFile tsf : locations) {
                            fw.write(newLine);
                            fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                            fw.write(newLine);
                            fw.write("Program type :" + tsf.getPrgType());
                            fw.write(newLine);
                        }
                        continue;
                    }
                    if (allAttrNames.toString().trim().equals(SCREEN_OCCUR_ID_ATTRIBUTE) || allAttrNames.toString().trim().equals(SCREEN_ID) || allAttrNames.toString().trim().equals(BOUNDS) || allAttrNames.toString().trim().equals(HAS_PROPERTIES_IN_PROPVIEW) || allAttrNames.toString().trim().equals(VERTEX_ID) || allAttrNames.toString().trim().equals(NODE_MAINFRAME) || allAttrNames.toString().trim().equals(APPLICABLE_INPUT)) continue;
                    fw.write(newLine);
                    fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                }
                List inEdges = node.inEdges();
                fw.write(newLine);
                fw.write(newLine);
                fw.write("The in edges :");
                this.writeEdge(inEdges, node, fw);
                List outEdges = node.outEdges();
                fw.write(newLine);
                fw.write("The out edges :");
                this.writeEdge(outEdges, node, fw);
                fw.write(newLine);
            }
            fw.close();
        }
        catch (IOException iOException) {
            L.error("Couldn't write to file");
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (!stmtType.equals("")) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

