/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.datasetflow;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.datasetflow.DatasetFlowGraphModel;
import com.ez.graphs.viewer.callgraph.datasetflow.DatasetFlowGraphMouseActionsHook;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowModel;
import com.ez.graphs.viewer.odb.datasetflow.DSFlowResults;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.datasetflow.DSFlowEdgeLegendInfo;
import com.ez.mainframe.gui.datasetflow.DSFlowNodeLegendInfo;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetFlowGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetFlowGraphJob.class);
    private DatasetFlowGraphMouseActionsHook mouseActionsHook;
    private String tabName;
    public static final String DATASETS_INFO_FORWARD = "datasets_Info-Forward";
    public static final String DATASETS_INFO_BACKWARD = "datasets_Info-Backward";
    public static final String DATASETS_INPUT = "datasets_Input";
    public static final String DATASETS_INFO = "datasets_Info";
    private static final int MAXNAMES = 10;
    private DSFlowModel model;

    public DatasetFlowGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new DatasetFlowGraphMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new DatasetFlowGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new DatasetFlowGraphModel(new AnalysisGraphManager(), (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO"));
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel tsGraphModel, IProgressMonitor pmonitor) {
        L.debug("compute results");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)150);
        Collection c = (Collection)this.analysis.getContextValue("not selected datasets");
        if (c != null) {
            c.clear();
        }
        if ((c = (Collection)this.analysis.getContextValue("available resources")) != null) {
            c.clear();
        }
        Properties env = (Properties)this.analysis.getContextValue("env");
        OrientBaseGraph dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        Direction direction = (Direction)this.analysis.getContextValue("directed");
        Integer limitObj = (Integer)this.analysis.getContextValue("datasetflow threshold");
        List old = this.analysis.getContextListValue("selected resources");
        List inputs = BaseResourceInput4GUI.extractNonGUIObjects((Collection)old);
        try {
            Object path = this.analysis.getContextValue("selected path");
            if (path != null && !path.toString().trim().equals("")) {
                for (VSAMInput singleValue : inputs) {
                    ArrayList<VSAMInput> singleValList = new ArrayList<VSAMInput>();
                    singleValList.add(singleValue);
                    this.computeGraphModel((IProgressMonitor)monitor, dbg, direction, limitObj, singleValList, tsGraphModel);
                    tsGraphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                    TSEGraph newGraph = tsGraphModel.getGraph();
                    ((DatasetFlowGraphModel)tsGraphModel).writeGraphToFile(newGraph, singleValue.getListableName(), path.toString());
                    newGraph.dispose();
                }
            } else {
                this.computeGraphModel((IProgressMonitor)monitor, dbg, direction, limitObj, inputs, tsGraphModel);
            }
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
            dbg = null;
        }
    }

    private void computeGraphModel(IProgressMonitor pmonitor, OrientBaseGraph dbg, Direction direction, Integer limitObj, List<VSAMInput> inputs, AbstractAnalysisGraphModel tsGraphModel) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)150);
        this.analysis.addContextValue("selected resources", inputs);
        List excluded = this.analysis.getContextListValue("excluded datasets");
        List excludedInpts = null;
        Set excludedDSNames = null;
        if (excluded != null) {
            excludedInpts = BaseResourceInput4GUI.extractNonGUIObjects((Collection)excluded);
            excludedDSNames = DSFlowModel.prepareInputs((Collection)excludedInpts);
        }
        Set inputDSNames = DSFlowModel.prepareInputs(inputs);
        monitor.worked(50);
        boolean markOnlyExpandable = WorkspacePrefUtils.getPreferenceStore().getBoolean("graphHighlightedOnlyExpandableAtLimit");
        long start = System.currentTimeMillis();
        this.model = new DSFlowModel(dbg, inputDSNames, excludedDSNames, direction, limitObj);
        this.model.setMarkOnlyExpandable(markOnlyExpandable);
        DSFlowResults flowResults = this.model.doFlow(monitor);
        ((DatasetFlowGraphModel)tsGraphModel).setInputs(inputDSNames);
        ((DatasetFlowGraphModel)tsGraphModel).setFlowResults(flowResults);
        L.debug("computing time in {}", (Object)(System.currentTimeMillis() - start));
        monitor.setWorkRemaining(0);
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    private void addEntriesToLegend(LegendPanel legend) {
        Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend);
        this.addEdgesToLegend(legend);
        com.ez.gdb.core.utils.Utils.addRestrictionMarkersToLegend((LegendPanel)legend, (Set)this.graphModel.getRestrictionTypesForLegend());
    }

    private void addNodesToLegend(LegendPanel legend) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<DSFlowNodeLegendInfo>(){

            @Override
            public int compare(DSFlowNodeLegendInfo nodeType1, DSFlowNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (DSFlowNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            legend.placeLegendEntry(nodeLegendInfo.getColorboxImagePath(), nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<DSFlowEdgeLegendInfo>(){

            @Override
            public int compare(DSFlowEdgeLegendInfo edgeType1, DSFlowEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (DSFlowEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
    }

    public void closing() {
        if (this.mouseActionsHook != null) {
            this.mouseActionsHook.dispose();
            this.mouseActionsHook = null;
        }
        if (this.model != null) {
            this.model.dispose();
            this.model = null;
        }
        super.closing();
    }

    public class DatasetFlowGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public DatasetFlowGraphInfo(EZEntityID id) {
            super(id);
            SharedImages.registerImage((String)"datasetFlow", (String)"icons/datasetflow.png");
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage((String)"datasetFlow");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            StringBuilder inputsText = new StringBuilder();
            List inputs = DatasetFlowGraphJob.this.analysis.getContextListValue("input_list");
            String inputsCount = "";
            int idx = 0;
            int all = inputs.size();
            for (EZEntityID entity : inputs) {
                if (truncate && idx >= 10) {
                    inputsCount = String.valueOf(inputsCount) + (all - idx);
                    break;
                }
                ++idx;
                EZSourceDatasetIDSg datasetSg = (EZSourceDatasetIDSg)entity.getSegment(EZSourceDatasetIDSg.class);
                inputsText.append(datasetSg.getDatasetName());
                if (datasetSg.getDatasetMemberName() != null && !datasetSg.getDatasetMemberName().isEmpty()) {
                    inputsText.append("(");
                    inputsText.append(datasetSg.getDatasetMemberName());
                    inputsText.append(")");
                }
                if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                inputsText.append(", ");
            }
            if (inputsCount.equals("")) {
                DatasetFlowGraphJob.this.tabName = Messages.getString(DatasetFlowGraphJob.class, "tabName.more", new String[]{inputsText.toString(), inputsCount, DatasetFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
            } else {
                DatasetFlowGraphJob.this.tabName = Messages.getString(DatasetFlowGraphJob.class, "tabName", new String[]{inputsText.toString(), DatasetFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
            }
            return DatasetFlowGraphJob.this.tabName;
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(DatasetFlowGraphJob.this.tabName);
            Direction direction = (Direction)DatasetFlowGraphJob.this.analysis.getContextValue("directed");
            Integer limitObj = (Integer)DatasetFlowGraphJob.this.analysis.getContextValue("datasetflow threshold");
            if (limitObj != null && limitObj != -1) {
                if (direction != null) {
                    buf.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip.text.all", new String[]{direction.toString(), limitObj.toString()}));
                } else {
                    buf.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip.text.null.direction", new String[]{limitObj.toString()}));
                }
            } else if (direction != null) {
                buf.append(Messages.getString(DatasetFlowGraphJob.class, "tooltip.text.null.limit", new String[]{direction.toString()}));
            }
            return buf.toString();
        }

        public boolean hasLegend() {
            return true;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){
                private LegendPanel legend;

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    this.legend = new LegendPanel((Composite)sc, 0);
                    DatasetFlowGraphJob.this.addEntriesToLegend(this.legend);
                    sc.setContent((Control)this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    this.legend.pack();
                    sc.setMinSize(this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = this.legend.getSize().x;
                    int x = this.legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }
    }
}

