/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.cross;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.graphs.viewer.callgraph.api.PrjsCollector;
import com.ez.graphs.viewer.callgraph.api.ProjectInputGUI;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.wizard.MultiSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class CrossExtInputsFilter
extends AbstractProjectInputsFilter {
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(CrossExtInputsFilter.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        MultiSelectionPage selectProjsPage = new MultiSelectionPage("programs page", false);
        selectProjsPage.setResourcesCollector((ResourcesCollector)new PrjsCollector());
        selectProjsPage.setLeftGroupLabel(Messages.getString(CrossExtInputsFilter.class, "available.projects.label"));
        selectProjsPage.setTitle(Messages.getString(CrossExtInputsFilter.class, "page.title"));
        selectProjsPage.setDescription(Messages.getString(CrossExtInputsFilter.class, "page.description"));
        selectProjsPage.setErrMsgNoResource(Messages.getString(CrossExtInputsFilter.class, "err.message"));
        wizard.addPage((IWizardPage)selectProjsPage);
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        this.preparePrjsData(wizard, analysis);
    }

    protected void preparePrjsData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List prjs = (List)wizard.getValue("selected resources");
        HashSet<String> prjNames = new HashSet<String>();
        for (ProjectInputGUI pInfo : prjs) {
            prjNames.add(pInfo.getListableName());
        }
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        List projects = service.getProjects();
        ArrayList<ProjectInfo> selPrjs = new ArrayList<ProjectInfo>();
        for (ProjectInfo pInfo : projects) {
            if (prjNames.contains(pInfo.getName())) {
                selPrjs.add(pInfo);
            }
            if (selPrjs.size() == prjNames.size()) break;
        }
        analysis.addContextValue("input_list", selPrjs);
        analysis.addContextValue("input_project_names", prjNames);
    }
}

