/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.cross;

import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UEBasedGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsToPrj;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tinkerpop.blueprints.Vertex;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossExtGraphModel
extends UEBasedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossExtGraphModel.class);
    public static final String UE_BY_PRJ_KEY = "UE_BY_PRJ";
    private Map<String, ProjectInfo> prjInfos = new HashMap<String, ProjectInfo>();

    public CrossExtGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = analysis;
    }

    @Override
    protected void initGraph() {
        super.initGraph();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        this.prjInfos.clear();
        HashMap ueOutForGISV = new HashMap();
        this.graphManager.setAttribute("ue inventory", ueOutForGISV);
    }

    public List<TSEGraph> getGraphs() {
        ArrayList<TSEGraph> graphsList = new ArrayList<TSEGraph>();
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        Set childGraphs = (Set)this.graphManager.getAttributeValue("child_graphs");
        if (childGraphs != null) {
            graphsList.addAll(childGraphs);
        } else {
            graphsList.add(mainGraph);
        }
        return graphsList;
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        Map ueByPrj = (Map)this.analysis.getContextValue(UE_BY_PRJ_KEY);
        Map ue = (Map)this.analysis.getContextValue("ue map");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(20 + 10 * (ueByPrj.size() + ue.size())));
        monitor.setTaskName(Messages.getString(CrossExtGraphModel.class, "loading.graph"));
        this.initGraph();
        if (monitor.isCanceled()) {
            return;
        }
        List prjList = (List)this.graphManager.getAttributeValue("projects");
        for (ProjectInfo prj : prjList) {
            if (prj.isEclipse()) continue;
            String prjName = prj.getName();
            this.prjInfos.put(prjName, prj);
        }
        Set inputs = this.analysis.getContextSetValue("input_project_names");
        this.graphManager.setAttribute("markPrjAsInput", (Object)inputs);
        for (String prjName : ueByPrj.keySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.dbg = null;
            this.env = ConnectionUtils.getODBSettings((String)prjName);
            try {
                this.dbg = this.getOrientDbg();
            }
            catch (Exception exception) {
                L.warn("no graph database for the project reached by external calls : {} ", (Object)prjName);
                continue;
            }
            this.ezsourcePrj = this.prjInfos.get(prjName);
            UserExitsToPrj uePrj = (UserExitsToPrj)ueByPrj.get(prjName);
            HashSet<String> idsSet = new HashSet<String>();
            HashSet<Integer> prgSids = new HashSet<Integer>();
            HashSet<String> prgWithoutSid = new HashSet<String>();
            this.processCFExitsToPrj(prjName, uePrj, idsSet, prgSids, prgWithoutSid);
            if (!idsSet.isEmpty()) {
                this.drawGraph(prjName, idsSet, (IProgressMonitor)monitor.newChild(10));
            }
            this.drawTranToMappedPrg(prjName);
        }
        this.drawCrossPrjEdges((IProgressMonitor)monitor.newChild(10));
        if (this.graph.nodes().size() == 0) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
            L.debug("no results");
            return;
        }
        long time = System.currentTimeMillis();
        this.findAnnotations(monitor.newChild(10));
        L.debug("findAnnotations in " + (System.currentTimeMillis() - time) + " ms");
        monitor.setWorkRemaining(0);
    }

    @Override
    protected Map<String, TSENode> drawGraph(String prjName, Set<String> prgRids, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        monitor.setTaskName(Messages.getString(CrossExtGraphModel.class, "drawing.cg", new String[]{prjName}));
        if (prgRids.isEmpty()) {
            return null;
        }
        this.ezsourcePrj = this.prjInfos.get(prjName);
        this.cg = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)new EZSourceProjectIDSg(this.ezsourcePrj), (boolean)true);
        if (!this.cg.hasAttribute("TS nodes per project")) {
            this.cg.setAttribute("TS nodes per project", new HashMap());
        }
        HashMap<String, TSENode> pNodes = new HashMap<String, TSENode>();
        for (String prgRid : prgRids) {
            TSENode n = this.getOrCreateTSNode((Vertex)this.dbg.getVertex((Object)prgRid), null, true, programLevel);
            pNodes.put(prgRid, n);
        }
        return pNodes;
    }

    @Override
    protected boolean isGraphThruPrjs() {
        return true;
    }

    @Override
    public void dispose() {
        this.prjInfos = null;
        super.dispose();
    }
}

