/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.cross;

import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.PLIProgramNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.cross.CrossExtGraphModel;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallLocationType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.ExtCallTargetType;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.Target;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UEBasedGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UEMouseActionsHook;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsFromPrg;
import com.ez.graphs.viewer.callgraph.programcallgraph.ue.UserExitsToPrj;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.odb.ui.ResolutionBaseJob;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossExtGraphJob
extends ResolutionBaseJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossExtGraphJob.class);
    private static final String extResQuery = "select in('ResourceLink')[0].@class as usageClass, name, location, locationType, type, $pr.asList().asString() as pRids, $ps.asList().asString() as stmts\n from ExtCFProxy let $pr = in('ResourceLink').prgRid,\n $ps = in('ResourceLink').in('Uses') ";
    private static final String extResQueryBack = "select in('ResourceLink')[0].@class as usageClass, name, location, locationType, type, $pr.asList().asString() as pRids, $ps.asList().asString() as stmts\n from ExtCFProxy let $pr = in('ResourceLink').prgRid,\n $ps = in('ResourceLink').in('Uses') where locationType = 2 or (locationType = 1 and location in [@@@@@EZLEGACY@@@@])";

    public CrossExtGraphJob(EZEntityID ezId) {
        super(ezId);
        this.initGraphDetails();
        this.mouseActionsHook = new UEMouseActionsHook(ezId, (GraphAnalysisJob)this);
        this.initContentProviders();
    }

    protected void initGraphDetails() {
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.graphModel = new CrossExtGraphModel(new AnalysisGraphManager(), this.analysis);
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((com.ez.workspace.analysis.graph.model.GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        monitor.setTaskName(Messages.getString(CrossExtGraphJob.class, "collectingData.taskName"));
        super.computeResults(model, (IProgressMonitor)monitor.newChild(50));
        this.graphManager.setAttribute("projects", this.analysis.getContextValue("projects"));
        this.graphManager.setAttribute("Projects_TS_map", new HashMap());
        HashMap<String, Map<String, UserExitsFromPrg>> ue = new HashMap<String, Map<String, UserExitsFromPrg>>();
        this.analysis.addContextValue("ue map", ue);
        HashMap<String, UserExitsToPrj> ueByPrj = new HashMap<String, UserExitsToPrj>();
        HashMap<Pair<String, ExtCallTargetType>, Map<Pair<String, String>, Set<String>>> ueByCicsReg = new HashMap<Pair<String, ExtCallTargetType>, Map<Pair<String, String>, Set<String>>>();
        Set<ExtCallTargetType> ttypes = this.processExtCalls(ueByPrj, ueByCicsReg, true, monitor.newChild(25));
        HashMap<Pair<String, ExtCallTargetType>, Map<Pair<String, String>, Set<String>>> ueByCicsReg_b = new HashMap<Pair<String, ExtCallTargetType>, Map<Pair<String, String>, Set<String>>>();
        Set<ExtCallTargetType> ttypes_b = this.processExtCalls(ueByPrj, ueByCicsReg_b, false, monitor.newChild(25));
        if (!monitor.isCanceled() && ueByCicsReg.size() + ueByCicsReg_b.size() > 0) {
            ExtCallTargetType ttype;
            String currentPrjName;
            HashMap<ExtCallTargetType, Map<Pair<String, String>, Set<String>>> allCicsReg = new HashMap<ExtCallTargetType, Map<Pair<String, String>, Set<String>>>();
            ttypes.addAll(ttypes_b);
            for (ExtCallTargetType ttype2 : ttypes) {
                allCicsReg.put(ttype2.getLabelForCICSInfo(), new HashMap());
            }
            ((UEBasedGraphModel)model).searchCICSRegions(allCicsReg, monitor.newChild(50));
            for (Pair key : ueByCicsReg.keySet()) {
                if (monitor.isCanceled()) break;
                currentPrjName = (String)key.getFirst();
                ttype = (ExtCallTargetType)((Object)key.getSecond());
                GraphUtils.translateCICSRegToPrj(currentPrjName, ttype, allCicsReg, (Map)ueByCicsReg.get(key), ueByPrj, ue);
            }
            for (Pair key : ueByCicsReg_b.keySet()) {
                if (monitor.isCanceled()) break;
                currentPrjName = (String)key.getFirst();
                ttype = (ExtCallTargetType)((Object)key.getSecond());
                Set inputs = this.analysis.getContextSetValue("input_project_names");
                GraphUtils.translateCICSRegToPrj(currentPrjName, ttype, allCicsReg, (Map)ueByCicsReg_b.get(key), ueByPrj, ue, inputs);
            }
        }
        this.analysis.addContextValue("UE_BY_PRJ", ueByPrj);
        monitor.setWorkRemaining(0);
    }

    private Set<ExtCallTargetType> processExtCalls(Map<String, UserExitsToPrj> ueByPrj, Map<Pair<String, ExtCallTargetType>, Map<Pair<String, String>, Set<String>>> ueByCicsReg, boolean forward, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CrossExtGraphJob.class, "process.extcall.task"));
        HashSet<ExtCallTargetType> ttypes = new HashSet<ExtCallTargetType>();
        long startTime = System.currentTimeMillis();
        if (!monitor.isCanceled()) {
            HashSet<String> start = new HashSet<String>();
            Set inputs = this.analysis.getContextSetValue("input_project_names");
            if (forward) {
                start.addAll(inputs);
            } else {
                List prjList = (List)this.graphManager.getAttributeValue("projects");
                IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
                for (ProjectInfo pi : prjList) {
                    if (pi.isEclipse() || inputs.contains(pi.getName()) || service == null) continue;
                    boolean ok = service.hasDatabase(pi.getName());
                    if (!ok) {
                        L.warn("can't access gdb for project {}", (Object)pi.getName());
                        GraphsErrorLog.warn((String)Messages.getString(CrossExtGraphJob.class, "gdb.not.found", new String[]{pi.getName()}), null);
                        continue;
                    }
                    start.add(pi.getName());
                }
            }
            StringBuilder prjsSb = forward ? null : com.ez.gdb.core.utils.Utils.makeStringBuilder((Set)inputs, (boolean)true);
            L.debug("will open {} projects ", (Object)start.size());
            for (String prjName : start) {
                if (monitor.isCanceled()) break;
                Properties env = ConnectionUtils.getODBSettings((String)prjName);
                OrientBaseGraph dbg = null;
                try {
                    try {
                        dbg = ConnectionUtils.getNoTxGraph((Properties)env);
                        String query = null;
                        query = forward ? extResQuery : extResQueryBack.replace("@@@@@EZLEGACY@@@@", prjsSb);
                        CloseableIterable res = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
                        for (OrientElement elem : res) {
                            ExtCallLocationType locationType = ExtCallLocationType.getLocType((Integer)elem.getProperty("locationType"));
                            String loc = (String)elem.getProperty("location");
                            String uClass = (String)elem.getProperty("usageClass");
                            Integer pType = (Integer)elem.getProperty("type");
                            ExtCallTargetType ttype = GraphUtils.getExtCallType(uClass, null);
                            if (pType != null && ttype.equals((Object)ExtCallTargetType.PROGRAM)) {
                                ttype = ProgramType.COBOL.getProgramTypeId() == pType.intValue() ? ExtCallTargetType.PROGRAM_COBOL : ExtCallTargetType.PROGRAM_PLI;
                            }
                            String name = (String)elem.getProperty("name");
                            String prgsStr = (String)elem.getProperty("pRids");
                            String stmtsStr = (String)elem.getProperty("stmts");
                            this.collectSourcePrgs(prjName, loc, name, ttype, locationType, prgsStr, stmtsStr);
                            if (ExtCallLocationType.APPLICATION.equals((Object)locationType)) {
                                L.debug("location {} is a project", (Object)loc);
                                if (prjName.equalsIgnoreCase(loc)) {
                                    L.warn("skip location {} within the same project as external call", (Object)loc);
                                    continue;
                                }
                                UserExitsToPrj ue = ueByPrj.get(loc);
                                if (ue == null) {
                                    ue = new UserExitsToPrj(loc);
                                    ueByPrj.put(loc, ue);
                                }
                                ue.addTarget(ttype, "'" + name + "'");
                                continue;
                            }
                            L.debug("location {} is a CICS region", (Object)loc);
                            ttypes.add(ttype);
                            Pair key = new Pair((Object)prjName, (Object)ttype);
                            Map<Pair<String, String>, Set<String>> cicsRegWithType = ueByCicsReg.get(key);
                            if (cicsRegWithType == null) {
                                cicsRegWithType = new HashMap<Pair<String, String>, Set<String>>();
                                ueByCicsReg.put((Pair<String, ExtCallTargetType>)key, cicsRegWithType);
                            }
                            cicsRegWithType.put((Pair<String, String>)new Pair((Object)loc, (Object)name), new HashSet());
                        }
                    }
                    catch (Exception e) {
                        L.error("while accesing graph db for project " + prjName, (Throwable)e);
                        GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
                        if (dbg != null) {
                            ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                        }
                        dbg = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (dbg != null) {
                        ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                    }
                    dbg = null;
                    throw throwable;
                }
                if (dbg != null) {
                    ConnectionUtils.releaseGraph((OrientBaseGraph)dbg, (Properties)env);
                }
                dbg = null;
            }
        }
        L.debug("end search external calls in {} ms for {}", (Object)(System.currentTimeMillis() - startTime), (Object)(forward ? "forward" : "backward"));
        return ttypes;
    }

    private Set<String> getPrgRids(String prgsStr) {
        HashSet<String> rids = new HashSet<String>();
        if (prgsStr.length() > 2) {
            String[] prgs;
            String[] stringArray = prgs = prgsStr.substring(1, prgsStr.length() - 1).split(", ");
            int n = prgs.length;
            int n2 = 0;
            while (n2 < n) {
                String pRid = stringArray[n2];
                rids.add(pRid);
                ++n2;
            }
        }
        return rids;
    }

    private void collectSourcePrgs(String prjName, String loc, String name, ExtCallTargetType ttype, ExtCallLocationType locType, String prgsStr, String stmts) {
        Map targetsPerPrj = (Map)this.analysis.getContextValue("ue map");
        String[] prids = prgsStr.substring(1, prgsStr.length() - 1).split(", ");
        String[] srids = stmts.substring(1, stmts.length() - 1).split(", ");
        int i = 0;
        while (i < prids.length) {
            UserExitsFromPrg ue;
            HashMap<String, UserExitsFromPrg> ueprg = (HashMap<String, UserExitsFromPrg>)targetsPerPrj.get(prjName);
            if (ueprg == null) {
                ueprg = new HashMap<String, UserExitsFromPrg>();
                targetsPerPrj.put(prjName, ueprg);
            }
            if ((ue = (UserExitsFromPrg)ueprg.get(prids[i])) == null) {
                ue = new UserExitsFromPrg(prjName, prids[i]);
                ueprg.put(prids[i], ue);
            }
            Target tgt = new Target(name, ttype, loc, locType, null);
            tgt.addStmt(srids[i]);
            ue.addTarget(tgt);
            ++i;
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor pmonitor, IStatus result) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CallGraphJob.class, "dolayout.taskName"));
        new GraphAnalysisJob.CollapseAllAction((GraphAnalysisJob)this).execute((IProgressMonitor)monitor.newChild(10));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)monitor, result);
        if (this.gfi != null) {
            this.addFilters(this.gfi);
            HashSet allNodes = new HashSet();
            List graphs = this.graphModel.getGraphs();
            for (TSEGraph gr : graphs) {
                allNodes.addAll(gr.nodes());
            }
            if (this.graphModel != null) {
                this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
            }
        }
        monitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        Utils.addMainframeNodesToLegend((LegendPanel)legend, (int)uiStyle, (boolean)false, (Set)this.graphModel.getNodeTypesForLegend());
        this.addEdgesToLegend(legend);
        com.ez.gdb.core.utils.Utils.addRestrictionMarkersToLegend((LegendPanel)legend, (Set)this.graphModel.getRestrictionTypesForLegend());
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(PLIProgramNode.class);
        gfi.registerFilterType(TransactionNode.class);
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;

        public GraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage((String)"programCallgraph", (String)"icons/programcall.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage((String)"programCallgraph");
            }
            return this.image;
        }

        public String getText() {
            this.text = this.getText(true);
            return super.getText();
        }

        public String getText(boolean truncate) {
            String txt = CrossExtGraphJob.this.analysis.getContextValue("input_project_names").toString();
            return Messages.getString(CrossExtGraphJob.class, "tab.name", new String[]{txt.substring(1, txt.length() - 1)});
        }

        public String getTooltip() {
            return this.text;
        }

        public ComponentBuilderInterface getLegendControl() {
            ComponentBuilderInterface cbi = new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CrossExtGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    Utils.setImageProvider((LegendPanel)CrossExtGraphJob.this.legend);
                    int uiStyle = CrossExtGraphJob.this.graphModel.getUIStyle();
                    CrossExtGraphJob.this.addEntriesToLegend(CrossExtGraphJob.this.legend, uiStyle, GraphInfo.this.gfi);
                    sc.setContent((Control)CrossExtGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CrossExtGraphJob.this.legend.pack();
                    sc.setMinSize(CrossExtGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CrossExtGraphJob)((GraphInfo)GraphInfo.this).CrossExtGraphJob.this).legend.getSize().x;
                    int x = ((CrossExtGraphJob)((GraphInfo)GraphInfo.this).CrossExtGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
            return cbi;
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            if (CrossExtGraphJob.this.legend != null) {
                CrossExtGraphJob.this.legend.dispose();
                CrossExtGraphJob.this.legend = null;
            }
            super.dispose();
        }
    }
}

