/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.cross;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.cross.CrossExtGraphJob;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossExtGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossExtGraphAnalysis.class);
    protected CrossExtGraphJob job = null;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CrossExtGraphJob)wk.getJob(id, CrossExtGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public void setInputs(List inputs) {
        if (inputs != null) {
            ArrayList<ProjectInfo> list = new ArrayList<ProjectInfo>();
            HashSet<String> prjNames = new HashSet<String>();
            String prjName = null;
            for (Object inpObj : inputs) {
                if (!(inpObj instanceof EZSourceProjectInputType)) continue;
                prjName = ((EZSourceProjectInputType)inpObj).getName();
                prjNames.add(prjName);
                ProjectInfo pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                list.add(pi);
            }
            this.addContextValue("input_project_names", prjNames);
            this.addContextValue("input_list", list);
        }
    }

    public String getLabelType() {
        return Messages.getString(CrossExtGraphAnalysis.class, "properties.labelType");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_GDB_CROSS_CALLGRAPH_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        this.getContextListValue("input_list");
        InputsFilter iFilter = null;
        return iFilter;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            Set inputs1 = this.getContextSetValue("input_project_names");
            Set inputs2 = a2.getContextSetValue("input_project_names");
            ret = this.type.equals((Object)a2.getType()) && inputs1.equals(inputs2);
        }
        return ret;
    }
}

