/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.api;

import com.ez.graphs.viewer.callgraph.api.ProjectInputGUI;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectProjectPage
extends SingleSelectionPage<ProjectInputGUI> {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Button limitCgButton;
    private Text thresholdLimit;
    private static final String errorMsg = Messages.getString(SelectProjectPage.class, "level.thresold.error");
    private String limitGroupButtonText = null;
    private String limitGraphLblText = null;

    public SelectProjectPage(String pageName, boolean useFilters) {
        super(pageName, useFilters);
    }

    protected void createContent(Composite composite) {
        super.createContent(composite);
        this.createLimitGroup(composite);
    }

    private void createLimitGroup(Composite parent) {
        Group limitGroup = new Group(parent, parent.getStyle());
        if (this.limitGroupButtonText != null) {
            limitGroup.setText(this.limitGroupButtonText);
        } else {
            limitGroup.setText(Messages.getString(SelectProjectPage.class, "limit.group.txt"));
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalIndent = 50;
        data.minimumWidth = 80;
        limitGroup.setLayoutData((Object)data);
        FormLayout fl = new FormLayout();
        fl.marginWidth = 10;
        fl.marginHeight = 10;
        limitGroup.setLayout((Layout)fl);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.limitCgButton = new Button((Composite)limitGroup, 32);
        if (this.limitGraphLblText != null) {
            this.limitCgButton.setText(this.limitGraphLblText);
        } else {
            this.limitCgButton.setText(Messages.getString(SelectProjectPage.class, "limit.cg.btn.txt"));
        }
        FormData fdata = new FormData();
        fdata.left = new FormAttachment(5, 0);
        fdata.bottom = new FormAttachment(100, -5);
        this.limitCgButton.setLayoutData((Object)fdata);
        this.limitCgButton.addSelectionListener((SelectionListener)new ChoiceSelection());
        this.limitCgButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimit = new Text((Composite)limitGroup, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        fdata = new FormData();
        fdata.left = new FormAttachment((Control)this.limitCgButton, 5);
        fdata.bottom = new FormAttachment(100, -5);
        fdata.right = new FormAttachment(100, -5);
        fdata.width = 120;
        this.thresholdLimit.setLayoutData((Object)fdata);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectPage.this.catchThresholdLimit();
                SelectProjectPage.this.setPageComplete(SelectProjectPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
    }

    private void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", (Object)threshold);
            }
        }
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isCgLimited = SelectProjectPage.this.limitCgButton.getSelection();
            SelectProjectPage.this.wizard.set("is graph limited", (Object)isCgLimited);
            SelectProjectPage.this.thresholdLimit.setEnabled(isCgLimited);
            if (isCgLimited) {
                SelectProjectPage.this.catchThresholdLimit();
            } else {
                SelectProjectPage.this.wizard.set("limit number for graph levels", null);
                SelectProjectPage.this.setErrorMessage(null);
            }
            SelectProjectPage.this.setPageComplete(SelectProjectPage.this.isPageComplete());
        }
    }
}

