/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.api;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.gdb.core.analysis.GdbFilterUtils;
import com.ez.graphs.viewer.callgraph.api.ProjectInputGUI;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrjsCollector
implements ResourcesCollector {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(PrjsCollector.class);

    public List collect(boolean useFilters, Set apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        ArrayList<ProjectInputGUI> prjs = new ArrayList<ProjectInputGUI>();
        IProjectsService prjServs = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        if (prjServs != null) {
            List allProjects = prjServs.getProjects();
            if (allProjects != null && !allProjects.isEmpty()) {
                ArrayList<String> projects = new ArrayList<String>();
                for (ProjectInfo pinfo : allProjects) {
                    projects.add(pinfo.getName());
                }
                List filtered = GdbFilterUtils.checkDefinition(projects);
                if (filtered != null) {
                    for (String name : filtered) {
                        prjs.add(new ProjectInputGUI(new ProjectInputGUI.ProjectInput(name)));
                    }
                    if (filtered.isEmpty()) {
                        L.warn("no projects filtered from GraphDB filter!");
                    }
                } else {
                    L.warn("no projects filtered from GraphDB filter; most probaly your ODB service it's not working!");
                }
            } else {
                L.warn("no projects found!");
            }
        } else {
            L.error("cannot access projects service");
        }
        return prjs;
    }

    public List getAvailableImages() {
        return null;
    }
}

