/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.api;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.callgraph.api.PrjsCollector;
import com.ez.graphs.viewer.callgraph.api.ProjectInputGUI;
import com.ez.graphs.viewer.callgraph.api.SelectProjectPage;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class APICallgraphInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(APICallgraphInputsFilter.class, "wizard.title");
            wizard.setWindowTitle(wizardName);
            SelectProjectPage selectProjsPage = new SelectProjectPage("programs page", false);
            selectProjsPage.setResourcesCollector(new PrjsCollector());
            selectProjsPage.setLeftGroupLabel(Messages.getString(APICallgraphInputsFilter.class, "available.projects.label"));
            selectProjsPage.setTitle(Messages.getString(APICallgraphInputsFilter.class, "page.title"));
            selectProjsPage.setDescription(Messages.getString(APICallgraphInputsFilter.class, "page.description"));
            selectProjsPage.setErrMsgNoResource(Messages.getString(APICallgraphInputsFilter.class, "err.message"));
            wizard.addPage((IWizardPage)selectProjsPage);
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        this.preparePrjsData(wizard, analysis);
        String key = "is graph limited";
        analysis.addContextValue(key, wizard.getValue(key));
        key = "limit number for graph levels";
        analysis.addContextValue(key, wizard.getValue(key));
        analysis.addContextValue("graph direction: forward or backward or both", (Object)Direction.FORWARD);
    }

    private void preparePrjsData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List prjs = (List)wizard.getValue("selected resources");
        String prjName = ((ProjectInputGUI)((Object)prjs.get(0))).getObject().getName();
        analysis.addContextValue("input_project_names", (Object)prjName);
        ProjectInfo pi = null;
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        List projects = service.getProjects();
        for (ProjectInfo pInfo : projects) {
            if (pi != null) break;
            if (!pInfo.getName().equals(prjName)) continue;
            pi = pInfo;
            break;
        }
        analysis.addContextValue("PROJECT_INFO", pi);
        analysis.addContextValue("env", (Object)ConnectionUtils.getODBSettings((String)prjName));
    }
}

