/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.callgraph.api;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.callgraph.api.APICallgraphInputsFilter;
import com.ez.graphs.viewer.callgraph.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphJob;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.CatalogAPIInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APICallgraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(APICallgraphAnalysis.class);
    CallGraphJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CallGraphJob)wk.getJob(id, CallGraphJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public void setInputs(List inputs) {
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        if (inputs != null) {
            for (Object inpObj : inputs) {
                EZEntityID id;
                CatalogAPISg sg;
                if (!(inpObj instanceof CatalogAPIInputType) || (sg = (CatalogAPISg)(id = ((CatalogAPIInputType)inpObj).getEntID()).getSegment(CatalogAPISg.class)) == null) continue;
                sg.getNode();
                list.add(id);
            }
            if (!list.isEmpty()) {
                this.addContextValue("input_list", list);
            }
        }
        this.addContextValue("API_CALLGRAPH", Boolean.TRUE);
        Boolean showOtherPrj = WorkspacePrefUtils.getPreferenceStore().getBoolean("showCgOtherPrj");
        this.addContextValue("continueCG_otherPrj_analysis", showOtherPrj);
    }

    public void addContextValue(String key, Object value) {
        if ("projects".equals(key) && value == null) {
            IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
            if (service != null) {
                List allProjects = service.getProjects();
                if (allProjects != null && !allProjects.isEmpty()) {
                    Collections.sort(allProjects);
                    super.addContextValue(key, (Object)allProjects);
                } else {
                    L.warn("null list of projects!");
                }
            } else {
                L.warn("IProjectsService not found! Cannot load projects list");
            }
        } else {
            super.addContextValue(key, value);
        }
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZ_API_CALLGRAPH_ANALYSIS;
    }

    public String getLabelType() {
        return Messages.getString(APICallgraphAnalysis.class, "properties.analysisname");
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected InputsFilter getInputsFilter() {
        APICallgraphInputsFilter iFilter = null;
        this.getContextListValue("input_list");
        iFilter = new APICallgraphInputsFilter();
        return iFilter;
    }

    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            ProjectInfo pi2;
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            ProjectInfo pi1 = (ProjectInfo)this.getContextValue("PROJECT_INFO");
            ret = pi1.equals((Object)(pi2 = (ProjectInfo)a2.getContextValue("PROJECT_INFO")));
            if (ret) {
                Boolean limitResources;
                Boolean isLimited1 = (Boolean)this.getContextValue("is graph limited");
                isLimited1 = isLimited1 == null ? false : isLimited1;
                Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
                if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                    ret = false;
                }
                limitResources = (limitResources = (Boolean)this.getContextValue("graph without resources")) == null ? false : limitResources;
                Boolean limitResources1 = (Boolean)a2.getContextValue("graph without resources");
                if (!limitResources.equals(limitResources1 = Boolean.valueOf(limitResources1 == null ? false : limitResources1))) {
                    ret = false;
                }
                if (!limitResources.booleanValue()) {
                    Map r1 = (Map)this.getContextValue("graph resources checked or not");
                    Map r2 = (Map)a2.getContextValue("graph resources checked or not");
                    if (r1 == null || r2 == null || !r1.values().toString().equals(r2.values().toString())) {
                        return false;
                    }
                }
                if (ret && isLimited1.booleanValue()) {
                    Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
                    Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
                    if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                        ret = false;
                    }
                }
                if (ret) {
                    Boolean showOtherPrj = (Boolean)this.getContextValue("continueCG_otherPrj_analysis");
                    ret = showOtherPrj.equals(a2.getContextValue("continueCG_otherPrj_analysis"));
                }
            }
        }
        return ret;
    }
}

