/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.idz.cics.ia.ui.actions;

import com.ez.rdz.resources.mainframe.analysis.CICSProgramIdentifier;
import com.ez.rdz.resources.mainframe.analysis.IResourceIdentifier;
import com.ez.rdz.resources.mainframe.analysis.RDZMainframeAnalysisJob;
import com.ez.rdz.utils.Messages;
import com.ibm.cics.eclipse.common.historical.IHistoricalProgram;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowCICSProgramAD
implements IObjectActionDelegate {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ShowCICSProgramAD.class);
    private Set<IResourceIdentifier> rdzResourceIdentifiers = new LinkedHashSet<IResourceIdentifier>();

    public void run(IAction arg0) {
        if (!this.rdzResourceIdentifiers.isEmpty()) {
            new RDZMainframeAnalysisJob(Messages.getString(ShowCICSProgramAD.class, (String)"job.rdzAnalysis.name"), this.rdzResourceIdentifiers).schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.rdzResourceIdentifiers = ShowCICSProgramAD.getADIdentifiers(selection);
    }

    public static Set<IResourceIdentifier> getADIdentifiers(ISelection selection) {
        LinkedHashSet<IResourceIdentifier> rdzResourceIdentifiers = new LinkedHashSet<IResourceIdentifier>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection currentSelection = (IStructuredSelection)selection;
            for (Object item : currentSelection) {
                L.debug("\t------> {}", item.getClass());
                Object adapter = Platform.getAdapterManager().getAdapter(item, IHistoricalProgram.class);
                IHistoricalProgram cicsProgram = null;
                if (item instanceof IHistoricalProgram) {
                    cicsProgram = (IHistoricalProgram)item;
                } else if (adapter != null) {
                    cicsProgram = (IHistoricalProgram)adapter;
                }
                if (cicsProgram != null) {
                    String prgName = cicsProgram.getProgram();
                    if (prgName != null && !prgName.isEmpty()) {
                        rdzResourceIdentifiers.add((IResourceIdentifier)new CICSProgramIdentifier(prgName));
                        continue;
                    }
                    L.debug("empty program name in selection: {}", item);
                    continue;
                }
                L.debug("no IHistoricalProgram found for selection: {}", item);
            }
        }
        return rdzResourceIdentifiers;
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

