/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.base.mainframe.project;

import com.ez.analysis.base.Activator;
import com.ez.analysis.base.internal.Messages;
import com.ez.analysis.base.project.ProjectInfoConfigurator;
import com.ez.analysis.base.project.ProjectProvider;
import com.ez.internal.model.IMFProjectsServiceFacade;
import com.ez.internal.model.MFProjListChangedListener;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.utils.ProjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeProjectProvider
implements ProjectProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeProjectProvider.class);

    public void loadProjects(List<ProjectInfo> projects, ProjectInfoConfigurator pic, IProgressMonitor pMonitor) {
        block8: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
            monitor.subTask(Messages.getString(MainframeProjectProvider.class, (String)"loading.projects.task.name"));
            try {
                IMFProjectsServiceFacade projectsService = (IMFProjectsServiceFacade)ServiceUtils.getService(IMFProjectsServiceFacade.class);
                List ezsprjs = projectsService.allAvailableProjects((IProgressMonitor)monitor.newChild(30));
                if (ezsprjs == null) break block8;
                ArrayList<String> projs = new ArrayList<String>();
                for (String[] arr : ezsprjs) {
                    projs.add(arr[0]);
                }
                monitor.setWorkRemaining(ezsprjs.size());
                for (String projName : projs) {
                    if (!monitor.isCanceled()) {
                        monitor.setTaskName(Messages.getString(MainframeProjectProvider.class, (String)"loading.proj.task.name", (Object[])new String[]{projName}));
                        if (!projName.isEmpty()) {
                            ProjectInfo pi = new ProjectInfo();
                            pi.setInfo(projectsService.getProjectInfo(projName, (IProgressMonitor)monitor.newChild(1)));
                            if (pi.getInfo() == null) {
                                LogUtil.displayErrorMessage((Status)new Status(2, "com.ez.analysis.base", 2, Messages.getString(MainframeProjectProvider.class, (String)"status.error.message", (Object[])new String[]{projName}), null), (boolean)false);
                                continue;
                            }
                            pi.setType(ProjectUtils.getProjectType((Map)pi.getInfo()));
                            pi.setEclipse(false);
                            pi.setName(projName);
                            pi.setDescription(pi.getInform());
                            pi.setDescription(pi.getDescription() == null ? "" : pi.getDescription());
                            pi.setMetadataKeys(ProjectUtils.getProjectMetadataKeys((Map)pi.getInfo()));
                            pi.setMetadataTable(ProjectUtils.getProjectMetadataTable((Map)pi.getInfo()));
                            if (pic != null) {
                                pic.configure(pi);
                            }
                            projects.add(pi);
                            continue;
                        }
                        monitor.worked(1);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                LogUtil.displayErrorMessage((Throwable)t, (String)Messages.getString(MainframeProjectProvider.class, (String)"connection.error.message"), (String)Messages.getString(MainframeProjectProvider.class, (String)"error.message.title"), (Plugin)Activator.getDefault(), (boolean)true);
            }
        }
    }

    public ProjectInfo createInfo(Object input, ProjectInfoConfigurator pic) {
        return null;
    }

    public void identityChanged() {
        L.debug("before call service facade for identityChanged");
        IMFProjectsServiceFacade projectsService = (IMFProjectsServiceFacade)ServiceUtils.getService(IMFProjectsServiceFacade.class);
        projectsService.identityChanged();
    }

    public void addListener(MFProjListChangedListener listChangedListener) {
        IMFProjectsServiceFacade projectsService = (IMFProjectsServiceFacade)ServiceUtils.getService(IMFProjectsServiceFacade.class);
        projectsService.addPrjListListener(listChangedListener);
    }
}

