/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ezdao.api;

import com.ez.ezdao.api.DatabaseInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInfoBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger logger = LoggerFactory.getLogger(DatabaseInfoBuilder.class);
    public static final String DATA_SOURCE_KEY = "Data Source";
    public static final String DATA_SOURCE_INTEGRATED_SECURITY_KEY = "Integrated Security";
    public static final String DATA_SOURCE_INTEGRATED_SECURITY_VALUE = "SSPI";
    public static final String s1 = "([^;]+)(?:=([^;]*))";
    public static final Pattern PATTERN_ITEM = Pattern.compile("([^;]+)(?:=([^;]*))");
    public static final String s2 = "([^;]+)(?:=\"([^\"]*))\"";
    public static final Pattern PATTERN_ITEM_DQ = Pattern.compile("([^;]+)(?:=\"([^\"]*))\"");
    public static final String s3 = "([^;]+)(?:='([^']*))'";
    public static final Pattern PATTERN_ITEM_SQ = Pattern.compile("([^;]+)(?:='([^']*))'");
    public static final Pattern PATTERN_DATA_SOURCE = Pattern.compile("([^\\\\,]+)(?:\\\\([^,]+))?(?:,(\\d+))?");
    private DatabaseInfo di;

    public static DatabaseInfoBuilder fromConnectionString(String connectionString) {
        return DatabaseInfoBuilder.fromConnectionString(null, connectionString);
    }

    public static DatabaseInfoBuilder fromConnectionString(String serverType, String connectionString) {
        if (connectionString == null) {
            throw new IllegalArgumentException("connectionString");
        }
        DatabaseInfo dbi = DatabaseInfoBuilder.parse(connectionString);
        if (serverType != null) {
            dbi.serverType = serverType;
        }
        return new DatabaseInfoBuilder(dbi);
    }

    public static DatabaseInfoBuilder fromHost(String host) {
        return DatabaseInfoBuilder.fromHost(null, host);
    }

    public static DatabaseInfoBuilder fromHost(String serverType, String host) {
        if (host == null) {
            throw new IllegalArgumentException("host");
        }
        DatabaseInfo dbi = new DatabaseInfo();
        if (serverType != null) {
            dbi.serverType = serverType;
        }
        dbi.host = host;
        return new DatabaseInfoBuilder(dbi);
    }

    public static DatabaseInfoBuilder fromServerType(String serverType) {
        if (serverType == null) {
            throw new IllegalArgumentException("serverType");
        }
        DatabaseInfo dbi = new DatabaseInfo();
        dbi.serverType = serverType;
        return new DatabaseInfoBuilder(dbi);
    }

    public static DatabaseInfoBuilder from(DatabaseInfo dbi) {
        if (dbi == null) {
            throw new IllegalArgumentException("dbi");
        }
        return new DatabaseInfoBuilder((DatabaseInfo)dbi.clone());
    }

    private DatabaseInfoBuilder(DatabaseInfo di) {
        this.di = di;
    }

    public DatabaseInfo build() {
        try {
            DatabaseInfo databaseInfo = this.di;
            return databaseInfo;
        }
        finally {
            this.di = null;
        }
    }

    private static DatabaseInfo parse(String adoConnectionString) {
        Map<String, String> values = DatabaseInfoBuilder.parseConnectionString(adoConnectionString);
        if (!values.containsKey(DATA_SOURCE_KEY)) {
            throw new IllegalArgumentException("Can't find host.");
        }
        DatabaseInfo di = DatabaseInfoBuilder.parseDataSourceField(values.get(DATA_SOURCE_KEY));
        if (values.containsKey(DATA_SOURCE_INTEGRATED_SECURITY_KEY)) {
            String value = values.get(DATA_SOURCE_INTEGRATED_SECURITY_KEY);
            String string = value = value != null ? value.toLowerCase() : null;
            if (value.equals(DATA_SOURCE_INTEGRATED_SECURITY_VALUE)) {
                di.userDomainAuth = true;
            }
        }
        return di;
    }

    public static DatabaseInfo parseDataSourceField(String dataSourceValue) {
        Matcher m = PATTERN_DATA_SOURCE.matcher(dataSourceValue);
        DatabaseInfo dsi = null;
        if (m.matches()) {
            String s;
            String instance = null;
            Integer port = null;
            String host = m.group(1);
            if (m.groupCount() > 1) {
                instance = m.group(2);
            }
            if (m.groupCount() > 2 && (s = m.group(3)) != null) {
                try {
                    port = Integer.valueOf(s);
                }
                catch (NumberFormatException ex) {
                    logger.error("Invalid port format in connection string: " + dataSourceValue);
                }
            }
            dsi = new DatabaseInfo();
            if (host != null) {
                dsi.host = host;
            }
            if (instance != null) {
                dsi.instance = instance;
            }
            if (port != null) {
                dsi.port = port;
            }
        }
        return dsi;
    }

    public static Map<String, String> parseConnectionString(String connectionString) {
        HashMap<String, String> values = new HashMap<String, String>();
        List<String> list = DatabaseInfoBuilder.parse(connectionString, ';');
        block0: for (String s : list) {
            if ((s = s.trim()).length() <= 0) continue;
            for (Pattern p : new Pattern[]{PATTERN_ITEM_DQ, PATTERN_ITEM_SQ, PATTERN_ITEM}) {
                Matcher m = p.matcher(s);
                if (!m.matches()) continue;
                values.put(m.group(1), m.groupCount() > 1 ? m.group(2) : null);
                continue block0;
            }
            values.put(s, null);
        }
        return values;
    }

    public static List<String> parse(String str, char delim) {
        LinkedList<String> r = null;
        boolean G = false;
        boolean DQ = true;
        int SQ = 2;
        int state = 0;
        if (str != null) {
            int i;
            int l = 0;
            r = new LinkedList<String>();
            for (i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (state == 0) {
                    if (c == delim) {
                        r.add(str.substring(l, i));
                        l = i + 1;
                        continue;
                    }
                    if (c == '\"') {
                        state = 1;
                        continue;
                    }
                    if (c != '\'') continue;
                    state = 2;
                    continue;
                }
                if (state == 1) {
                    if (c != '\"') continue;
                    state = 0;
                    continue;
                }
                if (state != 2 || c != '\'') continue;
                state = 0;
            }
            r.add(str.substring(l, i));
        }
        return r;
    }

    public void setUserDomainAuth(boolean userDomainAuth) {
        this.di.userDomainAuth = userDomainAuth;
    }

    public void setHost(String host) {
        this.di.host = host;
    }

    public void setUser(String username) {
        this.di.username = username;
    }

    public void setServerType(String serverType) {
        this.di.serverType = serverType;
    }

    public void setPassword(String password) {
        this.di.password = password;
    }

    public void setInstance(String instance) {
        this.di.instance = instance;
    }

    public void setDatabase(String database) {
        this.di.database = database;
    }

    public void setSchema(String schema) {
        this.di.schema = schema;
    }

    public void setPort(Integer port) {
        this.di.port = port;
    }

    public void setStorageGroup(String storageGroup) {
        this.di.storageGroup = storageGroup;
    }

    public void setProtocol(String protocol) {
        this.di.protocol = protocol;
    }

    public void setTrustServerCertificate(Boolean trustServerCertificate) {
        this.di.trustServerCertificate = trustServerCertificate;
    }

    public void setUseTLS(Boolean useTLS) {
        this.di.useTLS = useTLS;
    }

    public void setNodeName(String name) {
        this.di.nodeName = name;
    }
}

