/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment.ssdp;

import com.ez.eclient.environment.ssdp.SsdpServiceRegistry;
import com.ez.ssdp.NetworkCallback;
import com.ez.ssdp.SsdpNetworkService;
import com.ez.ssdp.SsdpService;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsdpServiceBootstrap {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(this.getClass());
    public static final String SSDP_HOST_DEFAULT = "localhost";
    public static final int SSDP_PORT = 1901;
    private static SsdpServiceBootstrap INSTANCE = new SsdpServiceBootstrap();
    private final SsdpNetworkService netService;
    private final SsdpService ssdpService;
    private final Configuration config = new BaseConfiguration();

    public static SsdpServiceBootstrap getInstance() {
        return INSTANCE;
    }

    public SsdpServiceBootstrap() {
        this.config.setProperty("ssdp.server.host", (Object)this.getHostIpAddress());
        this.config.setProperty("ssdp.announce_self", (Object)false);
        this.config.setProperty("ssdp.port", (Object)1901);
        this.netService = new SsdpNetworkService(this.config);
        this.ssdpService = new SsdpService(this.config);
        this.ssdpService.setNetworkCallback((NetworkCallback)this.netService);
    }

    public synchronized void start() {
        this.netService.start();
        try {
            this.ssdpService.start();
        }
        catch (Exception ex) {
            try {
                this.netService.stop();
            }
            catch (Exception ex2) {
                this.L.error("Unexpected.", (Throwable)ex2);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        SsdpServiceRegistry.publish(this.ssdpService);
    }

    public synchronized void stop() {
        SsdpServiceRegistry.unpublish();
        try {
            this.ssdpService.stop();
        }
        catch (Exception ex) {
            this.L.error("Unexpected.", (Throwable)ex);
        }
        try {
            this.netService.stop();
        }
        catch (Exception ex) {
            this.L.error("Unexpected.", (Throwable)ex);
        }
    }

    private String getHostIpAddress() {
        String ha = null;
        List<String> ips = this.getHostIpAddresses();
        if (ips.size() > 0) {
            ha = ips.get(0);
            this.L.error("Few host address, picking one: {}", (Object)ha);
        } else if (ips.size() == 0) {
            ha = SSDP_HOST_DEFAULT;
            this.L.error("Can't get host address, fallback to default: {}", (Object)SSDP_HOST_DEFAULT);
        }
        return ha;
    }

    private List<String> getHostIpAddresses() {
        LinkedList<String> ips = new LinkedList<String>();
        Enumeration<NetworkInterface> nie = null;
        try {
            nie = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.L.error("Unexpected error", (Throwable)e);
        }
        if (nie != null) {
            while (nie.hasMoreElements()) {
                NetworkInterface ni = nie.nextElement();
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                boolean up = false;
                try {
                    up = ni.isUp();
                }
                catch (SocketException e) {
                    this.L.error("Unexpected error", (Throwable)e);
                }
                if (!up) continue;
                for (InterfaceAddress ia : ias) {
                    if (ia.getAddress().isLinkLocalAddress()) continue;
                    ips.add(ia.getAddress().getHostAddress());
                }
            }
        }
        return ips;
    }
}

