/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment.preferences;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.persistence.Persister;
import java.io.StringReader;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentPreferences {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EnvironmentPreferences.class);
    public static final String PATH = "com.ez.eclient.environment";
    public static final String KEY_ENV = "environment";
    public static final String KEY_LOCAL_ENV = "hasLocalEnvironment";

    public static Environment getEnvironment() {
        Environment e = null;
        IPreferencesService ps = Platform.getPreferencesService();
        String es = EnvironmentPreferences.getValue(ps);
        if (es != null) {
            try {
                e = Persister.readEnvironment(new StringReader(es));
            }
            catch (Exception ex) {
                L.error("Can't read persisted environment.", (Throwable)ex);
            }
        }
        return e;
    }

    private static String getValue(IPreferencesService ps) {
        String es = ps.getString(PATH, KEY_ENV, null, null);
        if (es != null && es.length() == 0) {
            es = null;
        }
        return es;
    }
}

