/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment.persistence;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.persistence.InvalidFormatException;
import com.ez.ssdp.ServiceLocation;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;

public class Persister {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final char SEP = ':';
    public static final String SEP_SEQ = String.valueOf(':');

    public static void writeLocation(ServiceLocation l, Writer w) throws IOException {
        Persister.writeField(l.getProtocol(), w);
        Persister.writeSep(w);
        Persister.writeField(l.getHost(), w);
        Persister.writeSep(w);
        Persister.writeField(String.valueOf(l.getPort()), w);
    }

    public static ServiceLocation readLocation(Reader r) throws IOException {
        ServiceLocation l = null;
        String proto = Persister.readField(r);
        if (proto != null) {
            int iport;
            String host = Persister.readField(r);
            if (host == null) {
                throw new InvalidFormatException("location truncated");
            }
            String port = Persister.readField(r);
            if (port == null) {
                throw new InvalidFormatException("location truncated");
            }
            try {
                iport = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException(port, e);
            }
            l = new ServiceLocation(proto, host, Integer.valueOf(iport));
        }
        return l;
    }

    public static void writeEnvironment(Environment e, Writer w) throws IOException {
        Persister.writeField(e.getName(), w);
        Persister.writeSep(w);
        Persister.writeField(e.getId(), w);
        for (ServiceLocation l : e.getLocations()) {
            Persister.writeSep(w);
            Persister.writeLocation(l, w);
        }
    }

    public static Environment readEnvironment(Reader r) throws IOException {
        ServiceLocation l;
        HashSet<ServiceLocation> locs = new HashSet<ServiceLocation>();
        String name = Persister.readField(r);
        String id = Persister.readField(r);
        while ((l = Persister.readLocation(r)) != null) {
            locs.add(l);
        }
        return new Environment(id, name, locs);
    }

    private static String readField(Reader r) throws IOException {
        char c;
        int i;
        StringBuffer b = new StringBuffer();
        while ((i = r.read()) != -1 && (c = (char)i) != ':') {
            b.append(c);
        }
        return b.length() > 0 ? b.toString() : null;
    }

    private static void writeField(String field, Writer w) throws IOException {
        if (field.contains(SEP_SEQ)) {
            throw new IllegalArgumentException(": not allowed inside fileld.");
        }
        w.write(field);
    }

    private static void writeSep(Writer w) throws IOException {
        w.write(58);
    }
}

