/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.EnvironmentService;
import com.ez.eclient.environment.internal.LogUtil;
import com.ez.eclient.environment.internal.Messages;
import com.ez.ssdp.SsdpListener;
import com.ez.ssdp.SsdpService;
import com.ez.ssdp.SsdpServiceInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvironmentServiceImpl
implements EnvironmentService {
    public static final String SERVICE_ID = "com.ez.eclient.environment.EnvironmentService";
    private static final String SERVICE_TYPE = "ez:zookeeper";
    private static final char ENV_NAME_SEP = ';';
    private Logger L = LoggerFactory.getLogger(this.getClass());
    private SsdpService ssdp;
    private final Object g = new Object();
    private HashMap<String, Environment> envs = new HashMap();
    private SsdpListener ssdpListener;

    EnvironmentServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Environment> getEnvironments() {
        Object object = this.g;
        synchronized (object) {
            return (Map)this.envs.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object object = this.g;
        synchronized (object) {
            this.envs.clear();
            this.initializeServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSsdpService(SsdpService ssdp) {
        Object object = this.g;
        synchronized (object) {
            this.ssdp = ssdp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.g;
        synchronized (object) {
            if (this.ssdp == null) {
                throw new IllegalStateException("ssdp service not set");
            }
            this.ssdpListener = new SsdpListener(){

                public void serviceUpdated(SsdpServiceInfo s, SsdpServiceInfo si) {
                    if (EnvironmentServiceImpl.this.shouldCare(si)) {
                        EnvironmentServiceImpl.this.onServiceOnline(si);
                    }
                }

                public void serviceOnline(SsdpServiceInfo si) {
                    if (EnvironmentServiceImpl.this.shouldCare(si)) {
                        EnvironmentServiceImpl.this.onServiceOnline(si);
                    }
                }

                public void serviceOffline(SsdpServiceInfo si) {
                    if (EnvironmentServiceImpl.this.shouldCare(si)) {
                        EnvironmentServiceImpl.this.onServiceOffline(si);
                    }
                }

                public void serviceExpired(SsdpServiceInfo si) {
                    if (EnvironmentServiceImpl.this.shouldCare(si)) {
                        EnvironmentServiceImpl.this.onServiceOffline(si);
                    }
                }
            };
            this.initializeServices();
            this.ssdp.addListener(this.ssdpListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.g;
        synchronized (object) {
            this.ssdp.removeListener(this.ssdpListener);
        }
    }

    private void initializeServices() {
        for (SsdpServiceInfo s : this.ssdp.getSsdpServices()) {
            if (!this.shouldCare(s)) break;
            Set<String[]> envsInfo = this.getEnvNames(s);
            for (String[] ei : envsInfo) {
                String name = ei[0];
                String id = ei[1];
                Environment e = this.envs.get(id);
                if (e == null) {
                    this.envs.put(id, new Environment(id, name, Collections.singleton(s.getLocation())));
                    continue;
                }
                if (e.getName().equals(name)) {
                    String msg = String.format("Environment name clash: [%s %s %s] vs [%s %s %s]", id, e.getName(), e.getLocations(), id, name, s.getLocation());
                    LogUtil.log(4, Messages.getString(EnvironmentServiceImpl.class, "log.error.environment.name.clash", new String[]{id, e.getName(), "" + e.getLocations(), id, name, "" + s.getLocation()}));
                    this.L.error(msg);
                    continue;
                }
                this.envs.put(id, e.addLocation(name, s.getLocation()));
            }
        }
        for (Environment e : this.envs.values()) {
            String msg = "Discovered environments: " + e;
            LogUtil.log(4, Messages.getString(EnvironmentServiceImpl.class, "log.error.discovered.environments", new String[]{"" + e}));
            this.L.info(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceOnline(SsdpServiceInfo si) {
        this.L.debug("New configuration server online: " + si);
        Object object = this.g;
        synchronized (object) {
            Set<String[]> envs = this.getEnvNames(si);
            for (String[] env : envs) {
                String msg;
                Environment e;
                String name = env[0];
                String id = env[1];
                if (this.envs.containsKey(id)) {
                    this.L.debug(String.format("Environment already listed %s, updating to %s", env, si.getLocation()));
                    e = this.envs.get(id);
                    if (!e.getName().equals(name)) {
                        msg = String.format("Environment %s: name changed: %s=>%s", id, e.getName(), name);
                        LogUtil.log(2, Messages.getString(EnvironmentServiceImpl.class, "log.warning.name.changed", new String[]{id, e.getName(), name}));
                        this.L.warn(msg);
                    }
                    e = e.resetLocation(name, si.getLocation());
                    this.envs.put(id, e);
                    continue;
                }
                e = new Environment(id, name, Collections.singleton(si.getLocation()));
                msg = "New environment: " + e;
                LogUtil.log(1, Messages.getString(EnvironmentServiceImpl.class, "log.info.new.environment", new String[]{e.toString()}));
                this.L.debug(msg);
                this.envs.put(id, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceOffline(SsdpServiceInfo si) {
        this.L.debug("Configuration server said bye: " + si);
        Object object = this.g;
        synchronized (object) {
            Set<String[]> envs = this.getEnvNames(si);
            for (String[] env : envs) {
                String name = env[0];
                String id = env[1];
                if (this.envs.containsKey(id)) {
                    this.L.debug("Updating environment: " + env);
                    Environment e = this.envs.get(id);
                    if (!e.getName().equals(name)) {
                        String msg = String.format("Environment %s: name changed: %s=>%s", id, e.getName(), name);
                        LogUtil.log(1, Messages.getString(EnvironmentServiceImpl.class, "log.warning.name.changed", new String[]{id, e.getName(), name}));
                        this.L.warn(msg);
                    }
                    if ((e = e.removeLocation(name, si.getLocation())).getLocations().size() > 0) {
                        this.envs.put(id, e);
                        continue;
                    }
                    this.envs.remove(id);
                    continue;
                }
                this.L.debug("Environment not registered: " + env);
            }
        }
    }

    private boolean shouldCare(SsdpServiceInfo si) {
        return si.getServiceType().toLowerCase().equals(SERVICE_TYPE);
    }

    private Set<String[]> getEnvNames(SsdpServiceInfo si) {
        Set names = si.getEnvironments();
        HashSet<String[]> lowerNames = new HashSet<String[]>();
        if (names != null) {
            for (String n : names) {
                int i = n.indexOf(59);
                if (i > 0 && i < n.length() - 1) {
                    lowerNames.add(new String[]{n.substring(0, i).toLowerCase(), n.substring(i + 1, n.length())});
                    continue;
                }
                this.L.error("Can't parse environment: " + n);
            }
        }
        return lowerNames;
    }
}

