/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment;

import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.EnvironmentService;
import com.ez.eclient.environment.EnvironmentServiceImpl;
import com.ez.eclient.environment.ssdp.SsdpServiceBootstrap;
import com.ez.eclient.environment.ssdp.SsdpServiceRegistry;
import com.ez.ssdp.SsdpService;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentServiceAdaptor
implements EnvironmentService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EnvironmentServiceAdaptor.class);
    private EnvironmentServiceImpl es;
    private static EnvironmentServiceAdaptor INSTANCE = new EnvironmentServiceAdaptor();

    public static EnvironmentServiceAdaptor getInstance() {
        return INSTANCE;
    }

    @Override
    public Map<String, Environment> getEnvironments() {
        return this.es.getEnvironments();
    }

    @Override
    public void refresh() {
        this.es.refresh();
    }

    protected void activate(ComponentContext ctx) {
        this.start();
    }

    protected void deactivate(ComponentContext ctx) {
        this.stop();
    }

    public void start() {
        L.info("Starting environment service...");
        L.info("Starting SSDP service...");
        SsdpServiceBootstrap.getInstance().start();
        try {
            this.initService();
        }
        catch (Exception ex) {
            L.error("Can't start.", (Throwable)ex);
            try {
                L.debug("Stopping SSDP service...");
                SsdpServiceBootstrap.getInstance().stop();
                L.info("SSDP service stopped.");
            }
            catch (Exception exception) {
                L.error("Can't stop.", (Throwable)ex);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        L.info("Stopping environment service...");
        try {
            L.info("Stopping SSDP service...");
            SsdpServiceBootstrap.getInstance().stop();
        }
        catch (Exception ex) {
            L.debug("Unexpected error.", (Throwable)ex);
        }
        try {
            this.uninitService();
        }
        catch (Exception ex) {
            L.debug("Unexpected error.", (Throwable)ex);
        }
    }

    private void initService() {
        SsdpService ssdp = SsdpServiceRegistry.getDefault();
        this.es = new EnvironmentServiceImpl();
        this.es.setSsdpService(ssdp);
        this.es.start();
    }

    private void uninitService() {
        try {
            this.es.stop();
        }
        finally {
            this.es = null;
        }
    }
}

