/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.environment;

import com.ez.ssdp.ServiceLocation;
import java.util.HashSet;
import java.util.Set;

public class Environment {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String id;
    private String name;
    private HashSet<ServiceLocation> locations;

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Set<ServiceLocation> getLocations() {
        return this.locations;
    }

    public Environment(String id, String name, Set<ServiceLocation> locations) {
        if (id == null) {
            throw new IllegalArgumentException("id");
        }
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (locations == null) {
            throw new IllegalArgumentException("locations");
        }
        this.id = id;
        this.name = name;
        this.locations = new HashSet<ServiceLocation>(locations);
    }

    Environment resetLocation(String name, ServiceLocation location) {
        HashSet<ServiceLocation> newlocs = new HashSet<ServiceLocation>();
        if (location != null) {
            newlocs.add(location);
        }
        return new Environment(this.id, name, newlocs);
    }

    Environment addLocation(String name, ServiceLocation location) {
        HashSet<ServiceLocation> newlocs = new HashSet<ServiceLocation>();
        newlocs.addAll(this.locations);
        newlocs.add(location);
        return new Environment(this.id, name, newlocs);
    }

    Environment removeLocation(String name, ServiceLocation location) {
        HashSet newlocs = (HashSet)this.locations.clone();
        newlocs.remove(location);
        return new Environment(this.id, name, newlocs);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(" name: ");
        b.append(this.name);
        b.append(" id: ");
        b.append(this.id);
        for (ServiceLocation l : this.locations) {
            b.append(", l: ");
            b.append(l);
        }
        b.append(" ]");
        return b.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Environment other = (Environment)obj;
        return this.id.equals(other.id);
    }
}

