/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.utils;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.graphs.sharedresources.SharedResourcesNodeLegendInfo;
import com.ez.graphs.viewer.odb.impact.model.ResourceTypes;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDDName;
import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.analysis.config.inputs.EZSourceVariable;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDBIIDSg;
import com.ez.workspace.model.segments.EZSourceDDNameIDSg;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceFileIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBSegmentIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceQueueIDSg;
import com.ez.workspace.model.segments.EZSourceQueueManagerIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import images.LoadSVGImages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    public static final String IMPACT_GRAPH_KEY = "impact graph";
    public static final String IMPACT_GRAPH_FOLDER = "ig folder";
    public static final String STATEMENT_TYPE_ATTRIBUTTE = "STMT_TYPE";
    public static final String VERTEX_ID = "VERTEX_ID";
    public static final String VERTEX_CLASS = "VERTEX_CLASS";
    public static final String VERTEX_ID_LIST = "VERTEX_ID_LIST";
    public static final String PROGRAM_TYPE_ID = "prg type id";
    public static final String TSMEMBER_TYPE = "TS MEMBER TYPE";
    public static final String VERTEX_NATURAL_MAP_PROXY = "NaturalMapProxy";
    public static final String VERTEX_ADS_MAP_PROXY = "ADSMapProxy";
    public static final String VERTEX_DATACOM_PROXY = "DatacomProxy";
    public static final String VERTEX_IMS_SEGMENT_PROXY = "IMSSegmentProxy";
    public static final String VERTEX_IMS_SEGMENT_CLASS = "IMSSegment";
    public static final String IMS_TRANSACTION_PROXY = "IMSTransactionProxy";
    public static final String IMS_TERMINAL_PROXY = "IMSTerminalProxy";
    public static final String IMS_MQ_USAGE_PROXY = "IMSMQProxy";
    public static final String IMS_MOD_USAGE_PROXY = "IMSMODProxy";
    public static final String API = "api";
    public static final String API_SERVICE = "api_service";
    public static final String VERTEX_GENERIC_TRANSACTION_PROXY = "GenericTranProxy";
    public static final String VERTEX_GENERIC_MAP_PROXY = "GenericScreenProxy";
    public static final String JAVA_PROGRAM_TYPE = "Java Program";
    public static final String JAVA_PROGRAM_ID = "java_program";
    public static final String RID_MARKER = "@@@@@EZLEGACY@@@@";
    public static final String WHILE_MARKER = "@@@@@WHILE@EZLEGACY@@@@";
    public static final String SELECT_MARKER = "@@@@@SEL@EZLEGACY@@@@";
    public static final String REDEFINES_QUERY = "select 'Redefines' as relation from ( traverse both('Redefines') from  @@@@@EZLEGACY@@@@) where @rid = ";
    public static final String PARENT_CHILD_QUERY = "select 'ChildOf' as relation from (traverse out('ChildOf') from  @@@@@EZLEGACY@@@@ ) where @rid = ";
    public static final String PROGRAM_CALL_INFO = "select $scall.sid as fromId, $scall.name as fromName, $pCalled.sid as toId,  $pCalled.name as toName, 1 as dir,  out('APDefinedBy')[0].sid as fromVId, out('APDefinedBy')[0].name as fromVName,  $param.out('ProxyFor')[0].sid as toVId, $param.name as toVName  from ?  let $scall = in('UsesAP')[0].in('HasS')[0],  $param = out('ActualParameter')[0],  $pCalled = out('ActualParameter')[0].out('ParameterOf')[0]";
    public static final String PROGRAM_CALL_INFO2 = "select $scall.@rid.asString() as fromId, $scall.name as fromName, $param.out('VinCB')[0].@rid.asString() as toId,  $pCalled.name as toName,  out('APDefinedBy')[0].@rid.asString() as fromVId, out('APDefinedBy')[0].name as fromVName,  $param.@rid.asString() as toVId, $param.name as toVName  from @@@@@EZLEGACY@@@@ let $scall = in('UsesAP')[0].out('SinCB')[0].in('HasCB')[0].out('HasCB')[ordinalNumber = 1],  $param = out('ActualParameter')[0].out('ProxyFor')[0],  $pCalled = out('ActualParameter')[0].out('ParameterOf')[0]";
    public static final String PROGRAM_CALL_INFO3 = "select $arg.in('HasV')[0].@rid.asString() as fromId, $arg.in('HasV')[0].name as fromName, $param.in('formalParamDef')[0].@rid.asString() as toId, $param.in('formalParamDef')[0].name as toName, $arg.@rid.asString() as fromVId,$arg.name as fromVName, $param.@rid.asString() as toVId, $param.name as toVName  from ? let $param = out('mapsFormalParam')[0],$arg = out('BCDefinedBy')[0]";
    public static final String RESOURCE_SQL_FIELD_DETAILS = "select @rid as resRid, name, @class as resClass, $si[0].sLine as sLine, $si[0].in.full as full, $si[0].in.type.asString() from @@@@@EZLEGACY@@@@ let $si = out('FieldOf')[0].in('SIResourceLink')[0].outE('SourceInfo')  where $si.size() > 0 ";
    public static final String VAR_PARAM_TO_STMT = "select @rid as stmt from (traverse in() from @@@@@EZLEGACY@@@@ ) where @class = 'Statement'";
    public static final String IS_PROGRAM_SOURCE_PROPERTY = "isProgramSource";
    public static final String JOB_INFO_QUERY = "select $s.name as step, $s.in('Steps')[0].name as jobName, $s.in('Steps')[0].member as jobMember from @@@@@EZLEGACY@@@@ \nlet $s = in('UsesDD')[0]";
    public static final String TARGET_SELECTION = "targetSelectionOption";
    public static final String LOCATE_VAR_IN_INCLUDES = "locVarInIncludes";
    public static final String LOCATE_VAR_IN_PROGRAMS = "locVarInPrograms";

    public static String getTSNodeName(OrientExtendedGraph graph, Value value, String cls, boolean displayVarOff) {
        return Utils.getTSNodeName(graph, value, cls, displayVarOff, true);
    }

    public static String getTSNodeName(OrientExtendedGraph graph, Value value, String cls, boolean displayVarOff, boolean offsetRelToFirstParent) {
        String name = value.toString();
        if (value instanceof VertexValue) {
            if ("SQLFieldProxy".equals(cls)) {
                String tn = (String)((VertexValue)value).asVertex(graph).getProperty("tableName");
                name = String.valueOf(name) + "-" + tn;
            } else if ("Variable".equals(cls)) {
                String pn = (String)((VertexValue)value).getContext("variable first parent");
                if (pn != null) {
                    name = String.valueOf(name) + "/" + pn;
                }
                if (displayVarOff) {
                    int voff = 1;
                    if (offsetRelToFirstParent) {
                        voff = (Integer)value.getContext("memOffset");
                    }
                    int varIOff = (Integer)value.getContext("impactedOffset");
                    int varISize = (Integer)value.getContext("impactedSize");
                    name = String.format("%s[%d:%d]", name, voff + varIOff, varISize);
                }
            } else if ("AdabasFileProxy".equals(cls)) {
                OrientVertex adFileV = ((VertexValue)value).asVertex(graph);
                Vertex adDBV = (Vertex)adFileV.getVertices(Direction.OUT, new String[]{"FileOf"}).iterator().next();
                String dbName = null;
                if (adDBV != null) {
                    dbName = (String)adDBV.getProperty("dbNumber");
                }
                name = AdabasUtils.getListableName((String)name, dbName);
            }
        }
        return name;
    }

    public static String getDisplayNameForVariable(String varName, String firstParent, int voff, int vIOff, int vISize) {
        if (firstParent != null) {
            varName = String.valueOf(varName) + "/" + firstParent;
        }
        varName = String.format("%s[%d:%d]", varName, voff + vIOff, vISize);
        return varName;
    }

    public static String getTSNodeName(Vertex v) {
        String name = null;
        String cls = (String)v.getProperty("@class");
        if ("DSName".equals(cls)) {
            name = (String)v.getProperty("dsid");
        } else if ("SQLFieldProxy".equals(cls)) {
            String tableName = (String)v.getProperty("tableName");
            name = (String)v.getProperty("name");
            name = String.valueOf(name) + "-" + tableName;
        } else if ("AdabasFileProxy".equals(cls)) {
            name = (String)v.getProperty("name");
            Vertex adDBV = (Vertex)v.getVertices(Direction.OUT, new String[]{"FileOf"}).iterator().next();
            String dbName = null;
            if (adDBV != null) {
                dbName = (String)adDBV.getProperty("dbNumber");
            }
            name = AdabasUtils.getListableName((String)name, dbName);
        } else if ("FileUsageInfo".equals(cls)) {
            String localName = (String)v.getProperty("localName");
            name = "(" + localName + ")";
        } else if ("BMSProxy".equals(cls) || VERTEX_NATURAL_MAP_PROXY.equals(cls) || VERTEX_GENERIC_MAP_PROXY.equals(cls)) {
            name = (String)v.getProperty("name");
            String mapSet = (String)v.getProperty("mapSet");
            name = mapSet != null ? String.valueOf(mapSet) + "-" + name : name;
        } else if ("JCLJob".equals(cls)) {
            name = (String)v.getProperty("name");
            String memberName = (String)v.getProperty("member");
            if (memberName != null && !memberName.isEmpty()) {
                name = memberName.equals(name) ? name : String.valueOf(name) + "(" + memberName + ")";
            }
        } else if ("ProgramProxy".equals(cls)) {
            String ancestorPrefix;
            Vertex progV = v.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator().hasNext() ? (Vertex)v.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator().next() : null;
            String string = ancestorPrefix = progV != null ? Utils.getAncestorName4Program(progV) : Utils.getAncestorName4ProgramProxy(v);
            if (ancestorPrefix != null) {
                ancestorPrefix = String.valueOf(ancestorPrefix) + ":";
            }
            name = progV != null ? (String)progV.getProperty("name") : (String)v.getProperty("name");
            name = ancestorPrefix != null ? String.valueOf(ancestorPrefix) + name : name;
        } else if ("Program".equals(cls)) {
            String ancestorPrefix = Utils.getAncestorName4Program(v);
            if (ancestorPrefix != null) {
                ancestorPrefix = String.valueOf(ancestorPrefix) + ":";
            }
            name = (String)v.getProperty("name");
            name = ancestorPrefix != null ? String.valueOf(ancestorPrefix) + name : name;
        } else if (VERTEX_IMS_SEGMENT_PROXY.equals(cls)) {
            String segmentName = (String)v.getProperty("name");
            String dbName = (String)v.getProperty("dbName");
            name = dbName != null ? dbName.concat(".").concat(segmentName) : segmentName;
            name = "*".concat(name);
        } else if (VERTEX_IMS_SEGMENT_CLASS.equals(cls)) {
            String segmentName = (String)v.getProperty("name");
            Vertex dbV = (Vertex)v.getVertices(Direction.OUT, new String[]{"inDB"}).iterator().next();
            String dbName = (String)dbV.getProperty("name");
            name = dbName.concat(".").concat(segmentName);
        } else {
            name = (String)v.getProperty("name");
        }
        return name;
    }

    private static String getAncestorName4ProgramProxy(Vertex v) {
        String ancestorPrefix = null;
        Iterator ancestorIt = v.getVertices(Direction.OUT, new String[]{"Ancestor"}).iterator();
        if (ancestorIt.hasNext()) {
            Vertex ancestorV = (Vertex)ancestorIt.next();
            ancestorPrefix = Utils.getTSNodeName(ancestorV);
        }
        return ancestorPrefix;
    }

    private static String getAncestorName4Program(Vertex v) {
        String ancestor = null;
        Iterator ancestorIt = v.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator();
        if (ancestorIt.hasNext()) {
            Vertex proxyV = (Vertex)ancestorIt.next();
            ancestor = Utils.getAncestorName4ProgramProxy(proxyV);
        }
        return ancestor;
    }

    public static IGraphNodeLegendInfo setResourceUIStyle(TSNode tsNode, String cls, Set<IGraphNodeLegendInfo> nodeTypesSetForLegend, boolean isImpact, ProjectInfo ezsourcePrj) {
        CallgraphNodeLegendInfo info = null;
        TSEColor textColor = TSEColor.black;
        if ("Variable".equals(cls)) {
            info = CallgraphNodeLegendInfo.COBOL_VARIABLE;
        } else if ("Program".equals(cls) || "ProgramProxy".equals(cls)) {
            Integer type = (Integer)tsNode.getAttributeValue(PROGRAM_TYPE_ID);
            if (type == null) {
                L.warn("program without type ");
                type = 0;
            }
            info = CallgraphNodeLegendInfo.UNKNOWN;
            switch (type) {
                case -1: 
                case 0: {
                    info = CallgraphNodeLegendInfo.UNKNOWN;
                    break;
                }
                case 1: {
                    info = CallgraphNodeLegendInfo.COBOL;
                    textColor = TSEColor.white;
                    break;
                }
                case 22: {
                    info = CallgraphNodeLegendInfo.JAVA_PROGRAM;
                    textColor = TSEColor.white;
                    break;
                }
                case 15: {
                    info = CallgraphNodeLegendInfo.ASSEMBLER_CSECT;
                    break;
                }
                case 2: {
                    info = CallgraphNodeLegendInfo.PL1;
                    textColor = TSEColor.white;
                    break;
                }
                case 6: {
                    info = CallgraphNodeLegendInfo.SMART_SUBROUTINE;
                    textColor = TSEColor.white;
                    break;
                }
                case 16: {
                    info = CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT;
                    break;
                }
                case 3: {
                    info = CallgraphNodeLegendInfo.NATURAL;
                    break;
                }
                case 9: {
                    info = CallgraphNodeLegendInfo.REXX;
                    textColor = TSEColor.white;
                    break;
                }
                case 4: {
                    info = CallgraphNodeLegendInfo.SMART_DB_MODULE;
                    textColor = TSEColor.white;
                    break;
                }
                case 5: {
                    info = CallgraphNodeLegendInfo.SMART_DB_MODULE;
                    textColor = TSEColor.white;
                    break;
                }
                case 8: {
                    info = CallgraphNodeLegendInfo.ASSEMBLER;
                    break;
                }
                case 7: {
                    info = CallgraphNodeLegendInfo.CL;
                    textColor = TSEColor.white;
                    break;
                }
                case 10: {
                    info = CallgraphNodeLegendInfo.ADS_PROCESS;
                    break;
                }
                case 11: {
                    info = CallgraphNodeLegendInfo.ADS_DIALOG;
                    break;
                }
                case 19: {
                    info = CallgraphNodeLegendInfo.SCL;
                }
            }
        } else if (IMS_TERMINAL_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.TERMINAL;
            textColor = TSEColor.white;
        } else if (IMS_TRANSACTION_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.IMS_TRANSACTION;
            textColor = TSEColor.white;
        } else if (VERTEX_GENERIC_TRANSACTION_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.GENERIC_TRANSACTION;
            textColor = TSEColor.white;
        } else if (IMS_MQ_USAGE_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION;
            textColor = TSEColor.white;
        } else if (IMS_MOD_USAGE_PROXY.equals(cls) || "IMSModProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.IMS_SCREEN;
            textColor = TSEColor.white;
        } else if ("JCLJob".equals(cls)) {
            info = CallgraphNodeLegendInfo.JCL_JOB;
            textColor = TSEColor.white;
        } else if ("InvokedJob".equals(cls)) {
            info = CallgraphNodeLegendInfo.JCL_JOB;
            textColor = TSEColor.white;
        } else if ("SQLTableProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.SQL_TABLE;
            textColor = TSEColor.white;
        } else if ("SQLFieldProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.SQL_FIELD_TABLE;
            textColor = TSEColor.white;
        } else if ("DDNameProxy".equals(cls)) {
            if (isImpact) {
                info = SharedResourcesNodeLegendInfo.DDNAME;
            } else {
                info = CallgraphNodeLegendInfo.FILE;
                textColor = TSEColor.white;
            }
        } else if ("AdabasFileProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.ADABAS;
            textColor = TSEColor.white;
        } else if ("DALProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.DAL_FILE;
            textColor = TSEColor.white;
        } else if ("DBIProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.DBI_TABLE;
            textColor = TSEColor.white;
        } else if ("DSName".equals(cls) || "FileUsageInfo".equals(cls)) {
            info = CallgraphNodeLegendInfo.FILE;
            textColor = TSEColor.white;
        }
        if ("IDMSRecordProxy".equals(cls)) {
            info = ezsourcePrj != null && ezsourcePrj.isIDMSXDbVMEProject() ? CallgraphNodeLegendInfo.IDMSX_RECORD : CallgraphNodeLegendInfo.IDMS_RECORD;
        } else if ("IDMSSetProxy".equals(cls)) {
            info = ezsourcePrj != null && ezsourcePrj.isIDMSXDbVMEProject() ? CallgraphNodeLegendInfo.IDMSX_SET : CallgraphNodeLegendInfo.IDMS_SET;
        } else if ("TranProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.TRANSACTION;
        } else if ("JCLPGM".equals(cls)) {
            info = CallgraphNodeLegendInfo.JCL_PGM;
            textColor = TSEColor.white;
        } else if ("BMSProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.MAP;
        } else if (VERTEX_GENERIC_MAP_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.MAP_GENERIC;
        } else if ("MQQueueProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.QUEUE;
        } else if ("MQManagerProxy".equals(cls)) {
            info = CallgraphNodeLegendInfo.QUEUE_MANAGER;
        } else if (VERTEX_NATURAL_MAP_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.MAP;
        } else if (VERTEX_ADS_MAP_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.ADS_MAP;
        } else if (VERTEX_DATACOM_PROXY.equals(cls)) {
            info = CallgraphNodeLegendInfo.DATACOM_TABLE;
        } else if (VERTEX_IMS_SEGMENT_PROXY.equals(cls) || VERTEX_IMS_SEGMENT_CLASS.equals(cls)) {
            info = tsNode.hasAttribute("imsdb logical segment") && ((Boolean)tsNode.getAttributeValue("imsdb logical segment")).booleanValue() ? CallgraphNodeLegendInfo.IMS_DB_LOGIC_SEGMENT : CallgraphNodeLegendInfo.IMS_DB_SEGMENT;
        } else if (API.equals(cls)) {
            info = CallgraphNodeLegendInfo.API;
        } else if (API_SERVICE.equals(cls)) {
            info = CallgraphNodeLegendInfo.API_SERVICE;
        }
        if (info != null) {
            tsNode.setAttribute("class_name", (Object)info.getNodeTypeClass());
            String imgPath = info.getGraphImagePath();
            Utils.setNodeUI(tsNode, imgPath, info.getTSEColor(), textColor);
            if (nodeTypesSetForLegend != null) {
                nodeTypesSetForLegend.add((IGraphNodeLegendInfo)info);
            }
        }
        return info;
    }

    public static void setResourceUIStyle(TSNode tsNode, String cls, Set<IGraphNodeLegendInfo> nodeTypesSetForLegend) {
        Utils.setResourceUIStyle(tsNode, cls, nodeTypesSetForLegend, true, null);
    }

    private static void setNodeUI(TSNode node, String svgImagePath, TSEColor fillColor, TSEColor textColor) {
        TSESVGImage svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)svgImagePath);
        node.setAttribute("uiImage", (Object)svgimage);
        node.setAttribute("Fill_Color", (Object)fillColor);
        node.setAttribute("Color", (Object)textColor);
    }

    public static EZObjectType getResourceType(Vertex v, ProjectInfo ezsourcePrj, boolean isImpact) {
        EZObjectType inputType = null;
        EZSourceSQLTableIDSg resourceSg = null;
        String cls = (String)v.getProperty("@class");
        EZEntityID temporarEntity = null;
        if ("Program".equals(cls)) {
            Integer type = (Integer)v.getProperty("type");
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(type);
            Integer programId = (Integer)v.getProperty("sid");
            String prgName = (String)v.getProperty("name");
            String ancestorName = Utils.getAncestorName4Program(v);
            Integer ancestorId = (Integer)v.getProperty("ancestorid");
            OrientVertex vv = v.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().hasNext() ? (OrientVertex)v.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().next() : null;
            inputType.addProperty("program occur", (Object)Boolean.TRUE);
            resourceSg = TSGraphUtils.makeProgramSegment((EZObjectType)inputType, (Integer)programId, (Integer)type, (String)prgName, (String)ancestorName, (Integer)ancestorId);
            if (vv != null) {
                ((EZSourceProgramIDSg)resourceSg).setOdbRID(vv.getId().toString());
            }
        } else if ("ProgramProxy".equals(cls)) {
            Integer type = (Integer)v.getProperty("type");
            if (type > 0) {
                try {
                    inputType = type == 22 ? (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(type, JAVA_PROGRAM_ID) : (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(type);
                }
                catch (IllegalStateException ex) {
                    L.debug("unknown type of program; cannot build the input type", (Throwable)ex);
                }
                if (inputType != null) {
                    Integer programId = (Integer)v.getProperty("sid");
                    String prgName = (String)v.getProperty("name");
                    String ancestorName = Utils.getAncestorName4ProgramProxy(v);
                    Integer ancestorId = (Integer)v.getProperty("ancestorid");
                    inputType.addProperty("program occur", (Object)Boolean.FALSE);
                    resourceSg = TSGraphUtils.makeProgramSegment((EZObjectType)inputType, (Integer)programId, (Integer)type, (String)prgName, (String)ancestorName, (Integer)ancestorId);
                }
            }
        } else if ("SQLFieldProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(187), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String fieldName = (String)v.getProperty("name");
            Integer fId = (Integer)v.getProperty("sid");
            Vertex tVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{"FieldOf"}).iterator().next();
            String tableName = (String)tVertex.getProperty("name");
            resourceSg = new EZSourceSQLFieldTableIDSg(fieldName, fId, tableName);
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.setName(fieldName);
        } else if ("SQLTableProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(1), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String tableName = (String)v.getProperty("name");
            resourceSg = new EZSourceSQLTableIDSg(tableName);
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.setName(tableName);
        } else if ("JCLJob".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            String jobName = (String)v.getProperty("name");
            Integer jobId = (Integer)v.getProperty("sid");
            String memberName = (String)v.getProperty("member");
            String ca7JobName = null;
            Integer ca7jobId = null;
            resourceSg = new EZSourceJobIDSg(jobName, jobId.intValue(), Integer.valueOf(22), memberName, ca7JobName, ca7jobId);
            temporarEntity = new EZEntityID();
            temporarEntity.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(jobName, null));
        } else if ("DSName".equals(cls)) {
            Vertex ddNameV = (Vertex)v.getVertices(Direction.IN, new String[]{"MappedTo"}).iterator().next();
            String ddName = (String)ddNameV.getProperty("name");
            if (isImpact) {
                String datasetid = (String)v.getProperty("dsid");
                String generation = (String)v.getProperty("generation");
                Integer dsid = (Integer)v.getProperty("sid");
                Pair<EZObjectType, EZSegment> pair = Utils.makeDatasetInput(datasetid, dsid, generation, ddName);
                inputType = (EZObjectType)pair.getFirst();
                resourceSg = (EZSegment)pair.getSecond();
            } else {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceFileIDSg(ddName, 9);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            }
        } else if ("DDNameProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceFileIDSg(name, 9);
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.addProperty("logical file attribute", (Object)name);
        } else if ("FileUsageInfo".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String localname = (String)v.getProperty("localName");
            String physicalName = (String)v.getProperty("physicalName");
            resourceSg = new EZSourceFileIDSg(localname, 9);
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.addProperty("logical file attribute", (Object)localname);
            if (physicalName != null && !physicalName.isEmpty()) {
                inputType.addProperty("isPhysicalFile attribute", (Object)physicalName);
            }
        } else if ("Variable".equals(cls)) {
            int programTypeId = 1;
            inputType = new EZSourceVariable();
            Vertex prgV = (Vertex)v.getVertices(Direction.IN, new String[]{"HasV"}).iterator().next();
            Integer programId = (Integer)prgV.getProperty("sid");
            String prgName = (String)prgV.getProperty("name");
            String ancestorName = Utils.getAncestorName4Program(prgV);
            Integer ancestorId = (Integer)prgV.getProperty("ancestorid");
            inputType.addProperty("program occur", (Object)Boolean.TRUE);
            resourceSg = TSGraphUtils.makeProgramSegment((EZObjectType)inputType, (Integer)programId, (Integer)programTypeId, (String)prgName, (String)ancestorName, (Integer)ancestorId);
            String varName = (String)v.getProperty("name");
            Integer level = (Integer)v.getProperty("level");
            Integer varID = (Integer)v.getProperty("sid");
            Boolean isField = (Boolean)v.getProperty("isField");
            Boolean isFiller = (Boolean)v.getProperty("isFiller");
            String pic = (String)v.getProperty("pic");
            String type = (String)v.getProperty("type");
            Integer father = (Integer)v.getProperty("father");
            Integer ancestor = (Integer)v.getProperty("ancestor");
            Integer prgRefId = programId;
            Edge edge = (Edge)v.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
            Integer varStartRow = (Integer)edge.getProperty("sLine");
            EZSourceVariableIDSg varSeg = new EZSourceVariableIDSg(varName, varID.toString(), String.valueOf(level), isField.booleanValue(), isFiller.booleanValue(), String.valueOf(varStartRow), pic, type, ancestor != null ? ancestor.toString() : null, prgRefId != null ? prgRefId.toString() : null, father != null ? father.toString() : null);
            inputType.addProperty("mainframe resource id sg", (Object)varSeg);
            temporarEntity = new EZEntityID();
            temporarEntity.addSegment((EZSegment)varSeg);
            temporarEntity.addSegment((EZSegment)new EZSourceProgramTypeIDSg(Integer.valueOf(programTypeId)));
        } else if ("AdabasFileProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(56), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String dbName = (String)v.getProperty("dbName");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceAdabasIDSg(AdabasUtils.getListableName((String)name, (String)dbName));
            resourceSg.setNumber(((Integer)v.getProperty("fid")).intValue());
            ((EZSourceAdabasIDSg)resourceSg).setFileName(name);
            ((EZSourceAdabasIDSg)resourceSg).setDbName(dbName);
        } else if ("DALProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(189), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            inputType.setName(name);
            resourceSg = new EZSourceDALIDSg(name);
            Integer occID = (Integer)v.getProperty("occurId");
            ((EZSourceDALIDSg)resourceSg).setVirtual(String.valueOf(occID));
        } else if ("DDNameProxy".equals(cls)) {
            String name = (String)v.getProperty("name");
            if (isImpact) {
                inputType = new EZSourceDDName();
                resourceSg = new EZSourceDDNameIDSg(name);
            } else {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(9), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                resourceSg = new EZSourceFileIDSg(name, 9);
                inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
                inputType.addProperty("logical file attribute", (Object)name);
            }
        } else if ("DBIProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(190), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            Integer dbiID = (Integer)v.getProperty("sid");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceDBIIDSg(dbiID, name);
        } else if ("MQQueueProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(81), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceQueueIDSg(name);
        } else if ("MQManagerProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(79), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceQueueManagerIDSg(name);
        } else if ("IDMSRecordProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(75), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceIDMSRecordIDSg(name);
        } else if ("IDMSSetProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(76), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceIDMSSetIDSg(name);
        } else if ("TranProxy".equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(14), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceTransactionIDSg(name);
        } else if ("BMSProxy".equals(cls) || VERTEX_GENERIC_MAP_PROXY.equals(cls)) {
            Integer resType = "BMSProxy".equals(cls) ? 6 : 220;
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(resType, "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            String mapSet = (String)v.getProperty("mapSet");
            boolean isIncompleteSg = v.getProperty("hasLayout") == null;
            resourceSg = new EZSourceScreenIDSg(null, name, 119, null);
            ((EZSourceScreenIDSg)resourceSg).setMapSet(mapSet);
            if (isIncompleteSg) {
                resourceSg.setIncompleteSegment(isIncompleteSg);
            } else {
                boolean hasLayout = (Boolean)v.getProperty("hasLayout");
                ((EZSourceScreenIDSg)resourceSg).setHasLayout(hasLayout);
            }
        } else if (VERTEX_NATURAL_MAP_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(61), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            String mapSet = (String)v.getProperty("mapSet");
            boolean hasLayout = (Boolean)v.getProperty("hasLayout");
            resourceSg = new EZSourceScreenIDSg(null, name, 120, null);
            ((EZSourceScreenIDSg)resourceSg).setMapSet(mapSet);
            ((EZSourceScreenIDSg)resourceSg).setHasLayout(hasLayout);
        } else if (VERTEX_ADS_MAP_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(95), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            boolean hasLayout = (Boolean)v.getProperty("hasLayout");
            resourceSg = new EZSourceScreenIDSg(null, name, 118, null);
            ((EZSourceScreenIDSg)resourceSg).setHasLayout(hasLayout);
        } else if (VERTEX_IMS_SEGMENT_CLASS.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(209), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String segmentName = (String)v.getProperty("name");
            Vertex tVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{"inDB"}).iterator().next();
            String dbdName = (String)tVertex.getProperty("name");
            boolean isLogic = v.getVertices(Direction.OUT, new String[]{"IMSSSource"}).iterator().hasNext();
            if (isLogic) {
                inputType.addProperty("LOGICAL_SEGMENT_TYPE", (Object)true);
            }
            resourceSg = new EZSourceIMSDBSegmentIDSg(segmentName, dbdName);
            if (v.getProperty("sid") != null) {
                Integer sid = (Integer)v.getProperty("sid");
                ((EZSourceIMSDBSegmentIDSg)resourceSg).setSegmentID(sid);
            }
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.setName(segmentName);
        } else if (VERTEX_IMS_SEGMENT_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(209), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String segmentName = (String)v.getProperty("name");
            String dbdName = (String)v.getProperty("dbName");
            resourceSg = new EZSourceIMSDBSegmentIDSg(segmentName, dbdName);
            if (v.getProperty("sid") != null) {
                Integer sid = (Integer)v.getProperty("sid");
                ((EZSourceIMSDBSegmentIDSg)resourceSg).setSegmentID(sid);
            }
            inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
            inputType.setName(segmentName);
        } else if (IMS_MOD_USAGE_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(65), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            Integer screenType = (Integer)v.getProperty("type");
            boolean isMID = screenType == 0;
            resourceSg = new EZSourceScreenIDSg(null, name, 65, null);
            if (v.getVertices(Direction.OUT, new String[]{"IMSModProxyOf"}).iterator().hasNext()) {
                Vertex mflVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{"IMSModProxyOf"}).iterator().next();
                String difDof = (String)(isMID ? mflVertex.getProperty("dif") : mflVertex.getProperty("dof"));
                if (difDof != null) {
                    ((EZSourceScreenIDSg)resourceSg).setMapSet(difDof);
                    ((EZSourceScreenIDSg)resourceSg).setHasLayout(Boolean.TRUE.booleanValue());
                }
            }
        } else if (IMS_TRANSACTION_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(20), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceTransactionIDSg(name);
        } else if (VERTEX_DATACOM_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(182), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceDatacomTableIDSg(name);
            inputType.setName(name);
        } else if (VERTEX_GENERIC_TRANSACTION_PROXY.equals(cls)) {
            inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(219), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            String name = (String)v.getProperty("name");
            resourceSg = new EZSourceTransactionIDSg(name);
        }
        if (inputType != null) {
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(ezsourcePrj));
            if (resourceSg != null) {
                entity.addSegment(resourceSg);
                if (temporarEntity != null) {
                    entity.addEntitySegments(temporarEntity);
                }
            }
            inputType.setEntID(entity);
        }
        return inputType;
    }

    public static Pair<EZObjectType, EZSegment> makeDatasetInput(String datasetid, Integer sid, String generation, String ddName) {
        EZSourceDatasetIDSg resourceSg = null;
        EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(30), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
        EZSourceDataset.setLIBProperty((EZObjectType)inputType, (String)ddName);
        Pair pair = com.ez.gdb.core.utils.Utils.splitDSid((String)datasetid);
        String member = pair.getSecond() == null ? "" : (String)pair.getSecond();
        String datasetName = (String)pair.getFirst();
        if (generation != null && !generation.isEmpty()) {
            Integer generationNumber = Integer.valueOf(generation);
            resourceSg = new EZSourceDatasetIDSg(datasetName, sid, member, generationNumber);
            resourceSg.setIncompleteSegment(true);
        } else {
            resourceSg = new EZSourceDatasetIDSg(datasetName, sid, member, null);
        }
        inputType.addProperty("mainframe resource id sg", (Object)resourceSg);
        inputType.setName(datasetName);
        return new Pair((Object)inputType, (Object)resourceSg);
    }

    public static TextSelectionInFile computeSourceInfoForVertex(Vertex v) {
        return Utils.computeSourceInfoForVertex(v, false);
    }

    public static TextSelectionInFile computeSourceInfoForVertex(Vertex v, boolean findIfSourceIsPrg) {
        if (v == null) {
            return null;
        }
        Iterator sourceInfoEdgeIter = v.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator();
        TextSelectionInFile tsf = null;
        if (sourceInfoEdgeIter.hasNext()) {
            Edge sourceInfoEdge = (Edge)sourceInfoEdgeIter.next();
            OrientVertex pathV = (OrientVertex)sourceInfoEdge.getVertex(Direction.IN);
            Integer sLine = (Integer)sourceInfoEdge.getProperty("sLine");
            Integer sCol = (Integer)sourceInfoEdge.getProperty("sCol");
            Integer eLine = (Integer)sourceInfoEdge.getProperty("eLine");
            Integer eCol = (Integer)sourceInfoEdge.getProperty("eCol");
            String fileName = (String)pathV.getProperty("full");
            if (fileName != null) {
                fileName = com.ez.gdb.core.utils.Utils.replaceCharacters((String)fileName);
                tsf = sLine != null && sCol != null ? new TextSelectionInFile(fileName, ResourceTypes.getEditorId((Vertex)pathV), new Integer[]{sLine, sCol, eLine, eCol}) : new TextSelectionInFile(fileName, ResourceTypes.getEditorId((Vertex)pathV));
                tsf.addProperty("vertexID", (Object)v.getId().toString());
                if (findIfSourceIsPrg) {
                    tsf.addProperty(IS_PROGRAM_SOURCE_PROPERTY, (Object)(pathV.countEdges(Direction.IN, new String[]{"ProgramSourceInfo"}) > 0L ? 1 : 0));
                }
            }
        }
        return tsf;
    }

    public static String getDSListableName(String dsid) {
        Pair pair = com.ez.gdb.core.utils.Utils.splitDSid((String)dsid);
        return pair.getSecond() != null ? String.valueOf((String)pair.getFirst()) + "(" + (String)pair.getSecond() + ")" : (String)pair.getFirst();
    }

    public static StringBuilder getWhileRestrictions(String[] cgRestrictions) {
        StringBuilder sb = null;
        if (cgRestrictions != null && cgRestrictions.length > 0) {
            sb = new StringBuilder();
            HashSet<String> containSet = new HashSet<String>();
            HashSet<String> notLikeSet = new HashSet<String>();
            String[] stringArray = cgRestrictions;
            int n = cgRestrictions.length;
            int n2 = 0;
            while (n2 < n) {
                String patternEntry = stringArray[n2];
                if (!patternEntry.trim().isEmpty()) {
                    String patternProcessed;
                    String pattern = patternEntry.trim();
                    if (pattern.startsWith("*") && pattern.endsWith("*")) {
                        patternProcessed = pattern.substring(1, pattern.length() - 1);
                        notLikeSet.add(" not (name like '%" + patternProcessed + "%')");
                    } else if (pattern.startsWith("*")) {
                        patternProcessed = pattern.substring(1);
                        notLikeSet.add(" not (name like '%" + patternProcessed + "')");
                    } else if (pattern.endsWith("*")) {
                        patternProcessed = pattern.substring(0, pattern.length() - 1);
                        notLikeSet.add(" not (name like '" + patternProcessed + "%')");
                    } else {
                        containSet.add("'" + patternEntry + "'");
                    }
                }
                ++n2;
            }
            if (!containSet.isEmpty()) {
                sb.append(" name not in ");
                sb.append(((Object)containSet).toString());
            }
            if (!notLikeSet.isEmpty()) {
                for (String nl : notLikeSet) {
                    if (sb.length() > 0) {
                        sb.append(" and ");
                    }
                    sb.append(nl);
                }
            }
        }
        return sb;
    }

    public static boolean isValidName(String name, String[] restrictions) {
        String[] stringArray = restrictions;
        int n = restrictions.length;
        int n2 = 0;
        while (n2 < n) {
            String patternProcessed;
            String patternEntry = stringArray[n2];
            String pattern = patternEntry.trim();
            if (pattern.startsWith("*") && pattern.endsWith("*") ? name.contains(patternProcessed = pattern.substring(1, pattern.length() - 1)) : (pattern.startsWith("*") ? name.endsWith(patternProcessed = pattern.substring(1)) : (pattern.endsWith("*") ? name.startsWith(patternProcessed = pattern.substring(0, pattern.length() - 1)) : name.equals(pattern)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void fillExpandablePrograms(OrientBaseGraph dbg, boolean isForward, Set<String> toCheck, StringBuilder nameRestrictions, Set<String> toFill) {
        String queryFW = "select @rid.asString() as proxyRid from ProgramProxy where out('ProxyFor').outE('ProgramCall').size()>0 and @@@@@EZLEGACY@@@@@@@@@WHILE@EZLEGACY@@@@";
        String queryBW = "select @rid.asString() as proxyRid from ProgramProxy where in('ProgramCall').inE('ProxyFor').size()>0 and @@@@@EZLEGACY@@@@@@@@@WHILE@EZLEGACY@@@@";
        String qry = null;
        if (isForward) {
            qry = queryFW.replace(RID_MARKER, " @rid in " + toCheck);
        } else if (!isForward) {
            qry = queryBW.replace(RID_MARKER, " @rid in " + toCheck);
        }
        if (qry != null) {
            qry = nameRestrictions != null && !nameRestrictions.toString().isEmpty() ? qry.replace(WHILE_MARKER, " and (" + nameRestrictions.toString() + ")") : qry.replace(WHILE_MARKER, "");
            CloseableIterable childrenPrg = (CloseableIterable)dbg.command((OCommandRequest)new OCommandSQL(qry)).execute(new Object[0]);
            for (OrientElement elem : childrenPrg) {
                String rid = (String)elem.getProperty("proxyRid");
                toFill.add(rid);
            }
        } else {
            L.warn("query is null; nothing done!");
        }
    }

    public static String getImpactLabel(String cls) {
        return Utils.getNodeLabel(cls, true);
    }

    public static String getNodeLabel(String cls, boolean isImpact) {
        if ("DSName".equals(cls) || "FileUsageInfo".equals(cls)) {
            if (isImpact) {
                return "Dataset";
            }
            return "File";
        }
        if ("SQLFieldProxy".equals(cls)) {
            return "SQL Field";
        }
        if ("SQLTableProxy".equals(cls)) {
            return "SQL Table";
        }
        if ("Program".equals(cls) || "ProgramProxy".equals(cls)) {
            return "Cobol Program";
        }
        if ("Variable".equals(cls)) {
            return "Variable";
        }
        if ("JCLJob".equals(cls) || "InvokedJob".equals(cls)) {
            return "JCL Job";
        }
        if ("DDNameProxy".equals(cls)) {
            if (isImpact) {
                return "DDCard";
            }
            return "File";
        }
        if ("AdabasFileProxy".equals(cls)) {
            return "Adabas";
        }
        if ("DALProxy".equals(cls)) {
            return "DAL";
        }
        if ("DBIProxy".equals(cls)) {
            return "DBI Table";
        }
        if ("IDMSSetProxy".equals(cls)) {
            return "IDMS Set";
        }
        if ("IDMSRecordProxy".equals(cls)) {
            return "IDMS Record";
        }
        if ("JCLPGM".equals(cls)) {
            return "JCL Pgm";
        }
        if ("TranProxy".equals(cls)) {
            return "Transaction";
        }
        if ("BMSProxy".equals(cls)) {
            return "BMS Map";
        }
        if ("MQQueueProxy".equals(cls)) {
            return "Queue";
        }
        if ("MQManagerProxy".equals(cls)) {
            return "Queue Manager";
        }
        if (IMS_MQ_USAGE_PROXY.equals(cls)) {
            return "IMS terminal\\transaction";
        }
        if (IMS_TERMINAL_PROXY.equals(cls)) {
            return "IMS Terminal";
        }
        if (VERTEX_GENERIC_MAP_PROXY.equals(cls)) {
            return "Generic Map";
        }
        return "UNKNOWN";
    }

    public static TSEEdge getOrCreateEdge(TSEGraphManager graphManager, TSENode from, TSENode to) {
        TSEEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            if (!ed.getTargetNode().equals(to)) continue;
            edge = ed;
            break;
        }
        if (edge == null) {
            edge = graphManager.getEdgeBuilder().addEdge(graphManager, from, to);
        }
        return edge;
    }

    public static void setPropertiesViewerForNodes(TSENode node, String pathOrName, boolean isPath) {
        String type = (String)node.getAttributeValue(TSMEMBER_TYPE);
        if (type == null) {
            return;
        }
        if (isPath) {
            node.setAttribute("Node_Mainframe", (Object)new MainframeSourceNode(type, pathOrName));
        } else {
            node.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(pathOrName, type));
        }
    }

    public static void setPropertiesViewerForDatasets(TSENode node, String name, String memberName, String generationNumber, String type) {
        node.setAttribute("Node_Mainframe", (Object)new DatasetNode(name, memberName, (Object)generationNumber, type));
    }

    public static String translateOffToVarChild(Vertex childV, String pName, Integer pmo, Integer pio, Integer pis) {
        String name = (String)childV.getProperty("name");
        int voff = (Integer)childV.getProperty("memOffset");
        int vSize = (Integer)childV.getProperty("size");
        int vIOff = Math.max(0, pio - (voff - pmo));
        int vISize = Math.min(vSize - vIOff, pmo + pio + pis - (voff + vIOff));
        name = Utils.getDisplayNameForVariable(name, pName, 1, vIOff, vISize);
        return name;
    }

    public static String translateOffToVarChild(Vertex childV, Value firstParentValue, boolean displayParent) {
        boolean isChild = childV.getProperty("ancestor").equals(firstParentValue.getContext("var_sid"));
        if (isChild) {
            Integer pmo = (Integer)firstParentValue.getContext("memOffset");
            Integer pio = (Integer)firstParentValue.getContext("impactedOffset");
            Integer pis = (Integer)firstParentValue.getContext("impactedSize");
            return Utils.translateOffToVarChild(childV, displayParent ? firstParentValue.getVertexName() : null, pmo, pio, pis);
        }
        return null;
    }

    public static String getProgTypeDescription(String prgType) {
        if (String.valueOf(1).equals(prgType)) {
            return "COBOL";
        }
        if (String.valueOf(2).equals(prgType)) {
            return "PL1";
        }
        if (String.valueOf(22).equals(prgType)) {
            return "JCL";
        }
        return "default";
    }

    public static String getResTypeAsInt(String vertexCls) {
        if ("SQLTableProxy".equals(vertexCls)) {
            return "1";
        }
        if ("BMSProxy".equals(vertexCls)) {
            return "6";
        }
        if ("DDNameProxy".equals(vertexCls)) {
            return "9";
        }
        if ("AdabasFileProxy".equals(vertexCls)) {
            return "56";
        }
        if (VERTEX_NATURAL_MAP_PROXY.equals(vertexCls)) {
            return "61";
        }
        if ("IDMSRecordProxy".equals(vertexCls)) {
            return "77";
        }
        if ("IDMSSetProxy".equals(vertexCls)) {
            return "78";
        }
        if ("MQQueueProxy".equals(vertexCls)) {
            return "81";
        }
        if ("DALProxy".equals(vertexCls)) {
            return "189";
        }
        if ("DBIProxy".equals(vertexCls)) {
            return "190";
        }
        if ("SQLFieldProxy".equals(vertexCls)) {
            return "187";
        }
        if ("ProgramProxy".equals(vertexCls)) {
            return "5";
        }
        if (IMS_MQ_USAGE_PROXY.equals(vertexCls)) {
            return "21";
        }
        if (IMS_TERMINAL_PROXY.equals(vertexCls)) {
            return "19";
        }
        if (VERTEX_IMS_SEGMENT_PROXY.equals(vertexCls)) {
            return "209";
        }
        if (VERTEX_GENERIC_MAP_PROXY.equals(vertexCls)) {
            return "220";
        }
        return "-1";
    }

    public static void addStmtRidsForEdge(TSEEdge edge, Set<String> stmtRids) {
        if (stmtRids != null) {
            ArrayList<String> list = (ArrayList<String>)edge.getAttributeValue(VERTEX_ID_LIST);
            if (list == null) {
                list = new ArrayList<String>();
                edge.setAttribute(VERTEX_ID_LIST, list);
            }
            list.addAll(stmtRids);
        }
    }
}

