/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.utils;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.gdb.core.utils.Utils;
import com.ez.graphs.viewer.odb.Activator;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.ui.DynamicCallContent;
import com.ez.internal.analysis.config.inputs.EZSourceDynamicCall;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.mainframe.override.resolutions.ResolutionsProxy;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.mainframe.override.resolutions.model.UserAssistedResolution;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResolutionUtils.class);

    public static int applyResolution(ProjectInfo pInfo, String stmtId, Resolution toApply, String prgType, boolean saveResolution, IProgressMonitor pmonitor) {
        int ok;
        block12: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
            ok = 100;
            Properties env = ConnectionUtils.getODBSettings((String)pInfo.getName());
            OrientBaseGraph graph = ConnectionUtils.getTxGraph((Properties)env);
            try {
                try {
                    OrientVertex stmt = null;
                    stmt = stmtId == null ? ResolutionUtils.getStatementForResolution(graph, toApply, prgType) : graph.getVertex((Object)stmtId);
                    if (stmt == null) {
                        L.error("statement with vertex ID {} does not exist in database", (Object)stmtId);
                        ok = 3;
                        break block12;
                    }
                    if (ResolutionUtils.doApplyResolution(graph, (Vertex)stmt, toApply, (IProgressMonitor)monitor.newChild(100))) {
                        Vertex prgV = ResolutionUtils.getProgramForStatement((Vertex)stmt);
                        Object sid = prgV.getProperty("sid");
                        String prgId = sid != null ? sid.toString() : null;
                        String ancestor = ResolutionUtils.computeAncestor(toApply, prgType);
                        try {
                            ResolutionsProxy.registerResolution((Resolution)toApply, (boolean)saveResolution, (String)prgType, (String)prgId, (String)ancestor, (ProjectInfo)pInfo);
                            ok = 0;
                        }
                        catch (RuntimeException ex) {
                            if (ex.getCause() instanceof ResolutionException) {
                                ResolutionException rEx = (ResolutionException)ex.getCause();
                                if (rEx.httpResponseCode == 409) {
                                    L.error("could not acquire journal distributed lock");
                                    ok = 1;
                                }
                            }
                            if (ok != 1) {
                                L.error("while requesting change of journal file", (Throwable)ex);
                                ok = 50;
                            }
                            break block12;
                        }
                    }
                    L.error("there was a problem while applying resolutions in database!");
                    ok = 100;
                }
                catch (Throwable t) {
                    L.error("while applying resolution", t);
                    ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
                }
            }
            finally {
                ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
            }
        }
        return ok;
    }

    private static String computeAncestor(Resolution toApply, String prgType) {
        String ancestor = null;
        try {
            String[] tmp;
            int pTypeVal = Integer.valueOf(prgType);
            if ((1 == pTypeVal || 16 == pTypeVal || 15 == pTypeVal) && (tmp = toApply.contextName.split(":")).length > 1) {
                ancestor = tmp[tmp.length - 2].trim();
            }
        }
        catch (NumberFormatException ex) {
            L.warn("wrong program type", (Throwable)ex);
        }
        return ancestor;
    }

    private static OrientVertex getStatementForResolution(OrientBaseGraph graph, Resolution resolution, String prgType) {
        Iterator iterator;
        String[] stringArray;
        OrientVertex stmtVertex = null;
        String prgName = resolution.contextName;
        if (!prgType.equals(String.valueOf(2))) {
            stringArray = prgName.split(":");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prgName;
        }
        String[] parts = stringArray;
        if (parts.length > 1) {
            prgName = parts[parts.length - 1].trim();
        }
        String prgPath = resolution.contextPath;
        prgPath = Utils.convertToODBPath((String)prgPath);
        String stmtPath = resolution.path;
        stmtPath = Utils.convertToODBPath((String)stmtPath);
        Integer stmtLine = resolution.line;
        String query2 = "SELECT @rid as st from Statement \n let $p = in('HasS')[0],\n $s = outE('SourceInfo')[0] where $s.sLine = ? and $s.in.full = ? and typeId = ? and \n $p.name = ? and $p.type = ? and $p.out('SourceInfo')[0].full = ?";
        CloseableIterable ret2 = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL(query2)).execute(new Object[]{stmtLine, stmtPath, resolution.stmtType, prgName, prgType, prgPath});
        if (ret2 != null && (iterator = ret2.iterator()).hasNext()) {
            OrientVertex v = (OrientVertex)iterator.next();
            stmtVertex = (OrientVertex)v.getProperty("st");
        }
        return stmtVertex;
    }

    private static boolean doApplyResolution(OrientBaseGraph graph, Vertex stmt, Resolution toApply, IProgressMonitor pmonitor) {
        boolean ok;
        block27: {
            ok = true;
            Vertex prgV = ResolutionUtils.getProgramForStatement(stmt);
            boolean bl = ok = prgV != null;
            if (ok) {
                try {
                    ok = ResolutionUtils.checkValues(prgV, toApply);
                    if (!ok) break block27;
                    pmonitor.subTask(Messages.getString(ResolutionUtils.class, "deletingParameters.subtask"));
                    ResolutionUtils.deleteActualParameters(graph, stmt);
                    String prgRid = prgV.getId().toString();
                    List<Vertex> puVs = ResolutionUtils.getProgramUsageInfos(stmt);
                    if (!puVs.isEmpty()) {
                        pmonitor.subTask(Messages.getString(ResolutionUtils.class, "deletingProgramCall.subtask"));
                        ResolutionUtils.deleteProgramCall(graph, prgV, puVs);
                        pmonitor.subTask(Messages.getString(ResolutionUtils.class, "deletingProgramUsage.subtask"));
                        L.debug("deleting ProgramUsageInfo nodes");
                        Object[] sourceInfo = null;
                        boolean first = true;
                        for (Vertex v : puVs) {
                            if (first) {
                                first = false;
                                sourceInfo = ResolutionUtils.getSourceInfo(v);
                            }
                            graph.removeVertex(v);
                        }
                        puVs.clear();
                        puVs = null;
                        graph.commit();
                        pmonitor.subTask(Messages.getString(ResolutionUtils.class, "applyingValues.subtask"));
                        List<Vertex> apus = ResolutionUtils.getActualParameterUsages(stmt);
                        Iterable childrenVertices = ((Vertex)((Iterator)((Object)prgV.getVertices(Direction.IN, new String[]{"ProxyFor"}))).next()).getVertices(Direction.IN, new String[]{"Ancestor"});
                        HashMap<Pair, Vertex> ancestors = new HashMap<Pair, Vertex>();
                        ArrayList<OrientVertex> newNodeDependents = new ArrayList<OrientVertex>();
                        ArrayList<Edge> newEdgeDependents = new ArrayList<Edge>();
                        for (ValuesTriplet p : toApply.values) {
                            String prgName = (String)p.getFirst();
                            Integer prgType = (Integer)p.getSecond();
                            String ancestor = (String)p.getThird();
                            ArrayList<Object> pps = new ArrayList<Object>();
                            Iterator childrenVIt = childrenVertices.iterator();
                            boolean found = false;
                            while (childrenVIt.hasNext()) {
                                Vertex vertex = (Vertex)childrenVIt.next();
                                if (!prgName.equals(vertex.getProperty("name")) || !prgType.equals(vertex.getProperty("type"))) continue;
                                pps.add(vertex);
                                found = true;
                                break;
                            }
                            if (found && (ancestor == null || ancestor.isEmpty())) {
                                ancestor = (String)prgV.getProperty("name");
                                p.setThird((Object)ancestor);
                            }
                            if (!found) {
                                if (ancestor == null || ancestor.isEmpty()) {
                                    Vertex vertex = ResolutionUtils.searchProgramGlobal(graph, prgName, prgType, false);
                                    if (vertex != null) {
                                        pps.add(vertex);
                                        Object valueType = vertex.getProperty("type");
                                        if (!valueType.equals(prgType)) {
                                            String ancName;
                                            Vertex anc;
                                            L.info("change type of value [{}] from {} to {}", new Object[]{prgName, prgType, valueType});
                                            String errorLogMsg = Messages.getString(ResolutionUtils.class, "typechanged.errorlog.message", new String[]{prgName, ProgramType.fromID((Integer)prgType).name(), ProgramType.fromID((Integer)((Integer)valueType)).name()});
                                            ResolutionUtils.displayInfo(errorLogMsg);
                                            p.setSecond((Object)((Integer)valueType));
                                            Iterator it = vertex.getVertices(Direction.OUT, new String[]{"Ancestor"}).iterator();
                                            if (it != null && it.hasNext() && (anc = (Vertex)it.next()) != null && !(ancName = (String)anc.getProperty("name")).equalsIgnoreCase((String)p.getThird())) {
                                                L.info("change ancestor of value [{}] from {} to {}", new Object[]{prgName, p.getThird(), ancName});
                                                ResolutionUtils.displayInfo(Messages.getString(ResolutionUtils.class, "ancestorchanged.errorlog.message", new String[]{prgName, (String)p.getThird(), ancName}));
                                                p.setThird((Object)ancName);
                                            }
                                        }
                                    }
                                } else {
                                    Vertex pv;
                                    int n = ResolutionUtils.getAncestorType(prgType);
                                    Vertex aV = ResolutionUtils.searchProgramGlobal(graph, ancestor, n, true);
                                    Pair ancKey = new Pair((Object)ancestor, (Object)n);
                                    if (aV == null) {
                                        aV = (Vertex)ancestors.get(ancKey);
                                    }
                                    if (aV != null) {
                                        childrenVIt = aV.getVertices(Direction.IN, new String[]{"Ancestor"}).iterator();
                                        pv = null;
                                        while (childrenVIt.hasNext()) {
                                            Vertex cV = (Vertex)childrenVIt.next();
                                            if (!prgName.equals(cV.getProperty("name")) || prgType != (Integer)cV.getProperty("type")) continue;
                                            pv = cV;
                                            pps.add(cV);
                                            break;
                                        }
                                        if (pv == null) {
                                            pv = graph.addVertex((Object)"class:ProgramProxy", new Object[]{"sid", -1, "name", prgName, "type", prgType, "aliasType", 0});
                                            graph.addEdge(null, pv, aV, "Ancestor");
                                            pps.add(pv);
                                        }
                                    } else {
                                        aV = graph.addVertex((Object)"class:ProgramProxy", new Object[]{"sid", -1, "name", ancestor, "type", n, "aliasType", 0});
                                        ancestors.put(ancKey, aV);
                                        pv = graph.addVertex((Object)"class:ProgramProxy", new Object[]{"sid", -1, "name", prgName, "type", prgType, "aliasType", 0});
                                        graph.addEdge(null, pv, aV, "Ancestor");
                                        pps.add(pv);
                                    }
                                }
                            }
                            if (pps.isEmpty()) {
                                OrientVertex orientVertex = graph.addVertex((Object)"class:ProgramProxy", new Object[]{"sid", -1, "name", prgName, "type", prgType, "aliasType", 0});
                                pps.add(orientVertex);
                            }
                            for (Vertex vertex : pps) {
                                OrientEdge e;
                                OrientVertex uV = graph.addVertex((Object)"class:ProgramUsageInfo", new Object[]{"name", prgName, "dfs", Boolean.TRUE});
                                newNodeDependents.add(uV);
                                graph.addEdge(null, stmt, (Vertex)uV, "UsesPUI");
                                if (sourceInfo != null) {
                                    e = ResolutionUtils.addSourceInfo(graph, (Vertex)uV, (Vertex)sourceInfo[0], (Integer)sourceInfo[1], (Integer)sourceInfo[2], (Integer)sourceInfo[3], (Integer)sourceInfo[4]);
                                    newEdgeDependents.add((Edge)e);
                                }
                                e = graph.addEdge(null, (Vertex)uV, vertex, "PUIResourceLink");
                                newEdgeDependents.add((Edge)e);
                                e = graph.addEdge(null, prgV, vertex, "ProgramCall");
                                newEdgeDependents.add((Edge)e);
                                e.setProperty("prgUsage", uV.getProperty("@rid"));
                                ResolutionUtils.addActualParameters(graph, vertex, ancestor, apus, newEdgeDependents);
                                CloseableIterable ret1 = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL("select from JCLPGM where name = ? and inE('ContextOf').size() = 0 ")).execute(new Object[]{prgName});
                                if (ret1 == null || ret1.iterator() == null || !ret1.iterator().hasNext()) continue;
                                OrientVertex pgmContextV = graph.addVertex((Object)"class:PGMContext");
                                Edge eInContext = vertex.addEdge("InContext", (Vertex)pgmContextV);
                                eInContext.setProperty("pgm", (Object)true);
                                for (OrientVertex jclpgmV : ret1) {
                                    pgmContextV.addEdge("ContextOf", (Vertex)jclpgmV);
                                }
                            }
                        }
                        ancestors.clear();
                        graph.addVertex((Object)"class:NodeDependents", new Object[]{"master", prgV.getId(), "dependents", newNodeDependents});
                        L.debug("updated {} element references for {}", (Object)newNodeDependents.size(), (Object)prgRid);
                        graph.addVertex((Object)"class:EdgeDependents", new Object[]{"master", prgV.getId(), "dependents", newEdgeDependents});
                        L.debug("updated {} element edges for {}", (Object)newEdgeDependents.size(), (Object)prgRid);
                        graph.commit();
                        long start = System.currentTimeMillis();
                        String query = "select @rid as pgmctx, out('ContextOf')[0].name as pgmname from (select expand(in('ProxyFor').out('InContext')) from AD_FROM)";
                        CloseableIterable ret1 = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL(query.replace("AD_FROM", prgRid))).execute(new Object[0]);
                        if (ret1 != null) {
                            for (OrientElement v : ret1) {
                                OrientVertex pgmContextV = (OrientVertex)v.getProperty("pgmctx");
                                String pgmname = (String)v.getProperty("pgmname");
                                long l = System.currentTimeMillis();
                                String delQuery = "delete edge InContext to " + pgmContextV.getId();
                                graph.command((OCommandRequest)new OCommandSQL(delQuery)).execute(new Object[0]);
                                L.debug("remove incontext edges {} ms", (Object)(System.currentTimeMillis() - l));
                                long startl = System.currentTimeMillis();
                                ResolutionUtils.addPGMContext(graph, (Vertex)pgmContextV, pgmname);
                                L.debug("add ctx vertex {} ms", (Object)(System.currentTimeMillis() - startl));
                                graph.commit();
                            }
                        }
                        L.debug("updated pgmContext in {} ms", (Object)(System.currentTimeMillis() - start));
                        ResolutionUtils.deleteUnreferencedProgramProxies(graph);
                        ResolutionUtils.deleteUnreferencesPGMContext(graph);
                        break block27;
                    }
                    L.warn("no program usage in statement {} - nothing to do", (Object)stmt);
                    ok = false;
                }
                catch (Exception e) {
                    L.error("could not apply resolution", (Throwable)e);
                    ok = false;
                    graph.rollback();
                }
            } else {
                L.error("could not get program for statement {}", (Object)stmt);
                ok = false;
            }
        }
        return ok;
    }

    private static void displayInfo(String message) {
        Status st = LogUtil.createStatus((int)1, (Bundle)Activator.getDefault().getBundle(), (String)message, null);
        LogUtil.displayErrorMessage((Status)st, (boolean)false);
    }

    private static boolean checkValues(Vertex prgV, Resolution toApply) {
        Iterable childrenVertices = ((Vertex)((Iterator)((Object)prgV.getVertices(Direction.IN, new String[]{"ProxyFor"}))).next()).getVertices(Direction.IN, new String[]{"Ancestor"});
        ArrayList tmp = new ArrayList(toApply.values);
        for (ValuesTriplet p : tmp) {
            String prgName = (String)p.getFirst();
            Integer prgType = (Integer)p.getSecond();
            String ancestor = (String)p.getThird();
            boolean found = false;
            if (prgType == 1 && ancestor != null) {
                for (Vertex cV : childrenVertices) {
                    if (!prgName.equals(cV.getProperty("name")) || !prgType.equals(cV.getProperty("type"))) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
            if (found) continue;
            L.warn("value {} was not considered because embedded program not exist in project", (Object)p);
            ResolutionUtils.displayInfo(Messages.getString(ResolutionUtils.class, "cobolEmbeddedNotInProject.errorlog.mesage", new String[]{String.valueOf(ancestor) + ":" + prgName, prgName}));
            toApply.values.remove(p);
        }
        return !toApply.values.isEmpty();
    }

    public static void deleteUnreferencedProgramProxies(OrientBaseGraph graph) {
        String queryForChildren = "delete vertex ProgramProxy where outE('ProxyFor').size() = 0 and inE('ProgramCall').size() = 0 and inE('TranMapping').size() = 0 and outE('Ancestor').size() > 0 limit -1";
        Integer retChCount = (Integer)graph.command((OCommandRequest)new OCommandSQL(queryForChildren)).execute(null);
        if (retChCount != null) {
            L.debug("removed unreferenced child program proxies: count = {}", (Object)retChCount);
        }
        graph.commit();
        String query = "delete vertex ProgramProxy where outE('ProxyFor').size() = 0 and inE('ProgramCall').size() = 0 and inE('TranMapping').size() = 0 and inE('Ancestor').size() = 0 limit -1";
        Integer retCount = (Integer)graph.command((OCommandRequest)new OCommandSQL(query)).execute(null);
        if (retCount != null) {
            L.debug("removed unreferenced top level program proxies: count = {}", (Object)retCount);
        }
        graph.commit();
        L.info("delete unreferenced program proxies");
    }

    public static void deleteUnreferencesPGMContext(OrientBaseGraph graph) {
        String query = "select from PGMContext where inE('InContext').size() = 0 limit -1";
        CloseableIterable retIble = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL(query)).execute(null);
        for (Vertex v : retIble) {
            if (v == null) continue;
            v.remove();
        }
        L.info("delete unreferenced PGMContext");
    }

    private static Vertex searchProgramGlobal(OrientBaseGraph graph, String prgName, int prgType, boolean isAncestor) {
        List<Vertex> list;
        Vertex pv = null;
        if (prgType != 1 && !(list = ResolutionUtils.findProgramProxy(graph, prgName, prgType)).isEmpty()) {
            pv = list.get(0);
        }
        if (pv == null) {
            List<Vertex> allpps = ResolutionUtils.findProgramProxy(graph, prgName, 1);
            for (Vertex ppv : allpps) {
                Iterator it = ppv.getEdges(Direction.OUT, new String[]{"Ancestor"}).iterator();
                if (it.hasNext()) continue;
                pv = ppv;
                break;
            }
        }
        if (pv == null && !isAncestor) {
            if (prgType != 15 && pv == null && !(list = ResolutionUtils.findProgramProxy(graph, prgName, 15)).isEmpty()) {
                pv = list.get(0);
            }
            if (prgType != 16 && pv == null && !(list = ResolutionUtils.findProgramProxy(graph, prgName, 16)).isEmpty()) {
                pv = list.get(0);
            }
        } else {
            L.debug("stop");
        }
        return pv;
    }

    private static void addActualParameters(OrientBaseGraph graph, Vertex proxyV, String ancestor, List<Vertex> apus, List<Edge> edgeDependents) {
        String programName = (String)proxyV.getProperty("name");
        int programType = (Integer)proxyV.getProperty("type");
        for (Vertex apu : apus) {
            Vertex parProxyV2;
            int paramPos = (Integer)apu.getProperty("paramPos");
            boolean found = false;
            Iterable ppvsble = graph.getVertices("ParameterProxy", new String[]{"name", "type", "ancestor", "paramPos"}, new Object[]{programName, programType, ancestor, paramPos});
            for (Vertex parProxyV2 : ppvsble) {
                int pPos = (Integer)parProxyV2.getProperty("paramPos");
                if (paramPos != pPos) continue;
                OrientEdge e = graph.addEdge(null, apu, parProxyV2, "ActualParameter");
                edgeDependents.add((Edge)e);
                found = true;
                break;
            }
            if (found) continue;
            parProxyV2 = graph.addVertex((Object)"class:ParameterProxy", new Object[]{"name", programName, "type", programType, "paramPos", paramPos});
            if (ancestor != null) {
                parProxyV2.setProperty("ancestor", (Object)ancestor);
            }
            graph.addEdge(null, parProxyV2, proxyV, "ParameterOf");
            OrientEdge e = graph.addEdge(null, apu, parProxyV2, "ActualParameter");
            edgeDependents.add((Edge)e);
        }
    }

    private static void addPGMContext(OrientBaseGraph graph, Vertex pgmContextV, String pgmName) {
        L.info("process jclpgm {}", (Object)pgmName);
        String query = String.format("select @rid.asString() as proxyrid from (traverse out('ProxyFor', 'ProgramCall') from (select from ProgramProxy where name = '%s')) where @class = 'ProgramProxy'", pgmName);
        CloseableIterable retIble2 = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        ((OrientVertex)pgmContextV).reload();
        Iterator retIt = retIble2.iterator();
        HashMap<Integer, HashSet<Edge>> executedPgm = new HashMap<Integer, HashSet<Edge>>();
        while (retIt.hasNext()) {
            Iterable pIt;
            Iterator iterator;
            String proxyrid = (String)((Vertex)retIt.next()).getProperty("proxyrid");
            OrientVertex progProxyV = graph.getVertex((Object)proxyrid);
            progProxyV.reload();
            L.debug("add for {} incontext edge to program {}", (Object)pgmName, progProxyV.getProperty("name"));
            Edge e = progProxyV.addEdge("InContext", pgmContextV);
            if (pgmName.equals(progProxyV.getProperty("name"))) {
                Integer type = (Integer)progProxyV.getProperty("type");
                HashSet<Edge> edges = (HashSet<Edge>)executedPgm.get(type);
                if (edges == null) {
                    edges = new HashSet<Edge>();
                    executedPgm.put(type, edges);
                }
                edges.add(e);
            }
            if (!(iterator = (pIt = progProxyV.getVertices(Direction.OUT, new String[]{"ProxyFor"})).iterator()).hasNext()) continue;
            Vertex pV = (Vertex)iterator.next();
            String prgRid = pV.getId().toString();
            e.setProperty("prgRid", (Object)prgRid);
        }
        boolean addedExecPGMMarker = false;
        for (Integer key : executedPgm.keySet()) {
            if (key == 8) continue;
            for (Edge e : (Set)executedPgm.get(key)) {
                e.setProperty("pgm", (Object)true);
                addedExecPGMMarker = true;
            }
        }
        if (!addedExecPGMMarker && executedPgm.containsKey(8)) {
            for (Edge e : (Set)executedPgm.get(8)) {
                e.setProperty("pgm", (Object)true);
            }
        }
    }

    private static Vertex getProgramForStatement(Vertex stmt) {
        Iterator it;
        Vertex pV = null;
        Iterable ible = stmt.getVertices(Direction.IN, new String[]{"HasS"});
        if (ible != null && (it = ible.iterator()) != null && it.hasNext()) {
            pV = (Vertex)it.next();
        }
        return pV;
    }

    private static List<Vertex> getProgramUsageInfos(Vertex stmt) {
        ArrayList<Vertex> pVs = new ArrayList<Vertex>();
        Iterable ible = stmt.getVertices(Direction.OUT, new String[]{"UsesPUI"});
        if (ible != null) {
            Iterator it = ible.iterator();
            while (it != null && it.hasNext()) {
                Vertex v = (Vertex)it.next();
                pVs.add(v);
            }
        }
        return pVs;
    }

    private static List<Vertex> getActualParameterUsages(Vertex stmt) {
        ArrayList<Vertex> apus = new ArrayList<Vertex>();
        Iterable ible = stmt.getVertices(Direction.OUT, new String[]{"UsesAP"});
        if (ible != null) {
            Iterator it = ible.iterator();
            while (it != null && it.hasNext()) {
                Vertex v = (Vertex)it.next();
                apus.add(v);
            }
        }
        return apus;
    }

    private static void deleteActualParameters(OrientBaseGraph graph, Vertex stmt) {
        String query = "delete edge E where @rid in (select out('UsesAP').outE('ActualParameter') from " + stmt.getId().toString() + ")";
        graph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
    }

    private static void deleteProgramCall(OrientBaseGraph graph, Vertex prgV, List<Vertex> puVs) {
        L.debug("deleting ProgramCall edges");
        HashSet<String> okIds = new HashSet<String>();
        for (Vertex puV : puVs) {
            okIds.add(puV.getId().toString());
        }
        Iterable ible = prgV.getEdges(Direction.OUT, new String[]{"ProgramCall"});
        if (ible != null) {
            Iterator it = ible.iterator();
            while (it != null && it.hasNext()) {
                Edge e = (Edge)it.next();
                Vertex v = (Vertex)e.getProperty("prgUsage");
                if (v == null || !okIds.contains(v.getId().toString())) continue;
                graph.removeEdge(e);
            }
        }
    }

    private static List<Vertex> findProgramProxy(OrientBaseGraph graph, String programName, Integer programType) {
        ArrayList<Vertex> pv = new ArrayList<Vertex>();
        String query = "select from ProgramProxy where name = ? and type = ? ";
        CloseableIterable retIble = (CloseableIterable)graph.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{programName, programType});
        for (Vertex v : retIble) {
            pv.add(v);
        }
        return pv;
    }

    private static Object[] getSourceInfo(Vertex v) {
        Iterator it;
        Object[] objectArray = new Object[5];
        objectArray[1] = 0;
        objectArray[2] = 0;
        objectArray[3] = 0;
        objectArray[4] = 0;
        Object[] si = objectArray;
        Iterable ible = v.getEdges(Direction.OUT, new String[]{"SourceInfo"});
        if (ible != null && (it = ible.iterator()) != null && it.hasNext()) {
            Edge e = (Edge)it.next();
            si[0] = e.getVertex(Direction.IN);
            si[1] = e.getProperty("sLine");
            si[2] = e.getProperty("sCol");
            si[3] = e.getProperty("eLine");
            si[4] = e.getProperty("eCol");
        }
        return si[0] == null ? null : si;
    }

    private static OrientEdge addSourceInfo(OrientBaseGraph graph, Vertex from, Vertex to, int sLine, int sCol, int eLine, int eCol) {
        if (to.getClass().equals("Path")) {
            throw new IllegalArgumentException("SourceInfo should target Path nodes");
        }
        OrientEdge edge = graph.addEdge(null, from, to, "SourceInfo");
        edge.setProperties(new Object[]{"sLine", sLine, "sCol", sCol, "eLine", eLine, "eCol", eCol});
        L.trace("add SourceInfo {}", (Object)edge);
        return edge;
    }

    public static EZSourceDynamicCall buildInputType(Resolution resolution, ProjectInfo pInfo, String prgType, Set<TextSelectionInFile> callLocations) {
        EZSourceDynamicCall applicableInputType = new EZSourceDynamicCall();
        if (callLocations == null) {
            HashSet<TextSelectionInFile> defs = new HashSet<TextSelectionInFile>();
            TextSelectionInFile defTxt = new TextSelectionInFile(resolution.path, prgType, new Integer[]{resolution.line});
            defs.add(defTxt);
            applicableInputType.addProperty("file", (Object)defTxt);
        } else {
            applicableInputType.addProperty("file", callLocations);
        }
        applicableInputType.addProperty("contextSeq", (Object)resolution.contextSeq);
        String stmtType = resolution.stmtType.toString();
        applicableInputType.addProperty("stmtTypeId", (Object)stmtType);
        EZEntityID entity = new EZEntityID();
        entity.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
        StatementNode node = new StatementNode(stmtType);
        EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
        entity.addSegment((EZSegment)sg);
        applicableInputType.setEntID(entity);
        HashSet<TextSelectionInFile> prgs = new HashSet<TextSelectionInFile>();
        TextSelectionInFile prgTxt = new TextSelectionInFile(resolution.contextPath, prgType);
        prgs.add(prgTxt);
        EZSourceProgram objType = (EZSourceProgram)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(prgType));
        objType.addProperty("program_path", (Object)resolution.contextPath);
        objType.addProperty("program name", (Object)resolution.contextName);
        objType.addProperty("FILE", prgs);
        applicableInputType.addProperty("call_context", (Object)objType);
        return applicableInputType;
    }

    public static DynamicCallContent.ResolutionType getResType(Resolution r) {
        DynamicCallContent.ResolutionType callType = r == null ? DynamicCallContent.ResolutionType.NOT_RESOLVED : (r.isManual() ? DynamicCallContent.ResolutionType.MANUALLY_RESOLVED : (r.isSolved() ? DynamicCallContent.ResolutionType.AUTOMATICALLY_RESOLVED : DynamicCallContent.ResolutionType.NOT_RESOLVED));
        return callType;
    }

    public static int removeResolution(ProjectInfo pInfo, JournalEntry entry, IProgressMonitor pmonitor) {
        int ok;
        SubMonitor monitor;
        block8: {
            monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            ok = 100;
            Properties env = ConnectionUtils.getODBSettings((String)pInfo.getName());
            OrientBaseGraph graph = ConnectionUtils.getTxGraph((Properties)env);
            try {
                try {
                    ResolutionsProxy.deleteEntry((ProjectInfo)pInfo, (JournalEntry)entry);
                    ok = 0;
                }
                catch (Throwable ex) {
                    if (ex.getCause() instanceof ResolutionException) {
                        ResolutionException rEx = (ResolutionException)ex.getCause();
                        if (rEx.httpResponseCode == 409) {
                            L.error("could not acquire journal distributed lock");
                            ok = 1;
                        }
                    }
                    if (ok != 1) {
                        L.error("while removing resolution", ex);
                    }
                    ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
                throw throwable;
            }
            ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
        }
        monitor.worked(100);
        return ok;
    }

    public static int reassignResolution(ProjectInfo pInfo, JournalEntry unusedEntry, JournalEntry overriddenEntry, IProgressMonitor pmonitor) {
        int ok;
        block12: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            ok = 100;
            Properties env = ConnectionUtils.getODBSettings((String)pInfo.getName());
            OrientBaseGraph graph = ConnectionUtils.getTxGraph((Properties)env);
            try {
                try {
                    Resolution toApply = ResolutionUtils.covertResolution(overriddenEntry.resolution, unusedEntry.newValues);
                    OrientVertex stmt = ResolutionUtils.getStatementForResolution(graph, toApply, unusedEntry.programType.toString());
                    if (stmt == null) {
                        L.error("statement for resolution {} does not exist in database", (Object)toApply);
                        ok = 3;
                        break block12;
                    }
                    if (ResolutionUtils.doApplyResolution(graph, (Vertex)stmt, toApply, (IProgressMonitor)monitor.newChild(100))) {
                        String ancestor = ResolutionUtils.computeAncestor(toApply, unusedEntry.programType.toString());
                        try {
                            ResolutionsProxy.reapplyResolution((JournalEntry)unusedEntry, (JournalEntry)overriddenEntry, (Resolution)toApply, (String)ancestor, (ProjectInfo)pInfo);
                            ok = 0;
                        }
                        catch (RuntimeException ex) {
                            if (ex.getCause() instanceof ResolutionException) {
                                ResolutionException rEx = (ResolutionException)ex.getCause();
                                if (rEx.httpResponseCode == 409) {
                                    L.error("could not acquire journal distributed lock");
                                    ok = 1;
                                }
                            }
                            if (ok != 1) {
                                L.error("there was a problem asking the service to reapply a resolution!", (Throwable)ex);
                                ok = 100;
                            }
                            break block12;
                        }
                    }
                    L.error("there was a problem while applying resolutions in database!");
                    ok = 100;
                }
                catch (Throwable t) {
                    L.error("while reassigning resolution", t);
                    ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
                }
            }
            finally {
                ConnectionUtils.releaseGraph((OrientBaseGraph)graph, (Properties)env);
            }
        }
        return ok;
    }

    private static Resolution covertResolution(Resolution resolution, Set<ValuesTriplet<String, Integer, String>> newValues) {
        if (resolution.isManual()) {
            resolution.values = newValues;
            return resolution;
        }
        UserAssistedResolution ret = new UserAssistedResolution();
        ret.contextName = resolution.contextName;
        ret.contextPath = resolution.contextPath;
        ret.contextSeq = resolution.contextSeq;
        ret.creationDate = resolution.creationDate;
        ret.index = resolution.index;
        ret.line = resolution.line;
        ret.path = resolution.path;
        ret.priority = resolution.priority;
        ret.resType = resolution.resType;
        ret.stmtType = resolution.stmtType;
        ret.values = newValues;
        return ret;
    }

    public static int getAncestorType(int type) {
        int ret = type;
        switch (type) {
            case 1: {
                ret = 1;
                break;
            }
            case 15: 
            case 16: {
                ret = 8;
                break;
            }
            default: {
                ret = type;
            }
        }
        return ret;
    }
}

