/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.utils;

public class DatasetUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final int NOT_SPECIAL = -1;
    public static final int SORTIN = 100;
    private static final int SORTOUT = 200;
    private static final int SORTOF = 300;
    private static final int SDSETO = 400;
    public static final int SDSETI = 500;
    private static final int SBDSETI = 600;
    private static final int SBDSETO = 700;
    private static final int INFILE = 800;
    private static final int OUTFIL = 900;
    private static final int SYSUT1 = 1000;
    private static final int SYSUT2 = 1100;

    public static boolean isUtility(String name) {
        return name.equalsIgnoreCase("SORT") || name.equalsIgnoreCase("DB#FTPTRN") || name.equalsIgnoreCase("SBRDWT") || name.equalsIgnoreCase("RWRDWT") || name.equalsIgnoreCase("EZTPA00") || name.equalsIgnoreCase("IEBGENER");
    }

    public static int getSpecial(String ddn) {
        int rez = -1;
        if (ddn.equalsIgnoreCase("sortin")) {
            return 100;
        }
        if (ddn.equalsIgnoreCase("sortout")) {
            return 200;
        }
        if (ddn.equalsIgnoreCase("INFILE")) {
            return 800;
        }
        if (ddn.toUpperCase().startsWith("OUTFIL")) {
            return 900;
        }
        if (ddn.equalsIgnoreCase("SYSUT1")) {
            return 1000;
        }
        if (ddn.equalsIgnoreCase("SYSUT2")) {
            return 1100;
        }
        String[] prefix = new String[]{"SORTOF", "SDSETO", "SDSETI", "SBDSETI", "SBDSETO"};
        int i = 0;
        while (i < prefix.length) {
            if (ddn.toUpperCase().startsWith(prefix[i])) {
                String suf = ddn.substring(prefix[i].length(), ddn.length());
                if (suf.length() == 2) {
                    if (Character.isDigit(suf.charAt(0)) && Character.isDigit(suf.charAt(1))) {
                        return 300 + i * 100 + Integer.valueOf(suf);
                    }
                } else if (suf.length() == 0) {
                    return 300 + i * 100;
                }
            }
            ++i;
        }
        return rez;
    }

    public static boolean arePair(int type, int cType) throws Exception {
        boolean add = false;
        if (DatasetUtils.is(100, cType)) {
            if (DatasetUtils.is(300, type) || DatasetUtils.is(200, type)) {
                add = true;
            }
        } else if (DatasetUtils.is(300, cType) || DatasetUtils.is(200, cType)) {
            if (DatasetUtils.is(100, type)) {
                add = true;
            }
        } else if (DatasetUtils.is(500, cType) || DatasetUtils.is(600, cType)) {
            if (DatasetUtils.is(400, type) && cType - 500 == type - 400) {
                add = true;
            }
            if (DatasetUtils.is(700, type) && cType - 600 == type - 700) {
                add = true;
            }
        } else if (DatasetUtils.is(400, cType) || DatasetUtils.is(700, cType)) {
            if (DatasetUtils.is(500, type) && cType - 400 == type - 500) {
                add = true;
            }
            if (DatasetUtils.is(600, type) && cType - 700 == type - 600) {
                add = true;
            }
        } else if (DatasetUtils.is(800, cType)) {
            if (DatasetUtils.is(900, type)) {
                add = true;
            }
        } else if (DatasetUtils.is(900, cType)) {
            if (DatasetUtils.is(800, type)) {
                add = true;
            }
        } else if (DatasetUtils.is(1000, cType)) {
            if (DatasetUtils.is(1100, type)) {
                add = true;
            }
        } else if (DatasetUtils.is(1100, cType)) {
            if (DatasetUtils.is(1000, type)) {
                add = true;
            }
        } else {
            throw new Exception("");
        }
        return add;
    }

    public static boolean is(int target, int what) {
        int dif = what - target;
        if (dif < 0) {
            return false;
        }
        return dif <= 99;
    }

    public static boolean verifyUtilityDDCard(boolean forward, int type) {
        if (forward && (DatasetUtils.is(100, type) || DatasetUtils.is(500, type) || DatasetUtils.is(600, type) || DatasetUtils.is(800, type) || DatasetUtils.is(1000, type))) {
            return true;
        }
        return !forward && (DatasetUtils.is(300, type) || DatasetUtils.is(200, type) || DatasetUtils.is(400, type) || DatasetUtils.is(700, type) || DatasetUtils.is(900, type) || DatasetUtils.is(1100, type));
    }

    public static boolean arePairForUnknownPgm(boolean isForward, String ddcard1, String ddcard2) {
        String dd2;
        boolean ret = false;
        String dd1 = isForward ? ddcard1 : ddcard2;
        String string = dd2 = isForward ? ddcard2 : ddcard1;
        if (dd1.toLowerCase().contains("in") && dd2.toLowerCase().contains("out")) {
            ret = true;
        } else if (dd1.equalsIgnoreCase("SYSUT1") && dd2.equalsIgnoreCase("SYSUT2")) {
            ret = true;
        }
        return ret;
    }

    public static boolean isInputForUnknownPgm(boolean isForward, String ddcard) {
        boolean ret = false;
        ret = isForward ? ddcard.toLowerCase().contains("in") || ddcard.equalsIgnoreCase("SYSUT1") : ddcard.toLowerCase().contains("out") || ddcard.equalsIgnoreCase("SYSUT2");
        return ret;
    }
}

