/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.ui;

import com.ez.graphs.viewer.odb.Activator;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.ui.DynamicCallContent;
import com.ez.graphs.viewer.odb.ui.ResolutionBasedMouseHook;
import com.ez.graphs.viewer.odb.ui.ResolutionElement;
import com.ez.graphs.viewer.odb.utils.ResolutionUtils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.ez.workspace.analysis.graph.model.NodeFilter;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.drawing.complexity.events.TSComplexityChangeEvent;
import com.tomsawyer.drawing.events.TSDrawingChangeEvent;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.events.TSGraphChangeEvent;
import com.tomsawyer.graph.events.TSGraphChangeEventData;
import com.tomsawyer.graphicaldrawing.events.TSEAnyChangeListener;
import com.tomsawyer.graphicaldrawing.events.TSEModeChangeEvent;
import com.tomsawyer.graphicaldrawing.events.TSEPropertyChangeEvent;
import com.tomsawyer.graphicaldrawing.events.TSESelectionChangeEvent;
import com.tomsawyer.graphicaldrawing.events.TSEViewportChangeEvent;
import com.tomsawyer.service.events.TSConstraintChangeEvent;
import com.tomsawyer.service.events.TSServiceInputChangeEvent;
import com.tomsawyer.util.events.TSEvent;
import com.tomsawyer.util.events.TSPreferenceChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionsContentProvider
extends ContentProvider
implements TSEAnyChangeListener {
    private static final Logger L = LoggerFactory.getLogger(ResolutionsContentProvider.class);
    private GraphInnerElement root = null;
    private EdgesRefresher viewerFilter;
    private Sorter sorter = null;
    private LabelTooltipProvider lblProvider;
    Map<Resolution, Resolution> changed = new HashMap<Resolution, Resolution>();

    public ResolutionsContentProvider(ResolutionBasedMouseHook mouseActionsHook) {
        super((MouseActionsHook)mouseActionsHook);
        this.viewerFilter = new EdgesRefresher();
        this.sorter = new Sorter();
        this.lblProvider = new LabelTooltipProvider();
    }

    public void setInputTree(Map map) {
        DynamicCallContent dynamicCallInvent = (DynamicCallContent)map.get("resolutions");
        if (dynamicCallInvent != null) {
            this.inputTree = dynamicCallInvent.getContent();
            this.root = null;
        } else {
            this.inputTree = null;
        }
    }

    public Object getInputTree() {
        if (this.root == null && this.inputTree != null) {
            this.root = new GraphInnerElement();
            this.initialize(this.root, this.inputTree);
        }
        return this.root;
    }

    private void initialize(GraphInnerElement root, Map<DynamicCallContent.ResolutionType, Map<Resolution, List<TSEdge>>> map) {
        HashMap<Resolution, List<TSEdge>> forChanges = this.changed.isEmpty() ? null : new HashMap<Resolution, List<TSEdge>>();
        for (DynamicCallContent.ResolutionType callType : map.keySet()) {
            ResolutionElement gie = new ResolutionElement(callType);
            root.addElem((GraphInnerElement)gie);
            Map<Resolution, List<TSEdge>> tmp = map.get((Object)callType);
            Set<Resolution> resrs = tmp.keySet();
            for (Resolution r : resrs) {
                ResolutionElement gieChild = null;
                Resolution newRes = this.changed.get(r);
                if (newRes == null) {
                    for (Resolution rTmp : this.changed.keySet()) {
                        if (!rTmp.getType().equals((Object)r.getType()) || !rTmp.equalNoValues(r)) continue;
                        r = rTmp;
                        newRes = rTmp;
                        break;
                    }
                }
                List<TSEdge> edgesLst = tmp.get(r);
                if (newRes != null) {
                    DynamicCallContent.ResolutionType newType = ResolutionUtils.getResType(newRes);
                    if (newType.equals((Object)callType)) {
                        gieChild = new ResolutionElement(callType, newRes, edgesLst);
                        this.changed.remove(r);
                    } else {
                        forChanges.put(newRes, edgesLst);
                    }
                } else {
                    gieChild = new ResolutionElement(callType, r, edgesLst);
                }
                if (gieChild == null) continue;
                gie.addElem(gieChild);
            }
            if (gie.getElems().size() == 0) {
                root.getElems().remove((Object)gie);
                continue;
            }
            this.annotateName(gie);
        }
        if (forChanges != null && !forChanges.isEmpty()) {
            for (Resolution r : forChanges.keySet()) {
                DynamicCallContent.ResolutionType callType = ResolutionUtils.getResType(r);
                ResolutionElement parent = this.getParentElem(callType);
                if (parent == null) {
                    parent = new ResolutionElement(callType);
                    root.addElem((GraphInnerElement)parent);
                }
                ResolutionElement gieChild = new ResolutionElement(callType, r, (List)forChanges.get(r));
                parent.addElem(gieChild);
                this.refreshName(parent);
            }
            forChanges.clear();
        }
        this.changed.clear();
    }

    private ResolutionElement getParentElem(DynamicCallContent.ResolutionType rType) {
        if (rType != null) {
            for (GraphInnerElement el : this.root.getElems()) {
                if (!((ResolutionElement)el).type.equals((Object)rType)) continue;
                return (ResolutionElement)el;
            }
        }
        return null;
    }

    public String getToolbarName() {
        return Messages.getString(ResolutionsContentProvider.class, "toolbar.button.tooltip");
    }

    public boolean isDefault() {
        return false;
    }

    public ImageDescriptor getToolbarImage() {
        return Activator.getImageDescriptor("icons/resolution.png");
    }

    public NodeFilter getViewerFilter() {
        return this.viewerFilter;
    }

    public void clean() {
        this.viewerFilter = null;
        if (this.root != null) {
            for (GraphInnerElement child : this.root.getElems()) {
                ((ResolutionElement)child).clear();
            }
            this.root.getElems().clear();
            this.root = null;
        }
        if (this.changed != null) {
            this.changed.clear();
            this.changed = null;
        }
        super.clean();
    }

    public void graphChanged(TSGraphChangeEvent event) {
        Pair values;
        TSGraphChangeEventData data = (TSGraphChangeEventData)event.getData();
        String attributeName = data.getChangedAttributeName();
        if ("changedResolution".equals(attributeName) && (values = (Pair)data.getChangedAttributeValue()) != null) {
            TSEdge edge = (TSEdge)event.getSource();
            Resolution oldRes = (Resolution)values.getFirst();
            Resolution newRes = (Resolution)values.getSecond();
            if (this.root != null) {
                DynamicCallContent.ResolutionType oldType = oldRes != null ? ResolutionUtils.getResType(oldRes) : null;
                DynamicCallContent.ResolutionType newType = ResolutionUtils.getResType(newRes);
                ResolutionElement oldParent = this.getParentElem(oldType);
                ResolutionElement newParent = this.getParentElem(newType);
                List<TSEdge> edges = null;
                if (oldParent != null) {
                    ResolutionElement el = null;
                    for (GraphInnerElement e : oldParent.getElems()) {
                        ResolutionElement elem = (ResolutionElement)e;
                        if (!elem.res.equalNoValues(oldRes)) continue;
                        el = elem;
                        break;
                    }
                    if (el != null) {
                        boolean removeFromOld = oldParent.getElems().remove((Object)el);
                        L.trace("remove old=" + removeFromOld);
                        edges = el.edges;
                    }
                    if (oldParent.getElems().isEmpty() && newParent != oldParent) {
                        this.root.getElems().remove((Object)oldParent);
                    } else if (newParent != oldParent) {
                        this.refreshName(oldParent);
                    }
                }
                if (edges == null) {
                    edges = new ArrayList<TSEdge>();
                    edges.add(edge);
                }
                ResolutionElement newChild = new ResolutionElement(newType, newRes, edges);
                if (newParent == null) {
                    newParent = new ResolutionElement(newType);
                    this.root.addElem((GraphInnerElement)newParent);
                }
                boolean addNew = newParent.getElems().add(newChild);
                L.trace("addNew=" + addNew);
                this.refreshName(newParent);
                edge.removeAttribute("changedResolution");
                if (this.co != null) {
                    this.co.contentsChanged();
                } else {
                    L.info("null changeObserver");
                }
            } else {
                L.debug("event came while provider was not initialized");
                if (this.changed.values().contains(oldRes)) {
                    Resolution initRes = null;
                    for (Resolution r : this.changed.keySet()) {
                        if (!this.changed.get(r).equals((Object)oldRes)) continue;
                        initRes = r;
                        break;
                    }
                    this.changed.put(initRes, newRes);
                } else {
                    this.changed.put(oldRes, newRes);
                }
            }
        }
    }

    private void refreshName(GraphInnerElement elem) {
        if (elem != null && elem.getElems() != null) {
            String name = ((ResolutionElement)elem).computeName();
            elem.setName(Messages.getString(ResolutionsContentProvider.class, "element.text", new String[]{name, "" + elem.getElems().size()}));
        }
    }

    public ViewerSorter getSorter() {
        return this.sorter;
    }

    public StyledCellLabelProvider getLabelProvider() {
        return this.lblProvider;
    }

    public void complexityChanged(TSComplexityChangeEvent arg0) {
    }

    public void drawingChanged(TSDrawingChangeEvent arg0) {
    }

    public void modeChanged(TSEModeChangeEvent arg0) {
    }

    public void propertyChanged(TSEPropertyChangeEvent arg0) {
    }

    public void selectionChanged(TSESelectionChangeEvent arg0) {
    }

    public void viewportChanged(TSEViewportChangeEvent arg0) {
    }

    public void constraintChanged(TSConstraintChangeEvent arg0) {
    }

    public void serviceInputChanged(TSServiceInputChangeEvent arg0) {
    }

    public void preferenceChanged(TSPreferenceChangeEvent arg0) {
    }

    public void anyChange(TSEvent arg0) {
    }

    class EdgesRefresher
    extends NodeFilter {
        EdgesRefresher() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    class LabelTooltipProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        LabelTooltipProvider() {
        }

        public String getToolTipText(Object element) {
            Resolution res;
            String ret = null;
            if (element instanceof ResolutionElement && (res = ((ResolutionElement)((Object)element)).getResolution()) != null) {
                ret = res.path;
            }
            return ret;
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public String getText(Object element) {
            if (element instanceof GraphInnerElement) {
                if (((GraphInnerElement)element).getName() == null) {
                    return null;
                }
                return ((GraphInnerElement)element).getName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element));
            super.update(cell);
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class Sorter
    extends ViewerSorter {
        private static final String EMPTY_STRING = "";

        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name2;
            String name1;
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
                name2 = e2.toString();
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ILabelProvider) {
                    Resolution res1 = ((ResolutionElement)((Object)e1)).res;
                    Resolution res2 = ((ResolutionElement)((Object)e2)).res;
                    if (res1 != null && res2 != null) {
                        String name12 = res1.contextName != null ? res1.contextName : res1.contextPath;
                        String name22 = res2.contextName != null ? res2.contextName : res2.contextPath;
                        int ret = this.getComparator().compare(name12, name22);
                        if (ret == 0) {
                            ret = res1.line.compareTo(res2.line);
                        }
                        return ret;
                    }
                    ILabelProvider lprov = (ILabelProvider)prov;
                    name1 = lprov.getText(e1);
                    name2 = lprov.getText(e2);
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            }
            if (name1 == null) {
                name1 = EMPTY_STRING;
            }
            if (name2 == null) {
                name2 = EMPTY_STRING;
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

