/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.ui;

import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.ui.DynamicCallContent;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import java.util.HashSet;
import java.util.List;

public class ResolutionElement
extends GraphInnerElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    DynamicCallContent.ResolutionType type;
    Resolution res;
    List<TSEdge> edges;

    public ResolutionElement(DynamicCallContent.ResolutionType resolutionType) {
        this.type = resolutionType;
        this.name = resolutionType == null ? "" : resolutionType.toString();
    }

    public ResolutionElement(DynamicCallContent.ResolutionType resolutionType, Resolution r, List<TSEdge> list) {
        this(resolutionType);
        this.res = r;
        this.edges = list;
        this.name = this.computeName();
    }

    String computeName() {
        String name = null;
        name = this.res != null ? Messages.getString(ResolutionElement.class, "element.name", new String[]{this.res.contextName != null ? this.res.contextName : this.res.contextPath, "" + this.res.line}) : (this.type == null ? "" : this.type.toString());
        return name;
    }

    public TSGraphMember getNode() {
        return null;
    }

    public Object getSelection() {
        return this.edges;
    }

    public Object getContextData() {
        HashSet ret = new HashSet();
        for (TSEdge e : this.edges) {
            HashSet list = (HashSet)e.getAttributeValue("FILE");
            for (TextSelectionInFile f : list) {
                if (!f.getFileName().equals(this.res.path) || f.getBounds()[0] != this.res.line) continue;
                ret.addAll(list);
            }
        }
        return ret;
    }

    public Resolution getResolution() {
        return this.res;
    }

    public List<TSEdge> getEdges() {
        return this.edges;
    }

    public void clear() {
        if (this.edges != null) {
            this.edges.clear();
            this.edges = null;
        }
        this.res = null;
        this.type = null;
        if (this.getElems() != null) {
            for (GraphInnerElement c : this.getElems()) {
                ((ResolutionElement)c).clear();
            }
            this.elems.clear();
            this.elems = null;
        }
    }
}

