/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.ui;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.ui.ResolutionBasedGraphModel;
import com.ez.graphs.viewer.odb.ui.ResolutionElement;
import com.ez.graphs.viewer.odb.utils.ResolutionUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceDynamicCall;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.ez.workspace.analysis.graph.mouseHook.WUMouseActionsHookAdapter;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionBasedMouseHook
extends MainframeMouseActionsHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResolutionBasedMouseHook.class);
    WUMouseActionsHookAdapter.NodeAction editRes;
    ResolutionAction openEditor;

    public ResolutionBasedMouseHook(EZEntityID entityId) {
        super(entityId);
    }

    public Object overrideTSMemberAttribute(TSGraphMember member, String attribute) {
        if ((attribute.equals("HAS_PROPERTIES_IN_PROPVIEW") || attribute.equals("FILE") || attribute.equals("GOTOSOURCE")) && (!member.hasAttribute("Node_Mainframe") && !member.hasAttribute("Statement Node_Mainframe") || !member.hasAttribute("FILE"))) {
            ((ResolutionBasedGraphModel)this.graphModel).computeFileAttribute(member);
        }
        return super.overrideTSMemberAttribute(member, attribute);
    }

    public List getRightClickContributions(TSEEdge tsEdge, Object contextData) {
        ArrayList<Separator> contextItems = new ArrayList<Separator>();
        contextItems.addAll(super.getRightClickContributions(tsEdge, contextData));
        contextItems.add(new Separator());
        this.addAnalysisActions((TSEdge)tsEdge, null, contextItems, contextData);
        return contextItems;
    }

    public List getRightClickContributions(GraphInnerElement element) {
        Object selection = element.getSelection();
        if (selection != null) {
            ArrayList<Object> contextItems = new ArrayList<Object>();
            this.openEditor = this.makeGoToSourceAction((ResolutionElement)element);
            contextItems.add(new ActionContributionItem((IAction)this.openEditor));
            contextItems.add(new Separator());
            this.addAnalysisActions(null, (ResolutionElement)element, contextItems, null);
            return contextItems;
        }
        return null;
    }

    private void addAnalysisActions(TSEdge tsEdge, ResolutionElement elem, List contextItems, Object contextData) {
        if (elem != null) {
            tsEdge = (TSEdge)((List)elem.getSelection()).get(0);
        }
        if (((ResolutionBasedGraphModel)this.graphModel).considerStmtAsDynamic(tsEdge)) {
            EZWorkspace wk;
            List inputAnalysis;
            ProjectInfo pInfo = (ProjectInfo)tsEdge.getAttributeValue("ezproject");
            EZObjectType applicableInputType = null;
            if (elem != null) {
                if (contextData == null) {
                    contextData = this.getFileAttribute(elem);
                }
                applicableInputType = this.getOrCreateApplicableInputType(elem, contextData, pInfo);
            } else if (tsEdge != null) {
                applicableInputType = this.getOrCreateApplicableInputType((TSEEdge)tsEdge, contextData, pInfo);
            }
            if (applicableInputType != null && (inputAnalysis = (wk = EZWorkspace.getInstance()).getSpecificAnalysisType(applicableInputType)) != null && !inputAnalysis.isEmpty()) {
                if (this.editRes == null) {
                    this.editRes = new WUMouseActionsHookAdapter.NodeAction((WUMouseActionsHookAdapter)this){

                        public void execute(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.getString(ResolutionBasedMouseHook.class, "execute.addResolution.analysis"), -1);
                            ResolutionBasedMouseHook.this.executeAnalysis(this.analysisType, this.objType, this.node);
                            monitor.done();
                        }
                    };
                }
                this.editRes.setText(Messages.getString(ResolutionBasedMouseHook.class, "addResolution.menu"));
                this.editRes.setObjType(applicableInputType);
                EZAnalysisType analysisType = (EZAnalysisType)inputAnalysis.get(0);
                this.editRes.setAnalysisType(analysisType);
                this.editRes.setImageDescriptor(analysisType.getIconDescriptor());
                contextItems.add(new ActionContributionItem((IAction)this.editRes));
            }
        }
    }

    private EZObjectType getOrCreateApplicableInputType(TSEEdge tsEdge, Object contextData, ProjectInfo pInfo) {
        EZObjectType applicableInputType = (EZObjectType)tsEdge.getAttributeValue("APPLICABLE_INPUT");
        if (applicableInputType == null || contextData != null) {
            applicableInputType = new EZSourceDynamicCall();
            if (contextData == null) {
                tsEdge.setAttribute("APPLICABLE_INPUT", (Object)applicableInputType);
            }
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(pInfo));
            StatementNode node = (StatementNode)tsEdge.getAttributeValue("Statement Node_Mainframe");
            EZSourceMainframeNodeIdSg sg = new EZSourceMainframeNodeIdSg((Object)node);
            entity.addSegment((EZSegment)sg);
            applicableInputType.setEntID(entity);
            EZObjectType objType = this.getCallContext(tsEdge);
            applicableInputType.addProperty("call_context", (Object)objType);
            String stmtType = (String)tsEdge.getAttributeValue("STMT_TYPE");
            applicableInputType.addProperty("stmtTypeId", (Object)stmtType);
            applicableInputType.addProperty("contextSeq", (Object)Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE);
            Object callDefinitionLocations = tsEdge.getAttributeValue("FILE");
            if (contextData != null) {
                callDefinitionLocations = (Set)contextData;
            }
            applicableInputType.addProperty("file", callDefinitionLocations);
            applicableInputType.addProperty("edge", (Object)tsEdge);
        }
        return applicableInputType;
    }

    protected EZObjectType getCallContext(TSEEdge tsEdge) {
        TSNode ctxPrgNode = tsEdge.getSourceNode();
        EZObjectType objType = ((AnnotatedGraphModel)this.graphModel).getApplicableInputType(ctxPrgNode);
        objType.addProperty("FILE", ctxPrgNode.getAttributeValue("FILE"));
        return objType;
    }

    private EZObjectType getOrCreateApplicableInputType(ResolutionElement res, Object contextData, ProjectInfo pInfo) {
        TSEdge tsEdge = (TSEdge)((List)res.getSelection()).get(0);
        Set locs = null;
        locs = contextData != null ? (Set)contextData : (Set)tsEdge.getAttributeValue("FILE");
        EZObjectType objType = this.getCallContext((TSEEdge)tsEdge);
        EZSourceProgramIDSg prgSg = objType != null && objType.getEntID() != null ? (EZSourceProgramIDSg)objType.getEntID().getSegment(EZSourceProgramIDSg.class) : null;
        String prgType = prgSg != null ? prgSg.getTypeId().toString() : ((TextSelectionInFile)locs.iterator().next()).getPrgType();
        EZSourceDynamicCall applicableInputType = ResolutionUtils.buildInputType(res.getResolution(), pInfo, prgType, locs);
        applicableInputType.addProperty("edge", (Object)tsEdge);
        return applicableInputType;
    }

    private Set<TextSelectionInFile> getFileAttribute(ResolutionElement element) {
        HashSet<TextSelectionInFile> ret = new HashSet<TextSelectionInFile>();
        List<TSEdge> edges = element.getEdges();
        for (TSEdge e : edges) {
            Collection callDefinitionLocations = (Collection)e.getAttributeValue("FILE");
            if (callDefinitionLocations == null) {
                ((ResolutionBasedGraphModel)this.graphModel).computeFileAttribute((TSGraphMember)e);
                callDefinitionLocations = (Collection)e.getAttributeValue("FILE");
            }
            if (callDefinitionLocations == null) continue;
            for (TextSelectionInFile f : callDefinitionLocations) {
                if (!element.getResolution().path.equals(f.getFileName()) || element.getResolution().line != f.getBounds()[0]) continue;
                ret.add(f);
            }
        }
        return ret;
    }

    private ResolutionAction makeGoToSourceAction(ResolutionElement element) {
        if (this.openEditor == null) {
            this.openEditor = new ResolutionAction();
        }
        this.openEditor.project = this.getInputProjectsName(element.getNode());
        this.openEditor.options = this.getFileAttribute(element);
        if (this.openEditor.options.size() == 1) {
            this.openEditor.setText(Messages.getString(ResolutionBasedMouseHook.class, "editor.view.source"));
        } else {
            L.warn("many locations for an element?!");
        }
        return this.openEditor;
    }

    public void dispose() {
        if (this.editRes != null) {
            this.editRes.dispose();
            this.editRes = null;
        }
        if (this.openEditor != null) {
            this.openEditor.dispose();
            this.openEditor = null;
        }
        super.dispose();
    }

    class ResolutionAction
    extends WUMouseActionsHookAdapter.NodeAction {
        Set<TextSelectionInFile> options;
        String project;

        ResolutionAction() {
            super((WUMouseActionsHookAdapter)ResolutionBasedMouseHook.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(ResolutionBasedMouseHook.class, "goToSource.task.text"), -1);
            Utils.openEditor(this.options, (String)this.project);
            monitor.done();
        }
    }
}

