/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.ui;

import com.ez.cobol.callgraph.CallgraphEdgeLegendInfo;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IMSDBSegmentNode;
import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.graphs.viewer.odb.Activator;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.ui.DynamicCallContent;
import com.ez.graphs.viewer.odb.ui.ResolutionsContentProvider;
import com.ez.graphs.viewer.odb.utils.ResolutionUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.utils.IMSDBAccessType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.mainframe.override.resolutions.ResolutionsProxy;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.events.TSBaseGraphChangeListener;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResolutionBasedGraphModel
extends AnnotatedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResolutionBasedGraphModel.class);
    public static final String PRG_NODES_MAP_KEY = "PROGRAM_TS_NODES";
    public static final String ALL_TS_NODES_MAP = "TS nodes per project";
    protected static final String UE_INVENTORY_MAP_ATTRIBUTE = "ue inventory";
    public static final String EZPROJECT_KEY = "ezproject";
    public static final String EXT_RES_NAME = "ext_resource name";
    public static final String EXT_RES_TYPE = "ext_resource type";
    protected static final String API_TS_INVENTORY_KEY = "API_CG";
    protected static final String API_HAS_PARENT_KEY = "API_CG_parent";
    protected static final String API_TS_INVENTORY_LBL = Messages.getString(ResolutionBasedGraphModel.class, "api.ts.category");
    protected static final String NOT_REACHABLE_APITARGETS_INVENTORY_LBL = Messages.getString(ResolutionBasedGraphModel.class, "apitarget.notreachable.category");
    public static final String FILE_PHYSICAL_NAME_PROPERTY = "physicalName";
    protected ResolutionsContentProvider dynCP;
    protected ProjectInfo ezsourcePrj = null;
    protected Map<String, TSENode> extMap = new HashMap<String, TSENode>();
    protected boolean no_path_legend_entry = false;
    protected boolean isSrvCross = false;

    public void setDynCP(ResolutionsContentProvider dynCP) {
        this.dynCP = dynCP;
    }

    protected abstract OrientExtendedGraph getOrientDbg();

    protected abstract OrientExtendedGraph getOrientDbg(String var1);

    protected void initGraph() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        if (this.outForGISV != null) {
            this.outForGISV.clear();
        }
        this.graphManager.getEventManager().setFireEvents(false);
        if (this.dynCP != null) {
            this.graphManager.getEventManager().addGraphChangeListener((TSGraphObject)this.graphManager, (TSBaseGraphChangeListener)this.dynCP, 524288L);
        }
        this.extMap.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
        this.restrictionTypesSetForLegend.clear();
        this.graphManager.setAttribute("restriction types set for legend", (Object)this.restrictionTypesSetForLegend);
    }

    protected TSENode getOrCreateTSNode(Vertex proxyV, String fileName, boolean isPrg) {
        return this.getOrCreateTSNode(this.graph, proxyV, fileName, isPrg);
    }

    protected TSENode getOrCreateTSNode(TSEGraph gr, Vertex proxyV, String fileName, boolean isPrg) {
        String key;
        String name = null;
        String rid = proxyV.getId().toString();
        Iterator prgVertexIter = proxyV.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator();
        String string = key = isPrg && prgVertexIter.hasNext() ? ((Vertex)prgVertexIter.next()).getId().toString() : rid;
        if (fileName != null) {
            name = fileName;
            key = fileName;
        } else {
            name = com.ez.graphs.viewer.odb.utils.Utils.getTSNodeName(proxyV);
        }
        Map tsNodes = (Map)gr.getAttributeValue(ALL_TS_NODES_MAP);
        TSENode node = (TSENode)tsNodes.get(key);
        if (this.isSrvCross && node == null) {
            EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)gr.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
            String keyFromCross = null;
            if (isPrg) {
                Integer resId = (Integer)proxyV.getProperty("sid");
                Integer resTypeID = (Integer)proxyV.getProperty("type");
                keyFromCross = TSGraphUtils.getKey((String)prjIdSg.getProjectName(), (String)String.valueOf(resId), (String)String.valueOf(resTypeID));
            } else if ("TranProxy".equals(proxyV.getProperty("@class"))) {
                keyFromCross = TSGraphUtils.getKey((String)prjIdSg.getProjectName(), (String)((String)proxyV.getProperty("name")), (String)String.valueOf(14));
            } else if ("IMSTransactionProxy".equals(proxyV.getProperty("@class"))) {
                keyFromCross = TSGraphUtils.getKey((String)prjIdSg.getProjectName(), (String)((String)proxyV.getProperty("name")), (String)String.valueOf(20));
            }
            if (keyFromCross != null && (node = (TSENode)tsNodes.get(keyFromCross)) != null) {
                tsNodes.put(key, node);
            }
        }
        if (node == null) {
            IGraphNodeLegendInfo info;
            node = (TSENode)gr.addNode();
            String vertexClass = (String)proxyV.getProperty("@class");
            if (isPrg) {
                node.setAttribute("prg type id", proxyV.getProperty("type"));
            }
            if (vertexClass.equals("IMSSegment")) {
                boolean isLogical;
                boolean bl = isLogical = ((OrientVertex)proxyV).countEdges(Direction.OUT, new String[]{"IMSSSource"}) > 0L;
                if (isLogical) {
                    node.setAttribute("imsdb logical segment", (Object)isLogical);
                }
            }
            String lbl = (info = com.ez.graphs.viewer.odb.utils.Utils.setResourceUIStyle((TSNode)node, vertexClass, this.nodeTypesSetForLegend, false, this.ezsourcePrj)) != null ? info.getLegendLabel() : com.ez.graphs.viewer.odb.utils.Utils.getNodeLabel(vertexClass, false);
            node.setAttribute("TS MEMBER TYPE", (Object)lbl);
            node.setAttribute("VERTEX_CLASS", (Object)vertexClass);
            if (isPrg) {
                node.setAttribute("prg type id", proxyV.getProperty("type"));
                this.computePrgVForProxyV(proxyV, node);
                if (node.getAttributeValue("VERTEX_ID") == null) {
                    node.setAttribute("VERTEX_ID", (Object)rid);
                }
            } else {
                node.setAttribute("VERTEX_ID", (Object)rid);
                if (fileName != null) {
                    node.setAttribute("nameForProperties", (Object)fileName);
                }
            }
            this.setNodeUI(node);
            node.setName((Object)name);
            tsNodes.put(key, node);
            this.putEntriesInGISV(this.graphManager, lbl, node);
            node.setTooltipText(lbl.concat(": ").concat(name));
            node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
            node.setAttribute("is cobol node", (Object)Boolean.TRUE);
        }
        return node;
    }

    protected boolean isAnnCandidate(TSENode node) {
        String vClass = (String)node.getAttributeValue("VERTEX_CLASS");
        return "Program".equals(vClass) || "JCLJob".equals(vClass);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            TSEColor color = (TSEColor)node.getAttributeValue("Color");
            if (color != null) {
                node.setAttribute("Text_Color", (Object)color);
            }
        }
    }

    protected void putEntriesInGISV(TSEGraphManager gmanager, String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes;
        Map currentOutForGISV = this.outForGISV;
        if (gmanager != null && gmanager.hasAttribute(UE_INVENTORY_MAP_ATTRIBUTE)) {
            Map ueOutForGISV = (Map)gmanager.getAttributeValue(UE_INVENTORY_MAP_ATTRIBUTE);
            Object cat = tsNode.hasAttribute(API_TS_INVENTORY_KEY) ? tsNode.getAttributeValue(API_TS_INVENTORY_KEY) : (TSENode)tsNode.getOwnerGraph().getParent();
            boolean hasParent = tsNode.hasAttribute(API_HAS_PARENT_KEY);
            Map out = null;
            Object category = null;
            if (hasParent) {
                String parentCat = API_TS_INVENTORY_LBL;
                HashMap p1 = (HashMap)ueOutForGISV.get(parentCat);
                if (p1 == null) {
                    p1 = new HashMap();
                    ueOutForGISV.put(parentCat, p1);
                }
                if ((out = (Map)p1.get(cat)) == null) {
                    out = new HashMap();
                    p1.put(cat, out);
                }
                category = cat;
            } else {
                out = (HashMap)ueOutForGISV.get(cat);
                category = cat;
            }
            if (out == null) {
                out = new HashMap();
                ueOutForGISV.put(category, out);
            }
            currentOutForGISV = out;
        }
        if ((nodes = (HashSet<TSENode>)currentOutForGISV.get(inventoryCategory)) == null) {
            nodes = new HashSet<TSENode>();
            currentOutForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    private void computePrgVForProxyV(Vertex proxyVertex, TSENode node) {
        Iterator prgVertexIt = proxyVertex.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator();
        if (prgVertexIt.hasNext()) {
            Vertex prgVertex = (Vertex)prgVertexIt.next();
            String prgRid = prgVertex.getId().toString();
            node.setAttribute("VERTEX_ID", (Object)prgRid);
            node.setAttribute("VERTEX_CLASS", prgVertex.getProperty("@class"));
            Map prgRIDs = (Map)this.graph.getAttributeValue(PRG_NODES_MAP_KEY);
            if (prgRIDs != null) {
                prgRIDs.put(prgRid, node);
            }
            node.setAttribute("program occur", (Object)Boolean.TRUE);
        } else {
            if ("Program".equals(proxyVertex.getProperty("@class"))) {
                node.setAttribute("program occur", (Object)Boolean.TRUE);
            } else {
                node.setAttribute("program occur", (Object)Boolean.FALSE);
                this.no_path_legend_entry = true;
            }
            com.ez.graphs.viewer.odb.utils.Utils.setPropertiesViewerForNodes(node, node.getText(), false);
        }
    }

    public void postLoadGraph(SubMonitor monitor) {
        long time = System.currentTimeMillis();
        this.addMainframeResolutionsInfo(monitor.newChild(100));
        L.debug("addMainframeResolutionsInfo in {} ms", (Object)(System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        this.findAnnotations(monitor);
        L.debug("findAnnotations in {} ms", (Object)(System.currentTimeMillis() - time));
    }

    public boolean considerStmtAsDynamic(TSEdge edge) {
        String stmtType = (String)edge.getAttributeValue("STMT_TYPE");
        if (stmtType == null) {
            return false;
        }
        return stmtType.equals("390") || stmtType.equals("391") || stmtType.equals("392") || stmtType.equals("814") || stmtType.equals("816") || stmtType.equals("818") || stmtType.equals("752");
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        Set locs;
        Object path;
        EZObjectType objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        if (objType == null) {
            objType = this.createApplicableInputType(gNode);
            if (objType == null) {
                return null;
            }
            Set locs2 = (Set)gNode.getAttributeValue("FILE");
            if (locs2 != null && !locs2.isEmpty()) {
                objType.addProperty("program_path", (Object)((TextSelectionInFile)locs2.iterator().next()).getFileName());
            }
            gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
        }
        if ((path = objType.getProperty("program_path")) == null && (locs = (Set)gNode.getAttributeValue("FILE")) != null && !locs.isEmpty()) {
            objType.addProperty("program_path", (Object)((TextSelectionInFile)locs.iterator().next()).getFileName());
        }
        return objType;
    }

    protected EZObjectType createApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        String vRid = (String)gNode.getAttributeValue("VERTEX_ID");
        EZSourceProjectIDSg sg = (EZSourceProjectIDSg)gNode.getOwnerGraph().getAttributeValue("MAINFRAME_PROJECT_ID_SG");
        if (sg == null) {
            sg = (EZSourceProjectIDSg)this.graphManager.getMainDisplayGraph().getAttributeValue("MAINFRAME_PROJECT_ID_SG");
        }
        if (vRid != null) {
            this.ezsourcePrj = sg.getProjectInfo();
            Vertex vertex = this.getOrientDbg(sg.getProjectName()).getVertex((Object)vRid);
            if (vertex != null) {
                objType = com.ez.graphs.viewer.odb.utils.Utils.getResourceType(vertex, this.ezsourcePrj, false);
                if (gNode.hasAttribute("logical file attribute")) {
                    objType.addProperty("logical file attribute", gNode.getAttributeValue("logical file attribute"));
                }
            }
        }
        if (!gNode.hasAttribute("mainframe project name") && this.ezsourcePrj != null) {
            gNode.setAttribute("mainframe project name", (Object)this.ezsourcePrj.getName());
        }
        return objType;
    }

    public Object computeFileAttribute(TSGraphMember tsmember) {
        Boolean compute = null;
        List orids = (List)tsmember.getAttributeValue("VERTEX_ID_LIST");
        EZSourceProjectIDSg sg = (EZSourceProjectIDSg)tsmember.getOwnerGraph().getAttributeValue("MAINFRAME_PROJECT_ID_SG");
        if (sg == null) {
            sg = (EZSourceProjectIDSg)tsmember.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
        }
        if (sg == null) {
            compute = false;
            return compute;
        }
        if (orids != null) {
            HashSet<TextSelectionInFile> tsfSet = new HashSet<TextSelectionInFile>();
            for (Object orid : orids) {
                TextSelectionInFile tsf = this.computeSourceInfoForRID(sg.getProjectName(), orid);
                tsfSet.add(tsf);
            }
            Utils.setFileAttribute((TSGraphMember)tsmember, tsfSet);
            compute = true;
        } else if (tsmember.hasAttribute("VERTEX_ID")) {
            String vertexId = tsmember.getAttributeValue("VERTEX_ID").toString();
            String pathOrName = tsmember.getText();
            boolean isPath = false;
            String fileName = (String)tsmember.getAttributeValue("nameForProperties");
            if (fileName == null) {
                Vertex v = this.getOrientDbg(sg.getProjectName()).getVertex((Object)vertexId);
                TextSelectionInFile tsf = com.ez.graphs.viewer.odb.utils.Utils.computeSourceInfoForVertex(v);
                if (tsf != null) {
                    Utils.setFileAttribute((TSGraphMember)tsmember, (TextSelectionInFile)tsf);
                    pathOrName = tsf.getFileName();
                    compute = true;
                    isPath = true;
                }
            } else {
                pathOrName = fileName;
            }
            String cls = (String)tsmember.getAttributeValue("VERTEX_CLASS");
            if ("node".equals(tsmember.getTypeObjectKey())) {
                Vertex v;
                if ("IMSSegment".equals(cls) || "IMSSegmentProxy".equals(cls)) {
                    if (!tsmember.hasAttribute("Node_Mainframe") || tsmember.getAttributeValue("Node_Mainframe") == null) {
                        v = this.getOrientDbg(sg.getProjectName()).getVertex((Object)vertexId);
                        String type = (String)tsmember.getAttributeValue("TS MEMBER TYPE");
                        String name = (String)v.getProperty("name");
                        IMSDBSegmentNode segNode = new IMSDBSegmentNode(name, type);
                        tsmember.setAttribute("Node_Mainframe", (Object)segNode);
                        if ("IMSSegment".equals(cls)) {
                            this.collectProperties4IMSSegmentNode(v, segNode);
                        } else {
                            String dbName = (String)v.getProperty("dbName");
                            IMSDBNode dbNode = new IMSDBNode(dbName, null);
                            segNode.setDB(dbNode);
                        }
                    }
                } else if ("IMSMODProxy".equals(cls)) {
                    v = this.getOrientDbg(sg.getProjectName()).getVertex((Object)vertexId);
                    Integer type = (Integer)v.getProperty("type");
                    String typeAsString = type == 0 ? Messages.getString(ResolutionBasedGraphModel.class, "properties.mid.label") : Messages.getString(ResolutionBasedGraphModel.class, "properties.mod.label");
                    tsmember.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(pathOrName, typeAsString));
                } else {
                    com.ez.graphs.viewer.odb.utils.Utils.setPropertiesViewerForNodes((TSENode)tsmember, pathOrName, isPath);
                }
            }
        } else if (tsmember.hasAttribute(EXT_RES_NAME)) {
            String name = (String)tsmember.getAttributeValue(EXT_RES_NAME);
            String type = (String)tsmember.getAttributeValue(EXT_RES_TYPE);
            tsmember.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(name, type));
        }
        return compute;
    }

    private void collectProperties4IMSSegmentNode(Vertex v, IMSDBSegmentNode segNode) {
        Iterator fieldsVertexIt;
        Vertex dbVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{"inDB"}).iterator().next();
        Integer accessType = (Integer)dbVertex.getProperty("accessTypeId");
        String stringType = IMSDBAccessType.values()[accessType - 1].toString();
        IMSDBNode dbNode = new IMSDBNode((String)dbVertex.getProperty("name"), stringType);
        dbNode.setVersion((String)dbVertex.getProperty("dbVer"));
        dbNode.setRmName((String)dbVertex.getProperty("rmName"));
        dbNode.setPSName((String)dbVertex.getProperty("psName"));
        dbNode.setPass((String)dbVertex.getProperty("pass"));
        dbNode.setFPIndex((String)dbVertex.getProperty("fpIndex"));
        dbNode.setRemarks((String)dbVertex.getProperty("remarks"));
        segNode.setDB(dbNode);
        Iterator it = fieldsVertexIt = v.getVertices(Direction.IN, new String[]{"inSegment"}).iterator();
        while (fieldsVertexIt.hasNext()) {
            ArrayList<String> fields = segNode.getFieldsList();
            if (fields == null) {
                fields = new ArrayList<String>();
                segNode.setFieldsList(fields);
            }
            Vertex fieldVertex = (Vertex)it.next();
            fields.add((String)fieldVertex.getProperty("name"));
        }
    }

    private TextSelectionInFile computeSourceInfoForRID(String prjName, Object oRID) {
        if (oRID == null) {
            return null;
        }
        Vertex v = this.getOrientDbg(prjName).getVertex(oRID);
        return com.ez.graphs.viewer.odb.utils.Utils.computeSourceInfoForVertex(v);
    }

    protected void addMainframeResolutionsInfo(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ResolutionBasedGraphModel.class, "find.resolution"));
        Map prjTSMap = (Map)this.graphManager.getAttributeValue("Projects_TS_map");
        if (prjTSMap != null) {
            for (String pjName : prjTSMap.keySet()) {
                TSENode prjNode = (TSENode)prjTSMap.get(pjName);
                TSGraph graph = prjNode.getChildGraph();
                EZSourceProjectIDSg sg = (EZSourceProjectIDSg)graph.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
                if (sg == null) continue;
                ProjectInfo ezsourcePrj = sg.getProjectInfo();
                List edges = graph.edges();
                this.prepareResolutions(ezsourcePrj, edges);
            }
        } else {
            this.prepareResolutions(this.ezsourcePrj, this.graph.edges());
        }
        this.graphManager.getEventManager().setFireEvents(true);
    }

    private void prepareResolutions(ProjectInfo ezsourcePrj, List<TSEEdge> edges) {
        if (edges != null && !edges.isEmpty()) {
            L.trace("edges: {}", (Object)edges.size());
            Integer resType = new Integer(5);
            Integer idx = new Integer(1);
            DynamicCallContent cont = (DynamicCallContent)this.getOutForStructView().get("resolutions");
            Map<DynamicCallContent.ResolutionType, Map<Resolution, List<TSEdge>>> resolutionMap = null;
            if (cont == null) {
                cont = new DynamicCallContent();
                resolutionMap = cont.getContent();
                this.getOutForStructView().put("resolutions", cont);
            } else {
                resolutionMap = cont.getContent();
            }
            HashMap<Key, Resolution> tmp = new HashMap<Key, Resolution>();
            for (TSEEdge e : edges) {
                if (!this.considerStmtAsDynamic((TSEdge)e)) continue;
                e.setAttribute(EZPROJECT_KEY, (Object)ezsourcePrj);
                String stmtType = (String)e.getAttributeValue("STMT_TYPE");
                HashSet list = (HashSet)e.getAttributeValue("FILE");
                if (list == null) {
                    this.computeFileAttribute((TSGraphMember)e);
                    list = (HashSet)e.getAttributeValue("FILE");
                }
                if (list == null) continue;
                String[] info = this.getInputNameAndPath((TSEdge)e);
                String prgName = info[0];
                String prgPath = info[1];
                for (TextSelectionInFile loc : list) {
                    String defPath = loc.getFileName();
                    int defLine = loc.getBounds()[0];
                    Resolution r = null;
                    Key k = new Key(defPath, defLine, new Integer(stmtType), resType, idx, prgName, prgPath);
                    r = (Resolution)tmp.get(k);
                    if (r == null) {
                        try {
                            r = ResolutionsProxy.getLastApplied((ProjectInfo)ezsourcePrj, (String)defPath, (int)defLine, (int)new Integer(stmtType), (Integer)resType, (Integer)idx, (String)prgName, (String)prgPath, (int)Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE, (boolean)false);
                        }
                        catch (Throwable th) {
                            String msg = Messages.getString(ResolutionBasedGraphModel.class, "getResolution.exception", new String[]{String.valueOf(defLine), defPath});
                            if (th instanceof ResolutionException) {
                                msg = ((ResolutionException)th).getMessage();
                            }
                            LogUtil.displayErrorMessage((Throwable)th, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                        }
                    }
                    if (r != null) {
                        List<TSEdge> edg;
                        DynamicCallContent.ResolutionType callType = ResolutionUtils.getResType(r);
                        Map<Resolution, List<TSEdge>> m = resolutionMap.get((Object)callType);
                        if (m == null) {
                            m = new HashMap<Resolution, List<TSEdge>>();
                            resolutionMap.put(callType, m);
                        }
                        if ((edg = m.get(r)) == null) {
                            edg = new ArrayList<TSEdge>();
                            m.put(r, edg);
                        }
                        edg.add((TSEdge)e);
                        tmp.put(k, r);
                        continue;
                    }
                    L.info("not solved call?");
                }
            }
            tmp.clear();
            tmp = null;
        }
    }

    protected String[] getInputNameAndPath(TSEdge e) {
        TSNode srcNode = e.getSourceNode();
        TSNode ctxPrgNode = srcNode.hasAttribute("prg_name") ? srcNode : e.getTargetNode();
        String prgName = (String)ctxPrgNode.getAttributeValue("prg_name");
        HashSet nodeLoc = (HashSet)ctxPrgNode.getAttributeValue("FILE");
        if (nodeLoc == null) {
            this.computeFileAttribute((TSGraphMember)ctxPrgNode);
            nodeLoc = (HashSet)ctxPrgNode.getAttributeValue("FILE");
        }
        String prgPath = nodeLoc != null ? ((TextSelectionInFile)nodeLoc.iterator().next()).getFileName() : null;
        return new String[]{prgName, prgPath};
    }

    protected String addPhysicalNameToFile(Vertex usage, String logicalName) {
        String fileName = logicalName;
        String physicalName = (String)usage.getProperty(FILE_PHYSICAL_NAME_PROPERTY);
        if (physicalName != null && !physicalName.isEmpty()) {
            fileName = physicalName.concat(logicalName);
        }
        return fileName;
    }

    public TSEEdge makeCallExtEdge(TSENode sourceNode, TSENode node, Set<String> stmts, String stmtType) {
        TSEEdge e = null;
        if (!TSGraphUtils.extCallEdgeExists((TSENode)sourceNode, (TSENode)node) && (e = (TSEEdge)this.graphManager.addEdge((TSNode)sourceNode, (TSNode)node)) != null) {
            CallgraphEdgeLegendInfo edgeType = CallgraphEdgeLegendInfo.EXT_CALL;
            TSEColor edgeColor = edgeType.getTSEColor();
            this.edgeTypesSetForLegend.add(edgeType);
            e.setAttribute("Color", (Object)edgeColor);
            StatementNode sn = new StatementNode(stmtType);
            e.setAttribute("Statement Node_Mainframe", (Object)sn);
            com.ez.graphs.viewer.odb.utils.Utils.addStmtRidsForEdge(e, stmts);
        }
        return e;
    }

    protected TSENode getOrCreateNodeNoVertex(String name, String vertexClass) {
        String key = String.valueOf(name) + vertexClass;
        TSENode node = this.extMap.get(key);
        if (node == null) {
            node = (TSENode)this.graph.addNode();
            node.setName((Object)name);
            this.extMap.put(key, node);
            if ("Program".equals(vertexClass) && !node.hasAttribute("prg type id")) {
                node.setAttribute("prg type id", (Object)-1);
            }
        }
        return node;
    }

    protected TSENode getOrCreateExtNode(String tgName, String ttypeDesc, String ttypeTS, String location, String lTypeDesc, String pType) {
        String name = String.valueOf(lTypeDesc) + location + " : " + tgName;
        TSENode node = this.getOrCreateNodeNoVertex(name, ttypeTS);
        node.setAttribute(EXT_RES_NAME, (Object)name);
        node.setAttribute(EXT_RES_TYPE, (Object)ttypeDesc);
        if (pType != null) {
            node.setAttribute("prg type id", (Object)Integer.valueOf(pType));
        }
        com.ez.graphs.viewer.odb.utils.Utils.setResourceUIStyle((TSNode)node, ttypeTS, this.nodeTypesSetForLegend, false, null);
        this.setNodeUI(node);
        this.putEntriesInGISV(this.graphManager, ttypeDesc, node);
        node.setTooltipText(name);
        return node;
    }

    public void dispose() {
        if (this.dynCP != null) {
            this.graphManager.getEventManager().removeGraphChangeListener((TSGraphObject)this.graphManager, (TSBaseGraphChangeListener)this.dynCP, 524288L);
            this.dynCP = null;
        }
        this.ezsourcePrj = null;
        this.extMap = null;
        super.dispose();
    }

    class Key {
        public String path;
        public Integer line;
        public Integer stmtType;
        public Integer resType;
        public int index = -1;
        public int priority = 0;
        public String contextName;
        public String contextPath;
        public Integer contextSeq = Resolution.CONTEXT_SEQUENCE_DEFAULT_VALUE;

        public Key(String path, Integer line, Integer stmtType, Integer resType, int priority, String contextName, String contextPath) {
            this.path = path;
            this.line = line;
            this.stmtType = stmtType;
            this.resType = resType;
            this.priority = priority;
            this.contextName = contextName;
            this.contextPath = contextPath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getClass().hashCode();
            result = 31 * result + (this.contextName == null ? 0 : this.contextName.hashCode());
            result = 31 * result + (this.contextPath == null ? 0 : this.contextPath.hashCode());
            result = 31 * result + (this.contextSeq == null ? 0 : this.contextSeq.hashCode());
            result = 31 * result + this.index;
            result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + this.priority;
            result = 31 * result + (this.resType == null ? 0 : this.resType.hashCode());
            result = 31 * result + (this.stmtType == null ? 0 : this.stmtType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            if (this.contextName == null ? other.contextName != null : !this.contextName.equals(other.contextName)) {
                return false;
            }
            if (this.contextPath == null ? other.contextPath != null : !this.contextPath.equals(other.contextPath)) {
                return false;
            }
            if (this.contextSeq == null ? other.contextSeq != null : !this.contextSeq.equals(other.contextSeq)) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            if (this.priority != other.priority) {
                return false;
            }
            if (this.resType == null ? other.resType != null : !this.resType.equals(other.resType)) {
                return false;
            }
            return !(this.stmtType == null ? other.stmtType != null : !this.stmtType.equals(other.stmtType));
        }
    }
}

