/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model.mem;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.mem.MemLink;
import com.ez.graphs.viewer.odb.impact.model.mem.MemNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemGraph
implements ImpactGraph {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, List<Node>> registry = new HashMap<String, List<Node>>();
    private ArrayList<Node> startNodes = new ArrayList();
    long nodeId = 0L;
    long linkId = 0L;
    private Map<Long, Node> nodes = new HashMap<Long, Node>();
    private Map<Long, Link> links = new HashMap<Long, Link>();
    private Map<String, Long> nodeByKey = new HashMap<String, Long>();
    private Map<Long, Map<Long, Set<Long>>> cache = new HashMap<Long, Map<Long, Set<Long>>>();
    private Map<Integer, List<Long>> nodeTypes = new HashMap<Integer, List<Long>>();

    public Node addNode(Value v) {
        return this.addNode(v, false);
    }

    @Override
    public Node addNode(Value v, boolean asStartNode) {
        MemNode n = new MemNode(this.nodeId, v);
        ++this.nodeId;
        if (v.id() != null) {
            List<Node> nList = this.registry.get(v.id());
            if (nList == null) {
                nList = new ArrayList<Node>();
                this.registry.put(v.id(), nList);
            }
            nList.add(n);
        }
        if (asStartNode) {
            this.startNodes.add(n);
        }
        this.nodes.put(n.getId(), n);
        List<Long> nodeIds = this.nodeTypes.get(v.type());
        if (nodeIds == null) {
            nodeIds = new ArrayList<Long>();
            this.nodeTypes.put(v.type(), nodeIds);
        }
        nodeIds.add(n.getId());
        return n;
    }

    @Override
    public Link addEdge(Long fromId, Long toId) {
        return this.addEdge(1, fromId, toId, null);
    }

    @Override
    public Link addEdge(int level, Long fromId, Long toId) {
        return this.addEdge(level, fromId, toId, null);
    }

    @Override
    public Link addEdge(Long fromId, Long toId, Map<String, Object> edgeInfo) {
        return this.addEdge(1, fromId, toId, edgeInfo);
    }

    @Override
    public Link addEdge(int level, Long fromId, Long toId, Map<String, Object> edgeInfo) {
        MemLink e = new MemLink(this.linkId, fromId, toId, edgeInfo);
        ++this.linkId;
        this.getNode(fromId).addOut(level, e.getId());
        this.getNode(toId).addIn(level, e.getId());
        this.links.put(e.getId(), e);
        return e;
    }

    @Override
    public List<Node> getNode(String key) {
        return this.registry.get(key);
    }

    public Collection<Node> nodes() {
        LinkedList<Node> ret = new LinkedList<Node>();
        for (List<Node> nl : this.registry.values()) {
            for (Node n : nl) {
                ret.add(n);
            }
        }
        return ret;
    }

    @Override
    public List<Node> getStartNodes() {
        return this.startNodes;
    }

    @Override
    public Node getNode(Long nId) {
        return this.nodes.get(nId);
    }

    @Override
    public Link getLink(Long lId) {
        return this.links.get(lId);
    }

    @Override
    public void close() {
        this.registry = null;
        this.startNodes = null;
        this.nodes = null;
        this.links = null;
    }

    @Override
    public void updateNode(Node target, Value newValue) {
        ((MemNode)target).updateValue(newValue);
    }

    @Override
    public String printStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("MemGraph: nodes.size=").append(this.nodes.size()).append("; links.size=").append(this.links.size()).append("; startNodes.size=").append(this.startNodes.size());
        return sb.toString();
    }

    @Override
    public Iterable<Long> getSpecialNodes(int type) {
        List<Long> list = this.nodeTypes.get(type);
        if (list == null) {
            list = new ArrayList<Long>();
        }
        final Iterator<Long> it = list.iterator();
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return it;
            }
        };
    }

    @Override
    public void cacheValue(long first, long second, long value) {
        Set<Long> set;
        Map<Long, Set<Long>> smap = this.cache.get(first);
        if (smap == null) {
            smap = new HashMap<Long, Set<Long>>();
            this.cache.put(first, smap);
        }
        if ((set = smap.get(second)) == null) {
            set = new HashSet<Long>();
            smap.put(second, set);
        }
        set.add(value);
    }

    @Override
    public Set<Long> getCached(long first, long second) {
        Set<Long> set;
        HashSet<Long> ret = new HashSet<Long>();
        Map<Long, Set<Long>> smap = this.cache.get(first);
        if (smap != null && (set = smap.get(second)) != null) {
            ret.addAll(set);
        }
        return ret;
    }

    @Override
    public void commit() {
    }

    @Override
    public void registerWithKey(String key, long nodeId) {
        this.nodeByKey.put(key, nodeId);
    }

    @Override
    public Long getWithKey(String key) {
        return this.nodeByKey.get(key);
    }
}

