/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model.disk;

import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DiskNode
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private long id = -1L;
    private Value value = null;
    private Map<Integer, List<Long>> in = new HashMap<Integer, List<Long>>();
    private Map<Integer, List<Long>> out = new HashMap<Integer, List<Long>>();
    private Map<String, Object> info = new HashMap<String, Object>();

    protected DiskNode() {
        this.info = new HashMap<String, Object>();
    }

    public DiskNode(Long id, Value value) {
        this.value = value;
        this.id = id;
    }

    public DiskNode(DiskNode other) {
        this(other, other.value);
    }

    public DiskNode(DiskNode other, Value newValue) {
        this.value = newValue;
        this.id = other.id;
        this.info.putAll(other.info);
        this.in.putAll(other.in);
        this.out.putAll(other.out);
    }

    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj != null && obj instanceof DiskNode) {
            Value ov = ((Node)obj).value();
            eq = ov != null && ov.equals(this.value) ? true : this.id == ((DiskNode)obj).id;
        }
        return eq;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "Node [id=" + this.id + ", value=" + this.value.toString() + ", in=" + this.in + ", out=" + this.out + "]";
    }

    @Override
    public Value value() {
        return this.value;
    }

    @Override
    public List<Long> in() {
        return this.in(1);
    }

    @Override
    public List<Long> in(int typeSpec) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (int key : this.in.keySet()) {
            if ((key & typeSpec) == 0) continue;
            ret.addAll((Collection<Long>)this.in.get(key));
        }
        return ret;
    }

    @Override
    public List<Long> out() {
        return this.out(1);
    }

    @Override
    public List<Long> out(int typeSpec) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (int key : this.out.keySet()) {
            if ((key & typeSpec) == 0) continue;
            ret.addAll((Collection<Long>)this.out.get(key));
            break;
        }
        return ret;
    }

    @Override
    public void addOut(long id) {
        this.addOut(1, id);
    }

    @Override
    public void addIn(long id) {
        this.addIn(1, id);
    }

    @Override
    public void addOut(int type, long id) {
        List<Long> lst;
        if ((type & type - 1) == 0) {
            lst = this.out.get(type);
            if (lst == null) {
                lst = new ArrayList<Long>();
                this.out.put(type, lst);
            }
        } else {
            throw new IllegalArgumentException("type must be power of 2");
        }
        lst.add(id);
    }

    @Override
    public void addIn(int type, long id) {
        List<Long> lst;
        if ((type & type - 1) == 0) {
            lst = this.in.get(type);
            if (lst == null) {
                lst = new ArrayList<Long>();
                this.in.put(type, lst);
            }
        } else {
            throw new IllegalArgumentException("type must be power of 2");
        }
        lst.add(id);
    }

    @Override
    public Object info(String key) {
        return this.info.get(key);
    }

    @Override
    public long getId() {
        return this.id;
    }
}

