/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model.disk;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskLink;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskNode;
import com.ez.graphs.viewer.odb.utils.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerArrayTuple;
import org.mapdb.serializer.SerializerInteger;
import org.mapdb.serializer.SerializerLong;
import org.mapdb.serializer.SerializerString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskGraph
implements ImpactGraph {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private NavigableSet<Object[]> registry;
    private DB db;
    private DB.AtomicLongMaker nodesKey;
    private DB.AtomicLongMaker linksKey;
    private Map<Long, DiskNode> nodes;
    private Map<Long, DiskLink> links;
    private Set<Long> startNodes;
    private NavigableSet<Object[]> nodeTypes;
    private Map<String, Long> nodeByKey;
    private NavigableSet<Object[]> cache;
    private PrintWriter out = null;
    private static final Logger L = LoggerFactory.getLogger(DiskGraph.class);

    public DiskGraph(boolean loadFromDisk, File dbFile, PrintWriter out) {
        Thread.currentThread().setContextClassLoader(DiskGraph.class.getClassLoader());
        DBMaker.Maker dbMaker = DBMaker.fileDB((File)dbFile).transactionEnable().fileMmapEnableIfSupported().allocateStartSize(1000000L);
        this.db = dbMaker.make();
        if (loadFromDisk) {
            this.nodesKey = this.db.atomicLong("node.id");
            this.linksKey = this.db.atomicLong("link.id");
        } else {
            this.deleteFile(dbFile);
            this.nodesKey = this.db.atomicLong("node.id", 0L);
            this.linksKey = this.db.atomicLong("link.id", 0L);
        }
        this.registry = (NavigableSet)this.db.treeSet("registry").serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{new SerializerString(), new SerializerLong()})).create();
        this.nodes = this.db.hashMap("allNodes").keySerializer((Serializer)Serializer.LONG).counterEnable().create();
        this.links = this.db.hashMap("allEdges").keySerializer((Serializer)Serializer.LONG).counterEnable().create();
        this.startNodes = (Set)this.db.hashSet("startNodes").serializer((Serializer)Serializer.LONG).counterEnable().create();
        this.nodeTypes = (NavigableSet)this.db.treeSet("nodeTypes").serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{new SerializerInteger(), new SerializerLong()})).counterEnable().create();
        this.nodeByKey = this.db.hashMap("nodeByKey").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.LONG).counterEnable().create();
        this.out = out;
    }

    public void clear(DB db, File file) {
        if (db != null && !db.isClosed()) {
            this.close();
        }
        this.deleteFile(file);
    }

    protected void deleteFile(File file) {
        if (file != null && file.exists()) {
            try {
                boolean del = file.delete();
                L.debug("file " + file + " deleted=" + del);
            }
            catch (Exception ex) {
                L.warn("error trying to delete mapdb file", (Throwable)ex);
            }
        }
    }

    private void writeNodeDetails(Value value) {
        StringBuilder sb = null;
        if (value.type() != -1) {
            sb = new StringBuilder(Utils.getImpactLabel(value.getVertexClass()));
            if (value.getVertexClass().equals("SQLFieldProxy")) {
                sb.append(":").append(value.getContext("sql.tablename").toString());
            }
            sb.append(":").append(value.getVertexName());
            this.out.println(sb.toString());
        }
    }

    @Override
    public Node addNode(Value v, boolean asStartNode) {
        long nodeId = ((Atomic.Long)this.nodesKey.createOrOpen()).getAndIncrement();
        DiskNode node = new DiskNode(nodeId, v);
        this.nodes.put(nodeId, node);
        if (v.id() != null) {
            this.registry.add(new Object[]{v.id(), nodeId});
        }
        if (asStartNode) {
            this.startNodes.add(nodeId);
        }
        this.nodeTypes.add(new Object[]{v.type(), nodeId});
        if (this.out != null) {
            this.writeNodeDetails(v);
        }
        return node;
    }

    @Override
    public Link addEdge(Long fromId, Long toId) {
        return this.addEdge(1, fromId, toId, null);
    }

    @Override
    public Link addEdge(int level, Long fromId, Long toId) {
        return this.addEdge(level, fromId, toId, null);
    }

    @Override
    public Link addEdge(Long fromId, Long toId, Map<String, Object> edgeInfo) {
        return this.addEdge(1, fromId, toId, edgeInfo);
    }

    @Override
    public Link addEdge(int level, Long fromId, Long toId, Map<String, Object> edgeInfo) {
        DiskNode f = this.nodes.get(fromId);
        DiskNode t = this.nodes.get(toId);
        if (level == 1 && edgeInfo != null) {
            boolean ispcallfw = edgeInfo.get("programCallDirection") != null;
            List<Long> outEdges = f.out();
            List<Long> inEdges = t.in();
            ArrayList<Long> listIntersection = new ArrayList<Long>();
            listIntersection.addAll(outEdges);
            listIntersection.retainAll(inEdges);
            Iterator iterator = listIntersection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                Link link = this.getLink(l);
                if (!ispcallfw || link.info("programCallDirection") == null) continue;
                return link;
            }
        }
        long linkId = ((Atomic.Long)this.linksKey.createOrOpen()).getAndIncrement();
        DiskLink e = new DiskLink(linkId, fromId, toId, edgeInfo);
        this.links.put(linkId, e);
        f = this.nodes.remove(fromId);
        f.addOut(level, e.getId());
        this.nodes.put(fromId, f);
        t = this.nodes.remove(toId);
        t.addIn(level, e.getId());
        this.nodes.put(toId, t);
        return e;
    }

    @Override
    public List<Node> getNode(String key) {
        ArrayList<Node> ns = new ArrayList<Node>();
        Object[] objectArray = new Object[2];
        objectArray[0] = key;
        SortedSet<Object[]> mapSubset = this.registry.subSet(new Object[]{key}, objectArray);
        ArrayList ids = new ArrayList();
        if (!mapSubset.isEmpty()) {
            mapSubset.forEach(s -> {
                boolean bl = ids.add((Long)s[1]);
            });
        }
        for (Long l : ids) {
            DiskNode dn = this.nodes.get(l);
            if (dn == null) continue;
            ns.add(dn);
        }
        return ns;
    }

    @Override
    public List<Node> getStartNodes() {
        ArrayList<Node> ns = new ArrayList<Node>();
        for (long nid : this.startNodes) {
            ns.add(this.nodes.get(nid));
        }
        return ns;
    }

    @Override
    public Iterable<Long> getSpecialNodes(int type) {
        Iterable<Long> iterable = null;
        Object[] objectArray = new Object[2];
        objectArray[0] = type;
        SortedSet<Object[]> mapSubset = this.nodeTypes.subSet(new Object[]{type}, objectArray);
        if (!mapSubset.isEmpty()) {
            ArrayList vals = new ArrayList();
            mapSubset.forEach(s -> {
                boolean bl = vals.add((Long)s[1]);
            });
            iterable = () -> vals.iterator();
        } else {
            iterable = Collections.emptyList();
        }
        return iterable;
    }

    @Override
    public Node getNode(Long nId) {
        return this.nodes.get(nId);
    }

    @Override
    public Link getLink(Long lId) {
        return this.links.get(lId);
    }

    @Override
    public void close() {
        if (this.db != null) {
            this.db.getStore().compact();
            this.db.commit();
            this.db.close();
        }
        this.registry = null;
        this.startNodes = null;
        this.nodes = null;
        this.links = null;
        this.db = null;
    }

    @Override
    public void updateNode(Node target, Value newValue) {
        DiskNode newNode = new DiskNode((DiskNode)target, newValue);
        this.nodes.put(newNode.getId(), newNode);
    }

    @Override
    public String printStatistics() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskGraph: nodes.size=").append(this.nodes.size()).append("; links.size=").append(this.links.size()).append("; startNodes.size=").append(this.startNodes.size());
        return sb.toString();
    }

    @Override
    public void cacheValue(long first, long second, long value) {
        this.cache.add(new Object[]{first, second, value});
    }

    @Override
    public Set<Long> getCached(long first, long second) {
        HashSet<Long> ret = new HashSet<Long>();
        Object[] objectArray = new Object[3];
        objectArray[0] = first;
        objectArray[1] = second;
        SortedSet<Object[]> mapSubset = this.cache.subSet(new Object[]{first, second}, objectArray);
        ArrayList ids = new ArrayList();
        if (!mapSubset.isEmpty()) {
            mapSubset.forEach(s -> {
                boolean bl = ids.add((Long)s[1]);
            });
        }
        for (Long l : ids) {
            ret.add(l);
        }
        return ret;
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public void registerWithKey(String key, long nodeId) {
        this.nodeByKey.put(key, nodeId);
    }

    @Override
    public Long getWithKey(String key) {
        return this.nodeByKey.get(key);
    }
}

