/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.Value;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class VertexValue
implements Value,
Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 1L;
    public String name;
    private String id;
    private int type = -1;
    private String vertexClass;
    private Map<String, Object> context = new HashMap<String, Object>();

    VertexValue(OrientVertex v) {
        if (v == null) {
            throw new IllegalArgumentException("must receive a vertex");
        }
        this.name = "DSName".equals(v.getProperty("@class")) ? (String)v.getProperty("dsid") : (String)v.getProperty("name");
        this.id = v.getId().toString();
        this.type = this.getSpecial(v);
        this.vertexClass = (String)v.getProperty("@class");
        v = null;
    }

    public VertexValue(String name, String id, int type, String vclass) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.vertexClass = vclass;
    }

    private VertexValue(VertexValue v) {
        this.name = v.name;
        this.id = v.id;
        this.context.putAll(v.context);
        this.type = v.type;
        this.vertexClass = v.vertexClass;
    }

    @Override
    public String id() {
        return this.id;
    }

    private int getSpecial(OrientVertex v) {
        int ret = -1;
        String clazz = (String)v.getProperty("@class");
        if (clazz.equals("DSName") || clazz.equals("SQLFieldProxy") || clazz.equals("SQLTableProxy") || clazz.equals("AdabasFileProxy") || clazz.equals("DALProxy") || clazz.equals("DBIProxy") || clazz.equals("IDMSRecordProxy") || clazz.equals("IDMSSetProxy") || clazz.equals("BMSProxy")) {
            ret = 1;
        }
        return ret;
    }

    public OrientVertex asVertex(OrientExtendedGraph graph) {
        return (OrientVertex)graph.getVertex((Object)this.id);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.getContextId().hashCode();
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj != null && obj instanceof VertexValue) {
            ret = this.getContextId().equals(((VertexValue)obj).getContextId());
        }
        return ret;
    }

    @Override
    public <T> T getContext(String key) {
        return (T)this.context.get(key);
    }

    @Override
    public void addContext(String key, Object value) {
        this.context.put(key, value);
    }

    @Override
    public String getContextId() {
        return this.context.isEmpty() || this.context.get("id") == null ? this.id : ((Integer)this.context.get("id")).toString();
    }

    @Override
    public Value duplicate() {
        VertexValue duplicate = new VertexValue(this);
        return duplicate;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public String getVertexClass() {
        return this.vertexClass;
    }

    @Override
    public String getVertexName() {
        return this.name;
    }
}

