/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.Value;
import java.util.HashMap;
import java.util.Map;

public class ProgramValue
implements Value {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Map<String, Object> context = new HashMap<String, Object>();
    private String name;
    private String prgVId;

    public ProgramValue(String pName, Integer type, String prgVId) {
        this.name = pName;
        this.addContext("prg type id", type);
        this.prgVId = prgVId;
    }

    public ProgramValue(ProgramValue programValue) {
        this.name = programValue.name;
        this.prgVId = programValue.prgVId;
        this.context.putAll(programValue.context);
    }

    @Override
    public String id() {
        return this.prgVId;
    }

    @Override
    public <T> T getContext(String key) {
        return (T)this.context.get(key);
    }

    @Override
    public String getContextId() {
        return this.name;
    }

    @Override
    public void addContext(String key, Object value) {
        this.context.put(key, value);
    }

    @Override
    public Value duplicate() {
        ProgramValue duplicate = new ProgramValue(this);
        return duplicate;
    }

    @Override
    public int type() {
        return 2;
    }

    public String toString() {
        return "Program " + this.name;
    }

    @Override
    public String getVertexClass() {
        return "Program";
    }

    @Override
    public String getVertexName() {
        return this.name;
    }
}

