/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.IPathCycleDetector;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.internal.utils.Pair;
import java.util.List;
import java.util.Map;

public class PrgDetector
implements IPathCycleDetector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ImpactGraph ig;

    public PrgDetector(ImpactGraph ig) {
        this.ig = ig;
    }

    @Override
    public boolean hasCycle(List<Pair<Long, Long>> path, Long nId, Long lId) {
        boolean contains = false;
        Map nInEdgeVar = null;
        Long nVarId = null;
        Value nv = this.ig.getNode(nId).value();
        boolean isProgram = 2 == nv.type();
        boolean computenVarId = true;
        for (Pair<Long, Long> p : path) {
            Long nodeId = (Long)p.getFirst();
            Long linkId = (Long)p.getSecond();
            if (!nodeId.equals(nId)) continue;
            Node node = this.ig.getNode(nodeId);
            Value v = node.value();
            if (isProgram && 2 == v.type()) {
                if (lId == null && linkId == null) {
                    contains = true;
                    break;
                }
                if (lId == null || linkId == null) continue;
                Map inEdgeVar = (Map)v.getContext("inEdgeVar");
                Long varId = (Long)inEdgeVar.get(linkId);
                if (computenVarId) {
                    if (lId != null) {
                        nInEdgeVar = (Map)nv.getContext("inEdgeVar");
                        nVarId = (Long)nInEdgeVar.get(lId);
                    }
                    computenVarId = false;
                }
                if ((varId != null || nVarId != null) && (varId == null || !varId.equals(nVarId))) continue;
                contains = true;
                break;
            }
            if ((linkId != null || lId != null) && (linkId == null || lId == null || !linkId.equals(lId))) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private boolean isProgram(Long lastNodeId) {
        Iterable<Long> specialNodes = this.ig.getSpecialNodes(2);
        for (Long l : specialNodes) {
            if (!l.equals(lastNodeId)) continue;
            return true;
        }
        return false;
    }
}

