/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.internal.utils.Pair;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathPrinter
implements PathHandler {
    private static final Logger L = LoggerFactory.getLogger(PathPrinter.class);
    private boolean showCycles;
    private boolean forward;
    private Writer writer;
    private String prjName;
    private OrientExtendedGraph dbg;
    private ImpactGraph ig;

    public PathPrinter(OrientExtendedGraph dbg, ImpactGraph ig, boolean forward, Writer writer, Properties env) {
        this(dbg, ig, forward, false, writer, env);
    }

    public PathPrinter(OrientExtendedGraph dbg, ImpactGraph ig, boolean forward, boolean showCycles, Writer writer, Properties env) {
        this.showCycles = showCycles;
        this.forward = forward;
        this.writer = writer;
        this.prjName = env.getProperty("db").substring(3);
        this.dbg = dbg;
        this.ig = ig;
    }

    @Override
    public void handlePath(List<Pair<Long, Long>> path, Pair<Long, Long> entryCycleNode) {
        Long cycleNodeId;
        Long l = cycleNodeId = entryCycleNode != null ? (Long)entryCycleNode.getFirst() : null;
        if (cycleNodeId != null) {
            if (this.showCycles) {
                this.write("cycle " + this.ig.getNode(cycleNodeId).value());
            } else {
                return;
            }
        }
        int i = path.size() - 1;
        while (i > 0) {
            Pair<Long, Long> p1 = path.get(i);
            Pair<Long, Long> p2 = path.get(i - 1);
            Long n1Id = (Long)p1.getFirst();
            Long e1Id = (Long)p1.getSecond();
            Long n2Id = (Long)p2.getFirst();
            Long cfr_ignored_0 = (Long)p2.getSecond();
            String extraInfo = this.extraInfo(e1Id, this.forward);
            this.printEntry(n1Id, n2Id, extraInfo, this.forward);
            --i;
        }
        this.write("------------------------");
    }

    private void printEntry(Long nId1, Long nId2, String extraInfo, boolean forward) {
        OrientVertex vn2;
        Node n1 = this.ig.getNode(nId1);
        Node n2 = this.ig.getNode(nId2);
        String sv1 = n1.value().toString();
        String sv2 = n2.value().toString();
        VertexValue vvn1 = (VertexValue)n1.value();
        Value vvn2 = n2.value();
        OrientVertex vn1 = vvn1.asVertex(this.dbg);
        Integer v1sLine = null;
        Integer v2sLine = null;
        String v1Path = null;
        String v2Path = null;
        Integer iOff1 = null;
        Integer iOff2 = null;
        Integer iSize1 = null;
        Integer iSize2 = null;
        String v1S = null;
        String v2S = null;
        String p1S = "(nopath)";
        String p2S = "(nopath)";
        if (vn1.getProperty("@class").equals("Variable")) {
            Integer cfr_ignored_0 = (Integer)vn1.getProperty("size");
            Integer cfr_ignored_1 = (Integer)vn1.getProperty("memOffset");
            iOff1 = (Integer)vvn1.getContext("impactedOffset");
            iSize1 = (Integer)vvn1.getContext("impactedSize");
            OrientEdge si = (OrientEdge)vn1.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
            v1Path = (String)si.getVertex(Direction.IN).getProperty("full");
            v1sLine = (Integer)si.getProperty("sLine");
            v1S = String.format("%s[%d:%d]", sv1, iOff1, iOff1 + iSize1 - 1);
            p1S = String.format("%s[%d]", v1Path, v1sLine);
        } else {
            v1S = sv1;
        }
        OrientVertex orientVertex = vn2 = vvn2 instanceof VertexValue ? ((VertexValue)vvn2).asVertex(this.dbg) : null;
        if (vn2 != null && vn2.getProperty("@class").equals("Variable")) {
            Integer cfr_ignored_2 = (Integer)vn2.getProperty("size");
            Integer cfr_ignored_3 = (Integer)vn2.getProperty("memOffset");
            iOff2 = (Integer)vvn2.getContext("impactedOffset");
            iSize2 = (Integer)vvn2.getContext("impactedSize");
            OrientEdge si = (OrientEdge)vn2.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
            v2Path = (String)si.getVertex(Direction.IN).getProperty("full");
            v2sLine = (Integer)si.getProperty("sLine");
            v2S = String.format("%s[%d:%d]", sv2, iOff2, iOff2 + iSize2 - 1);
            p2S = String.format("%s[%d]", v2Path, v2sLine);
        } else if (vn2 != null && vn2.getProperty("@class").equals("DDCard")) {
            String dsname = (String)vvn2.getContext("dsName");
            String jobStep = (String)vvn2.getContext("job/step");
            v2S = String.valueOf(dsname) + "(" + jobStep + ")";
        } else {
            v2S = sv2;
        }
        if (p1S.length() > 37) {
            p1S = "..." + p1S.substring(p1S.length() - 37);
        }
        if (p2S.length() > 37) {
            p2S = "..." + p2S.substring(p2S.length() - 37);
        }
        this.write(String.format("%40s %s %-40s : %s", v1S, forward ? "-->" : "<--", v2S, extraInfo));
    }

    private String extraInfo(Long lId, boolean direct) {
        StringBuilder info = new StringBuilder();
        Link l = this.ig.getLink(lId);
        String link = (String)l.info("link");
        if (link.equals("ProxyFor")) {
            String prg = (String)l.info("program");
            Integer pos = (Integer)l.info("argument#");
            info.append("called program:").append(prg).append(", arg#: ").append(pos);
        } else if (link.equals("Argument")) {
            String prg = (String)l.info("program");
            Integer pos = (Integer)l.info("argument#");
            info.append("calling program:").append(prg).append(", arg#: ").append(pos);
        } else if (link.equals("DDCard association")) {
            String ddcard = (String)l.info("DDCard");
            info.append("DDCard association:").append(ddcard);
        } else if (link.equals("DatasetFlow")) {
            String lbl2;
            info.append("job/step " + l.info("job/step"));
            info.append(" | DDCards " + l.info("DDCard"));
            info.append(" | ");
            String lbl1 = direct ? "fromfileusage" : "tofileusage";
            String string = lbl2 = direct ? "tofileusage" : "fromfileusage";
            if (l.info(lbl1) != null && l.info(lbl2) != null) {
                this.processStmtInfo((Vertex)l.info(lbl1), link, info);
                info.append(" --> ");
                this.processStmtInfo((Vertex)l.info(lbl2), link, info);
            }
        } else {
            Object eid = l.info("edgeORID");
            Vertex vu = eid == null ? null : (Vertex)this.dbg.getEdge(eid).getProperty(direct ? "fromUsage" : "toUsage");
            this.processStmtInfo(vu, link, info);
        }
        return info.toString();
    }

    private void processStmtInfo(Vertex vu, String link, StringBuilder info) {
        String stmtType = null;
        String path = null;
        Integer line = null;
        Integer col = null;
        if (vu != null) {
            Edge si = (Edge)vu.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
            Vertex stmt = (Vertex)vu.getVertices(Direction.IN, new String[]{"Uses"}).iterator().next();
            stmtType = (String)stmt.getProperty("type");
            path = (String)si.getVertex(Direction.IN).getProperty("full");
            int idxPrj = path.indexOf(this.prjName);
            if ((path = path.substring(path.indexOf("|", idxPrj))).length() > 40) {
                path = "..." + path.substring(path.length() - 40);
            }
            line = (Integer)si.getProperty("sLine");
            col = (Integer)si.getProperty("sCol");
        }
        info.append(stmtType == null ? link : stmtType);
        if (path != null && line != null) {
            info.append(" ").append(path).append("[").append(line).append(":").append(col).append("]");
        }
    }

    private final void write(String str) {
        try {
            this.writer.write(String.valueOf(str) + "\n");
        }
        catch (IOException ex) {
            L.error("while writting data: ", (Throwable)ex);
        }
    }

    @Override
    public void addPathInfo(Object o) {
    }
}

