/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.ExpandAtProgramLevel;
import com.ez.graphs.viewer.odb.impact.model.IExpandConstraint;
import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.IPathCycleDetector;
import com.ez.graphs.viewer.odb.impact.model.IStopTest;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.NodeExpander;
import com.ez.graphs.viewer.odb.impact.model.NodeHandler;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.PrgDetector;
import com.ez.graphs.viewer.odb.impact.model.ProgramValue;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Quartet;
import com.ez.internal.utils.Triplet;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MGUtil.class);
    public static final String PRG_EDGE_MAPPING_OUT_TO_IN = "outToIn";
    public static final String PRG_EDGE_MAPPING_IN_TO_OUT = "inToOut";

    public static boolean build(ImpactGraph ig, List<? extends Value> startList, Set<String> excludedIds, int maxExpandDepth, NodeExpander expander, boolean computePrgAndDSLvl, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        int totalWork = computePrgAndDSLvl ? 50 : 100;
        boolean ignoreCancel = MGUtil.b(ig, startList, excludedIds, maxExpandDepth, expander, (IProgressMonitor)monitor.newChild(totalWork));
        final Boolean[] result = new Boolean[1];
        if (ignoreCancel) {
            L.debug("cancel is pressed");
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell[] shArr = Display.getDefault().getShells();
                    String title = Messages.getString(MGUtil.class, "title");
                    String msg = Messages.getString(MGUtil.class, "msg");
                    result[0] = MessageDialog.openQuestion((Shell)shArr[shArr.length - 1], (String)title, (String)msg);
                }
            });
            ignoreCancel = result[0];
            if (!ignoreCancel) {
                L.debug("analysis finished without partial data");
            } else {
                monitor.setTaskName(Messages.getString(MGUtil.class, "task.name"));
                L.debug("partial data will be displayed");
            }
        }
        if (computePrgAndDSLvl) {
            long start = System.currentTimeMillis();
            MGUtil.computeProgramTransitions(ig, ignoreCancel, (IProgressMonitor)monitor.newChild(30));
            L.debug("finished programTransitions " + (System.currentTimeMillis() - start) + " ms");
            start = System.currentTimeMillis();
            MGUtil.computeDatasourceLevel(ig, ignoreCancel, (IProgressMonitor)monitor.newChild(20));
            L.debug("finished datasource level " + (System.currentTimeMillis() - start) + " ms");
        }
        ig.commit();
        return ignoreCancel;
    }

    private static boolean b(ImpactGraph ig, List<? extends Value> startList, Set<String> excludedIds, int maxExpandDepth, NodeExpander expander, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(maxExpandDepth > 0 ? maxExpandDepth : 10));
        boolean ignoreCancel = false;
        L.debug("MGUtil:startbuild");
        long start = System.currentTimeMillis();
        int id = 0;
        LinkedList<Pair> toExpand = new LinkedList<Pair>();
        for (Value value : startList) {
            Node n = ig.addNode(value, true);
            if ("Variable".equals(value.getVertexClass()) && value.getContext("mustSearchAncestor") != null) {
                int varOff;
                int imsize;
                int imOff;
                String rid = value.getContextId();
                Value vv = expander.searchAncestor(rid, imOff = ((Integer)value.getContext("impactedOffset")).intValue(), imsize = ((Integer)value.getContext("impactedSize")).intValue(), varOff = ((Integer)value.getContext("memOffset")).intValue());
                if (vv == null) continue;
                List<Node> nl = ig.getNode(vv.id());
                Node n2 = null;
                if (nl != null && !nl.isEmpty()) {
                    n2 = expander.resolveConflict(nl, vv);
                }
                if (n2 == null) {
                    n2 = ig.addNode(vv, false);
                    toExpand.add(new Pair((Object)n2.getId(), (Object)0));
                }
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("link", "Child of");
                LinkedHashSet<String> oridInfo = new LinkedHashSet<String>();
                String fakeStmtRid = vv.id();
                oridInfo.add(fakeStmtRid);
                info.put("nodeORID", oridInfo);
                ig.addEdge(n.getId(), (Long)n2.getId(), info);
                MGUtil.handleHigherLevel(ig, n, n2, null);
                continue;
            }
            toExpand.add(new Pair((Object)n.getId(), (Object)0));
        }
        L.trace("start node size: " + startList.size());
        boolean bl = false;
        int odepth = 0;
        long loop = System.currentTimeMillis();
        int links = 0;
        block1: while (toExpand.size() > 0) {
            Boolean needUpdate;
            Pair p = (Pair)toExpand.remove(0);
            long nId = (Long)p.getFirst();
            Node n = ig.getNode(nId);
            Value nv = n.value();
            int n2 = (Integer)p.getSecond();
            if (n2 != odepth) {
                if (maxExpandDepth > 0) {
                    monitor.setWorkRemaining(maxExpandDepth - n2);
                } else {
                    monitor.setWorkRemaining(10);
                }
                odepth = n2;
            }
            if (monitor.isCanceled()) {
                ignoreCancel = true;
                break;
            }
            if (maxExpandDepth > 0 && n2 >= maxExpandDepth || !startList.contains(nv) && 1 == nv.type() && expander.shouldStopAtDataSource()) {
                Value v = nv.duplicate();
                v.addContext("node is not expanded in callgraph", "true");
                ig.updateNode(n, v);
                continue;
            }
            if (excludedIds != null && excludedIds.contains(nv.id())) {
                boolean isSpecial = nv.type() != -1;
                String pNode = (String)nv.getContext("programName");
                if (!isSpecial && pNode == null) {
                    isSpecial = true;
                }
                if (isSpecial) continue;
                String prgVId = (String)nv.getContext("prog_vertex_id");
                Integer pTypeId = (Integer)nv.getContext("prg type id");
                List<Long> prgList = n.out(8);
                MGUtil.handleProgramDefNode(ig, prgList, nId, pNode, pTypeId, prgVId);
                continue;
            }
            List<Pair<? extends Value, Map<String, Object>>> expandedFromCalls = null;
            if (nv.getContext("impactedInSubprogram") != null) {
                String rid = nv.id();
                Map<Long, Map<String, Set<String>>> infoFromCalls = expander.getCallsInfo(rid);
                if (infoFromCalls != null) {
                    for (Long fromNodeId : infoFromCalls.keySet()) {
                        List<Pair<? extends Value, Map<String, Object>>> expandedFromCallsLocal;
                        if (!MGUtil.isPathBetween(ig, fromNodeId, n) || (expandedFromCallsLocal = expander.addImpactedVars(nv, fromNodeId, infoFromCalls.get(fromNodeId))) == null) continue;
                        if (expandedFromCalls == null) {
                            expandedFromCalls = expandedFromCallsLocal;
                            continue;
                        }
                        expandedFromCalls.addAll(expandedFromCallsLocal);
                    }
                } else {
                    expandedFromCalls = expander.addImpactedVars(nv, null, null);
                }
            }
            long st = System.currentTimeMillis();
            List<Pair<? extends Value, Map<String, Object>>> expanded = expander.expand(n);
            if (expandedFromCalls != null) {
                if (expanded == null) {
                    expanded = expandedFromCalls;
                } else {
                    expanded.addAll(expandedFromCalls);
                }
            }
            if ((needUpdate = (Boolean)n.value().getContext("node need update in impact graph")) != null && needUpdate.booleanValue()) {
                ig.updateNode(n, n.value());
            }
            if (L.isTraceEnabled()) {
                String pFrom = (String)n.value().getContext("programName");
                if (L.isTraceEnabled()) {
                    L.trace("toExpand.size()={}; depth= {}; expanded.size= {}; n={}; expand.time={} ms, prg={} id= {} loop={}", new Object[]{toExpand.size(), n2, expanded.size(), n.value(), System.currentTimeMillis() - st, pFrom, n.value().id(), System.currentTimeMillis() - loop});
                }
                loop = System.currentTimeMillis();
            }
            if (!expanded.isEmpty()) {
                while (expanded.size() > 0) {
                    Pair<? extends Value, Map<String, Object>> pair = expanded.remove(0);
                    Value ev = (Value)pair.getFirst();
                    if (ev.id() == null) continue;
                    if (monitor.isCanceled()) {
                        ignoreCancel = true;
                        continue block1;
                    }
                    Map edgeInfo = (Map)pair.getSecond();
                    Node en = null;
                    List<Node> nl = ig.getNode(ev.id());
                    if (nl != null && !nl.isEmpty()) {
                        en = expander.resolveConflict(nl, ev);
                    }
                    if (en == null) {
                        ev.addContext("id", id++);
                        en = ig.addNode(ev, false);
                        int currentDepth = n2;
                        if (expander.incrementLevel(ev.type())) {
                            currentDepth = n2 + 1;
                        }
                        toExpand.add(new Pair((Object)en.getId(), (Object)currentDepth));
                    } else {
                        Set viaCallCurrent = (Set)ev.getContext("via call information");
                        if (viaCallCurrent != null) {
                            HashSet viaCall = (HashSet)en.value().getContext("via call information");
                            if (viaCall == null) {
                                viaCall = new HashSet();
                                en.value().addContext("via call information", viaCall);
                            }
                            viaCall.addAll(viaCallCurrent);
                        }
                    }
                    if (edgeInfo.containsKey("Redefine_processed")) {
                        ev.addContext("Redefine_processed", edgeInfo.get("Redefine_processed"));
                    }
                    Link l = ig.addEdge(nId, (Long)en.getId(), edgeInfo);
                    edgeInfo.put("lowLevelEdgeId", l.getId());
                    links = (int)((long)links + MGUtil.handleHigherLevel(ig, n, en, edgeInfo));
                }
                continue;
            }
            links = (int)((long)links + MGUtil.handleHigherLevel(ig, n, null, null));
        }
        L.debug("MGUtil:endbuild {} ms", (Object)(System.currentTimeMillis() - start));
        L.debug("MGUtil:statistics: {}", (Object)ig.printStatistics());
        L.debug("addEdge calls {}", (Object)links);
        return ignoreCancel;
    }

    private static boolean isPathBetween(ImpactGraph ig, Long fromNodeId, Node n) {
        ArrayList<Node> toExpand = new ArrayList<Node>();
        toExpand.add(n);
        boolean found = false;
        HashSet<Long> processed = new HashSet<Long>();
        processed.add(n.getId());
        block0: while (!found && !toExpand.isEmpty()) {
            Node cn = (Node)toExpand.remove(0);
            List<Long> inEdges = cn.in();
            for (long eId : inEdges) {
                Link link = ig.getLink(eId);
                long fId = link.from();
                if (processed.contains(fId)) continue;
                Node fNode = ig.getNode(fId);
                if (fromNodeId.equals(fNode.getId())) {
                    found = true;
                    continue block0;
                }
                toExpand.add(fNode);
                processed.add(cn.getId());
            }
        }
        return found;
    }

    private static boolean alreadyAdded(NodeExpander expander, Value ev, List<Node> addedInToExpand) {
        Node en;
        ev.id();
        return addedInToExpand != null && !addedInToExpand.isEmpty() && (en = expander.resolveConflict(addedInToExpand, ev)) != null;
    }

    private static void createDatasourceLevelLink(ImpactGraph ig, List<Pair<Long, Long>> nodes, Long cycleNodeId, boolean noDSNode) {
        if (cycleNodeId != null && !noDSNode) {
            return;
        }
        Long firstId = (Long)nodes.get(0).getFirst();
        Long lastId = cycleNodeId != null ? cycleNodeId : (Long)nodes.get(nodes.size() - 1).getFirst();
        Node last = ig.getNode(lastId);
        List<Long> edges = last.in(4);
        boolean found = false;
        for (Long eId : edges) {
            Link e = ig.getLink(eId);
            if (e == null || !firstId.equals(e.from())) continue;
            found = true;
            break;
        }
        if (!found) {
            ig.addEdge(4, firstId, lastId);
        }
    }

    private static void computeDatasourceLevel(final ImpactGraph ig, boolean ignoreCancel, IProgressMonitor pmonitor) {
        ArrayList<Long> stop = new ArrayList<Long>();
        ArrayList<Long> dsList = new ArrayList<Long>();
        for (Long dId : ig.getSpecialNodes(1)) {
            dsList.add(dId);
            stop.add(dId);
        }
        L.debug("datasources number: {}", (Object)dsList.size());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(100 + dsList.size() * 100));
        final boolean noDSNode = dsList.size() == 0;
        List<Node> l = ig.getStartNodes();
        for (Node node : l) {
            if (dsList.contains(node.getId())) continue;
            dsList.add(node.getId());
        }
        PathHandler dsph = new PathHandler(){

            @Override
            public void handlePath(List<Pair<Long, Long>> nodes, Pair<Long, Long> entryCycleNode) {
                Long cycleNodeID = entryCycleNode != null ? (Long)entryCycleNode.getFirst() : null;
                MGUtil.createDatasourceLevelLink(ig, nodes, cycleNodeID, noDSNode);
            }

            @Override
            public void addPathInfo(Object o) {
            }
        };
        ExpandAtProgramLevel expander = new ExpandAtProgramLevel();
        PrgDetector detector = new PrgDetector(ig);
        for (Long dNodeId : dsList) {
            ArrayList<Long> sNodes = new ArrayList<Long>();
            sNodes.add(dNodeId);
            MGUtil.allPathsDepthFirst(sNodes, ig, true, dsph, null, null, stop, 2, expander, detector, ignoreCancel, (IProgressMonitor)monitor.newChild(100));
        }
    }

    private static void computeProgramTransitions(ImpactGraph ig, boolean ignoreCancel, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        int prgCount = 0;
        for (Node sn : ig.getStartNodes()) {
            List<Long> prgDefOut;
            if (sn.value().type() == 1 || (prgDefOut = sn.out(8)) == null) continue;
            Long defPrg = prgDefOut.get(0);
            Long pgmId = ig.getLink(defPrg).to();
            HashMap<String, Object> eInfo = new HashMap<String, Object>();
            eInfo.put("lowLevel.toId", sn.getId());
            eInfo.put("memOffset", sn.value().getContext("memOffset"));
            eInfo.put("impactedOffset", sn.value().getContext("impactedOffset"));
            eInfo.put("impactedSize", sn.value().getContext("impactedSize"));
            ig.addEdge(2, sn.getId(), pgmId, eInfo);
            L.debug("startVar to pgm: {} ---> {}", (Object)sn, (Object)pgmId);
        }
        for (Long pId : ig.getSpecialNodes(2)) {
            Node pNode = ig.getNode(pId);
            ++prgCount;
            if (!ignoreCancel && monitor.isCanceled()) break;
            HashSet<Long> ins = new HashSet<Long>(pNode.in(2));
            HashSet<Long> outs = new HashSet<Long>(pNode.out(2));
            HashMap<Long, HashSet<Long>> inVarEdge = new HashMap<Long, HashSet<Long>>();
            HashMap<Long, Long> inEdgeVar = new HashMap<Long, Long>();
            for (Long eId : ins) {
                Link l = ig.getLink(eId);
                Long vId = (Long)l.info("lowLevel.toId");
                HashSet<Long> eids = (HashSet<Long>)inVarEdge.get(vId);
                if (eids == null) {
                    eids = new HashSet<Long>();
                    inVarEdge.put(vId, eids);
                }
                eids.add(eId);
                inEdgeVar.put(eId, vId);
            }
            HashMap<Long, HashSet<Long>> outVarEdge = new HashMap<Long, HashSet<Long>>();
            for (Long eId : outs) {
                Link l = ig.getLink(eId);
                Long vId = (Long)l.info("lowLevel.fromId");
                HashSet<Long> eids = (HashSet<Long>)outVarEdge.get(vId);
                if (eids == null) {
                    eids = new HashSet<Long>();
                    outVarEdge.put(vId, eids);
                }
                eids.add(eId);
            }
            HashMap<Long, Set<Long>> inToOut = new HashMap<Long, Set<Long>>();
            HashMap<Long, Set<Long>> outToIn = new HashMap<Long, Set<Long>>();
            for (Long vId : inVarEdge.keySet()) {
                Set inEdge = (Set)inVarEdge.get(vId);
                for (Long inE : inEdge) {
                    Map<Long, Set<Long>> impacted = MGUtil.getImpactedVarsAtProgramEdge(vId, inE, ig, pId);
                    for (Long outVar : impacted.keySet()) {
                        Set<Long> lowLevelEdges = impacted.get(outVar);
                        Set outEdge = (Set)outVarEdge.get(outVar);
                        HashSet<Long> filtered = new HashSet<Long>();
                        Iterator iterator = outEdge.iterator();
                        while (iterator.hasNext()) {
                            long lId = (Long)iterator.next();
                            Link link = ig.getLink(lId);
                            if (!lowLevelEdges.contains(link.info("lowLevelEdgeId"))) continue;
                            filtered.add(lId);
                        }
                        MGUtil.addInToOut(inToOut, inE, filtered);
                        MGUtil.addOutToIn(outToIn, filtered, inE);
                    }
                }
            }
            Value v = pNode.value().duplicate();
            v.addContext(PRG_EDGE_MAPPING_IN_TO_OUT, inToOut);
            v.addContext(PRG_EDGE_MAPPING_OUT_TO_IN, outToIn);
            v.addContext("inVarEdge", inVarEdge);
            v.addContext("inEdgeVar", inEdgeVar);
            ig.updateNode(pNode, v);
            pNode = ig.getNode(pNode.getId());
        }
        L.debug("processed programs: {}", (Object)prgCount);
    }

    private static void addOutToIn(Map<Long, Set<Long>> map, Set<Long> outList, Long inE) {
        if (outList != null) {
            for (Long out : outList) {
                Set<Long> iList = map.get(out);
                if (iList == null) {
                    iList = new HashSet<Long>();
                    map.put(out, iList);
                }
                iList.add(inE);
            }
        }
    }

    private static void addInToOut(Map<Long, Set<Long>> map, Long in, Set<Long> outList) {
        Set<Long> iList = map.get(in);
        if (iList == null) {
            iList = new HashSet<Long>();
            map.put(in, iList);
        }
        if (outList != null) {
            iList.addAll(outList);
        }
    }

    private static Map<Long, Set<Long>> getImpactedVarsAtProgramEdge(Long startVId, Long startEId, ImpactGraph ig, Long pId) {
        HashMap<Long, Set<Long>> vars = new HashMap<Long, Set<Long>>();
        HashSet<Triplet> visited = new HashSet<Triplet>();
        ArrayList<Triplet> toExpand = new ArrayList<Triplet>();
        Node vNode = ig.getNode(startVId);
        Link vLink = ig.getLink(startEId);
        Set soffs = vLink.info("impact") != null ? ((Map)vLink.info("impact")).keySet() : null;
        toExpand.add(new Triplet((Object)vNode, (Object)vLink, soffs));
        while (toExpand.size() != 0) {
            Triplet pair = (Triplet)toExpand.remove(0);
            vNode = (Node)pair.getFirst();
            vLink = (Link)pair.getSecond();
            soffs = (Set)pair.getThird();
            visited.add(new Triplet((Object)vNode.getId(), (Object)vLink.getId(), (Object)soffs));
            Map soffMap = (Map)vLink.info("impact");
            List<Long> nextEdges = vNode.out();
            for (Long lId : nextEdges) {
                Node nextVar;
                Link link = ig.getLink(lId);
                boolean consider = false;
                Map offMap = (Map)link.info("impact");
                HashSet<Object> offs = new HashSet<Object>();
                if (soffMap == null || offMap == null) {
                    consider = true;
                    if (offMap != null) {
                        offs.addAll(offMap.keySet());
                    }
                } else {
                    for (String ckey : soffs) {
                        String[] cim = ((String)soffMap.get(ckey)).split(",");
                        ArrayList<Integer> clist = new ArrayList<Integer>();
                        int i = 1;
                        while (i <= Integer.valueOf(cim[3])) {
                            clist.add(Integer.valueOf(cim[2]) + i);
                            ++i;
                        }
                        for (String key : offMap.keySet()) {
                            String[] im = ((String)offMap.get(key)).split(",");
                            ArrayList<Integer> list = new ArrayList<Integer>();
                            int i2 = 1;
                            while (i2 <= Integer.valueOf(im[1])) {
                                list.add(Integer.valueOf(im[0]) + i2);
                                ++i2;
                            }
                            if (Collections.disjoint(clist, list)) continue;
                            offs.add(key);
                            consider = true;
                        }
                    }
                }
                if (!consider || visited.contains(new Triplet((Object)(nextVar = ig.getNode(link.to())).getId(), (Object)link.getId(), offs))) continue;
                List<Long> pDefNode = nextVar.out(8);
                if (!pDefNode.isEmpty() && pId.equals(ig.getLink(pDefNode.get(0)).to())) {
                    Triplet p = new Triplet((Object)nextVar, (Object)link, offs);
                    if (toExpand.contains(p)) continue;
                    toExpand.add(p);
                    continue;
                }
                HashSet<Long> existent = (HashSet<Long>)vars.get(vNode.getId());
                if (existent == null) {
                    existent = new HashSet<Long>();
                    vars.put(vNode.getId(), existent);
                }
                existent.add(lId);
            }
        }
        return vars;
    }

    private static Long[] handleProgramDefNode(ImpactGraph ig, List<Long> pDefEdges, Long nodeId, String prgName, Integer pTypeId, String prgVId) {
        Long pNodeId = null;
        long links = 0L;
        if (pDefEdges.size() == 0) {
            pNodeId = ig.getWithKey(prgName);
            Node pNode = null;
            if (pNodeId == null) {
                ProgramValue pv = new ProgramValue(prgName, pTypeId, prgVId);
                pNode = ig.addNode(pv, false);
                pNodeId = pNode.getId();
                ig.registerWithKey(prgName, pNodeId);
            } else {
                pNode = ig.getNode(pNodeId);
            }
            ig.addEdge(8, nodeId, pNodeId);
            ++links;
        } else {
            pNodeId = ig.getLink(pDefEdges.get(0)).to();
        }
        return new Long[]{pNodeId, links};
    }

    private static long handleHigherLevel(ImpactGraph ig, Node from, Node to, Map<String, Object> lowLevelEdgeInfo) {
        System.currentTimeMillis();
        long links = 0L;
        boolean fromSpecial = from.value().type() != -1;
        from = ig.getNode(from.getId());
        List<Long> fromPrg = from.out(8);
        String pFrom = (String)from.value().getContext("programName");
        Node pFromNode = null;
        Long pFromNodeId = null;
        if (!fromSpecial && pFrom == null) {
            fromSpecial = true;
        }
        if (!fromSpecial) {
            String prgVId = from.value().getContext("prog_vertex_id").toString();
            Integer pTypeId = (Integer)from.value().getContext("prg type id");
            Long[] ret = MGUtil.handleProgramDefNode(ig, fromPrg, from.getId(), pFrom, pTypeId, prgVId);
            pFromNodeId = ret[0];
            pFromNode = ig.getNode(pFromNodeId);
            from = ig.getNode(from.getId());
            links += ret[1].longValue();
        }
        if (to != null) {
            HashMap<String, Object> eInfo;
            Object impactOffMap;
            to = ig.getNode(to.getId());
            List<Long> toPrg = to.out(8);
            boolean toSpecial = to.value().type() != -1;
            String pTo = (String)to.value().getContext("programName");
            if (!toSpecial && pTo == null) {
                toSpecial = true;
            }
            Node pToNode = null;
            Long pToNodeId = null;
            if (!toSpecial) {
                String prgVId = to.value().getContext("prog_vertex_id").toString();
                Integer pTypeId = (Integer)to.value().getContext("prg type id");
                Long[] ret = MGUtil.handleProgramDefNode(ig, toPrg, to.getId(), pTo, pTypeId, prgVId);
                pToNodeId = ret[0];
                pToNode = ig.getNode(pToNodeId);
                to = ig.getNode(to.getId());
                links += ret[1].longValue();
                from = ig.getNode(from.getId());
                if (pFromNodeId != null) {
                    pFromNode = ig.getNode(pFromNodeId);
                }
            }
            String edgeToAddDepTypeFWCall = lowLevelEdgeInfo != null && lowLevelEdgeInfo.get("programCallDirection") != null ? lowLevelEdgeInfo.get("programCallDirection").toString() : null;
            Object object = impactOffMap = lowLevelEdgeInfo != null ? lowLevelEdgeInfo.get("impact") : null;
            if (pFromNodeId != null && pToNodeId != null) {
                if (!pFromNodeId.equals(pToNodeId)) {
                    eInfo = new HashMap();
                    eInfo.put("lowLevel.fromId", from.getId());
                    eInfo.put("lowLevel.toId", to.getId());
                    eInfo.put("lowLevelEdgeId", lowLevelEdgeInfo.get("lowLevelEdgeId"));
                    eInfo.put("programCallDirection", edgeToAddDepTypeFWCall);
                    if (impactOffMap != null) {
                        eInfo.put("impact", impactOffMap);
                    }
                    if (lowLevelEdgeInfo.get("REQUIRED_NODE_ID_ON_PATH") != null) {
                        eInfo.put("REQUIRED_NODE_ID_ON_PATH", lowLevelEdgeInfo.get("REQUIRED_NODE_ID_ON_PATH"));
                    }
                    Link e = ig.addEdge(2, pFromNodeId, pToNodeId, eInfo);
                    ig.getLink(e.getId());
                    ++links;
                    pFromNode = ig.getNode(pFromNode.getId());
                    pToNode = ig.getNode(pToNode.getId());
                }
            } else if (pFromNodeId == null && pToNodeId == null) {
                eInfo = new HashMap<String, Object>();
                eInfo.put("lowLevel.fromId", from.getId());
                eInfo.put("lowLevel.toId", to.getId());
                eInfo.put("lowLevelEdgeId", lowLevelEdgeInfo.get("lowLevelEdgeId"));
                eInfo.put("programCallDirection", edgeToAddDepTypeFWCall);
                if (impactOffMap != null) {
                    eInfo.put("impact", impactOffMap);
                }
                Link e = ig.addEdge(2, from.getId(), to.getId(), eInfo);
                ig.getLink(e.getId());
                ++links;
                from = ig.getNode(from.getId());
                to = ig.getNode(to.getId());
            } else if (pFromNodeId == null) {
                eInfo = new HashMap();
                eInfo.put("lowLevel.fromId", from.getId());
                eInfo.put("lowLevel.toId", to.getId());
                eInfo.put("lowLevelEdgeId", lowLevelEdgeInfo.get("lowLevelEdgeId"));
                eInfo.put("programCallDirection", edgeToAddDepTypeFWCall);
                if (impactOffMap != null) {
                    eInfo.put("impact", impactOffMap);
                }
                Link e = ig.addEdge(2, from.getId(), pToNodeId, eInfo);
                ig.getLink(e.getId());
                ++links;
                from = ig.getNode(from.getId());
                pToNode = ig.getNode(pToNode.getId());
            } else {
                eInfo = new HashMap();
                eInfo.put("lowLevel.fromId", from.getId());
                eInfo.put("lowLevel.toId", to.getId());
                eInfo.put("lowLevelEdgeId", lowLevelEdgeInfo.get("lowLevelEdgeId"));
                eInfo.put("programCallDirection", edgeToAddDepTypeFWCall);
                if (impactOffMap != null) {
                    eInfo.put("impact", impactOffMap);
                }
                Link e = ig.addEdge(2, pFromNodeId, to.getId(), eInfo);
                ig.getLink(e.getId());
                ++links;
                pFromNode = ig.getNode(pFromNode.getId());
                to = ig.getNode(to.getId());
            }
        }
        return links;
    }

    public static void allPathsDepthFirst(Collection<Long> startNodeIds, ImpactGraph graph, boolean forward, PathHandler ph, NodeHandler nh, final List<? extends Value> stopValues, final List<Long> stopNodes, int igLevel, INodeExpander expander, IPathCycleDetector detector, boolean ignoreCancel, IProgressMonitor pmonitor) {
        IStopTest stopTester = new IStopTest(){

            @Override
            public boolean shouldStop(Node node) {
                return stopNodes != null && stopNodes.contains(node.getId()) || stopValues != null && stopValues.contains(node.value());
            }

            @Override
            public boolean handlePathOnNoExpand() {
                return !(stopValues != null && !stopValues.isEmpty() || stopNodes != null && !stopNodes.isEmpty());
            }
        };
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        MGUtil.allPathsDepthFirst(startNodeIds, graph, forward, ph, nh, igLevel, stopTester, expander, detector, null, ignoreCancel, (IProgressMonitor)monitor.newChild(100));
    }

    public static void allPathsDepthFirst(Collection<Long> startNodeIds, ImpactGraph graph, boolean forward, PathHandler ph, NodeHandler nh, int igLevel, IStopTest stopTester, INodeExpander expander, IPathCycleDetector detector, IExpandConstraint constraint, boolean ignoreCancel, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ArrayList<Quartet> toExpand = new ArrayList<Quartet>();
        ArrayList<Pair<Long, Long>> stack = new ArrayList<Pair<Long, Long>>();
        for (Long snId : startNodeIds) {
            toExpand.add(new Quartet((Object)snId, (Object)-1L, (Object)0, null));
        }
        while (toExpand.size() > 0) {
            if (!ignoreCancel && monitor.isCanceled()) {
                toExpand.clear();
                break;
            }
            Quartet p = (Quartet)toExpand.remove(0);
            long nId = (Long)p.getFirst();
            long eId = (Long)p.getSecond();
            Node node = graph.getNode(nId);
            Link edge = graph.getLink(eId);
            String dependencyTypeFWCall = null;
            if (edge != null && edge.info("programCallDirection") != null) {
                dependencyTypeFWCall = edge.info("programCallDirection").toString();
            }
            int stackLevel = (Integer)p.getThird();
            while (stack.size() > stackLevel) {
                stack.remove(stack.size() - 1);
            }
            Pair entry = new Pair((Object)nId, (Object)eId);
            if (detector != null && detector.hasCycle(stack, nId, eId) || detector == null && MGUtil.pathContains(stack, nId, eId)) {
                if (nh != null) {
                    nh.handle(stack, (Pair<Long, Long>)entry);
                }
                if (ph == null) continue;
                ph.handlePath(stack, (Pair<Long, Long>)entry);
                continue;
            }
            stack.add(entry);
            if (nh != null) {
                nh.handle(stack, null);
            }
            if (stackLevel > 0 && stopTester.shouldStop(node)) {
                if (ph != null) {
                    ph.handlePath(stack, null);
                }
                stack.remove(stack.size() - 1);
                continue;
            }
            List<Pair<Long, Set<String>>> nextEdges = expander.expand(graph, forward, edge, node, (Set)p.getFourth());
            boolean addEdges = false;
            if (nextEdges != null && nextEdges.size() > 0) {
                for (Pair<Long, Set<String>> pair : nextEdges) {
                    boolean add;
                    String edgeToAddDepTypeFWCall;
                    Long lId = (Long)pair.getFirst();
                    Link edgeToAdd = graph.getLink(lId);
                    if (edgeToAdd.info("REQUIRED_NODE_ID_ON_PATH") != null) {
                        boolean found = false;
                        Long toSearch = (Long)edgeToAdd.info("REQUIRED_NODE_ID_ON_PATH");
                        for (Pair pair2 : stack) {
                            long edgeid = (Long)pair2.getSecond();
                            Link edgeOnPath = graph.getLink(edgeid);
                            long llnodeId = edgeOnPath != null && edgeOnPath.info("lowLevel.fromId") != null ? (Long)edgeOnPath.info("lowLevel.fromId") : (Long)pair2.getFirst();
                            if (!toSearch.equals(llnodeId)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    Set orids = (Set)pair.getSecond();
                    long nextNode = forward ? edgeToAdd.to() : edgeToAdd.from();
                    Value edgeFromValue = edge != null ? graph.getNode(edge.from()).value() : null;
                    String fromRid = edge != null ? edgeFromValue.id() : null;
                    String toRid = graph.getNode(edgeToAdd.to()).value().id();
                    if (constraint != null) {
                        boolean add2;
                        if (!constraint.allowExpand(nextNode)) continue;
                        edgeToAddDepTypeFWCall = edgeToAdd.info("programCallDirection") != null ? edgeToAdd.info("programCallDirection").toString() : null;
                        boolean bl = add2 = dependencyTypeFWCall == null || edgeToAddDepTypeFWCall == null || dependencyTypeFWCall.equals(edgeToAddDepTypeFWCall) || !fromRid.equals(toRid);
                        if (!add2) continue;
                        addEdges = true;
                        toExpand.add(0, new Quartet((Object)nextNode, (Object)lId, (Object)stack.size(), (Object)orids));
                        continue;
                    }
                    edgeToAddDepTypeFWCall = edgeToAdd.info("programCallDirection") != null ? edgeToAdd.info("programCallDirection").toString() : null;
                    boolean bl = add = dependencyTypeFWCall == null || edgeToAddDepTypeFWCall == null || dependencyTypeFWCall.equals(edgeToAddDepTypeFWCall) || !fromRid.equals(toRid);
                    if (!add) continue;
                    addEdges = true;
                    toExpand.add(0, new Quartet((Object)nextNode, (Object)lId, (Object)stack.size(), (Object)orids));
                }
            }
            if (addEdges) continue;
            if (stopTester.handlePathOnNoExpand() && ph != null) {
                ph.handlePath(stack, null);
            }
            stack.remove(stack.size() - 1);
        }
        monitor.subTask("");
        monitor.done();
    }

    public static void uniquePathDepthFirst(Collection<Long> startNodeIds, ImpactGraph graph, boolean forward, PathHandler ph, NodeHandler nh, int igLevel, IStopTest stopTester, INodeExpander expander, IPathCycleDetector detector, IExpandConstraint constraint, boolean continueAnalysis, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ArrayList<Quartet> toExpand = new ArrayList<Quartet>();
        ArrayList<Pair<Long, Long>> stack = new ArrayList<Pair<Long, Long>>();
        HashSet<Triplet> expanded = new HashSet<Triplet>();
        for (Long snId : startNodeIds) {
            toExpand.add(new Quartet((Object)snId, (Object)-1L, (Object)0, null));
        }
        while (toExpand.size() > 0) {
            if (!continueAnalysis) {
                toExpand.clear();
                break;
            }
            Quartet p = (Quartet)toExpand.remove(0);
            expanded.add(new Triplet((Object)((Long)p.getFirst()), (Object)((Long)p.getSecond()), (Object)((Set)p.getFourth())));
            long nId = (Long)p.getFirst();
            long eId = (Long)p.getSecond();
            Node node = graph.getNode(nId);
            Link edge = graph.getLink(eId);
            String dependencyTypeFWCall = null;
            if (edge != null) {
                if (edge.info("programCallDirection") != null) {
                    dependencyTypeFWCall = edge.info("programCallDirection").toString();
                }
                if (ph != null && edge.info("VARPARAM") != null) {
                    ph.addPathInfo(edge.info("VARPARAM"));
                }
            }
            int stackLevel = (Integer)p.getThird();
            while (stack.size() > stackLevel) {
                stack.remove(stack.size() - 1);
            }
            Pair entry = new Pair((Object)nId, (Object)eId);
            if (detector != null && detector.hasCycle(stack, nId, eId) || detector == null && MGUtil.pathContains(stack, nId, eId)) {
                if (nh != null) {
                    nh.handle(stack, (Pair<Long, Long>)entry);
                }
                if (ph == null) continue;
                ph.handlePath(stack, (Pair<Long, Long>)entry);
                continue;
            }
            stack.add(entry);
            if (nh != null) {
                nh.handle(stack, null);
            }
            if (stackLevel > 0 && stopTester.shouldStop(node)) {
                if (ph != null) {
                    ph.handlePath(stack, null);
                }
                stack.remove(stack.size() - 1);
                continue;
            }
            List<Pair<Long, Set<String>>> nextEdges = expander.expand(graph, forward, edge, node, (Set)p.getFourth());
            boolean addEdges = false;
            if (nextEdges != null && nextEdges.size() > 0) {
                for (Pair<Long, Set<String>> pair : nextEdges) {
                    boolean add;
                    Triplet triplet;
                    String edgeToAddDepTypeFWCall;
                    Long lId = (Long)pair.getFirst();
                    Link edgeToAdd = graph.getLink(lId);
                    if (edgeToAdd.info("REQUIRED_NODE_ID_ON_PATH") != null) {
                        boolean found = false;
                        Long toSearch = (Long)edgeToAdd.info("REQUIRED_NODE_ID_ON_PATH");
                        for (Pair pair2 : stack) {
                            long edgeid = (Long)pair2.getSecond();
                            Link edgeOnPath = graph.getLink(edgeid);
                            long llnodeId = edgeOnPath != null && edgeOnPath.info("lowLevel.fromId") != null ? (Long)edgeOnPath.info("lowLevel.fromId") : (Long)pair2.getFirst();
                            if (!toSearch.equals(llnodeId)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    Set orids = (Set)pair.getSecond();
                    long nextNode = forward ? edgeToAdd.to() : edgeToAdd.from();
                    Value edgeFromValue = edge != null ? graph.getNode(edge.from()).value() : null;
                    String fromRid = edge != null ? edgeFromValue.id() : null;
                    String toRid = graph.getNode(edgeToAdd.to()).value().id();
                    if (constraint != null) {
                        boolean add2;
                        if (!constraint.allowExpand(nextNode)) continue;
                        edgeToAddDepTypeFWCall = edgeToAdd.info("programCallDirection") != null ? edgeToAdd.info("programCallDirection").toString() : null;
                        boolean bl = add2 = dependencyTypeFWCall == null || edgeToAddDepTypeFWCall == null || dependencyTypeFWCall.equals(edgeToAddDepTypeFWCall) || !fromRid.equals(toRid);
                        if (!add2) continue;
                        triplet = new Triplet((Object)nextNode, (Object)lId, (Object)orids);
                        if (!expanded.contains(triplet)) {
                            addEdges = true;
                            toExpand.add(0, new Quartet((Object)nextNode, (Object)lId, (Object)stack.size(), (Object)orids));
                            continue;
                        }
                        L.debug("ignore this posibility to explore, it is explored on a previous path");
                        continue;
                    }
                    edgeToAddDepTypeFWCall = edgeToAdd.info("programCallDirection") != null ? edgeToAdd.info("programCallDirection").toString() : null;
                    boolean bl = add = dependencyTypeFWCall == null || edgeToAddDepTypeFWCall == null || dependencyTypeFWCall.equals(edgeToAddDepTypeFWCall) || !fromRid.equals(toRid);
                    if (!add) continue;
                    triplet = new Triplet((Object)nextNode, (Object)lId, (Object)orids);
                    if (!expanded.contains(triplet)) {
                        addEdges = true;
                        toExpand.add(0, new Quartet((Object)nextNode, (Object)lId, (Object)stack.size(), (Object)orids));
                        continue;
                    }
                    L.debug("ignore this posibility to explore, it is explored on a previous path");
                }
            }
            if (addEdges) continue;
            if (stopTester.handlePathOnNoExpand() && ph != null) {
                ph.handlePath(stack, null);
            }
            stack.remove(stack.size() - 1);
        }
        monitor.subTask("");
        monitor.done();
    }

    private static void print(List<Triplet<Long, Long, List<Integer>>> stack, ImpactGraph graph) {
    }

    private static boolean hasImpactIntersection(Value toValue, Value fromValue) {
        if (toValue == null || fromValue == null) {
            return false;
        }
        int impactedOffsetFrom = (Integer)fromValue.getContext("impactedOffset") + (Integer)fromValue.getContext("memOffset");
        int impactedSizeFrom = (Integer)fromValue.getContext("impactedSize");
        int impactedOffsetTo = (Integer)toValue.getContext("impactedOffset") + (Integer)toValue.getContext("memOffset");
        int impactedSizeTo = (Integer)toValue.getContext("impactedSize");
        HashSet<Integer> f = new HashSet<Integer>();
        int i = 1;
        while (i <= impactedSizeFrom) {
            f.add(impactedOffsetFrom + i);
            ++i;
        }
        HashSet<Integer> t = new HashSet<Integer>();
        int i2 = 1;
        while (i2 <= impactedSizeTo) {
            t.add(impactedOffsetTo + i2);
            ++i2;
        }
        ArrayList<Integer> listIntersection = new ArrayList<Integer>();
        listIntersection.addAll(f);
        listIntersection.retainAll(t);
        return !Collections.disjoint(t, f);
    }

    private static boolean pathContains(List<Pair<Long, Long>> path, Long nId, Long eId) {
        boolean contains = false;
        for (Pair<Long, Long> p : path) {
            if (!((Long)p.getFirst()).equals(nId)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    static class LinkComparator
    implements Comparator<Link> {
        private static final String EDGEID = "edgeid";
        private static final String TO_USAGE = "toUsage";
        private static final String FROM_USAGE = "fromUsage";
        private static final String S_LINE = "sLine";
        private static final String FULL = "full";
        private static final String NAME = "name";
        private static final String CLASS = "@class";
        private static final String LINK = "link";
        boolean forward;
        private ImpactGraph graph;
        private OrientBaseGraph dbg;

        LinkComparator(OrientBaseGraph dbg, ImpactGraph graph, boolean forward) {
            this.graph = graph;
            this.forward = forward;
            this.dbg = dbg;
        }

        @Override
        public int compare(Link l1, Link l2) {
            String ln2;
            int ret = 0;
            String ln1 = (String)l1.info(LINK);
            ret = ln1.compareTo(ln2 = (String)l2.info(LINK));
            if (ret == 0) {
                VertexValue v1 = null;
                VertexValue v2 = null;
                if (this.forward) {
                    v1 = (VertexValue)this.graph.getNode(l1.to()).value();
                    v2 = (VertexValue)this.graph.getNode(l2.to()).value();
                } else {
                    v1 = (VertexValue)this.graph.getNode(l1.from()).value();
                    v2 = (VertexValue)this.graph.getNode(l2.from()).value();
                }
                ret = v1.toString().compareTo(v2.toString());
                if (ret == 0) {
                    ret = ((String)v1.asVertex((OrientExtendedGraph)this.dbg).getProperty(CLASS)).compareTo((String)v2.asVertex((OrientExtendedGraph)this.dbg).getProperty(CLASS));
                }
            }
            if (ret == 0) {
                Object e1id = l1.info(EDGEID);
                Object e2id = l2.info(EDGEID);
                if (e1id != null && e2id != null) {
                    String n2;
                    String n1;
                    OrientEdge e1 = this.dbg.getEdge(e1id);
                    OrientEdge e2 = this.dbg.getEdge(e2id);
                    OrientVertex u1 = (OrientVertex)e1.getProperty(this.forward ? FROM_USAGE : TO_USAGE);
                    OrientVertex u2 = (OrientVertex)e2.getProperty(this.forward ? FROM_USAGE : TO_USAGE);
                    String c1 = (String)u1.getProperty(CLASS);
                    String c2 = (String)u2.getProperty(CLASS);
                    ret = c1.compareTo(c2);
                    if (ret == 0 && (ret = (n1 = (String)u1.getProperty(NAME)).compareTo(n2 = (String)u2.getProperty(NAME))) == 0) {
                        String path2;
                        Edge si1 = (Edge)u1.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
                        Edge si2 = (Edge)u2.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next();
                        String path1 = (String)si1.getVertex(Direction.IN).getProperty(FULL);
                        ret = path1.compareTo(path2 = (String)si2.getVertex(Direction.IN).getProperty(FULL));
                        if (ret == 0) {
                            Integer li1 = (Integer)si1.getProperty(S_LINE);
                            Integer li2 = (Integer)si2.getProperty(S_LINE);
                            ret = li1.compareTo(li2);
                        }
                    }
                } else {
                    ret = e1id == null ? -1 : (e2id == null ? 0 : 1);
                }
            }
            return (this.forward ? 1 : -1) * ret;
        }
    }
}

