/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.MGUtil;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.NodeExpander;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Impact {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Impact.class);
    public static final int PLI_PRG_TYPE = 2;
    public static final int COBOL_PRG_TYPE = 1;
    public static final String VARIABLE_SIZE = "size";
    public static final String VARIABLE_MEMOFFSET = "memOffset";
    public static final String VARIABLE_TYPE = "type";
    public static final String IMPACTED_SIZE = "impactedSize";
    public static final String IMPACTED_OFFSET = "impactedOffset";
    public static final String PGM_CONTEXT_RID = "pgmContextRid";
    public static final String PROXY_FOR = "ProxyFor";
    public static final String IN_CONTEXT = "InContext";
    public static final String CONTEXT_OF = "ContextOf";
    public static final String EXECPGM = "ExecPGM";
    public static final String ACTUAL_PARAMETER = "ActualParameter";
    public static final String REDEFINES = "Redefines";
    public static final String CHILD_OF = "ChildOf";
    public static final String DATAFLOW = "DataFlow";
    public static final String HASV = "HasV";
    public static final String HASS = "HasS";
    public static final String USES = "Uses";
    public static final String USES_VAR = "UsesVar";
    public static final String USESDD = "UsesDD";
    public static final String USESAP = "UsesAP";
    public static final String STEPS = "Steps";
    public static final String MAPPED_TO = "MappedTo";
    public static final String FORMAL_PARAMDEF = "formalParamDef";
    public static final String PARAMETER_OF = "ParameterOf";
    public static final String AP_DEFINEDBY = "APDefinedBy";
    public static final String SOURCE_INFO = "SourceInfo";
    public static final String FILE_OF = "FileOf";
    public static final String VERTEX_VARIABLE = "Variable";
    public static final String VERTEX_PROGRAM = "Program";
    public static final String VERTEX_PROGRAM_PROXY = "ProgramProxy";
    public static final String VERTEX_JOB = "JCLJob";
    public static final String VERTEX_INVOKED_JOB = "InvokedJob";
    public static final String VERTEX_SQL_TABLE_PROXY = "SQLTableProxy";
    public static final String VERTEX_SQL_FIELD_PROXY = "SQLFieldProxy";
    public static final String VERTEX_ADABAS_FILE_PROXY = "AdabasFileProxy";
    public static final String VERTEX_DDNAME_PROXY = "DDNameProxy";
    public static final String VERTEX_DAL_PROXY = "DALProxy";
    public static final String VERTEX_DBI_PROXY = "DBIProxy";
    public static final String VERTEX_IDMS_SET_PROXY = "IDMSSetProxy";
    public static final String VERTEX_IDMS_RECORD_PROXY = "IDMSRecordProxy";
    public static final String VERTEX_DSNAME = "DSName";
    public static final String VERTEX_DDCard = "DDCard";
    public static final String VERTEX_MQQUEUE_PROXY = "MQQueueProxy";
    public static final String VERTEX_MQManager_PROXY = "MQManagerProxy";
    public static final String VERTEX_TRANSACTION_PROXY = "TranProxy";
    public static final String VERTEX_BMS_PROXY = "BMSProxy";
    public static final String VERTEX_IMSMOD_PROXY = "IMSModProxy";
    public static final String VERTEX_IMS_SEGMENT_PROXY = "IMSSegmentProxy";
    public static final String VERTEX_EXP_PARAM = "expParam";
    public static final String VERTEX_VAR_PARAM = "varParam";
    public static final String SQL_TABLE_FORCE_EXPAND = "forceTableExpand";
    public static final String SQL_TABLE_NAME = "sql.tablename";
    public static final String RESOURCE_USAGE_FROM_DATA_FLOW = "resUsageInfoFromDataFlow";
    public static final String VERTEX_NATURAL_MAP_PROXY = "NaturalMapProxy";
    public static final String VERTEX_ADS_MAP_PROXY = "ADSMapProxy";
    public static final String VERTEX_TERM_OR_TRAN = "IMSMQProxy";
    public static final String VERTEX_IMS_TERM = "IMSTerminalProxy";
    public static final String PROGRAM_NAME = "programName";
    public static final String FIRST_PARENT_NAME = "variable first parent";
    public static final String RESOURCE_TYPE_DATASET = "dataset";
    public static final String RESOURCE_TYPE_DALFILE = "dalFile";
    public static final String RESOURCE_TYPE_SCREEN = "screen";
    public static final String RESOURCE_TYPE_VARIABLE = "variable";
    public static final String RESOURCE_TYPE_TABLE = "sqlTable";
    public static final String RESOURCE_TYPE_FIELD_TABLE = "sqlField";
    public static final String RESOURCE_TYPE_FILE = "file";
    public static final String RESOURCE_TYPE_COBOLPROGRAM = "cobolprogram";
    public static final String RESOURCE_TYPE_INCLUDE = "include";
    public static final String META_DIRECTION_FORWARD = "direction.forward";
    public static final String META_START_DATE_IMPACT = "startImpactDate";
    public static final String META_MAX_LEVEL = "max.level";
    public static final String META_RESOURCE_TYPE = "resourceType";
    public static final String META_RESOURCES_NR = "resources.nr";
    public static final String META_RESOURCE_PREFIX = "resource.";
    public static final String META_FILE = "metadata.properties";
    public static final String IS_NOT_EXPANDED_NODE_ATTRIBUTE = "node is not expanded in callgraph";
    public static final String MUST_SEARCH_ANCESTOR = "mustSearchAncestor";
    public static final String JOB_STEP_FOR_DS = "job/step";
    private OrientExtendedGraph dbg;
    private Writer writer;

    public Impact(OrientExtendedGraph g, Writer w) {
        this.dbg = g;
        this.writer = w;
    }

    public boolean doImpact(ImpactGraph ig, NodeExpander expander, boolean forward, int maxLevel, String resType, List<String> resources, String program, List<Integer> varIds, Map<String, String> resRids, boolean computePrgAndDSLvl, File location, HashMap<String, List<?>> excludedRes, Properties metadata, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        List<VertexValue> startValues = this.getStartValues(expander, forward, resType, resources, program, varIds, resRids);
        Set<String> excludedIds = null;
        if (excludedRes != null) {
            excludedIds = this.getExcludedIds(excludedRes);
        }
        boolean ignoreCancel = MGUtil.build(ig, startValues, excludedIds, maxLevel, expander, computePrgAndDSLvl, (IProgressMonitor)monitor.newChild(100));
        if (location != null && metadata == null) {
            Properties meta = this.getMetadata();
            meta.setProperty(META_DIRECTION_FORWARD, String.valueOf(forward));
            meta.setProperty(META_MAX_LEVEL, String.valueOf(maxLevel));
            meta.setProperty(META_RESOURCE_TYPE, resType);
            meta.setProperty(META_RESOURCES_NR, String.valueOf(resources.size()));
            meta.setProperty(META_START_DATE_IMPACT, Calendar.getInstance().getTime().toString());
            int i = 0;
            while (i < resources.size()) {
                meta.setProperty(META_RESOURCE_PREFIX + i, resources.get(i));
                ++i;
            }
            try {
                meta.store(new FileOutputStream(new File(location.getParent(), META_FILE)), "");
            }
            catch (Exception e) {
                L.error("cannot write model metadata {}", (Throwable)e);
            }
        }
        return ignoreCancel;
    }

    private String header(Node n) {
        StringBuilder sb = new StringBuilder();
        Value vv = n.value();
        if (vv instanceof VertexValue) {
            OrientVertex v = ((VertexValue)vv).asVertex(this.dbg);
            String type = (String)v.getProperty("@class");
            sb.append(vv);
            if (type.equals(VERTEX_ADABAS_FILE_PROXY)) {
                sb.append(":");
                Vertex dbVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{FILE_OF}).iterator().next();
                String dbName = (String)dbVertex.getProperty("name");
                sb.append(dbName);
                sb.append("(").append(type).append(")");
            } else if (!type.equals(VERTEX_VARIABLE)) {
                sb.append("(").append(type).append(")");
            }
        } else {
            sb.append(vv);
        }
        return sb.toString();
    }

    private List<VertexValue> getStartValues(NodeExpander expander, boolean forward, String resourceType, List<String> resources, String program, List<Integer> varIds, Map<String, String> resRids) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (RESOURCE_TYPE_VARIABLE.equals(resourceType)) {
            if (resources == null) {
                throw new IllegalArgumentException("config file needs impact.program, impact.resource.name keys when impact.resource.type=variable");
            }
            if (program == null && varIds == null) {
                L.debug("search variable for all programs");
            }
            if (varIds != null) {
                ret.addAll(this.getVariable(expander, varIds));
            } else {
                for (String resource : resources) {
                    ret.addAll(this.getVariable(expander, resource, program));
                }
            }
        } else {
            for (String resource : resources) {
                if (RESOURCE_TYPE_TABLE.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=sqlTable");
                    }
                    ret.addAll(this.getSQLTable(resource));
                    continue;
                }
                if (RESOURCE_TYPE_FIELD_TABLE.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=sqlField");
                    }
                    String[] vals = resource.split(":");
                    String table = null;
                    String field = null;
                    if (vals.length >= 2) {
                        table = vals[0].trim().isEmpty() ? null : vals[0].trim();
                        String string = field = vals[1].trim().isEmpty() ? null : vals[1].trim();
                    }
                    if (table == null || field == null) {
                        throw new IllegalArgumentException("sql field must be specified as: <tableName>:<fieldName>");
                    }
                    ret.addAll(this.getSQLFieldTable(table, field));
                    continue;
                }
                if (RESOURCE_TYPE_FILE.equals(resourceType)) {
                    if (program == null || resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.program, impact.resource.name keys when impact.resource.type=file");
                    }
                    ret.addAll(this.getFile(program, resource));
                    continue;
                }
                if (RESOURCE_TYPE_DATASET.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=dataset");
                    }
                    ret.addAll(this.getDSInJob(forward, VERTEX_DSNAME, "dsid", this.makedsid(resource)));
                    continue;
                }
                if (RESOURCE_TYPE_DALFILE.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=dal");
                    }
                    String dalrid = resRids == null ? null : resRids.get(resource);
                    ret.addAll(this.getDALFiles(resource, VERTEX_DAL_PROXY, dalrid));
                    continue;
                }
                if (RESOURCE_TYPE_SCREEN.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=bmsproxy");
                    }
                    String bmsProxyRid = resRids == null ? null : resRids.get(resource);
                    ret.addAll(this.getScreens(resource, VERTEX_DAL_PROXY, bmsProxyRid));
                    continue;
                }
                if (RESOURCE_TYPE_COBOLPROGRAM.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=cobolprogram");
                    }
                    ret.addAll(this.getResource(VERTEX_PROGRAM, "sid", resource));
                    continue;
                }
                if (RESOURCE_TYPE_INCLUDE.equals(resourceType)) {
                    if (resource == null || resource.isEmpty()) {
                        throw new IllegalArgumentException("config file needs impact.resource.name keys when impact.resource.type=include");
                    }
                    ret.addAll(this.getResource("Path", null, resource));
                    continue;
                }
                throw new IllegalArgumentException("unhandled resource type: " + resourceType);
            }
        }
        return ret;
    }

    private String makedsid(String resource) {
        if (resource.contains("(") && resource.endsWith(")")) {
            resource = resource.replace("(", "|");
            resource = resource.replace(")", "");
        }
        return resource;
    }

    private List<VertexValue> getResource(String proxyType, String property, String name) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (property == null) {
            property = "name";
        }
        String query = "select @rid as prid from AD_FROM where AD_PROPERTY = ?".replace("AD_FROM", proxyType).replace("AD_PROPERTY", property);
        Iterable ible = this.runQuery(query, name);
        for (OrientVertex vertex : ible) {
            OrientVertex v = (OrientVertex)vertex.getProperty("prid");
            VertexValue vv = new VertexValue(v);
            ret.add(vv);
        }
        return ret;
    }

    private List<VertexValue> getDALFiles(String resource, String proxyType, String resourceRID) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (resourceRID != null) {
            OrientVertex dsV = (OrientVertex)this.dbg.getVertex((Object)resourceRID);
            VertexValue vv = new VertexValue(dsV);
            ret.add(vv);
        } else {
            String dalQuery = "select @RID.asString() as dalrid from AD_FROM where name = ?".replace("AD_FROM", proxyType);
            Iterable ible = this.runQuery(dalQuery, resource);
            for (Vertex v : ible) {
                String dalRid = (String)v.getProperty("dalrid");
                OrientVertex dalV = (OrientVertex)this.dbg.getVertex((Object)dalRid);
                VertexValue vv = new VertexValue(dalV);
                ret.add(vv);
            }
        }
        return ret;
    }

    private List<VertexValue> getScreens(String resource, String proxyType, String resourceRID) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (resourceRID != null) {
            OrientVertex dsV = (OrientVertex)this.dbg.getVertex((Object)resourceRID);
            VertexValue vv = new VertexValue(dsV);
            ret.add(vv);
        }
        return ret;
    }

    private List<VertexValue> getDSInJob(boolean forward, String proxyType, String property, String name) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (property == null) {
            property = "name";
        }
        String q = String.format("select @rid.asString() as drid, $a.in('Steps').sid[0] as jsid, $a.@rid[0].asString() as steprid, $a.ordinalNumInJob[0] as stepPos from AD_FROM\n let $a = in('MappedTo').in('UsesDD') \n where AD_PROPERTY = '%s' order by stepPos AD_ORDER", name);
        Iterable ible = this.runQuery(q.replace("AD_FROM", proxyType).replace("AD_PROPERTY", property).replace("AD_ORDER", forward ? "ASC" : "DESC"), new String[0]);
        for (Vertex v : ible) {
            String ridStr = (String)v.getProperty("drid");
            OrientVertex dsV = (OrientVertex)this.dbg.getVertex((Object)ridStr);
            VertexValue vv = new VertexValue(dsV);
            vv.addContext("stepVertexId", v.getProperty("steprid"));
            ret.add(vv);
        }
        return ret;
    }

    private List<VertexValue> getSQLTable(String name) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        String query = "select @rid.asString() as trid from SQLTableProxy where name = ?";
        Iterable ible = this.runQuery(query, name);
        for (Vertex v : ible) {
            String trid = (String)v.getProperty("trid");
            OrientVertex tv = (OrientVertex)this.dbg.getVertex((Object)trid);
            VertexValue vv = new VertexValue(tv);
            vv.addContext(SQL_TABLE_FORCE_EXPAND, true);
            ret.add(vv);
        }
        return ret;
    }

    private List<VertexValue> getProgramOrInclude(String prgOrIncludeRID) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        OrientVertex prgOrIncV = (OrientVertex)this.dbg.getVertex((Object)prgOrIncludeRID);
        VertexValue vv = new VertexValue(prgOrIncV);
        ret.add(vv);
        return ret;
    }

    private List<VertexValue> getSQLFieldTable(String tableName, String fieldName) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        String query = String.format("select in('FieldOf')[name='%s'].@rid.asString() as ftrid  from SQLTableProxy where name = '%s'", fieldName, tableName);
        Iterable ible = this.runQuery(query, new String[0]);
        for (Vertex v : ible) {
            String ftrid = (String)v.getProperty("ftrid");
            OrientVertex ftv = (OrientVertex)this.dbg.getVertex((Object)ftrid);
            VertexValue vv = new VertexValue(ftv);
            vv.addContext(SQL_TABLE_NAME, tableName);
            ret.add(vv);
        }
        return ret;
    }

    private List<VertexValue> getFile(String program, String file) {
        String query2 = String.format("select set(out('HasS').out('UsesFile')[name = '%s'].out('ResourceLink').@rid).asString() as proxies from Program where name = ?", file);
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        Iterable ible = this.runQuery(query2, program);
        for (OrientVertex v : ible) {
            String[] pRids;
            String proxies = (String)v.getProperty("proxies");
            if (proxies.length() <= 2) continue;
            proxies = proxies.substring(1, proxies.length() - 1);
            String[] stringArray = pRids = proxies.split(", ");
            int n = pRids.length;
            int n2 = 0;
            while (n2 < n) {
                String proxyRid = stringArray[n2];
                OrientVertex proxy = (OrientVertex)this.dbg.getVertex((Object)proxyRid);
                VertexValue vv = new VertexValue(proxy);
                vv.addContext(RESOURCE_USAGE_FROM_DATA_FLOW, v);
                ret.add(vv);
                ++n2;
            }
        }
        return ret;
    }

    private Properties getMetadata() {
        Properties p = new Properties();
        String query = "select prjName, prjVersion, prjAvatar from Metadata";
        Iterable ible = this.runQuery(query, null);
        Iterator iterator = ible.iterator();
        if (iterator.hasNext()) {
            OrientVertex v = (OrientVertex)iterator.next();
            p.put("prjName", v.getProperty("prjName"));
            p.put("prjVersion", v.getProperty("prjVersion").toString());
            p.put("prjAvatar", v.getProperty("prjAvatar"));
        }
        return p;
    }

    private List<VertexValue> getVariable(NodeExpander expander, String var, String program) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        if (program == null) {
            String query1 = String.format("select  $p.name as pname, $p.type as ptype, $p.asString() as prid, @rid.asString() as vrid from Variable \nlet $p = in('HasV').@rid[0] \n where name = '%s'", var);
            Iterable ible = this.runQuery(query1, new String[0]);
            for (OrientVertex v : ible) {
                String prgRid = (String)v.getProperty("prid");
                program = (String)v.getProperty("pname");
                Integer pType = (Integer)v.getProperty("ptype");
                OrientVertex varV = (OrientVertex)this.dbg.getVertex(v.getProperty("vrid"));
                VertexValue vv = Impact.makeVarValue(expander, this.dbg, program, pType, varV, prgRid);
                ret.add(vv);
            }
        } else {
            String query = String.format("select @rid.asString() as prid, type as ptype, out('HasV')[name = '%s'].@rid.asString() as vrid from Program where name = ?", var);
            Iterable ible = this.runQuery(query, program);
            for (OrientVertex v : ible) {
                OrientVertex varV = (OrientVertex)this.dbg.getVertex(v.getProperty("vrid"));
                String prid = (String)v.getProperty("prid");
                Integer ptype = (Integer)v.getProperty("ptype");
                VertexValue vv = Impact.makeVarValue(expander, this.dbg, program, ptype, varV, prid);
                if ((Integer)varV.getProperty("ancestor") != 0) {
                    vv.addContext(MUST_SEARCH_ANCESTOR, Boolean.TRUE);
                }
                if (expander.isParameter(varV)) {
                    vv.addContext("impactedInSubprogram", Boolean.TRUE);
                }
                ret.add(vv);
            }
        }
        return ret;
    }

    private List<VertexValue> getVariable(NodeExpander expander, List<Integer> varIds) {
        LinkedList<VertexValue> ret = new LinkedList<VertexValue>();
        L.debug("start impact using variable ids");
        String query2 = String.format("select $p.name as pname, $p.type as ptype, $p.asString() as prid, @rid.asString() as vrid from Variable \nlet $p = in('HasV').@rid[0] \n where sid in %s", varIds);
        Iterable ible2 = this.runQuery(query2, new String[0]);
        for (OrientVertex v : ible2) {
            String prgRid = (String)v.getProperty("prid");
            String program = (String)v.getProperty("pname");
            Integer pType = (Integer)v.getProperty("ptype");
            OrientVertex varV = (OrientVertex)this.dbg.getVertex(v.getProperty("vrid"));
            VertexValue vv = Impact.makeVarValue(expander, this.dbg, program, pType, varV, prgRid);
            ret.add(vv);
        }
        return ret;
    }

    public static VertexValue makeVarValue(NodeExpander expander, OrientExtendedGraph odbg, String program, Integer pType, OrientVertex varV, String prgRid) {
        VertexValue vv = new VertexValue(varV);
        vv.addContext(IMPACTED_OFFSET, 0);
        vv.addContext(IMPACTED_SIZE, varV.getProperty(VARIABLE_SIZE));
        vv.addContext(VARIABLE_MEMOFFSET, varV.getProperty(VARIABLE_MEMOFFSET));
        vv.addContext(PROGRAM_NAME, program);
        vv.addContext("prg type id", pType);
        vv.addContext("prog_vertex_id", prgRid);
        vv.addContext("var_sid", varV.getProperty("sid"));
        if ((Integer)varV.getProperty("ancestor") != 0) {
            vv.addContext(MUST_SEARCH_ANCESTOR, Boolean.TRUE);
        }
        vv.addContext(FIRST_PARENT_NAME, Impact.getFirstParentName(odbg, (Vertex)varV));
        if (expander.isParameter(varV)) {
            vv.addContext("impactedInSubprogram", Boolean.TRUE);
        }
        return vv;
    }

    public static String getFirstParentName(OrientExtendedGraph odbg, Vertex varV) {
        Integer ancestorId = (Integer)varV.getProperty("ancestor");
        if (ancestorId > 0) {
            String query = "select name from ( traverse out('ChildOf') from AD_FROM ) where ancestor = 0";
            Iterable ret = (Iterable)odbg.command((OCommandRequest)new OCommandSQL(query.replace("AD_FROM", varV.getId().toString()))).execute(new Object[0]);
            Iterator resIt = ret.iterator();
            if (resIt.hasNext()) {
                return (String)((OrientElement)resIt.next()).getProperty("name");
            }
            L.warn("not found ancestor having id " + ancestorId);
        }
        return null;
    }

    private final void write(String str) {
        try {
            this.writer.write(String.valueOf(str) + "\n");
        }
        catch (IOException ex) {
            L.error("while writting data: ", (Throwable)ex);
        }
    }

    public <T> Iterable<T> runQuery(String query, String ... params) {
        return (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute((Object[])params);
    }

    private Set<String> getExcludedIds(HashMap<String, List<?>> excludedRes) {
        Iterable ible;
        HashSet<String> excludedIds = new HashSet<String>();
        if (excludedRes.get(RESOURCE_TYPE_DATASET) != null) {
            for (Map dataset : (ArrayList)excludedRes.get(RESOURCE_TYPE_DATASET)) {
                String datasetQuery = String.format("select @RID.asString() as drid from DSName where dsid = '%s'", dataset.get(RESOURCE_TYPE_DATASET));
                ible = this.runQuery(datasetQuery, new String[0]);
                for (OrientVertex v : ible) {
                    excludedIds.add((String)v.getProperty("drid"));
                }
            }
        }
        if (excludedRes.get("dalfile") != null) {
            for (Map dalfile : (ArrayList)excludedRes.get("dalfile")) {
                String dalfileQuery = String.format("select @RID.asString() as dalrid from DALProxy where name = '%s'", dalfile.get("dalfile"));
                ible = this.runQuery(dalfileQuery, new String[0]);
                for (OrientVertex v : ible) {
                    excludedIds.add((String)v.getProperty("dalrid"));
                }
            }
        }
        if (excludedRes.get("sqltable") != null) {
            for (Map sqltable : (ArrayList)excludedRes.get("sqltable")) {
                String sqltableQuery = String.format("select @RID.asString() as trid from SQLTableProxy where name = '%s'", sqltable.get("sqltable"));
                ible = this.runQuery(sqltableQuery, new String[0]);
                for (OrientVertex v : ible) {
                    excludedIds.add((String)v.getProperty("trid"));
                }
            }
        }
        if (excludedRes.get("sqlfield") != null) {
            for (Map sqlfield : (ArrayList)excludedRes.get("sqlfield")) {
                String sqlfieldQuery = String.format("select @RID.asString() as frid from SQLFieldProxy where name ='%s' and tableName ='%s'", sqlfield.get("sqlfield"), sqlfield.get("sqltable"));
                ible = this.runQuery(sqlfieldQuery, new String[0]);
                for (OrientVertex v : ible) {
                    excludedIds.add((String)v.getProperty("frid"));
                }
            }
        }
        if (excludedRes.get(RESOURCE_TYPE_VARIABLE) != null) {
            for (Map variable : (ArrayList)excludedRes.get(RESOURCE_TYPE_VARIABLE)) {
                String variableQuery;
                Iterable ible2 = null;
                if (!((String)variable.get("program")).isEmpty()) {
                    if (!((String)variable.get("forefather")).isEmpty()) {
                        variableQuery = String.format("select @rid.asString() as rid from ( traverse out('ChildOf')  from (select @rid from Variable where in('HasV')[0].name='%s' and name='%s' )) where name='%s'", variable.get("program"), variable.get(RESOURCE_TYPE_VARIABLE), variable.get("forefather"));
                        ible2 = this.runQuery(variableQuery, new String[0]);
                        for (OrientVertex vertex : ible2) {
                            excludedIds.add((String)vertex.getProperty("rid"));
                        }
                        continue;
                    }
                    variableQuery = "select out('HasV')[name='" + (String)variable.get(RESOURCE_TYPE_VARIABLE) + "'";
                    variableQuery = String.valueOf(variableQuery) + "].@RID.asString() as prid from Program where name='" + (String)variable.get("program") + "'";
                    ible2 = this.runQuery(variableQuery, new String[0]);
                    for (OrientVertex vertex : ible2) {
                        String record = (String)vertex.getProperty("prid");
                        if (record == null) continue;
                        excludedIds.add(record);
                    }
                    continue;
                }
                if (!((String)variable.get("forefather")).isEmpty()) {
                    variableQuery = String.format("select  @rid.asString() as vrid from ( traverse out('ChildOf')  from (select @rid from Variable where name='%s' ))  where name='%s'", variable.get(RESOURCE_TYPE_VARIABLE), variable.get("forefather"));
                    ible2 = this.runQuery(variableQuery, new String[0]);
                    for (OrientVertex vertex : ible2) {
                        excludedIds.add((String)vertex.getProperty("vrid"));
                    }
                    continue;
                }
                variableQuery = "select @RID.asString() as vrid from Variable where name=?";
                ible2 = this.runQuery(variableQuery, (String)variable.get(RESOURCE_TYPE_VARIABLE));
                for (OrientVertex vertex : ible2) {
                    excludedIds.add((String)vertex.getProperty("vrid"));
                }
            }
        }
        if (excludedRes.get("bmsproxy") != null) {
            for (Map bmsproxy : (ArrayList)excludedRes.get("bmsproxy")) {
                String bmsproxyQuery = String.format("select @RID.asString() as trid from BMSProxy where name = '%s'", bmsproxy.get("bmsproxy"));
                if (bmsproxy.get("mapset") != null) {
                    bmsproxyQuery = String.valueOf(bmsproxyQuery) + String.format(" and mapSet = '%s'", bmsproxy.get("mapset"));
                }
                ible = this.runQuery(bmsproxyQuery, new String[0]);
                for (OrientVertex v : ible) {
                    excludedIds.add((String)v.getProperty("trid"));
                }
            }
        }
        return excludedIds;
    }
}

