/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.ProgramValue;
import com.ez.internal.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class HigherLevelsPathHandler
implements PathHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ImpactGraph ig;
    private int paths = 0;

    public HigherLevelsPathHandler(ImpactGraph ig) {
        this.ig = ig;
    }

    public int pathCount() {
        return this.paths;
    }

    @Override
    public void handlePath(List<Pair<Long, Long>> nodes, Pair<Long, Long> entryCycleNode) {
        Long cycleNodeId;
        Long l = cycleNodeId = entryCycleNode != null ? (Long)entryCycleNode.getFirst() : null;
        if (cycleNodeId != null) {
            return;
        }
        ++this.paths;
        if (this.paths % 1000 == 0) {
            System.out.println(this.paths);
        }
        this.createDatasourceLevel(this.ig, nodes);
        this.createProgramLevel(this.ig, nodes);
    }

    private void createProgramLevel(ImpactGraph ig, List<Pair<Long, Long>> nodes) {
        String prg = null;
        Integer prgTypeId = null;
        Long prevId = (Long)nodes.get(0).getFirst();
        ArrayList<Long> varids = new ArrayList<Long>();
        Node firstProgramInPath = null;
        for (Pair<Long, Long> t : nodes) {
            Node pNode;
            ProgramValue pv;
            Node n = ig.getNode((Long)t.getFirst());
            String p = (String)n.value().getContext("programName");
            Integer pTypeId = (Integer)n.value().getContext("prg type id");
            if (p == null) {
                if (prg == null) continue;
                pv = new ProgramValue(prg, prgTypeId, null);
                pv.addContext("varIds", varids);
                pNode = ig.addNode(pv, false);
                if (firstProgramInPath == null) {
                    firstProgramInPath = pNode;
                }
                ig.addEdge(2, prevId, pNode.getId());
                prevId = pNode.getId();
                ig.addEdge(2, prevId, n.getId());
                continue;
            }
            if (!p.equals(prg)) {
                if (prg == null) {
                    prg = p;
                    prgTypeId = pTypeId;
                    varids.add(n.getId());
                    continue;
                }
                pv = new ProgramValue(prg, prgTypeId, null);
                pv.addContext("varIds", varids);
                pNode = ig.addNode(pv, false);
                if (firstProgramInPath == null) {
                    firstProgramInPath = pNode;
                }
                ig.addEdge(2, prevId, pNode.getId());
                prevId = pNode.getId();
                varids = new ArrayList();
                prg = p;
                prgTypeId = pTypeId;
                varids.add(n.getId());
                continue;
            }
            varids.add(n.getId());
        }
        long idStart = (Long)nodes.get(0).getFirst();
        long idEnd = (Long)nodes.get(nodes.size() - 1).getFirst();
        if (firstProgramInPath != null) {
            ig.cacheValue(idStart, idEnd, firstProgramInPath.getId());
        }
    }

    private void createDatasourceLevel(ImpactGraph ig, List<Pair<Long, Long>> nodes) {
        Long firstId = (Long)nodes.get(0).getFirst();
        Node first = ig.getNode(firstId);
        Long lastId = (Long)nodes.get(nodes.size() - 1).getFirst();
        List<Long> edges = first.out(4);
        boolean found = false;
        for (Long eId : edges) {
            Link e = ig.getLink(eId);
            if (e == null || !lastId.equals(e.to())) continue;
            found = true;
            break;
        }
        if (!found) {
            ig.addEdge(4, firstId, lastId);
        }
    }

    @Override
    public void addPathInfo(Object o) {
    }
}

