/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.AbstractExportManager;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportImpactModel
extends AbstractExportManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExportImpactModel.class);
    JTextField fileText = null;

    public String getPropertiesKey() {
        return "exportImpactProperties";
    }

    public String getActionKey() {
        return "exp_impact";
    }

    public String[] getGroupSelectorDetails() {
        return new String[]{"Export Impact Model as file", this.getActionKey(), "M"};
    }

    public void createPanel(Font font, int width) {
        this.panel = this.createImpactPanel(font, width);
    }

    private JPanel createImpactPanel(Font font, int width) {
        JPanel localJPanelCSV = new JPanel();
        this.createBorder(localJPanelCSV, "", 0, 6, 5, 5, font);
        localJPanelCSV.setLayout(new BoxLayout(localJPanelCSV, 1));
        JLabel localJLabel2 = this.createLabel("File_Name:", font);
        this.fileText = new JTextField();
        String path = String.valueOf(System.getProperty("user.home")) + File.separator + "Untitled.im";
        this.fileText.setText(path);
        this.fileText.setPreferredSize(new Dimension(width, (int)this.fileText.getPreferredSize().getHeight()));
        this.fileText.setMaximumSize(this.fileText.getPreferredSize());
        localJLabel2.setDisplayedMnemonic('f');
        localJLabel2.setLabelFor(this.fileText);
        JButton localJButton = this.createButton("Browse...", "browse", 'b');
        localJButton.setFont(font);
        localJButton.setMaximumSize(new Dimension(40, 35));
        JPanel localJPanel6 = new JPanel();
        localJPanel6.setLayout(new BoxLayout(localJPanel6, 0));
        localJLabel2.setAlignmentY(0.5f);
        this.fileText.setAlignmentY(0.5f);
        localJButton.setAlignmentY(0.5f);
        localJPanel6.add(localJLabel2);
        localJPanel6.add(Box.createRigidArea(new Dimension(9, 0)));
        localJPanel6.add(this.fileText);
        localJPanel6.add(Box.createRigidArea(new Dimension(9, 0)));
        localJPanel6.add(Box.createHorizontalGlue());
        localJPanel6.add(localJButton);
        localJPanel6.setAlignmentX(0.0f);
        localJPanelCSV.add(Box.createRigidArea(new Dimension(0, 5)));
        localJPanelCSV.add(localJPanel6);
        return localJPanelCSV;
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public void setFileName(String fName) {
        this.fileText.setText(fName);
    }

    public FileFilter getFileFilter() {
        return new FileNameExtensionFilter("Impact model files", "im");
    }

    public boolean doExport(AnalysisGraphManager graphMngr) {
        boolean ok = true;
        try {
            String zipName = this.getFileName();
            File gphModelFile = (File)this.data.get("impactGraphModelFile");
            File metadataFile = new File(String.valueOf(gphModelFile.getAbsolutePath()) + File.separator + "metadata.properties");
            if (metadataFile.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(metadataFile));
                if (zipName.endsWith(".im")) {
                    zipName = zipName.substring(0, zipName.length() - 3);
                    zipName = String.valueOf(zipName) + "-" + prop.getProperty("startImpactDate") + ".im";
                } else {
                    zipName = String.valueOf(zipName) + "-" + prop.getProperty("startImpactDate") + ".im";
                }
            } else {
                L.error("no metadata.properties file for impact");
            }
            if (gphModelFile != null && gphModelFile.exists()) {
                File tempZip = com.ez.workspace.utils.FileUtils.zipIt((File)gphModelFile);
                File dstZip = new File(zipName);
                FileUtils.copyFile((File)tempZip, (File)dstZip);
                String resImpactFile = String.valueOf(gphModelFile.getAbsolutePath()) + File.separator + "impact-results.imx";
                FileUtils.copyFile((File)new File(resImpactFile), (File)new File(dstZip.getParentFile() + File.separator + zipName + "x"));
            } else {
                L.error("could not export this graph. folder instance not found");
                ok = false;
            }
        }
        catch (Exception e) {
            L.error("could not export impact model", (Throwable)e);
            ok = false;
        }
        return ok;
    }

    public boolean isOpenFileOnExportOk() {
        return false;
    }
}

