/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.Impact;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.NodeExpander;
import com.ez.graphs.viewer.odb.impact.model.NonVertexValue;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.impact.model.VertexValue;
import com.ez.graphs.viewer.odb.utils.DatasetUtils;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Triplet;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expander
implements NodeExpander {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Expander.class);
    protected boolean forward;
    private static final String DDCARDS_RESTRICTION = "ddcard_restriction";
    private static final String STEP_RESTRICTION = "step_restriction";
    private static final String PCALLFW = "pcallfw";
    public static final String REDEF_EDGE_DIRECTION = "redefDir";
    public static final String REDEF_EDGE_ID = "redefEdge";
    protected static final String REDEFINE_PROCESSED = "Redefine_processed";
    public static final String REDEFINE_REVERSE = "Reverse Redefine";
    public static final String REDEFINE_DIRECT = "Direct Redefine";
    private static final String FORMAL_PARAM_RID = "formalParamRid";
    public static final String IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL = "isVarOrExprParamFromInternalCall";
    private static final String IS_INTERNAL_VAR_PARAM_FROM_RETURN = "isVarParamFromInternalReturn";
    public static final String INTERNAL_VAR_PARAMS = "contextVarParams";
    private static final String CONTEXT_CB_PARAMS = "contextCBParam";
    private static final String HAS_CONTEXT_CB_PARAMS = "contextCBParam on edge";
    private static final String INTERNAL_CALL_RESTRICTIONS = "internalCallRestrictions";
    private static final String KEY_SEPARATOR = "|";
    private OrientExtendedGraph dbg;
    private static Set<String> numericVarTypes = new HashSet<String>(){
        {
            this.add("1");
            this.add("2");
            this.add("3");
            this.add("4");
            this.add("5");
        }
    };
    private Map<String, Map<Long, Map<String, Set<String>>>> varmap = new HashMap<String, Map<Long, Map<String, Set<String>>>>();
    public static final String MARKER_RID = "MARKER_RID";
    private static final String RESTRICTIONS_MARKER = "RESTRICTIONS_MARKER";
    private static final String CALL_STMT_QUERY = "select @rid.asString() as stmt from (traverse in() from ? while @class <> 'Program') where @class = 'Statement'";
    private static final String ANCESTOR_SEARCH_QUERY = "select @rid.asString() as parentRid, type, size, memOffset, $prg.name as prgName, $prg.type as prgType, $prg.@rid.asString() as prgRid from \n(traverse out('ChildOf') from MARKER_RID ) \nlet $prg =  in('HasV')[0] \n where ancestor = 0";
    private static final String VAR_OR_EXP_FROM_RETURN = "select  @rid.asString() as cbRid, $stmt.@rid.asString() as stmtRet from MARKER_RID let $stmt = set(in('SinCB')[typeId = 424]) ";
    private static final String GET_RETURN_STMT_QUERY = "select $a[0].@rid.asString() as returnRid from MARKER_RID let $a = list(in('DefinedBy').in('UsesVar')[typeId = 424])";
    private static final String Query_DS_TO_VAR_BACKWARD = "select  list(df.out.@rid).asString() as varRid,  \tlist(df.@rid).asString() as usageRid,\tlist(df.fromUsage.in('Uses')[0].type).asString() AS stmtType \nFROM (select inE('DataFlow') as df from MARKER_RID unwind df)\n where df.out.in('HasV')[0].type = 2 RESTRICTIONS_MARKER";
    private static final String Query_DS_TO_VAR_FORWARD = "select list(df.in.@rid).asString() as varRid, \tlist(df.@rid).asString() as usageRid,\tlist(df.fromUsage.in('Uses')[0].type).asString() AS stmtType \nFROM (select outE('DataFlow') as df from MARKER_RID unwind df)\n where df.in.in('HasV')[0].type = 2 RESTRICTIONS_MARKER";
    private static final String queryF = "select eap.out.out('APDefinedBy')[0].asString() as childRid, eap.in.out('ProxyFor')[0] as varrid, eap.out.asString() as stmtRids,\neap.out.in('UsesAP').out('UsesAP').out('APDefinedBy').asList().asString() as fromVars, eap.in.out('ParameterOf').in('ParameterOf').out('ProxyFor').asList().asString() as toVars,eap.out.in('UsesAP').out('UsesAP').paramPos.asString() as paramPos from (select $pu as eap from MARKER_RID let $pu = in('APDefinedBy').outE('ActualParameter')\n unwind eap limit -1\n) order by varrid limit -1";
    private static final String queryWithCallRestrictionF = "select eap.out.out('APDefinedBy')[0].asString() as childRid, eap.in.out('ProxyFor')[0] as varrid, eap.out.asString() as stmtRids,\neap.out.in('UsesAP').out('UsesAP').out('APDefinedBy').asList().asString() as fromVars, eap.in.out('ParameterOf').in('ParameterOf').out('ProxyFor').asList().asString() as toVars, eap.out.in('UsesAP').out('UsesAP').paramPos.asString() as paramPos from (select $pu as eap from MARKER_RID let $pu = in('APDefinedBy').outE('ActualParameter')\n unwind eap limit -1\n) where eap.in.out('ProxyFor').in('HasV')[0].@rid  not in RESTRICTIONS_MARKER\n order by varrid limit -1";
    protected static final String queryF_CB = "select eap.out('BCDefinedBy')[0].asString() as childRid,  eap.out('mapsFormalParam')[0] as varrid, eap.@rid.asString() as stmtRids, eap.in('UsesBCP').out('UsesBCP').out('BCDefinedBy').asList().asString() as fromVars, eap.in('UsesBCP').out('UsesBCP').out('mapsFormalParam').asList().asString() as toVars from (select $pu as eap from MARKER_RID let $pu = in('BCDefinedBy') unwind eap limit -1 ) order by varrid limit -1 ";
    protected static final String queryF_INTERNAL = "select childRid, $current.vp.@rid.asString() as varParam , vp.out('mapsFormalParam')[0] as formalPar, vp.in('hasVarParam')[0].asString() as ce, vp.in('hasVarParam')[0].out('calledBlock')[0].@rid.asString() as cb from (select $current.@rid.asString() as childRid, $vpNotIn as  vp from  MARKER_RID  let $vpNotIn = in('VPDefinedBy') \n where $vpNotIn.size() > 0 unwind vp limit -1) where  vp.outE('mapsFormalParam')[0].accessModifier <> 2";
    protected static final String queryF_INTERNAL2 = "select $current.@rid.asString() as childRid, in('VPDefinedBy').@rid.asString() as vp from MARKER_RID limit -1";
    private static final String queryFCallDF = "select @rid as childRid.asString(), $s.in.asString() as varrid , $s.@rid.asString() as stmtRids   from MARKER_RID \nlet $s =  outE('Dataflow') limit -1";
    private static final String queryFCallDFWithCallRestriction = "select @rid as childRid.asString(), $s.in.asString() as varrid , $s.@rid.asString() as stmtRids   from MARKER_RID \nlet $s =  outE('Dataflow') limit -1";
    private static final String queryB = "select childRid, \t\t\t\teap.out.out('APDefinedBy')[0] as varrid,\n\t\teap.out.asString() as stmtRids\nfrom (select   @rid.asString() as childRid, in('ProxyFor')[0].inE('ActualParameter') as eap from MARKER_RID\n where in('ProxyFor')[0] is not null  unwind eap limit -1 ) order by varrid limit -1";
    protected static final String queryB_CB = "select childRid, eap.out.out('BCDefinedBy')[0] as varrid, \t\teap.out.asString() as stmtRids \t\tfrom (select   @rid.asString() as childRid, inE('mapsFormalParam') as eap from MARKER_RID unwind eap limit -1 ) order by varrid limit -1";
    private static final String queryWithCallRestrictionB = "select childRid, \t\t\t\teap.out.out('APDefinedBy')[0] as varrid,\n\t\teap.out.asString() as stmtRids\nfrom (select   @rid.asString() as childRid, in('ProxyFor')[0].inE('ActualParameter') as eap from MARKER_RID\n where in('ProxyFor')[0] is not null and eap.out.in('UsesAP').in('HasS')[0].@rid  not in RESTRICTIONS_MARKER unwind eap limit -1 ) \n order by varrid limit -1";
    private static final String queryFDataFlow = "select fromRid.asString(), df.in.asString() as toRid, \ndf.@rid.asString() as stmtRid, fromRid.in('HasV')[0].asString() as prgRid \nfrom  (select @rid as fromRid, outE('DataFlow') as df from  MARKER_RID unwind df)  where df.toClass<>'SQLUsageInfo'";
    private static final String queryBDataFlow = "select fromRid.asString(), df.out.asString() as toRid, df.@rid.asString() as stmtRid, fromRid.in('HasV')[0].asString() as prgRid \nfrom  (select @rid as fromRid, inE('DataFlow') as df from  MARKER_RID unwind df)  where df.fromClass<>'SQLUsageInfo'";
    private static final String queryFromLeftVarToExpr = "select $a.@rid.asString() as ce from MARKER_RID let $a = set(in('DefinedBy')[bRead = 2].in('UsesVar')[typeId = 394].out('UsesExp').out('expPart')[@class = 'callExp'])\n where $a.size() > 0 ";
    private static final String queryAllReturnsFromCB = "select set(out('calledBlock')).in('SinCB')[typeId = 424] from ? ";
    private static final String query_VarParam_for_Subprgram = "select vp.@rid as outvp from (select in('mapsFormalParam') as vp from RESTRICTIONS_MARKER unwind vp limit -1)\n where vp.outE('mapsFormalParam')[0].accessModifier <> 1 ";
    private static final String query_VarParam_for_Subprgram_Context = "select vp.@rid as outvp from (select in('mapsFormalParam') as vp from RESTRICTIONS_MARKER unwind vp limit -1)\n where vp.outE('mapsFormalParam')[0].accessModifier <> 1  and vp not in MARKER_RID and vp.in('hasVarParam')[0] in (select in('hasVarParam', 'hasExpParam') from MARKER_RID)";
    private static final String query_VarParam_for_Subprgram_Restriction = "select vp.@rid as outvp from (select in('mapsFormalParam') as vp from RESTRICTIONS_MARKER unwind vp limit -1)\n where vp.outE('mapsFormalParam')[0].accessModifier <> 1  and vp in MARKER_RID";

    public Expander(OrientExtendedGraph dbg, boolean forward) {
        this.forward = forward;
        this.dbg = dbg;
    }

    @Override
    public List<Pair<? extends Value, Map<String, Object>>> expand(Node n) {
        LinkedList<Pair<? extends Value, Map<String, Object>>> ret = new LinkedList<Pair<? extends Value, Map<String, Object>>>();
        if (!(n.value() instanceof VertexValue)) {
            L.debug(n.value() + " is not a vertex and will not be expanded");
            return null;
        }
        n.value().addContext("ImpactGraph node id", n.getId());
        List<Pair<? extends Value, Map<String, Object>>> r = this.expandVar(this.forward, n.value());
        if (r != null) {
            ret.addAll(r);
        }
        if ((r = this.expandSQL(this.forward, n.value())) != null) {
            ret.addAll(r);
        }
        if ((r = this.expandFile(this.forward, n.value())) != null) {
            ret.addAll(r);
        }
        if ((r = this.expandDSName(this.forward, n.value())) != null) {
            ret.addAll(r);
        }
        if ((r = this.expandDAL(this.forward, n.value())) != null) {
            ret.addAll(r);
        }
        return ret;
    }

    private List<Pair<? extends Value, Map<String, Object>>> expandDAL(boolean forward, Value value) {
        if (!"DALProxy".equals(value.getVertexClass())) {
            return null;
        }
        LinkedList<Pair<? extends Value, Map<String, Object>>> values = new LinkedList<Pair<? extends Value, Map<String, Object>>>();
        String dsRid = value.id();
        this.addVariableFromDataSource(dsRid, value.getVertexClass(), forward, values, null);
        return values;
    }

    private List<Pair<? extends Value, Map<String, Object>>> expandSQL(boolean forward, Value value) {
        if (!"SQLTableProxy".equals(value.getVertexClass()) && !"SQLFieldProxy".equals(value.getVertexClass())) {
            return null;
        }
        VertexValue expand = (VertexValue)value;
        if ("SQLTableProxy".equals(value.getVertexClass())) {
            Boolean forceExpand = (Boolean)value.getContext("forceTableExpand");
            if (forceExpand == null) {
                forceExpand = false;
            }
            OrientVertex ov = expand.asVertex(this.dbg);
            if (!forceExpand.booleanValue() && ((Boolean)ov.getProperty("hasDef")).booleanValue()) {
                return null;
            }
        }
        LinkedList<Pair<? extends Value, Map<String, Object>>> values = new LinkedList<Pair<? extends Value, Map<String, Object>>>();
        String pgmContext = (String)expand.getContext("pgmContextRid");
        HashMap<String, Object> restrictionCtx = new HashMap<String, Object>();
        restrictionCtx.put("pgmContextRid", pgmContext);
        restrictionCtx.remove(STEP_RESTRICTION);
        restrictionCtx.remove(DDCARDS_RESTRICTION);
        String rid = value.id();
        this.addVariableFromDataSource(rid, value.getVertexClass(), forward, values, restrictionCtx);
        return values;
    }

    private List<Pair<? extends Value, Map<String, Object>>> expandDSName(boolean forward, Value value) {
        LinkedList<Pair<? extends Value, Map<String, Object>>> values;
        block6: {
            OrientVertex ov;
            HashSet<String> restriction;
            block5: {
                if (!"DSName".equals(value.getVertexClass())) {
                    return null;
                }
                values = new LinkedList<Pair<? extends Value, Map<String, Object>>>();
                restriction = (HashSet<String>)value.getContext(DDCARDS_RESTRICTION);
                ov = ((VertexValue)value).asVertex(this.dbg);
                if (restriction == null) break block5;
                String dsn1Name = (String)ov.getProperty("dsid");
                List<String> vToContinue = this.getDSNameToContinue(dsn1Name, restriction);
                for (String ovRid : vToContinue) {
                    Vertex ovc = this.dbg.getVertex((Object)ovRid);
                    Pair<String, Map<String, Object>> pair = this.processDDNameVertex(ovc, forward, values);
                    String ddNameProxyRid = (String)pair.getFirst();
                    if (ddNameProxyRid == null) continue;
                    Map additionalCtx = (Map)pair.getSecond();
                    this.addVariableFromDataSource(ddNameProxyRid, "DDNameProxy", forward, values, additionalCtx);
                }
                break block6;
            }
            Vertex ddcardv1 = (Vertex)ov.getVertices(Direction.IN, new String[]{"MappedTo"}).iterator().next();
            Vertex stepVertex = (Vertex)ddcardv1.getVertices(Direction.IN, new String[]{"UsesDD"}).iterator().next();
            value.addContext("stepVertexId", stepVertex.getId().toString());
            Pair<String, Map<String, Object>> pair = this.processDDNameVertex((Vertex)ov, forward, values);
            Map additionalCtx = (Map)pair.getSecond();
            String ddNameProxyRid = (String)pair.getFirst();
            if (ddNameProxyRid == null) break block6;
            if (additionalCtx != null && additionalCtx.containsKey(DDCARDS_RESTRICTION)) {
                this.addVariableFromDataSource(ddNameProxyRid, "DDNameProxy", forward, values, additionalCtx);
            } else {
                Integer stepPosition = (Integer)stepVertex.getProperty("ordinalNumInJob");
                Vertex jobV = (Vertex)stepVertex.getVertices(Direction.IN, new String[]{"Steps"}).iterator().next();
                restriction = this.getNextDDCards(forward, stepPosition, jobV.getId().toString());
                String dsn1Name = (String)ov.getProperty("dsid");
                List<String> vToContinue = this.getDSNameToContinue(dsn1Name, restriction);
                for (String ovRid : vToContinue) {
                    Vertex ovc = this.dbg.getVertex((Object)ovRid);
                    pair = this.processDDNameVertex(ovc, forward, values);
                    ddNameProxyRid = (String)pair.getFirst();
                    if (ddNameProxyRid == null) continue;
                    additionalCtx = (Map)pair.getSecond();
                    this.addVariableFromDataSource(ddNameProxyRid, "DDNameProxy", forward, values, additionalCtx);
                }
            }
        }
        return values;
    }

    private Pair<String, Map<String, Object>> processDDNameVertex(Vertex ov, boolean forward, List<Pair<? extends Value, Map<String, Object>>> values) {
        Vertex ddcardv1 = (Vertex)ov.getVertices(Direction.IN, new String[]{"MappedTo"}).iterator().next();
        Vertex stepVertex = (Vertex)ddcardv1.getVertices(Direction.IN, new String[]{"UsesDD"}).iterator().next();
        String ddNameProxyRid = null;
        Iterator iterator = stepVertex.getVertices(Direction.OUT, new String[]{"ExecPGM"}).iterator();
        if (!iterator.hasNext()) {
            L.debug("step excuting a procedure stepid = " + stepVertex.getId());
            Vertex ddNameProxy = (Vertex)ddcardv1.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().next();
            ddNameProxyRid = ddNameProxy.getId().toString();
            return new Pair((Object)ddNameProxyRid, null);
        }
        Vertex execPgm = (Vertex)iterator.next();
        String execPgmName = (String)execPgm.getProperty("name");
        Edge jobStepEdge = (Edge)stepVertex.getEdges(Direction.IN, new String[]{"Steps"}).iterator().next();
        HashMap<String, Object> context = null;
        if (!DatasetUtils.isUtility(execPgmName)) {
            Iterator it = execPgm.getVertices(Direction.IN, new String[]{"ContextOf"}).iterator();
            if (it.hasNext()) {
                Vertex pgmContext = (Vertex)it.next();
                HashSet<String> prgRids = new HashSet<String>();
                Iterable cgPrgProxyIt = pgmContext.getVertices(Direction.IN, new String[]{"InContext"});
                for (Vertex ppV : cgPrgProxyIt) {
                    Vertex pVertex;
                    Integer type;
                    Iterator pVIt = ppV.getVertices(Direction.OUT, new String[]{"ProxyFor"}).iterator();
                    if (!pVIt.hasNext() || (type = (Integer)(pVertex = (Vertex)pVIt.next()).getProperty("type")) != 2) continue;
                    prgRids.add(pVertex.getId().toString());
                }
                if (!prgRids.isEmpty()) {
                    HashSet<String> nextDDCards = null;
                    context = new HashMap<String, Object>();
                    if (pgmContext != null) {
                        context.put("pgmContextRid", pgmContext.getId().toString());
                    }
                    context.put(STEP_RESTRICTION, stepVertex.getId().toString());
                    Vertex ddNameProxy = (Vertex)ddcardv1.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().next();
                    ddNameProxyRid = ddNameProxy.getId().toString();
                    Iterable usageIt = ddNameProxy.getVertices(Direction.IN, new String[]{"ResourceLink"});
                    boolean foundFirst = false;
                    for (Vertex fUsageV : usageIt) {
                        Integer bRead = (Integer)fUsageV.getProperty("bRead");
                        String prgRid = (String)fUsageV.getProperty("prgRid");
                        if (!prgRids.contains(prgRid) || (!forward || bRead != 1) && (forward || bRead != 2)) continue;
                        foundFirst = true;
                        break;
                    }
                    if (foundFirst) {
                        Iterable ddcardsInStep = stepVertex.getVertices(Direction.OUT, new String[]{"UsesDD"});
                        for (Vertex ddcardv2 : ddcardsInStep) {
                            if (!ddcardv2.equals(ddcardv1)) {
                                Vertex ddNameProxy2 = (Vertex)ddcardv2.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().next();
                                Iterable usageIt2 = ddNameProxy2.getVertices(Direction.IN, new String[]{"ResourceLink"});
                                for (Vertex fUsageV2 : usageIt2) {
                                    Integer bRead2 = (Integer)fUsageV2.getProperty("bRead");
                                    String prgRid2 = (String)fUsageV2.getProperty("prgRid");
                                    if ((!prgRids.contains(prgRid2) || !forward || bRead2 != 2) && (forward || bRead2 != 1)) continue;
                                    if (nextDDCards == null) {
                                        Integer stepPosition = (Integer)stepVertex.getProperty("ordinalNumInJob");
                                        Vertex jobV = jobStepEdge.getVertex(Direction.OUT);
                                        nextDDCards = this.getNextDDCards(forward, stepPosition, jobV.getId().toString());
                                    }
                                    context.put(DDCARDS_RESTRICTION, nextDDCards);
                                    break;
                                }
                            }
                            if (nextDDCards == null) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else {
                L.debug("execpgm " + execPgmName + " without a PGMContext");
                String ddcardName1 = (String)ddcardv1.getProperty("name");
                if (forward && ddcardName1.toLowerCase().contains("in") || !forward && ddcardName1.toLowerCase().contains("out")) {
                    Iterable ddcardsFromStep = stepVertex.getVertices(Direction.OUT, new String[]{"UsesDD"});
                    for (Vertex ddcardv2 : ddcardsFromStep) {
                        String ddcardName2 = (String)ddcardv2.getProperty("name");
                        if (ddcardv2.equals(ddcardv1) || (!forward || !ddcardName2.toLowerCase().contains("out")) && (forward || !ddcardName2.toLowerCase().contains("in"))) continue;
                        Integer stepPosition = (Integer)stepVertex.getProperty("ordinalNumInJob");
                        Vertex jobV = jobStepEdge.getVertex(Direction.OUT);
                        Pair<VertexValue, Map<String, Object>> item = this.addNextDSNameItem(forward, ddcardName1, ddcardv2.getId().toString(), this.getNextDDCards(forward, stepPosition, jobV.getId().toString()));
                        if (item == null) continue;
                        values.add(item);
                    }
                } else {
                    Integer stepPosition = (Integer)stepVertex.getProperty("ordinalNumInJob");
                    Vertex jobV = jobStepEdge.getVertex(Direction.OUT);
                    L.debug("skip the DDstatement for DDcard: " + ddcardName1 + " in step " + stepPosition + " in job " + jobV.getProperty("name"));
                }
            }
        } else {
            L.debug(String.valueOf(execPgmName) + " is a utility!");
            String ddcardName1 = (String)ddcardv1.getProperty("name");
            int idxCard1 = DatasetUtils.getSpecial(ddcardName1);
            if (DatasetUtils.verifyUtilityDDCard(forward, idxCard1)) {
                Iterable ddcardsFromStep = stepVertex.getVertices(Direction.OUT, new String[]{"UsesDD"});
                boolean found = false;
                for (Vertex ddcardv2 : ddcardsFromStep) {
                    String ddcardName2 = (String)ddcardv2.getProperty("name");
                    int idxCard2 = DatasetUtils.getSpecial(ddcardName2);
                    int type = forward ? idxCard1 : idxCard2;
                    int cType = forward ? idxCard2 : idxCard1;
                    try {
                        if (ddcardv2.equals(ddcardv1) || !DatasetUtils.arePair(type, cType)) continue;
                        Integer stepPosition = (Integer)stepVertex.getProperty("ordinalNumInJob");
                        Vertex jobV = jobStepEdge.getVertex(Direction.OUT);
                        Pair<VertexValue, Map<String, Object>> item = this.addNextDSNameItem(forward, ddcardName1, ddcardv2.getId().toString(), this.getNextDDCards(forward, stepPosition, jobV.getId().toString()));
                        if (item == null) continue;
                        ((VertexValue)item.getFirst()).addContext("stepVertexId", stepVertex.getId().toString());
                        values.add(item);
                        found = true;
                    }
                    catch (Exception exception) {
                        L.debug("ddcard1=" + ddcardName1 + " and ddcard2=" + ddcardName2 + " are not pair" + " in utility " + execPgmName);
                    }
                }
                if (!found && (DatasetUtils.is(100, idxCard1) || DatasetUtils.is(500, idxCard1))) {
                    if (!forward) {
                        L.warn("wrong direction for type " + idxCard1);
                    }
                    NonVertexValue nvv = new NonVertexValue("Printer");
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("link", "DatasetFlow");
                    info.put("DDCard", String.valueOf(ddcardName1) + " -> Printer");
                    Pair item = new Pair((Object)nvv, info);
                    values.add((Pair<? extends Value, Map<String, Object>>)item);
                }
            } else {
                Vertex jobV = jobStepEdge.getVertex(Direction.OUT);
                L.debug("pair ddcard - utility is not recognized. The DDcard is " + ddcardName1 + " in job " + jobV.getProperty("name"));
            }
        }
        return new Pair((Object)ddNameProxyRid, context);
    }

    private Pair<VertexValue, Map<String, Object>> addNextDSNameItem(boolean forward, String ddCardName1, String ddcardRid2, HashSet<String> nextDDCards) {
        String q = "select $a[0].name as step, $b.name as jobName, $b.member as jobMember, name as ddCardName2, out('MappedTo')[0].@rid.asString() as dsnRid from AD_FROM\n let $a = in('UsesDD'),\n$b = in('UsesDD').in('Steps')[0] where out('MappedTo').size() > 0";
        CloseableIterable dsnRIds = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(q.replace("AD_FROM", ddcardRid2))).execute(new Object[0]);
        Iterator iterator = dsnRIds.iterator();
        if (iterator.hasNext()) {
            OrientElement oe = (OrientElement)iterator.next();
            String ddCardName2 = (String)oe.getProperty("ddCardName2");
            Object dsnrid = oe.getProperty("dsnRid");
            OrientVertex dsn2V = (OrientVertex)this.dbg.getVertex(dsnrid);
            VertexValue vv = new VertexValue(dsn2V);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("link", "DatasetFlow");
            info.put("DDCard", forward ? String.valueOf(ddCardName1) + " -> " + ddCardName2 : String.valueOf(ddCardName2) + "/" + ddCardName1);
            vv.addContext(DDCARDS_RESTRICTION, nextDDCards);
            return new Pair((Object)vv, info);
        }
        return null;
    }

    private HashSet<String> getNextDDCards(boolean forward, Integer stepPosition, String jobRid) {
        String q = "select st.@rid.asString() as stepRid from (select  out('Steps') as st from AD_FROM unwind st) where st.ordinalNumInJob AD_POS ? limit -1".replace("AD_FROM", jobRid).replace("AD_POS", forward ? " > " : " < ");
        CloseableIterable stRIds = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(q)).execute(new Object[]{stepPosition});
        HashSet<String> nextDDCards = new HashSet<String>();
        for (OrientElement coe : stRIds) {
            String stepRid = (String)coe.getProperty("stepRid");
            CloseableIterable dsRIDs = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL("select out('UsesDD').out('MappedTo').@rid.asString() as dsnames from AD_FROM".replace("AD_FROM", stepRid))).execute(new Object[0]);
            for (OrientElement oe : dsRIDs) {
                String dsnames = (String)oe.getProperty("dsnames");
                String[] dsArray = this.splitResult(dsnames);
                if (dsArray == null) continue;
                String[] stringArray = dsArray;
                int n = dsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ds = stringArray[n2];
                    nextDDCards.add(ds);
                    ++n2;
                }
            }
        }
        return nextDDCards;
    }

    private List<String> getDSNameToContinue(String dsn2Name, HashSet<String> nextDDCards) {
        ArrayList<String> result = new ArrayList<String>();
        for (String rid : nextDDCards) {
            OrientVertex dsNameV = (OrientVertex)this.dbg.getVertex((Object)rid);
            if (!dsn2Name.equals(dsNameV.getProperty("dsid"))) continue;
            result.add(dsNameV.getId().toString());
        }
        return result;
    }

    private void addVariableFromDataSource(String dsRid, String dsCls, boolean forward, List<Pair<? extends Value, Map<String, Object>>> values, Map<String, Object> restrictionCtx) {
        String pgmContextRid;
        String prgRestrictionStr = null;
        String string = pgmContextRid = restrictionCtx != null ? (String)restrictionCtx.get("pgmContextRid") : null;
        if (pgmContextRid != null) {
            String prgRestictionQuery = "select in('InContext').out('ProxyFor').@rid.asString() as prgRestriction from PGMContext where @rid = ";
            CloseableIterable restrictions = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(prgRestictionQuery.concat(pgmContextRid))).execute(new Object[0]);
            Iterator iterator = restrictions.iterator();
            if (restrictions != null && iterator.hasNext()) {
                prgRestrictionStr = (String)((OrientElement)iterator.next()).getProperty("prgRestriction");
            }
            if (prgRestrictionStr == null || prgRestrictionStr.length() < 3) {
                L.warn("empty pgmContext!!!");
                return;
            }
        }
        String query = forward ? Query_DS_TO_VAR_FORWARD : Query_DS_TO_VAR_BACKWARD;
        query = query.replace(MARKER_RID, dsRid);
        query = prgRestrictionStr != null ? query.replace(RESTRICTIONS_MARKER, String.valueOf(forward ? "and df.fromUsage.prgRid in " : "and df.toUsage.prgRid in ") + prgRestrictionStr) : query.replace(RESTRICTIONS_MARKER, "");
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap<String, Pair> addedRids = new HashMap<String, Pair>();
        HashMap<String, List<Pair<Value, Map<String, Object>>>> forCumulate = new HashMap<String, List<Pair<Value, Map<String, Object>>>>();
        for (OrientElement rv : ret) {
            String stmtTypeStr = (String)rv.getProperty("stmtType");
            String usageRidStr = (String)rv.getProperty("usageRid");
            String varRidStr = (String)rv.getProperty("varRid");
            if (stmtTypeStr == null || usageRidStr == null || varRidStr == null) {
                L.debug("no results for query {} only empty v(null)[#-2:0]", (Object)query);
                continue;
            }
            String[] stmtTypes = this.splitResult(stmtTypeStr);
            String[] usageRids = this.splitResult(usageRidStr);
            String[] varRids = this.splitResult(varRidStr);
            int i = 0;
            while (i < varRids.length) {
                HashMap<String, String> m;
                if (addedRids.get(varRids[i]) != null) {
                    Pair pair = (Pair)addedRids.get(varRids[i]);
                    Map info = (Map)pair.getSecond();
                    Set set = (Set)info.get("nodeORID");
                    set.add(usageRids[i]);
                    String stmtsDescription = (String)info.get("link");
                    if (!stmtsDescription.contains(stmtTypes[i])) {
                        stmtsDescription = stmtsDescription.concat(", " + stmtTypes[i]);
                        info.put("link", stmtsDescription);
                    }
                    m = (HashMap<String, String>)info.get("impact");
                    m.put(usageRids[i], (String)info.get(varRids[i]));
                } else {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("link", stmtTypes[i]);
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    set.add(usageRids[i]);
                    info.put("nodeORID", set);
                    OrientVertex v = (OrientVertex)this.dbg.getVertex((Object)varRids[i]);
                    Value vv = this.searchAncestor(varRids[i], 0, (Integer)v.getProperty("size"), (Integer)v.getProperty("memOffset"));
                    if (vv != null) {
                        String parentRid;
                        ArrayList<Pair> map;
                        m = new HashMap<String, String>();
                        int voff = (Integer)vv.getContext("memOffset");
                        int impactedOffset = (Integer)vv.getContext("impactedOffset");
                        int impactedSize = (Integer)vv.getContext("impactedSize");
                        m.put(usageRids[i], String.valueOf(voff + impactedOffset) + "," + impactedSize + "," + (voff + impactedOffset) + "," + impactedSize);
                        info.put("impact", m);
                        info.put(varRids[i], m.get(usageRids[i]));
                        if (restrictionCtx != null) {
                            for (String key : restrictionCtx.keySet()) {
                                vv.addContext(key, restrictionCtx.get(key));
                            }
                        }
                        if ((map = (ArrayList<Pair>)forCumulate.get(parentRid = vv.id())) == null) {
                            map = new ArrayList<Pair>();
                            forCumulate.put(parentRid, map);
                        }
                        Pair pair = new Pair((Object)vv, info);
                        map.add(pair);
                        addedRids.put(varRids[i], pair);
                    }
                }
                ++i;
            }
        }
        values.addAll(this.compact(forCumulate));
    }

    private String[] splitResult(String str) {
        String[] result = null;
        if (str != null && str.length() > 2) {
            str = str.substring(1, str.length() - 1);
            result = str.split(", ");
        }
        return result;
    }

    private List<Pair<? extends Value, Map<String, Object>>> expandFile(boolean forward, Value value) {
        if (!"DDNameProxy".equals(value.getVertexClass())) {
            return null;
        }
        LinkedList<Pair<? extends Value, Map<String, Object>>> values = new LinkedList<Pair<? extends Value, Map<String, Object>>>();
        Vertex prgV = this.dbg.getVertex(value.getContext("resUsageInfoFromDataFlow"));
        Iterable pgmIt = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select in.@rid.asString() as pgmc from InContext where prgRid  = ?")).execute(new Object[]{prgV.getId().toString()});
        HashSet<String> jclPgmRids = new HashSet<String>();
        for (Vertex pV : pgmIt) {
            String pgmc = (String)pV.getProperty("pgmc");
            jclPgmRids.add(((Vertex)this.dbg.getVertex((Object)pgmc).getVertices(Direction.OUT, new String[]{"ContextOf"}).iterator().next()).getId().toString());
        }
        for (String jclPgmRid : jclPgmRids) {
            Vertex jclPgmV = this.dbg.getVertex((Object)jclPgmRid);
            Iterable etble3 = jclPgmV.getEdges(Direction.IN, new String[]{"ExecPGM"});
            for (Edge e3 : etble3) {
                Vertex stepV = e3.getVertex(Direction.OUT);
                if (value.getContext(STEP_RESTRICTION) != null && !stepV.getId().toString().equals(value.getContext(STEP_RESTRICTION))) continue;
                Iterable etble4 = stepV.getEdges(Direction.OUT, new String[]{"UsesDD"});
                for (Edge e4 : etble4) {
                    Vertex ddCardV = e4.getVertex(Direction.IN);
                    OrientVertex ov = ((VertexValue)value).asVertex(this.dbg);
                    if (!ddCardV.getProperty("name").equals(ov.getProperty("name"))) continue;
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("link", "DDCard association");
                    HashSet<String> set = new HashSet<String>();
                    set.add(ddCardV.getId().toString());
                    info.put("nodeORID", set);
                    info.put("DDCard", ddCardV.getProperty("name"));
                    Iterator it = ddCardV.getEdges(Direction.OUT, new String[]{"MappedTo"}).iterator();
                    Edge steps = (Edge)stepV.getEdges(Direction.IN, new String[]{"Steps"}).iterator().next();
                    Vertex jobV = steps.getVertex(Direction.OUT);
                    if (it.hasNext()) {
                        Edge mappedTo = (Edge)it.next();
                        Vertex dsNameV = mappedTo.getVertex(Direction.IN);
                        if (((Boolean)dsNameV.getProperty("isTemp")).booleanValue() || ((Boolean)dsNameV.getProperty("isInstream")).booleanValue() || ((Boolean)dsNameV.getProperty("isLib")).booleanValue()) continue;
                        VertexValue vv = new VertexValue((OrientVertex)dsNameV);
                        vv.addContext("dsName", dsNameV.getProperty("dsid"));
                        vv.addContext("stepVertexId", stepV.getId().toString());
                        vv.addContext(DDCARDS_RESTRICTION, value.getContext(DDCARDS_RESTRICTION));
                        values.add((Pair<? extends Value, Map<String, Object>>)new Pair((Object)vv, info));
                        continue;
                    }
                    if (!L.isDebugEnabled()) continue;
                    L.debug("ddcard " + ddCardV.getProperty("name") + " not mapped with DSN in step " + stepV.getProperty("name") + " for job " + jobV.getProperty("name"));
                }
            }
        }
        return values;
    }

    private List<Pair<? extends Value, Map<String, Object>>> expandVar(boolean forward, Value value) {
        List<Pair<? extends Value, Map<String, Object>>> varsFromSubpogram;
        if (!"Variable".equals(value.getVertexClass())) {
            return null;
        }
        VertexValue expand = (VertexValue)value;
        OrientVertex ov = expand.asVertex(this.dbg);
        int impactedOffset = (Integer)value.getContext("impactedOffset");
        int impactedSize = (Integer)value.getContext("impactedSize");
        L.debug("var {} parent {} program {} -- impactedOffset = {} impactedSize {} --- varoffset {} varSize {}", new Object[]{ov.getProperty("name"), expand.getContext("variable first parent"), expand.getContext("programName"), impactedOffset, impactedSize, ov.getProperty("memOffset"), ov.getProperty("size")});
        if (impactedOffset + impactedSize > (Integer)ov.getProperty("size")) {
            L.debug("out of range - expandVar");
            return null;
        }
        Boolean pCallFw = (Boolean)expand.getContext(PCALLFW);
        boolean direction = forward;
        HashMap<String, Map<String, Object>> impactedChildren = new HashMap<String, Map<String, Object>>();
        this.expandVarChildOf((Vertex)ov, impactedOffset, impactedSize, impactedChildren);
        Map<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromRedefines = null;
        if (this.searchForRedefines(expand, ov)) {
            HashSet<Vertex> varForChildOf = new HashSet<Vertex>();
            impactedFromRedefines = this.expandVarRedefines(ov, impactedOffset, impactedSize, impactedChildren, varForChildOf);
            if (!varForChildOf.isEmpty()) {
                for (Vertex vco : varForChildOf) {
                    this.expandVarChildOf(vco, impactedOffset, impactedSize, impactedChildren);
                }
            }
        }
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        if (!impactedChildren.isEmpty() || impactedFromRedefines != null) {
            boolean hasMissingPrg;
            HashMap<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromChildren = impactedFromRedefines != null ? impactedFromRedefines : new HashMap<Triplet<String, Integer, Integer>, Map<String, Object>>();
            Triplet<Set<String>, Set<String>, Set<String>> childrenForNext = this.splitChildren(impactedChildren, direction, pCallFw);
            Set cForDataflow = (Set)childrenForNext.getFirst();
            Set cForForwardCall = (Set)childrenForNext.getSecond();
            Set cForForwardIntenalCall = (Set)childrenForNext.getThird();
            if (!cForDataflow.isEmpty()) {
                this.expandVarDataFlow(expand, direction, impactedChildren, impactedFromChildren, cForDataflow);
            }
            if (cForForwardCall != null && !cForForwardCall.isEmpty() && (hasMissingPrg = this.expandVarArgumentsForward(expand, impactedChildren, impactedFromChildren, cForForwardCall))) {
                expand.addContext("node need update in impact graph", Boolean.TRUE);
            }
            if (cForForwardIntenalCall != null && !cForForwardIntenalCall.isEmpty()) {
                this.expandCallExprForward(expand, impactedChildren, impactedFromChildren, cForForwardIntenalCall);
            }
            this.makeNext(expand, vars, impactedFromChildren);
        }
        if (expand.getContext(CONTEXT_CB_PARAMS) != null && !((Stack)expand.getContext(CONTEXT_CB_PARAMS)).isEmpty()) {
            String returnStmtRid;
            if (forward && (returnStmtRid = this.getReturnStatement(value.id())) != null) {
                List<Pair<? extends Value, Map<String, Object>>> varsFromReturn = this.addImpactedVarFromReturn(expand, returnStmtRid);
                vars.addAll(varsFromReturn);
            }
            if (expand.getContext(IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL) == null && ov.countEdges(Direction.IN, new String[]{"formalParamDef"}) > 0L) {
                varsFromSubpogram = this.addFromFormalParameter(expand);
                vars.addAll(varsFromSubpogram);
            }
        }
        if (!forward && expand.getContext(CONTEXT_CB_PARAMS) == null && ov.countEdges(Direction.IN, new String[]{"formalParamDef"}) > 0L) {
            varsFromSubpogram = this.addFromFormalParameter(expand);
            vars.addAll(varsFromSubpogram);
        }
        if (!forward) {
            List<Pair<? extends Value, Map<String, Object>>> varsFromLeftAssign = this.addFromLeftAssignVar(expand);
            vars.addAll(varsFromLeftAssign);
        }
        L.debug("expand {} found {} variables to be expanded", (Object)value.id(), (Object)vars.size());
        return vars;
    }

    private List<Pair<? extends Value, Map<String, Object>>> addFromLeftAssignVar(VertexValue expand) {
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryFromLeftVarToExpr.replace(MARKER_RID, expand.id()))).execute(new Object[0]);
        HashMap<String, Set<String>> cbToCallExp = new HashMap<String, Set<String>>();
        for (OrientElement oe : ret) {
            String[] ces;
            String ceRids = (String)oe.getProperty("ce");
            String[] stringArray = ces = this.splitResult(ceRids);
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                String ce = stringArray[n2];
                Iterator cbIt = this.dbg.getVertex((Object)ce).getVertices(Direction.OUT, new String[]{"calledBlock"}).iterator();
                if (cbIt.hasNext()) {
                    Vertex cbV = (Vertex)cbIt.next();
                    String cb = cbV.getId().toString();
                    HashSet<String> callExps = (HashSet<String>)cbToCallExp.get(cb);
                    if (callExps == null) {
                        callExps = new HashSet<String>();
                        cbToCallExp.put(cb, callExps);
                    }
                    callExps.add(ce);
                } else {
                    L.warn("callExp without called codeBlock {}", (Object)ce);
                }
                ++n2;
            }
        }
        if (!cbToCallExp.isEmpty()) {
            HashMap<String, Map<String, Object>> addedVars = new HashMap<String, Map<String, Object>>();
            Map<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromLeftAss = this.getVarFromReturns(expand, cbToCallExp, addedVars);
            this.makeNext(expand, vars, impactedFromLeftAss);
        }
        return vars;
    }

    private Map<Triplet<String, Integer, Integer>, Map<String, Object>> getVarFromReturns(VertexValue expand, Map<String, Set<String>> cbToCallExp, Map<String, Map<String, Object>> added) {
        CloseableIterable result = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(VAR_OR_EXP_FROM_RETURN.replace(MARKER_RID, cbToCallExp.keySet().toString()))).execute(new Object[0]);
        Map<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromLeftAss = new HashMap<Triplet<String, Integer, Integer>, Map<String, Object>>();
        HashMap<String, Set<String>> cbToCallExpFromExp = new HashMap<String, Set<String>>();
        for (OrientElement oe : result) {
            String cbRid = (String)oe.getProperty("cbRid");
            String stmtRetStr = (String)oe.getProperty("stmtRet");
            String[] stmtsRet = this.splitResult(stmtRetStr);
            if (stmtsRet == null) {
                L.warn("getVarFromReturns: could not match return statement {}", cbToCallExp.keySet());
                continue;
            }
            String[] stringArray = stmtsRet;
            int n = stmtsRet.length;
            int n2 = 0;
            while (n2 < n) {
                String stmtRet = stringArray[n2];
                Vertex stmtV = this.dbg.getVertex((Object)stmtRet);
                Iterable itStmt = stmtV.getVertices(Direction.OUT, new String[]{"UsesVar"});
                for (Vertex usesVarV : itStmt) {
                    Vertex varV = (Vertex)usesVarV.getVertices(Direction.OUT, new String[]{"DefinedBy"}).iterator().next();
                    String varVRid = String.valueOf(varV.getId());
                    if (added.containsKey(varVRid)) {
                        L.debug("already added");
                        continue;
                    }
                    for (String ce : cbToCallExp.get(cbRid)) {
                        Vertex ceV = this.dbg.getVertex((Object)ce);
                        Iterable varParamIt = ceV.getVertices(Direction.OUT, new String[]{"hasVarParam", "hasExpParam"});
                        Map<String, Object> info = null;
                        for (Vertex varParamV : varParamIt) {
                            HashSet<String> ct;
                            String varParam = varParamV.getId().toString();
                            if (info == null) {
                                info = this.addDataflowInfo(expand, stmtRet, varParam, varV, impactedFromLeftAss);
                                info.put(IS_INTERNAL_VAR_PARAM_FROM_RETURN, Boolean.TRUE);
                                info.put("return stmt from internal call", Boolean.TRUE);
                                ct = new HashSet<String>();
                                ct.add(varParam);
                                info.put(INTERNAL_VAR_PARAMS, ct);
                                added.put(varVRid, info);
                                continue;
                            }
                            ct = (HashSet<String>)info.get(INTERNAL_VAR_PARAMS);
                            ct.add(varParam);
                        }
                    }
                }
                Iterable itExp = stmtV.getVertices(Direction.OUT, new String[]{"UsesExp"});
                for (Vertex expV : itExp) {
                    Iterable iter = expV.getVertices(Direction.OUT, new String[]{"expPart"});
                    for (Vertex callExp : iter) {
                        if ("callExp".equals(callExp.getProperty("@class"))) {
                            Iterator cbVIt = callExp.getVertices(Direction.OUT, new String[]{"calledBlock"}).iterator();
                            if (cbVIt.hasNext()) {
                                String rid = ((Vertex)cbVIt.next()).getId().toString();
                                HashSet<String> callRefs = (HashSet<String>)cbToCallExpFromExp.get(rid);
                                if (callRefs == null) {
                                    callRefs = new HashSet<String>();
                                    cbToCallExpFromExp.put(rid, callRefs);
                                }
                                callRefs.add(callExp.getId().toString());
                                continue;
                            }
                            L.warn("callExp without called codeBlock {}", callExp.getId());
                            continue;
                        }
                        L.debug("skip callExtExp and variable");
                    }
                }
                if (!cbToCallExpFromExp.isEmpty()) {
                    impactedFromLeftAss = this.getVarFromReturns(expand, cbToCallExpFromExp, added);
                }
                ++n2;
            }
        }
        return impactedFromLeftAss;
    }

    private List<Pair<? extends Value, Map<String, Object>>> addFromFormalParameter(VertexValue expand) {
        Stack context = (Stack)expand.getContext(CONTEXT_CB_PARAMS);
        String query = null;
        Stack contextClone = null;
        if (context == null) {
            L.debug("impact is backward without context restrictions; will search for all calls where the current variable is involved");
            query = query_VarParam_for_Subprgram.replace(RESTRICTIONS_MARKER, expand.id());
        } else {
            contextClone = (Stack)context.clone();
            Set currentContext = (Set)contextClone.pop();
            if (expand.getContext(IS_INTERNAL_VAR_PARAM_FROM_RETURN) != null) {
                expand.addContext(IS_INTERNAL_VAR_PARAM_FROM_RETURN, null);
                expand.addContext("node need update in impact graph", Boolean.TRUE);
                query = query_VarParam_for_Subprgram_Restriction.replace(RESTRICTIONS_MARKER, expand.id()).replaceAll(MARKER_RID, currentContext.toString());
            } else {
                query = query_VarParam_for_Subprgram_Context.replace(RESTRICTIONS_MARKER, expand.id()).replaceAll(MARKER_RID, currentContext.toString());
            }
        }
        HashMap<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromSubprogram = new HashMap<Triplet<String, Integer, Integer>, Map<String, Object>>();
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap<String, Map<String, Object>> outVpRids = new HashMap<String, Map<String, Object>>();
        HashMap<String, Set<String>> cbToCallExp = new HashMap<String, Set<String>>();
        for (OrientElement oe : ret) {
            Vertex outVpV = (Vertex)oe.getProperty("outvp");
            String outVp = String.valueOf(outVpV.getId());
            Vertex callExpV = (Vertex)outVpV.getVertices(Direction.IN, new String[]{"hasVarParam", "hasExpParam"}).iterator().next();
            Iterator cbIt = callExpV.getVertices(Direction.OUT, new String[]{"calledBlock"}).iterator();
            if (cbIt.hasNext()) {
                String cbName = (String)((Vertex)cbIt.next()).getProperty("name");
                if ("varParam".equals(outVpV.getProperty("@class"))) {
                    HashSet<String> intCallRestr;
                    Map<String, Object> info;
                    Integer paramPos = (Integer)outVpV.getProperty("paramPos");
                    Vertex outVarV = (Vertex)outVpV.getVertices(Direction.OUT, new String[]{"VPDefinedBy"}).iterator().next();
                    String outVarRid = String.valueOf(outVarV.getId());
                    if (outVpRids.containsKey(outVarRid)) {
                        info = (Map<String, Object>)outVpRids.get(outVarRid);
                        intCallRestr = (HashSet<String>)info.get(INTERNAL_CALL_RESTRICTIONS);
                        intCallRestr.add(this.makeKey(cbName, String.valueOf(paramPos)));
                        continue;
                    }
                    info = this.addDataflowInfo(expand, outVp, outVp, outVarV, impactedFromSubprogram);
                    if (info == null) continue;
                    info.put("programCallDirection", Boolean.TRUE);
                    if (this.forward) {
                        info.put("reverse impact direction", Boolean.TRUE);
                    }
                    intCallRestr = new HashSet<String>();
                    intCallRestr.add(this.makeKey(cbName, String.valueOf(paramPos)));
                    info.put(INTERNAL_CALL_RESTRICTIONS, intCallRestr);
                    outVpRids.put(outVarRid, info);
                    info.put(HAS_CONTEXT_CB_PARAMS, Boolean.TRUE);
                    if (contextClone == null || contextClone.isEmpty()) continue;
                    info.put(CONTEXT_CB_PARAMS, contextClone);
                    continue;
                }
                Vertex expAsParamV = (Vertex)outVpV.getVertices(Direction.OUT, new String[]{"toExp"}).iterator().next();
                Vertex callExpAsParamV = (Vertex)expAsParamV.getVertices(Direction.OUT, new String[]{"expPart"}).iterator().next();
                Vertex cbV = (Vertex)callExpAsParamV.getVertices(Direction.OUT, new String[]{"calledBlock"}).iterator().next();
                String cb = cbV.getId().toString();
                HashSet<String> callExps = (HashSet<String>)cbToCallExp.get(cb);
                if (callExps == null) {
                    callExps = new HashSet<String>();
                    cbToCallExp.put(cb, callExps);
                }
                callExps.add(callExpAsParamV.getId().toString());
                continue;
            }
            L.warn("callExp without called codeBlock {}", callExpV.getId());
        }
        if (!cbToCallExp.isEmpty()) {
            HashMap<String, Map<String, Object>> addedVar = new HashMap<String, Map<String, Object>>();
            Map<Triplet<String, Integer, Integer>, Map<String, Object>> fromExpParam = this.getVarFromReturns(expand, cbToCallExp, addedVar);
            impactedFromSubprogram.putAll(fromExpParam);
        }
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        this.makeNext(expand, vars, impactedFromSubprogram);
        return vars;
    }

    private List<Pair<? extends Value, Map<String, Object>>> addImpactedVarFromReturn(VertexValue expand, String returnRid) {
        Stack context = (Stack)expand.getContext(CONTEXT_CB_PARAMS);
        Stack contextClone = (Stack)context.clone();
        HashMap<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromInternalCalls = new HashMap<Triplet<String, Integer, Integer>, Map<String, Object>>();
        boolean found = false;
        HashSet<String> leftVarAdded = new HashSet<String>();
        HashSet<String> expParamAdded = new HashSet<String>();
        while (!contextClone.isEmpty() && !found) {
            Set currentContext = (Set)contextClone.pop();
            for (String varParam : currentContext) {
                Vertex callExpV;
                Iterable expVIt;
                Vertex varParamV = this.dbg.getVertex((Object)varParam);
                Iterator callExpVIt = varParamV.getVertices(Direction.IN, new String[]{"hasVarParam"}).iterator();
                if (!callExpVIt.hasNext()) {
                    callExpVIt = varParamV.getVertices(Direction.IN, new String[]{"hasExpParam"}).iterator();
                }
                if (!(expVIt = (callExpV = (Vertex)callExpVIt.next()).getVertices(Direction.IN, new String[]{"expPart"})).iterator().hasNext()) {
                    L.warn("callexpV without expresion {} ", callExpV.getId());
                    continue;
                }
                OrientVertex expV = (OrientVertex)expVIt.iterator().next();
                if (expV.countEdges(Direction.IN, new String[]{"UsesExp"}) > 0L) {
                    Vertex stmtV = (Vertex)expV.getVertices(Direction.IN, new String[]{"UsesExp"}).iterator().next();
                    if ("424".equals(stmtV.getProperty("typeId"))) {
                        L.debug("is Return with call");
                        continue;
                    }
                    for (Vertex varUsageV : stmtV.getVertices(Direction.OUT, new String[]{"UsesVar"})) {
                        if (!"2".equals(String.valueOf(varUsageV.getProperty("bRead")))) {
                            L.debug("skip var usage because is from an expression");
                            continue;
                        }
                        Iterator leftAssVarIt = varUsageV.getVertices(Direction.OUT, new String[]{"DefinedBy"}).iterator();
                        if (!leftAssVarIt.hasNext()) continue;
                        Vertex leftAssVarV = (Vertex)leftAssVarIt.next();
                        String rid = leftAssVarV.getId().toString();
                        if (!leftVarAdded.contains(rid)) {
                            Map<String, Object> info = this.addDataflowInfo(expand, returnRid, varParam, leftAssVarV, impactedFromInternalCalls);
                            if (info != null) {
                                info.put("return stmt from internal call", Boolean.TRUE);
                                info.put(HAS_CONTEXT_CB_PARAMS, Boolean.TRUE);
                                info.put("VARPARAM", varParam);
                                info.put(IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL, "varParam");
                                if (!contextClone.isEmpty()) {
                                    info.put(CONTEXT_CB_PARAMS, contextClone);
                                }
                            }
                            leftVarAdded.add(rid);
                            continue;
                        }
                        L.debug("already added as impacted from return statement {}", (Object)rid);
                    }
                    found = true;
                    continue;
                }
                if (expV.countEdges(Direction.IN, new String[]{"toExp"}) <= 0L) continue;
                Vertex expParamV = (Vertex)expV.getVertices(Direction.IN, new String[]{"toExp"}).iterator().next();
                String rid = expParamV.getId().toString();
                if (!expParamAdded.contains(rid)) {
                    Vertex varV = (Vertex)expParamV.getVertices(Direction.OUT, new String[]{"mapsFormalParam"}).iterator().next();
                    Map<String, Object> info = this.addDataflowInfo(expand, returnRid, rid, varV, impactedFromInternalCalls);
                    if (info != null) {
                        info.put("return stmt from internal call", Boolean.TRUE);
                        info.put(IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL, "expParam");
                        info.put(HAS_CONTEXT_CB_PARAMS, Boolean.TRUE);
                        HashSet<String> ct = new HashSet<String>();
                        ct.add(rid);
                        info.put(INTERNAL_VAR_PARAMS, ct);
                        if (!contextClone.isEmpty()) {
                            info.put(CONTEXT_CB_PARAMS, contextClone);
                        }
                    }
                    expParamAdded.add(rid);
                } else {
                    L.debug("already added as impacted from return statement {}", (Object)rid);
                }
                found = true;
            }
        }
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        this.makeNext(expand, vars, impactedFromInternalCalls);
        return vars;
    }

    private Map<String, Object> addDataflowInfo(VertexValue expand, String dfRid, String impactRid, Vertex impactedVarV, Map<Triplet<String, Integer, Integer>, Map<String, Object>> impacted) {
        int impactedOffset = (Integer)expand.getContext("impactedOffset");
        int impactedSize = (Integer)expand.getContext("impactedSize");
        int voff = (Integer)expand.getContext("memOffset");
        return this.addDataflowInfo(impactedOffset, impactedSize, voff, dfRid, impactRid, impactedVarV, impacted);
    }

    private Map<String, Object> addDataflowInfo(int impactedOffset, int impactedSize, int voff, String dfRid, String impactRid, Vertex impactedVarV, Map<Triplet<String, Integer, Integer>, Map<String, Object>> impacted) {
        Map<String, Object> info = this.computeVarOffsets(impactedVarV, impactedOffset, impactedSize);
        if (info == null) {
            return null;
        }
        Integer imOff = (Integer)info.remove("impactedOffset");
        Integer imSize = (Integer)info.remove("impactedSize");
        HashSet<String> oridInfo = new HashSet<String>();
        oridInfo.add(dfRid);
        info.put("nodeORID", oridInfo);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(impactRid, String.valueOf(voff + impactedOffset) + "," + impactedSize);
        info.put("impact", m);
        String rid = impactedVarV.getId().toString();
        impacted.put((Triplet<String, Integer, Integer>)new Triplet((Object)rid, (Object)imOff, (Object)imSize), info);
        return info;
    }

    private String getReturnStatement(String varRid) {
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(GET_RETURN_STMT_QUERY.replace(MARKER_RID, varRid))).execute(new Object[0]);
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            OrientElement oe = (OrientElement)iterator.next();
            String retRid = (String)oe.getProperty("returnRid");
            return retRid;
        }
        return null;
    }

    private Triplet<Set<String>, Set<String>, Set<String>> splitChildren(Map<String, Map<String, Object>> impactedChildren, boolean direction, Boolean pCallFw) {
        HashSet<String> cForForwardCall = new HashSet<String>();
        HashSet<String> cForForwardInternalCall = new HashSet<String>();
        HashSet<String> cForDataflow = new HashSet<String>();
        for (String rid : impactedChildren.keySet()) {
            OrientVertex v = (OrientVertex)this.dbg.getVertex((Object)rid);
            if (v.countEdges(direction ? Direction.OUT : Direction.IN, new String[]{"DataFlow"}) > 0L) {
                cForDataflow.add(rid);
            }
            if (cForForwardCall != null && this.hasForward(v)) {
                cForForwardCall.add(rid);
            }
            if (cForForwardInternalCall == null || !this.hasInternalCallForward(v)) continue;
            cForForwardInternalCall.add(rid);
        }
        return new Triplet(cForDataflow, cForForwardCall, cForForwardInternalCall);
    }

    public List<Pair<? extends Value, Map<String, Object>>> makeNextFromRedefine(VertexValue expand) {
        OrientVertex ov = expand.asVertex(this.dbg);
        Map<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromRedefines = null;
        if (this.searchForRedefines(expand, ov)) {
            HashSet<Vertex> varForChildOf = new HashSet<Vertex>();
            HashMap<String, Map<String, Object>> impactedChildren = new HashMap<String, Map<String, Object>>();
            int impactedOffset = (Integer)expand.getContext("impactedOffset");
            int impactedSize = (Integer)expand.getContext("impactedSize");
            impactedFromRedefines = this.expandVarRedefines(ov, impactedOffset, impactedSize, impactedChildren, varForChildOf);
        }
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        this.makeNext(expand, vars, impactedFromRedefines);
        return vars;
    }

    private void makeNext(VertexValue expand, List<Pair<? extends Value, Map<String, Object>>> nextVars, Map<Triplet<String, Integer, Integer>, Map<String, Object>> impactedFromChildren) {
        HashMap<String, List<Pair<Value, Map<String, Object>>>> forCumulate = new HashMap<String, List<Pair<Value, Map<String, Object>>>>();
        for (Triplet<String, Integer, Integer> t : impactedFromChildren.keySet()) {
            ArrayList<Pair> map;
            String callkey;
            String rid = (String)t.getFirst();
            Integer imOff = (Integer)t.getSecond();
            Integer imsize = (Integer)t.getThird();
            Map<String, Object> info = impactedFromChildren.get(t);
            Value vv = null;
            if (imOff == null && imsize == null) {
                vv = new VertexValue((OrientVertex)this.dbg.getVertex((Object)rid));
                vv.addContext("pgmContextRid", expand.getContext("pgmContextRid"));
                vv.addContext(DDCARDS_RESTRICTION, expand.getContext(DDCARDS_RESTRICTION));
                vv.addContext(STEP_RESTRICTION, expand.getContext(STEP_RESTRICTION));
                vv.addContext("resUsageInfoFromDataFlow", info.get("resUsageInfoFromDataFlow"));
                if (info.get("sql.tablename") != null) {
                    vv.addContext("sql.tablename", info.get("sql.tablename"));
                }
                nextVars.add((Pair<? extends Value, Map<String, Object>>)new Pair((Object)vv, info));
                continue;
            }
            int varOff = (Integer)info.get("memOffset");
            String string = info.get(IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL) != null ? IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL : (callkey = info.get(IS_INTERNAL_VAR_PARAM_FROM_RETURN) != null ? IS_INTERNAL_VAR_PARAM_FROM_RETURN : null);
            if (callkey != null && info.get(INTERNAL_VAR_PARAMS) != null) {
                Stack<Set<String>> ctx = this.makeCallContext(expand, info, callkey);
                if (ctx == null) continue;
                vv = this.searchAncestor(rid, imOff, imsize, varOff);
                if (vv != null) {
                    vv.addContext(CONTEXT_CB_PARAMS, ctx);
                    vv.addContext(callkey, info.get(callkey));
                }
            } else {
                vv = this.searchAncestor(rid, imOff, imsize, varOff);
                if (vv != null && expand.getContext(CONTEXT_CB_PARAMS) != null) {
                    if (info.containsKey(HAS_CONTEXT_CB_PARAMS)) {
                        if (info.get(CONTEXT_CB_PARAMS) != null) {
                            vv.addContext(CONTEXT_CB_PARAMS, info.get(CONTEXT_CB_PARAMS));
                        }
                    } else {
                        vv.addContext(CONTEXT_CB_PARAMS, expand.getContext(CONTEXT_CB_PARAMS));
                    }
                }
            }
            if (vv == null) continue;
            if (info.get(INTERNAL_CALL_RESTRICTIONS) != null) {
                vv.addContext(INTERNAL_CALL_RESTRICTIONS, info.get(INTERNAL_CALL_RESTRICTIONS));
            } else if (expand.getContext(INTERNAL_CALL_RESTRICTIONS) != null) {
                vv.addContext(INTERNAL_CALL_RESTRICTIONS, expand.getContext(INTERNAL_CALL_RESTRICTIONS));
            }
            String parentRid = vv.id();
            Map imOffMap = (Map)info.get("impact");
            if (imOffMap != null) {
                for (String key : imOffMap.keySet()) {
                    String s = (String)imOffMap.get(key);
                    s = String.valueOf(s) + "," + ((Integer)vv.getContext("memOffset") + (Integer)vv.getContext("impactedOffset")) + "," + vv.getContext("impactedSize");
                    imOffMap.put(key, s);
                }
            }
            vv.addContext("pgmContextRid", expand.getContext("pgmContextRid"));
            vv.addContext(DDCARDS_RESTRICTION, expand.getContext(DDCARDS_RESTRICTION));
            vv.addContext(STEP_RESTRICTION, expand.getContext(STEP_RESTRICTION));
            if (info.get("programCallDirection") != null) {
                vv.addContext("programCallDirection", info.get("programCallDirection"));
            } else if (this.isParameter((OrientVertex)this.dbg.getVertex((Object)parentRid))) {
                vv.addContext("impactedInSubprogram", Boolean.TRUE);
            }
            if (info.get("via call information") != null) {
                vv.addContext("via call information", info.get("via call information"));
            }
            if (info.get("reverse impact direction") != null) {
                vv.addContext("reverse impact direction", info.get("reverse impact direction"));
            }
            if (expand.getContext(IS_INTERNAL_VAR_PARAM_FROM_RETURN) != null) {
                vv.addContext(IS_INTERNAL_VAR_PARAM_FROM_RETURN, expand.getContext(IS_INTERNAL_VAR_PARAM_FROM_RETURN));
            }
            if ((map = (ArrayList<Pair>)forCumulate.get(parentRid)) == null) {
                map = new ArrayList<Pair>();
                forCumulate.put(parentRid, map);
            }
            map.add(new Pair((Object)vv, info));
        }
        nextVars.addAll(this.compact(forCumulate));
    }

    private Stack<Set<String>> makeCallContext(VertexValue expand, Map<String, Object> info, String key) {
        Stack ctx = null;
        if (info.get(key) != null) {
            Set varParam = (Set)info.get(INTERNAL_VAR_PARAMS);
            Stack ectx = (Stack)expand.getContext(CONTEXT_CB_PARAMS);
            if (ectx == null || !ectx.contains(varParam)) {
                ctx = ectx == null ? new Stack() : (Stack)ectx.clone();
                ctx.push(varParam);
            } else {
                L.debug("context already processed; skip it", (Object)varParam);
            }
        }
        return ctx;
    }

    @Override
    public boolean isParameter(OrientVertex v) {
        return v.countEdges(Direction.IN, new String[]{"ProxyFor"}) > 0L;
    }

    private Collection<? extends Pair<? extends Value, Map<String, Object>>> compact(Map<String, List<Pair<Value, Map<String, Object>>>> forCumulate) {
        ArrayList<Object> vars = new ArrayList<Object>();
        for (String parentRid : forCumulate.keySet()) {
            List<Pair<Value, Map<String, Object>>> map = forCumulate.get(parentRid);
            if (this.compactContinueMemoryArea() && map.size() > 1) {
                int n;
                Value vv;
                int no = 0;
                ArrayList<Integer> memory = new ArrayList<Integer>();
                ArrayList<Pair<Value, Map<String, Object>>> vvs = new ArrayList<Pair<Value, Map<String, Object>>>();
                for (Pair<Value, Map<String, Object>> p : map) {
                    vv = (Value)p.getFirst();
                    int imOff = (Integer)vv.getContext("impactedOffset");
                    n = (Integer)vv.getContext("impactedSize");
                    int i = 0;
                    while (i < n) {
                        if (!memory.contains(1 + imOff + i)) {
                            memory.add(1 + imOff + i);
                        }
                        ++i;
                    }
                    vvs.add(p);
                }
                Collections.sort(memory);
                int first = (Integer)memory.get(0);
                if (memory.size() == 1 || memory.size() - 1 == (Integer)memory.get(memory.size() - 1) - first) {
                    Pair p = (Pair)vvs.remove(0);
                    vv = (Value)p.getFirst();
                    vv.addContext("impactedOffset", first - 1);
                    vv.addContext("impactedSize", memory.size());
                    vars.add(p);
                    if (memory.size() > 1) {
                        Map info = (Map)p.getSecond();
                        for (Pair pair : vvs) {
                            Map info2 = (Map)pair.getSecond();
                            Set orids = (Set)info.get("nodeORID");
                            orids.addAll((Set)info2.get("nodeORID"));
                            HashMap listimpOff = (HashMap)info.get("impact");
                            HashMap listimpOff2 = (HashMap)info2.get("impact");
                            listimpOff.putAll(listimpOff2);
                        }
                    }
                    ++no;
                } else {
                    int i = 0;
                    while (i < memory.size() - 1) {
                        Pair<Value, Map<String, Object>> p;
                        int sz;
                        int current = (Integer)memory.get(i);
                        int succesor = (Integer)memory.get(i + 1);
                        if (succesor - current > 1) {
                            n = first - 1;
                            sz = current - first + 1;
                            p = this.collectinfo(vvs, n, sz);
                            Value vv2 = (Value)p.getFirst();
                            vv2.addContext("impactedOffset", n);
                            vv2.addContext("impactedSize", sz);
                            first = succesor;
                            vars.add(p);
                            ++no;
                        }
                        if (i == memory.size() - 2) {
                            n = first - 1;
                            sz = succesor - first + 1;
                            p = this.collectinfo(vvs, n, sz);
                            Value vv2 = (Value)p.getFirst();
                            vv2.addContext("impactedOffset", n);
                            vv2.addContext("impactedSize", sz);
                            vars.add(p);
                            ++no;
                        }
                        ++i;
                    }
                }
                L.info("----------------------------------replace " + map.size() + " size " + no);
                continue;
            }
            vars.addAll(map);
        }
        return vars;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Value, Map<String, Object>> collectinfo(List<Pair<Value, Map<String, Object>>> vvs, int off, int sz) {
        void var7_8;
        Pair result = null;
        ArrayList<Pair<Value, Map<String, Object>>> list = new ArrayList<Pair<Value, Map<String, Object>>>();
        ArrayList<Integer> ints = new ArrayList<Integer>();
        boolean bl = false;
        while (var7_8 < vvs.size()) {
            Pair<Value, Map<String, Object>> p = vvs.get((int)var7_8);
            Value v = (Value)p.getFirst();
            int nOff = (Integer)v.getContext("impactedOffset");
            int nSz = (Integer)v.getContext("impactedSize");
            if (off <= nOff && nOff + nSz <= off + sz) {
                list.add(p);
                ints.add((int)var7_8);
            }
            ++var7_8;
        }
        for (Integer n : ints) {
            vvs.remove(n);
        }
        if (!list.isEmpty()) {
            for (Pair pair : list) {
                if (result == null) {
                    result = pair;
                    continue;
                }
                Map info = (Map)result.getSecond();
                Map info2 = (Map)pair.getSecond();
                Set orids = (Set)info.get("nodeORID");
                orids.addAll((Set)info2.get("nodeORID"));
                HashMap listimpOff = (HashMap)info.get("impact");
                HashMap listimpOff2 = (HashMap)info2.get("impact");
                if (listimpOff != null) {
                    if (listimpOff2 == null) continue;
                    for (String key : listimpOff2.keySet()) {
                        if (!listimpOff.containsKey(key)) {
                            listimpOff.put(key, (String)listimpOff2.get(key));
                            continue;
                        }
                        listimpOff.put(key, String.valueOf(off) + "," + sz + "," + off + "," + sz);
                    }
                    continue;
                }
                if (listimpOff2 == null) continue;
                info.put("impact", listimpOff2);
            }
        }
        return result;
    }

    @Override
    public Value searchAncestor(String rid, int imOff, int imsize, int varOff) {
        VertexValue vv = null;
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(ANCESTOR_SEARCH_QUERY.replace(MARKER_RID, rid))).execute(new Object[0]);
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            OrientElement oe = (OrientElement)iterator.next();
            String parentRid = (String)oe.getProperty("parentRid");
            OrientVertex parentVertex = (OrientVertex)this.dbg.getVertex((Object)parentRid);
            int pvoff = (Integer)oe.getProperty("memOffset");
            vv = new VertexValue(parentVertex);
            vv.addContext("memOffset", pvoff);
            boolean isNumeric = Expander.isNumeric((String)oe.getProperty("type"));
            int pvsize = (Integer)oe.getProperty("size");
            if (isNumeric) {
                vv.addContext("impactedOffset", 0);
                vv.addContext("impactedSize", pvsize);
            } else {
                if (rid.equals(parentRid)) {
                    vv.addContext("impactedOffset", imOff);
                    vv.addContext("impactedSize", imsize);
                } else {
                    int currImpactedOffset = varOff - pvoff + imOff;
                    if (currImpactedOffset >= pvsize) {
                        L.warn("out of range - searchAncestor: " + rid + " variable will be ignored");
                        return null;
                    }
                    vv.addContext("impactedOffset", currImpactedOffset);
                    vv.addContext("impactedSize", Math.min(imsize, pvsize - currImpactedOffset));
                }
                boolean doCompute = !isNumeric;
                int i = 0;
                boolean changed = false;
                int imOffset = (Integer)vv.getContext("impactedOffset");
                int imSize = (Integer)vv.getContext("impactedSize");
                Integer prgType = (Integer)oe.getProperty("prgType");
                while (doCompute) {
                    Pair newIm;
                    Pair pair = newIm = 1 == prgType ? this.getNumericChildren(parentVertex, imOffset, imSize) : new Pair((Object)imOffset, (Object)imSize);
                    if (imOffset != (Integer)newIm.getFirst() || imSize != (Integer)newIm.getSecond()) {
                        imOffset = (Integer)newIm.getFirst();
                        imSize = (Integer)newIm.getSecond();
                        changed = true;
                    } else {
                        doCompute = false;
                        vv.addContext("impactedOffset", imOffset);
                        vv.addContext("impactedSize", imSize);
                    }
                    ++i;
                }
                if (changed) {
                    L.debug("new " + parentVertex.getProperty("name") + " program " + oe.getProperty("prgName") + " -- impactedOffset = " + imOffset + " impactedSize " + imSize + "--- varoffset " + parentVertex.getProperty("memOffset") + " varSize " + parentVertex.getProperty("size"));
                    L.debug("new {} program {} -- impactedOffset = {} impactedSize {} --- varoffset {} varSize {}", new Object[]{parentVertex.getProperty("name"), oe.getProperty("prgName"), imOffset, imSize, parentVertex.getProperty("memOffset"), parentVertex.getProperty("size")});
                    L.debug("enlarge the impacted zone because it contains numeric children; recalculation steps {}", (Object)i);
                }
            }
            vv.addContext("programName", oe.getProperty("prgName"));
            vv.addContext("prg type id", oe.getProperty("prgType"));
            vv.addContext("prog_vertex_id", oe.getProperty("prgRid"));
            vv.addContext("var_sid", parentVertex.getProperty("sid"));
        }
        return vv;
    }

    private Pair<Integer, Integer> getNumericChildren(OrientVertex toExpand, int impactedOffset, int impactedSize) {
        Integer newIOffset = impactedOffset;
        Integer newISize = impactedSize;
        int varoff = (Integer)toExpand.getProperty("memOffset");
        if ((Integer)toExpand.getProperty("ancestor") == 0) {
            List<String> childrenRids = this.getChildrenWithFlow(toExpand.getId().toString(), impactedOffset, impactedSize, varoff, false);
            for (String r : childrenRids) {
                Vertex cV = this.dbg.getVertex((Object)r);
                if (!Expander.isNumeric((String)cV.getProperty("type"))) continue;
                int coff = (Integer)cV.getProperty("memOffset");
                int csize = (Integer)cV.getProperty("size");
                if (newIOffset > coff - varoff) {
                    int temp = newIOffset;
                    newIOffset = coff - varoff;
                    newISize = newISize + (temp - newIOffset);
                }
                if (coff - varoff + csize <= newIOffset + newISize) continue;
                newISize = newISize + (coff - varoff + csize - (impactedSize + impactedOffset));
            }
            if (toExpand.countEdges(Direction.IN, new String[]{"Redefines"}) > 0L) {
                String query = this.getVarRedefinesQuery();
                String toExpandRid = toExpand.getId().toString();
                Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.replaceAll(MARKER_RID, toExpandRid))).execute(new Object[0]);
                for (OrientElement oe : ret) {
                    OrientVertex ov = (OrientVertex)oe.getProperty("vrid");
                    int voff = (Integer)ov.getProperty("memOffset");
                    childrenRids = this.getChildrenWithFlow(ov.getId().toString(), newIOffset, newISize, voff, false);
                    for (String r : childrenRids) {
                        Vertex cV = this.dbg.getVertex((Object)r);
                        if (!Expander.isNumeric((String)cV.getProperty("type"))) continue;
                        int coff = (Integer)cV.getProperty("memOffset");
                        int csize = (Integer)cV.getProperty("size");
                        if (newIOffset > coff - varoff) {
                            int temp = newIOffset;
                            newIOffset = coff - varoff;
                            newISize = newISize + (temp - newIOffset);
                        }
                        if (coff - varoff + csize <= newIOffset + newISize) continue;
                        newISize = newISize + (coff - varoff + csize - (impactedSize + impactedOffset));
                    }
                }
            }
        }
        return new Pair((Object)newIOffset, (Object)newISize);
    }

    private List<String> getChildrenWithFlow(String pVarRid, int impactedOffset, int impactedSize, int varOff, boolean onlyNumeric) {
        ArrayList<String> results = new ArrayList<String>();
        String query = "select @rid.asString() as childRid , type from (traverse in('ChildOf') from MARKER_RID limit -1) where memOffset < ? and (memOffset + size) > ? limit -1";
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.replace(MARKER_RID, pVarRid))).execute(new Object[]{impactedOffset + impactedSize + varOff, impactedOffset + varOff});
        for (OrientElement oe : ret) {
            String vrid = (String)oe.getProperty("childRid");
            if (onlyNumeric && !Expander.isNumeric((String)oe.getProperty("type"))) continue;
            results.add(vrid);
        }
        return results;
    }

    @Override
    public String getVarRedefinesQuery() {
        return "select @rid as vrid from (traverse in('Redefines') from MARKER_RID) where @rid <> MARKER_RID";
    }

    @Override
    public boolean searchForRedefines(VertexValue expand, OrientVertex toExpand) {
        return toExpand.countEdges(Direction.IN, new String[]{"Redefines"}) > 0L && (Integer)toExpand.getProperty("ancestor") == 0;
    }

    private Map<Triplet<String, Integer, Integer>, Map<String, Object>> expandVarRedefines(OrientVertex toExpand, int impactedOffset, int impactedSize, Map<String, Map<String, Object>> impactedChildren, Set<Vertex> varForChildOf) {
        HashMap<Triplet, Map> impactedFromRedefines = null;
        String toExpandRid = toExpand.getId().toString();
        String query = this.getVarRedefinesQuery().replaceAll(MARKER_RID, toExpandRid);
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap maptemp = null;
        for (OrientElement oe : ret) {
            OrientVertex ov = (OrientVertex)oe.getProperty("vrid");
            OrientEdge defEdge = null;
            String direction = null;
            if (ov == null) {
                defEdge = (OrientEdge)oe.getProperty("rdef");
                if (toExpandRid.equals(defEdge.getVertex(Direction.OUT).getIdentity().toString())) {
                    ov = defEdge.getVertex(Direction.IN);
                    direction = REDEFINE_DIRECT;
                } else {
                    ov = defEdge.getVertex(Direction.OUT);
                    direction = REDEFINE_REVERSE;
                }
            }
            if (!this.processRedefineAsChild()) {
                String toRid;
                String childRid;
                String key;
                if (maptemp == null) {
                    maptemp = new HashMap();
                }
                if (maptemp.containsKey(key = this.makeKey(childRid = toExpand.getId().toString(), toRid = String.valueOf(ov.getId())))) {
                    Map info = (Map)maptemp.get(key);
                    Set oridInfo = (Set)info.get("nodeORID");
                    String fakeStmtRid = toRid;
                    oridInfo.add(fakeStmtRid);
                    Map m = (Map)info.get("impact");
                    m.put(fakeStmtRid, (String)info.get(key));
                    if (defEdge == null) continue;
                    info.put(REDEF_EDGE_ID, defEdge.getId().toString());
                    info.put(REDEF_EDGE_DIRECTION, direction);
                    continue;
                }
                Map<String, Object> map = impactedChildren.get(childRid);
                int impactedOffsetE = (Integer)map.get("impactedOffset");
                int impactedSizeE = (Integer)map.get("impactedSize");
                HashMap<String, Object> info = new HashMap<String, Object>();
                LinkedHashSet<String> oridInfo = new LinkedHashSet<String>();
                String fakeStmtRid = toRid;
                oridInfo.add(fakeStmtRid);
                info.put("nodeORID", oridInfo);
                if (defEdge != null) {
                    info.put(REDEF_EDGE_ID, defEdge.getId().toString());
                    info.put(REDEF_EDGE_DIRECTION, direction);
                }
                HashMap<String, String> m = new HashMap<String, String>();
                Integer voff = (Integer)map.get("memOffset");
                String offInfo = String.valueOf(voff + impactedOffsetE) + "," + impactedSizeE;
                m.put(fakeStmtRid, offInfo);
                info.put("impact", m);
                info.put(key, offInfo);
                int pvsize = (Integer)ov.getProperty("size");
                boolean isNumeric = Expander.isNumeric((String)ov.getProperty("type"));
                if (isNumeric) {
                    info.put("impactedOffset", 0);
                    info.put("impactedSize", pvsize);
                } else {
                    if (impactedOffsetE >= pvsize) {
                        L.debug("out of range - expandVarDataFlow");
                        continue;
                    }
                    info.put("impactedOffset", impactedOffsetE);
                    info.put("impactedSize", Math.min(impactedSizeE, pvsize - impactedOffsetE));
                }
                info.put("memOffset", ov.getProperty("memOffset"));
                info.put("size", pvsize);
                maptemp.put(key, info);
                continue;
            }
            varForChildOf.add((Vertex)ov);
        }
        if (maptemp != null) {
            impactedFromRedefines = new HashMap<Triplet, Map>();
            for (String key : maptemp.keySet()) {
                Map info = (Map)maptemp.get(key);
                Integer imOff = (Integer)info.remove("impactedOffset");
                Integer imSize = (Integer)info.remove("impactedSize");
                if (REDEFINE_REVERSE.equals(info.get(REDEF_EDGE_DIRECTION))) {
                    info.put(REDEFINE_PROCESSED, Boolean.TRUE);
                }
                impactedFromRedefines.put(new Triplet((Object)key.substring(key.indexOf(KEY_SEPARATOR) + 1), (Object)imOff, (Object)imSize), info);
            }
        }
        return impactedFromRedefines;
    }

    private void expandVarChildOf(Vertex toExpand, int impactedOffset, int impactedSize, Map<String, Map<String, Object>> impactedChildren) {
        int varOff = (Integer)toExpand.getProperty("memOffset");
        String query = "select @rid.asString() as childRid from (traverse in('ChildOf') from AD_FROM limit -1) where memOffset < ? and (memOffset + size) > ? limit -1";
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.replace("AD_FROM", toExpand.getId().toString()))).execute(new Object[]{impactedOffset + impactedSize + varOff, impactedOffset + varOff});
        for (OrientElement oe : ret) {
            String rid = (String)oe.getProperty("childRid");
            OrientVertex v = (OrientVertex)this.dbg.getVertex((Object)rid);
            int voff = (Integer)v.getProperty("memOffset");
            int vsize = (Integer)v.getProperty("size");
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            boolean isNumeric = Expander.isNumeric((String)v.getProperty("type"));
            if (isNumeric) {
                info.put("impactedOffset", 0);
                info.put("impactedSize", vsize);
                info.put("memOffset", voff);
            } else {
                if (impactedOffset >= voff - varOff + vsize || impactedOffset + impactedSize <= voff - varOff) {
                    L.warn("out of range - expandVarChildOf - child - must be excluded from query's results");
                }
                int currentImpactedOffset = 0;
                if (voff >= varOff && voff - varOff < impactedOffset) {
                    currentImpactedOffset = impactedOffset - (voff - varOff);
                }
                if (currentImpactedOffset >= vsize) {
                    L.debug("out of range - expandVarChildOf -child");
                    continue;
                }
                info.put("impactedOffset", currentImpactedOffset);
                info.put("impactedSize", Math.min(Math.min(impactedSize, varOff + impactedOffset + impactedSize - voff), vsize - currentImpactedOffset));
                info.put("memOffset", voff);
            }
            impactedChildren.put(rid, info);
        }
    }

    protected boolean hasBackward(OrientVertex v) {
        return v.countEdges(Direction.IN, new String[]{"ProxyFor"}) > 0L;
    }

    protected boolean hasForward(OrientVertex v) {
        return v.countEdges(Direction.IN, new String[]{"APDefinedBy"}) > 0L;
    }

    protected boolean hasInternalCallForward(OrientVertex v) {
        return false;
    }

    private boolean getDFDirection(Boolean pCallFW) {
        return this.forward ? this.forward : pCallFW != null && pCallFW != false;
    }

    private boolean expandVarArgumentsForward(VertexValue expand, Map<String, Map<String, Object>> impactedChildren, Map<Triplet<String, Integer, Integer>, Map<String, Object>> vars, Set<String> childrenForForwardCall) {
        boolean hasMissingPrgInfo = false;
        Set callingOrCalledPrgVertexRids = (Set)expand.getContext("via call information");
        CloseableIterable forwardCallResult = null;
        String query = this.getQueryForForward(callingOrCalledPrgVertexRids);
        if (callingOrCalledPrgVertexRids != null) {
            String queryWithCallRestrictionF2 = query.replace(MARKER_RID, childrenForForwardCall.toString());
            queryWithCallRestrictionF2 = queryWithCallRestrictionF2.replace(RESTRICTIONS_MARKER, callingOrCalledPrgVertexRids.toString());
            forwardCallResult = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryWithCallRestrictionF2)).execute(new Object[0]);
        } else {
            String queryF2 = query.replace(MARKER_RID, childrenForForwardCall.toString());
            forwardCallResult = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryF2)).execute(new Object[0]);
        }
        HashMap added = new HashMap();
        for (OrientElement res : forwardCallResult) {
            String childRid = (String)res.getProperty("childRid");
            if (res.getProperty("varrid") == null) {
                HashSet<String> missingRids = (HashSet<String>)expand.getContext("MISSING_PRG_CALLS");
                if (missingRids == null) {
                    missingRids = new HashSet<String>();
                    expand.addContext("MISSING_PRG_CALLS", missingRids);
                }
                missingRids.add((String)res.getProperty("stmtRids"));
                hasMissingPrgInfo = true;
                continue;
            }
            Vertex v = (Vertex)res.getProperty("varrid");
            String ridStr = v.getId().toString();
            String key = this.makeKey(childRid, ridStr);
            if (added.containsKey(key)) {
                Map info = (Map)added.get(key);
                Set oridInfo = (Set)info.get("nodeORID");
                String stmtRid = (String)res.getProperty("stmtRids");
                oridInfo.add(stmtRid);
                Map m = (Map)info.get("impact");
                m.put(stmtRid, (String)info.get(key));
                this.computeLSVarMapping(res, (Long)expand.getContext("ImpactGraph node id"), stmtRid);
                continue;
            }
            Map<String, Object> map = impactedChildren.get(childRid);
            int impactedOffset = (Integer)map.get("impactedOffset");
            int impactedSize = (Integer)map.get("impactedSize");
            int memOffset = (Integer)map.get("memOffset");
            int voff = (Integer)v.getProperty("memOffset");
            int vsize = (Integer)v.getProperty("size");
            boolean isNumeric = Expander.isNumeric((String)v.getProperty("type"));
            Integer imOff = null;
            Integer imSize = null;
            if (isNumeric) {
                imOff = 0;
                imSize = vsize;
            } else {
                if (impactedOffset >= vsize) {
                    L.debug("out of range - expandVarArguments - forward");
                    continue;
                }
                imOff = impactedOffset;
                imSize = Math.min(impactedSize, vsize - impactedOffset);
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("memOffset", voff);
            info.put("size", vsize);
            if (!this.forward) {
                info.put("reverse impact direction", Boolean.TRUE);
            }
            HashSet<String> prgCallInfo = new HashSet<String>();
            String prgVertexRid = (String)expand.getContext("prog_vertex_id");
            prgCallInfo.add(prgVertexRid);
            info.put("via call information", prgCallInfo);
            info.put("programCallDirection", Boolean.TRUE);
            info.put(PCALLFW, Boolean.TRUE);
            LinkedHashSet<String> oridInfo = new LinkedHashSet<String>();
            String stmtRid = (String)res.getProperty("stmtRids");
            HashMap<String, String> m = new HashMap<String, String>();
            oridInfo.add(stmtRid);
            String offInfo = String.valueOf(memOffset + impactedOffset) + "," + impactedSize;
            m.put(stmtRid, offInfo);
            info.put("nodeORID", oridInfo);
            info.put("impact", m);
            info.put(key, offInfo);
            added.put(key, info);
            this.computeLSVarMapping(res, (Long)expand.getContext("ImpactGraph node id"), stmtRid);
            vars.put((Triplet<String, Integer, Integer>)new Triplet((Object)ridStr, (Object)imOff, (Object)imSize), info);
        }
        forwardCallResult.close();
        return hasMissingPrgInfo;
    }

    private void expandCallExprForward(VertexValue expand, Map<String, Map<String, Object>> impactedChildren, Map<Triplet<String, Integer, Integer>, Map<String, Object>> vars, Set<String> childrenForForwardInternalCall) {
        String query = this.getQueryForInternalForward(null);
        String queryF2 = query.replace(MARKER_RID, childrenForForwardInternalCall.toString());
        CloseableIterable forwardCallResult = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(queryF2)).execute(new Object[0]);
        HashMap added = new HashMap();
        Set intCallRestr = (Set)expand.getContext(INTERNAL_CALL_RESTRICTIONS);
        for (OrientElement res : forwardCallResult) {
            String ridStr;
            Vertex pf = (Vertex)res.getProperty("formalPar");
            if (pf == null) {
                L.warn("could not match formal parameter {}", childrenForForwardInternalCall);
                continue;
            }
            String childRid = (String)res.getProperty("childRid");
            String key = this.makeKey(childRid, ridStr = pf.getId().toString());
            if (added.containsKey(key)) {
                Map info = (Map)added.get(key);
                String varParam = (String)res.getProperty("varParam");
                Set ct = (Set)info.get(INTERNAL_VAR_PARAMS);
                ct.add(varParam);
                info.put(INTERNAL_VAR_PARAMS, ct);
                Set oridInfo = (Set)info.get("nodeORID");
                oridInfo.add(varParam);
                continue;
            }
            String varParam = (String)res.getProperty("varParam");
            if (intCallRestr != null) {
                Vertex vpV;
                String varPos;
                String callExp = (String)res.getProperty("ce");
                Vertex callExpV = this.dbg.getVertex((Object)callExp);
                String cbName = (String)((Vertex)callExpV.getVertices(Direction.OUT, new String[]{"calledBlock"}).iterator().next()).getProperty("name");
                if (intCallRestr.contains(this.makeKey(cbName, varPos = String.valueOf((vpV = this.dbg.getVertex((Object)varParam)).getProperty("paramPos"))))) {
                    L.debug("skip this call because already processed");
                    continue;
                }
            }
            Map<String, Object> map = impactedChildren.get(childRid);
            int impactedOffset = (Integer)map.get("impactedOffset");
            int impactedSize = (Integer)map.get("impactedSize");
            int memOffset = (Integer)map.get("memOffset");
            int voff = (Integer)pf.getProperty("memOffset");
            int vsize = (Integer)pf.getProperty("size");
            boolean isNumeric = Expander.isNumeric((String)pf.getProperty("type"));
            Integer imOff = null;
            Integer imSize = null;
            if (isNumeric) {
                imOff = 0;
                imSize = vsize;
            } else {
                if (impactedOffset >= vsize) {
                    L.debug("out of range - expandVarArguments - forward");
                    continue;
                }
                imOff = impactedOffset;
                imSize = Math.min(impactedSize, vsize - impactedOffset);
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("memOffset", voff);
            info.put("size", vsize);
            if (!this.forward) {
                info.put("reverse impact direction", Boolean.TRUE);
            }
            HashSet<String> prgCallInfo = new HashSet<String>();
            String prgVertexRid = (String)expand.getContext("prog_vertex_id");
            prgCallInfo.add(prgVertexRid);
            info.put("via call information", prgCallInfo);
            info.put("programCallDirection", Boolean.TRUE);
            info.put(PCALLFW, Boolean.TRUE);
            LinkedHashSet<String> oridInfo = new LinkedHashSet<String>();
            HashMap<String, String> m = new HashMap<String, String>();
            oridInfo.add(varParam);
            String offInfo = String.valueOf(memOffset + impactedOffset) + "," + impactedSize;
            m.put(varParam, offInfo);
            info.put("nodeORID", oridInfo);
            info.put("impact", m);
            info.put(key, offInfo);
            info.put(IS_INTERNAL_VAR_OR_EXPR_PARAM_FROM_CALL, "varParam");
            info.put(FORMAL_PARAM_RID, ridStr);
            HashSet<String> ct = new HashSet<String>();
            ct.add(varParam);
            info.put(INTERNAL_VAR_PARAMS, ct);
            added.put(key, info);
            vars.put((Triplet<String, Integer, Integer>)new Triplet((Object)ridStr, (Object)imOff, (Object)imSize), info);
        }
        forwardCallResult.close();
    }

    private String makeKey(String first, String second) {
        return first.concat(KEY_SEPARATOR).concat(second);
    }

    protected String getQueryForForward(Set<String> callingOrCalledPrgVertexRids) {
        if (callingOrCalledPrgVertexRids != null) {
            return queryWithCallRestrictionF;
        }
        return queryF;
    }

    protected String getQueryForInternalForward(Set<String> callingOrCalledPrgVertexRids) {
        return null;
    }

    private void computeLSVarMapping(OrientElement res, Long nodeId, String stmtRid) {
        String fromVars = (String)res.getProperty("fromVars");
        String[] fromVarsArray = this.splitResult(fromVars);
        String toVars = (String)res.getProperty("toVars");
        String[] toVarsArray = this.splitResult(toVars);
        String[] paramPosArray = null;
        if (fromVarsArray.length != toVarsArray.length) {
            String paramPos = (String)res.getProperty("paramPos");
            paramPosArray = this.splitResult(paramPos);
        } else {
            paramPosArray = new String[toVarsArray.length];
            int i = 0;
            while (i < paramPosArray.length) {
                paramPosArray[i] = String.valueOf(i + 1);
                ++i;
            }
        }
        int i = 0;
        while (i < paramPosArray.length) {
            int pos = Integer.valueOf(paramPosArray[i]) - 1;
            if (pos >= toVarsArray.length) {
                L.warn("formal parameter not found!!! skip dataflow for " + fromVarsArray[i]);
            } else {
                Set<String> stmts;
                Map<String, Set<String>> info;
                Map<Long, Map<String, Set<String>>> mm = this.varmap.get(toVarsArray[pos]);
                if (mm == null) {
                    mm = new HashMap<Long, Map<String, Set<String>>>();
                    this.varmap.put(toVarsArray[pos], mm);
                }
                if ((info = mm.get(nodeId)) == null) {
                    info = new HashMap<String, Set<String>>();
                    mm.put(nodeId, info);
                }
                if ((stmts = info.get(fromVarsArray[i])) == null) {
                    stmts = new HashSet<String>();
                    info.put(fromVarsArray[i], stmts);
                }
                stmts.add(stmtRid);
            }
            ++i;
        }
    }

    private void expandVarRedefines(VertexValue expand, int impactedOffset, int impactedSize, List<Pair<? extends Value, Map<String, Object>>> vars) {
        OrientVertex toExpand = expand.asVertex(this.dbg);
        Iterable itble = toExpand.getVertices(Direction.BOTH, new String[]{"Redefines"});
        int varoff = (Integer)toExpand.getProperty("memOffset");
        HashMap<String, Pair> maptemp = new HashMap<String, Pair>();
        for (Vertex v : itble) {
            int voff = (Integer)v.getProperty("memOffset");
            int vsize = (Integer)v.getProperty("size");
            if (varoff != voff) {
                L.warn("different offsets for variable and redefined variable, so skip it");
                continue;
            }
            VertexValue vv = null;
            boolean isNumeric = Expander.isNumeric((String)v.getProperty("type"));
            if (isNumeric) {
                vv = new VertexValue((OrientVertex)v);
                vv.addContext("impactedOffset", 0);
                vv.addContext("impactedSize", vsize);
            } else {
                if (impactedOffset >= vsize) {
                    L.debug("out of range - expandVarRedefines");
                    continue;
                }
                vv = new VertexValue((OrientVertex)v);
                vv.addContext("impactedOffset", impactedOffset);
                vv.addContext("impactedSize", Math.min(impactedSize, vsize - impactedOffset));
            }
            Vertex prgV = (Vertex)v.getVertices(Direction.IN, new String[]{"HasV"}).iterator().next();
            vv.addContext("programName", prgV.getProperty("name"));
            vv.addContext("prg type id", prgV.getProperty("type"));
            vv.addContext("prog_vertex_id", prgV.getId().toString());
            vv.addContext("variable first parent", Impact.getFirstParentName(this.dbg, v));
            vv.addContext("var_sid", v.getProperty("sid"));
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("link", "Redefinition");
            maptemp.put(v.getId().toString(), new Pair((Object)vv, info));
        }
        ArrayList list = new ArrayList(maptemp.keySet());
        Collections.sort(list);
        for (String r : list) {
            vars.add((Pair<? extends Value, Map<String, Object>>)((Pair)maptemp.get(r)));
        }
    }

    private void expandVarChildOf(VertexValue expand, int impactedOffset, int impactedSize, List<Pair<? extends Value, Map<String, Object>>> vars) {
        OrientVertex toExpand = expand.asVertex(this.dbg);
        int varOff = (Integer)toExpand.getProperty("memOffset");
        Vertex prgV = (Vertex)toExpand.getVertices(Direction.IN, new String[]{"HasV"}).iterator().next();
        String programName = (String)prgV.getProperty("name");
        Iterable itble = toExpand.getVertices(Direction.OUT, new String[]{"ChildOf"});
        for (Vertex v : itble) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("link", this.forward ? "Child of" : "Parent of");
            info.put("dependency_restriction", (String)info.get("link"));
            VertexValue vv = new VertexValue((OrientVertex)v);
            int pvoff = (Integer)v.getProperty("memOffset");
            int pvsize = (Integer)v.getProperty("size");
            boolean isNumeric = Expander.isNumeric((String)v.getProperty("type"));
            if (isNumeric) {
                vv = new VertexValue((OrientVertex)v);
                vv.addContext("impactedOffset", 0);
                vv.addContext("impactedSize", pvsize);
            } else {
                int currImpactedOffset = varOff - pvoff + impactedOffset;
                if (currImpactedOffset >= pvsize) {
                    L.debug("out of range - expandVarChildOf - parent");
                    continue;
                }
                vv.addContext("impactedOffset", currImpactedOffset);
                vv.addContext("impactedSize", Math.min(impactedSize, pvsize - currImpactedOffset));
            }
            vv.addContext("pgmContextRid", expand.getContext("pgmContextRid"));
            vv.addContext(DDCARDS_RESTRICTION, expand.getContext(DDCARDS_RESTRICTION));
            vv.addContext(STEP_RESTRICTION, expand.getContext(STEP_RESTRICTION));
            vv.addContext("programName", programName);
            vv.addContext("prg type id", prgV.getProperty("type"));
            vv.addContext("prog_vertex_id", prgV.getId().toString());
            vv.addContext("var_sid", v.getProperty("sid"));
            vv.addContext("variable first parent", Impact.getFirstParentName(this.dbg, v));
            vars.add((Pair<? extends Value, Map<String, Object>>)new Pair((Object)vv, info));
        }
        String query = "select c.@rid.asString() as childRid from (select in('ChildOf') as c from AD_FROM unwind c ) where c.memOffset < ? and (c.memOffset + c.size) > ? limit -1";
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(query.replace("AD_FROM", toExpand.getId().toString()))).execute(new Object[]{impactedOffset + impactedSize + varOff, impactedOffset + varOff});
        for (OrientElement oe : ret) {
            OrientVertex v = (OrientVertex)this.dbg.getVertex(oe.getProperty("childRid"));
            int voff = (Integer)v.getProperty("memOffset");
            int vsize = (Integer)v.getProperty("size");
            VertexValue vv = null;
            boolean isNumeric = Expander.isNumeric((String)v.getProperty("type"));
            if (isNumeric) {
                vv = new VertexValue(v);
                vv.addContext("impactedOffset", 0);
                vv.addContext("impactedSize", vsize);
            } else {
                if (impactedOffset >= voff - varOff + vsize || impactedOffset + impactedSize <= voff - varOff) {
                    L.warn("out of range - expandVarChildOf - child - must be excluded from query's results");
                }
                int currentImpactedOffset = 0;
                if (voff >= varOff && voff - varOff < impactedOffset) {
                    currentImpactedOffset = impactedOffset - (voff - varOff);
                }
                if (currentImpactedOffset >= vsize) {
                    L.debug("out of range - expandVarChildOf -child");
                    continue;
                }
                vv = new VertexValue(v);
                vv.addContext("impactedOffset", currentImpactedOffset);
                vv.addContext("impactedSize", Math.min(Math.min(impactedSize, varOff + impactedOffset + impactedSize - voff), vsize - currentImpactedOffset));
            }
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("link", this.forward ? "Parent of" : "Child of");
            info.put("dependency_restriction", (String)info.get("link"));
            vv.addContext("pgmContextRid", expand.getContext("pgmContextRid"));
            vv.addContext(DDCARDS_RESTRICTION, expand.getContext(DDCARDS_RESTRICTION));
            vv.addContext(STEP_RESTRICTION, expand.getContext(STEP_RESTRICTION));
            vv.addContext("programName", programName);
            vv.addContext("prog_vertex_id", prgV.getId().toString());
            vv.addContext("var_sid", v.getProperty("sid"));
            vv.addContext("variable first parent", Impact.getFirstParentName(this.dbg, (Vertex)v));
            vars.add((Pair<? extends Value, Map<String, Object>>)new Pair((Object)vv, info));
        }
    }

    private void expandVarDataFlow(VertexValue expand, boolean direction, Map<String, Map<String, Object>> impactedChildren, Map<Triplet<String, Integer, Integer>, Map<String, Object>> vars, Set<String> childrenForDataflow) {
        String query = direction ? queryFDataFlow : queryBDataFlow;
        query = query.replace(MARKER_RID, childrenForDataflow.toString());
        CloseableIterable result = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[0]);
        HashMap<String, Map<Object, Object>> maptemp = new HashMap<String, Map<Object, Object>>();
        for (OrientElement oe : result) {
            String toRid;
            String childRid = (String)oe.getProperty("fromRid");
            String key = this.makeKey(childRid, toRid = (String)oe.getProperty("toRid"));
            if (maptemp.containsKey(key)) {
                Map info = (Map)maptemp.get(key);
                Set oridInfo = (Set)info.get("nodeORID");
                String stmtRid = (String)oe.getProperty("stmtRid");
                oridInfo.add(stmtRid);
                Map m = (Map)info.get("impact");
                m.put(stmtRid, (String)info.get(key));
                continue;
            }
            Map<String, Object> map = impactedChildren.get(childRid);
            int impactedOffset = (Integer)map.get("impactedOffset");
            int impactedSize = (Integer)map.get("impactedSize");
            Map<Object, Object> info = null;
            Vertex v = this.dbg.getVertex((Object)toRid);
            boolean isVariable = v.getProperty("@class").equals("Variable");
            if (isVariable) {
                info = this.computeVarOffsets(v, impactedOffset, impactedSize);
            } else {
                info = new HashMap<String, Object>();
                info.put("resUsageInfoFromDataFlow", oe.getProperty("prgRid"));
                if (v.getProperty("@class").equals("SQLFieldProxy")) {
                    String tableName = (String)v.getProperty("tableName");
                    info.put("sql.tablename", tableName);
                }
            }
            if (info == null) continue;
            LinkedHashSet<String> oridInfo = new LinkedHashSet<String>();
            String stmtRid = (String)oe.getProperty("stmtRid");
            oridInfo.add(stmtRid);
            info.put("nodeORID", oridInfo);
            HashMap<String, String> m = new HashMap<String, String>();
            Integer voff = (Integer)map.get("memOffset");
            String offInfo = String.valueOf(voff + impactedOffset) + "," + impactedSize;
            m.put(stmtRid, offInfo);
            info.put("impact", m);
            info.put(key, offInfo);
            maptemp.put(key, info);
        }
        for (String key : maptemp.keySet()) {
            Map info = (Map)maptemp.get(key);
            Integer imOff = (Integer)info.remove("impactedOffset");
            Integer imSize = (Integer)info.remove("impactedSize");
            vars.put((Triplet<String, Integer, Integer>)new Triplet((Object)key.substring(key.indexOf(KEY_SEPARATOR) + 1), (Object)imOff, (Object)imSize), info);
        }
    }

    private Map<String, Object> computeVarOffsets(Vertex targetV, int impactedOffset, int impactedSize) {
        if ("expParam".equals(targetV.getProperty("@class"))) {
            targetV = (Vertex)targetV.getVertices(Direction.OUT, new String[]{"mapsFormalParam"}).iterator().next();
        }
        int pvsize = (Integer)targetV.getProperty("size");
        boolean isNumeric = Expander.isNumeric((String)targetV.getProperty("type"));
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (isNumeric) {
            info.put("impactedOffset", 0);
            info.put("impactedSize", pvsize);
        } else {
            if (impactedOffset >= pvsize) {
                L.debug("out of range - expandVarDataFlow " + targetV.getId());
                return null;
            }
            info.put("impactedOffset", impactedOffset);
            info.put("impactedSize", Math.min(impactedSize, pvsize - impactedOffset));
        }
        info.put("memOffset", targetV.getProperty("memOffset"));
        info.put("size", pvsize);
        return info;
    }

    private int[] intersect(int voff, int vsize, int impactedOffset, int impactedSize) {
        int[] nArray;
        boolean ok = false;
        int iOffset = 0;
        int iSize = 0;
        if (voff + vsize - 1 < impactedOffset || voff > impactedOffset + impactedSize - 1) {
            ok = false;
        } else {
            iOffset = Math.max(impactedOffset, voff);
            iSize = Math.min(impactedOffset + impactedSize, voff + vsize - 1) - iOffset + 1;
            ok = true;
        }
        if (ok) {
            int[] nArray2 = new int[2];
            nArray2[0] = iOffset;
            nArray = nArray2;
            nArray2[1] = iSize;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static boolean isNumeric(String varType) {
        boolean ret = numericVarTypes.contains(varType);
        return ret;
    }

    @Override
    public Node resolveConflict(List<Node> nl, Value ev) {
        Node ret = null;
        Node ret2 = null;
        if (nl != null) {
            VertexValue vv = (VertexValue)ev;
            String ovClass = vv.getVertexClass();
            String vid = vv.id();
            for (Node n : nl) {
                VertexValue procd = (VertexValue)n.value();
                String pid = procd.id();
                if (ovClass.equals("Variable") && "Variable".equals(procd.getVertexClass())) {
                    if (!pid.equals(vid) || (vv.getContext(CONTEXT_CB_PARAMS) != null || procd.getContext(CONTEXT_CB_PARAMS) != null) && (vv.getContext(CONTEXT_CB_PARAMS) == null || !vv.getContext(CONTEXT_CB_PARAMS).equals(procd.getContext(CONTEXT_CB_PARAMS)))) continue;
                    int newIOff = (Integer)vv.getContext("impactedOffset");
                    int newISize = (Integer)vv.getContext("impactedSize");
                    int procIOff = (Integer)procd.getContext("impactedOffset");
                    int procISize = (Integer)procd.getContext("impactedSize");
                    Object step1 = vv.getContext(STEP_RESTRICTION);
                    Object step2 = procd.getContext(STEP_RESTRICTION);
                    if ((step1 != null || step2 != null) && (step1 == null || !step1.equals(step2))) continue;
                    if (newIOff == procIOff && newISize == procISize) {
                        L.trace("already processed variable " + vid);
                        ret = n;
                        break;
                    }
                    if (newIOff < procIOff || newISize > procISize - (newIOff - procIOff)) continue;
                    ret = n;
                    continue;
                }
                if (ovClass.equals("DDNameProxy")) {
                    if (!pid.equals(vid) || !ev.getContext("resUsageInfoFromDataFlow").equals(n.value().getContext("resUsageInfoFromDataFlow"))) continue;
                    Object step1 = vv.getContext(STEP_RESTRICTION);
                    Object step2 = procd.getContext(STEP_RESTRICTION);
                    if ((step1 != null || step2 != null) && (step1 == null || !step1.equals(step2))) continue;
                    ret = n;
                    break;
                }
                if (!pid.equals(vid)) continue;
                ret = n;
                break;
            }
        }
        ret = ret != null ? ret : ret2;
        return ret;
    }

    @Override
    public Map<Long, Map<String, Set<String>>> getCallsInfo(String lsRid) {
        Map<Long, Map<String, Set<String>>> toAddFromSubprgInfo = this.varmap.get(lsRid);
        return toAddFromSubprgInfo;
    }

    @Override
    public List<Pair<? extends Value, Map<String, Object>>> addImpactedVars(Value lsv, Long fromNodeId, Map<String, Set<String>> impactedVars) {
        if (impactedVars == null) {
            if (this.forward) {
                return null;
            }
            impactedVars = this.getVarFromAllCalls(lsv.id());
        }
        ArrayList<Pair<? extends Value, Map<String, Object>>> vars = new ArrayList<Pair<? extends Value, Map<String, Object>>>();
        String calledPrgRid = (String)lsv.getContext("prog_vertex_id");
        for (String vrid : impactedVars.keySet()) {
            OrientVertex vv = (OrientVertex)this.dbg.getVertex((Object)vrid);
            VertexValue vvsp = new VertexValue(vv);
            HashMap<String, Object> info = new HashMap<String, Object>();
            vvsp.addContext("pgmContextRid", lsv.getContext("pgmContextRid"));
            vvsp.addContext(DDCARDS_RESTRICTION, lsv.getContext(DDCARDS_RESTRICTION));
            vvsp.addContext(STEP_RESTRICTION, lsv.getContext(STEP_RESTRICTION));
            Set<String> stmtSet = impactedVars.get(vrid);
            info.put("nodeORID", stmtSet);
            info.put("programCallDirection", Boolean.TRUE);
            info.put("REQUIRED_NODE_ID_ON_PATH", fromNodeId);
            if (this.forward) {
                info.put("reverse impact direction", Boolean.TRUE);
            }
            int impactedOffset = (Integer)lsv.getContext("impactedOffset");
            int impactedSize = (Integer)lsv.getContext("impactedSize");
            int voff = (Integer)vv.getProperty("memOffset");
            vvsp.addContext("impactedOffset", impactedOffset);
            vvsp.addContext("impactedSize", impactedSize);
            vvsp.addContext("memOffset", voff);
            HashMap<String, String> impMap = new HashMap<String, String>();
            int lsvoff = (Integer)lsv.getContext("memOffset");
            String offInfo = String.valueOf(lsvoff + impactedOffset) + "," + impactedSize + "," + (voff + impactedOffset) + "," + impactedSize;
            for (String stmtrid : stmtSet) {
                impMap.put(stmtrid, offInfo);
            }
            info.put("impact", impMap);
            Vertex pv = (Vertex)vv.getVertices(Direction.IN, new String[]{"HasV"}).iterator().next();
            vvsp.addContext("programName", pv.getProperty("name"));
            vvsp.addContext("prg type id", pv.getProperty("type"));
            vvsp.addContext("var_sid", vv.getProperty("sid"));
            vvsp.addContext("prog_vertex_id", pv.getId().toString());
            HashSet<String> prgRestrictionSet = new HashSet<String>();
            prgRestrictionSet.add(calledPrgRid);
            vvsp.addContext("via call information", prgRestrictionSet);
            vars.add((Pair<? extends Value, Map<String, Object>>)new Pair((Object)vvsp, info));
        }
        return vars;
    }

    private Map<String, Set<String>> getVarFromAllCalls(String rid) {
        HashMap<String, Set<String>> impactedVars = new HashMap<String, Set<String>>();
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(this.getQueryFormalToActualP().replace(MARKER_RID, rid))).execute(new Object[0]);
        for (OrientElement oe : ret) {
            String vars = (String)oe.getProperty("vars");
            String[] varArray = this.splitResult(vars);
            if (varArray == null) continue;
            String stmts = (String)oe.getProperty("stmts");
            String[] stmtsArray = this.splitResult(stmts);
            int i = 0;
            while (i < varArray.length) {
                HashSet<String> stmtSet = (HashSet<String>)impactedVars.get(varArray[i]);
                if (stmtSet == null) {
                    stmtSet = new HashSet<String>();
                    impactedVars.put(varArray[i], stmtSet);
                }
                stmtSet.add(stmtsArray[i]);
                ++i;
            }
        }
        return impactedVars;
    }

    public String getQueryFormalToActualP() {
        return "select  $apu.out('APDefinedBy').@rid.asString() as vars, $apu.@rid.asString() as stmts from MARKER_RID\n let $apu = in('ProxyFor').in('ActualParameter') limit -1";
    }

    @Override
    public boolean shouldStopAtDataSource() {
        return false;
    }

    @Override
    public boolean incrementLevel(int nodeType) {
        return 1 == nodeType;
    }

    @Override
    public boolean compactContinueMemoryArea() {
        return true;
    }

    @Override
    public boolean processRedefineAsChild() {
        return true;
    }
}

