/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.internal.utils.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpandAtProgramLevel
implements INodeExpander {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public List<Pair<Long, Set<String>>> expand(ImpactGraph ig, boolean forward, Link startEdge, Node toExpand, Set<String> orids) {
        Value pv = toExpand.value();
        if (pv.type() == 2) {
            Map mapping = (Map)pv.getContext(forward ? "inToOut" : "outToIn");
            Map cfr_ignored_0 = (Map)startEdge.info("impact");
            Set ret = (Set)mapping.get(startEdge.getId());
            ArrayList<Pair> res = null;
            if (ret != null && orids != null) {
                res = new ArrayList<Pair>();
                for (Long lId : ret) {
                    Link link = ig.getLink(lId);
                    Map offMap = (Map)link.info("impact");
                    res.add(new Pair((Object)lId, offMap.keySet()));
                }
            } else if (orids == null && ret != null) {
                res = new ArrayList();
                for (Long lId : ret) {
                    Link link = ig.getLink(lId);
                    Map offMap = (Map)link.info("impact");
                    res.add(new Pair((Object)lId, offMap.keySet()));
                }
            }
            return res;
        }
        List<Long> ret = toExpand.out(2);
        ArrayList<Pair> res = null;
        if (ret != null) {
            res = new ArrayList<Pair>();
            Iterator<Long> iterator = ret.iterator();
            while (iterator.hasNext()) {
                Long lId;
                Link link = ig.getLink(lId = iterator.next());
                Map soffMap = (Map)link.info("impact");
                res.add(new Pair((Object)lId, soffMap != null ? soffMap.keySet() : null));
            }
        }
        return res;
    }
}

