/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact.model;

import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.internal.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpandAtOffsets
implements INodeExpander {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Set<List<Long>> prgs;

    @Override
    public List<Pair<Long, Set<String>>> expand(ImpactGraph ig, boolean forward, Link startEdge, Node toExpand, Set<String> orids) {
        List<Long> nextEdges;
        List<Long> list = nextEdges = forward ? toExpand.out(1) : toExpand.in(1);
        if (startEdge == null || startEdge.info("impact") == null || !"Variable".equals(toExpand.value().getVertexClass())) {
            ArrayList<Pair<Long, Set<String>>> ret = new ArrayList<Pair<Long, Set<String>>>();
            Iterator<Long> iterator = nextEdges.iterator();
            while (iterator.hasNext()) {
                Long lId;
                Link link = ig.getLink(lId = iterator.next());
                Map soffMap = (Map)link.info("impact");
                ret.add((Pair<Long, Set<String>>)new Pair((Object)lId, soffMap != null ? soffMap.keySet() : null));
            }
            return ret;
        }
        long prg = ig.getLink(toExpand.out(8).get(0)).to();
        Map soffMap = (Map)startEdge.info("impact");
        ArrayList<Pair<Long, Set<String>>> rs = new ArrayList<Pair<Long, Set<String>>>();
        for (long lId : nextEdges) {
            Link link = ig.getLink(lId);
            long nextNode = forward ? link.to() : link.from();
            Node node = ig.getNode(nextNode);
            if ("Variable".equals(node.value().getVertexClass())) {
                long nextPrg = ig.getLink(node.out(8).get(0)).to();
                boolean found = false;
                for (List<Long> list2 : this.prgs) {
                    int idx = list2.indexOf(prg);
                    int nextidx = list2.indexOf(nextPrg);
                    if (idx == -1 || nextidx == -1 || idx != nextidx && !list2.toString().contains(String.valueOf(nextPrg) + ", " + prg) && !list2.toString().contains(String.valueOf(prg) + ", " + nextPrg)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            Map offMap = (Map)link.info("impact");
            HashSet<String> filteredOrids = new HashSet<String>();
            for (String ckey : orids) {
                String[] cim = ((String)soffMap.get(ckey)).split(",");
                ArrayList<Integer> clist = new ArrayList<Integer>();
                int i = 1;
                while (i <= Integer.valueOf(cim[3])) {
                    clist.add(Integer.valueOf(cim[2]) + i);
                    ++i;
                }
                for (String key : offMap.keySet()) {
                    String[] im = ((String)offMap.get(key)).split(",");
                    ArrayList<Integer> list3 = new ArrayList<Integer>();
                    int i2 = 1;
                    while (i2 <= Integer.valueOf(im[1])) {
                        list3.add(Integer.valueOf(im[0]) + i2);
                        ++i2;
                    }
                    if (Collections.disjoint(clist, list3)) continue;
                    filteredOrids.add(key);
                }
            }
            if (filteredOrids.isEmpty()) continue;
            rs.add((Pair<Long, Set<String>>)new Pair((Object)lId, filteredOrids));
        }
        return rs;
    }

    public void setPrgs(Set<List<Long>> prgs) {
        this.prgs = prgs;
    }
}

