/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact;

import com.ez.graphs.viewer.odb.impact.ReportInfo;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.Value;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReportPathHandler
implements PathHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportPathHandler.class);
    private ImpactGraph ig;
    private OrientBaseGraph dbg;
    private ReportInfo reportInfo;
    private boolean forward;
    private Set<String> internallCalls = new HashSet<String>();
    private Set<List<Pair<Long, Long>>> pathsWhenCycle = new HashSet<List<Pair<Long, Long>>>();
    private static final String COLOCATED_LBL = Messages.getString(ReportPathHandler.class, "col.lbl");
    private static final String PARENT_OF_LBL = Messages.getString(ReportPathHandler.class, "ParentOf.lbl");
    private static final String FORM_PAR_LBL = Messages.getString(ReportPathHandler.class, "form.param.lbl");
    private static final String ACT_PAR_LBL = Messages.getString(ReportPathHandler.class, "act.param.lbl");
    private static final String CALL_PROC_LBL = Messages.getString(ReportPathHandler.class, "call.proc.lbl");
    private static final String PROC_DEF_LBL = Messages.getString(ReportPathHandler.class, "proc.def.lbl");
    private static final String PRG_ARG_LBL = Messages.getString(ReportPathHandler.class, "prg.arg.lbl");
    private static final String CALL_PAR_LBL = Messages.getString(ReportPathHandler.class, "call.par.lbl");
    private static final String CALL_PRG_LBL = Messages.getString(ReportPathHandler.class, "call.prg.lbl");
    private static final String PRG_DEF_LBL = Messages.getString(ReportPathHandler.class, "prg.def.lbl");
    private static final String CALLLED_PROC_LBL = Messages.getString(ReportPathHandler.class, "called.proc.lbl");
    private static final String NA_LBL = Messages.getString(ReportPathHandler.class, "notAvailable");
    private static final String CALLED_PRG_LBL = Messages.getString(ReportPathHandler.class, "called.prg.lbl");
    private static final String PRG_LBL = Messages.getString(ReportPathHandler.class, "prg.lbl");
    private static final String FUNCCALL_LBL = Messages.getString(ReportPathHandler.class, "funccall.lbl");
    private static final String COMMA = ",";
    private static final String NAME = "name";
    private static final String IMPACT = "impact";
    private static final String FROM_USAGE = "fromUsage";
    private static final String TYPE = "type";
    private static final String STMT = "stmt";
    private static final String SIN_CB = "SinCB";
    private static final String RELATION = "relation";
    private static final String RESOURCE_LINK = "ResourceLink";
    private static final String TO_USAGE = "toUsage";
    private static final String VIN_CB = "VinCB";
    private static final String CALLED_BLOCK = "calledBlock";
    private static final String HAS_VAR_PARAM = "hasVarParam";
    private static final String FROM_V_NAME = "fromVName";
    private static final String FROM_V_ID = "fromVId";
    private static final String TO_V_NAME = "toVName";
    private static final String TO_V_ID = "toVId";
    private static final String FROM_NAME = "fromName";
    private static final String FROM_ID = "fromId";
    private static final String TO_NAME = "toName";
    private static final String TO_ID = "toId";
    private static final String ACTUAL_PARAM_USAGE_INFO = "ActualParamUsageInfo";

    public ReportPathHandler(OrientBaseGraph dbg, ImpactGraph ig, ReportInfo reportInfo, boolean forward) {
        this.ig = ig;
        this.dbg = dbg;
        this.reportInfo = reportInfo;
        this.forward = forward;
    }

    @Override
    public void addPathInfo(Object o) {
        this.internallCalls.add((String)o);
    }

    @Override
    public void handlePath(List<Pair<Long, Long>> nodes, Pair<Long, Long> entryCycleNode) {
        if (entryCycleNode != null) {
            if (this.pathsWhenCycle.contains(nodes)) {
                L.info("same path restricted at cycle node was expanded before; skip it");
                return;
            }
            this.pathsWhenCycle.add(nodes);
        }
        ArrayList<String[]> pathInfo = new ArrayList<String[]>();
        String currentVarRid = null;
        boolean lastIsDs = false;
        for (Pair<Long, Long> t : nodes) {
            Long eid = (Long)t.getSecond();
            Link edge = this.ig.getLink(eid);
            if (edge == null) {
                Node node = this.ig.getNode((Long)t.getFirst());
                if (nodes.size() == 1 && "Variable".equals(node.value().getVertexClass())) {
                    OrientVertex fv = this.dbg.getVertex((Object)node.value().id());
                    Pair<String, String> pairCb = ReportPathHandler.getCBNameForVar(fv);
                    this.reportInfo.addToFinalVariables((Vertex)fv, node.value().getVertexName(), null, (String)pairCb.getSecond());
                    this.reportInfo.addToPrograms((Vertex)this.dbg.getVertex(pairCb.getFirst()));
                }
                this.makePathToMissingPrg(pathInfo, node);
                continue;
            }
            Node fNode = this.ig.getNode(edge.from());
            Value fValue = fNode.value();
            Node tNode = this.ig.getNode(edge.to());
            Value tValue = tNode.value();
            if ("DSName".equals(fValue.getVertexClass())) {
                currentVarRid = this.makeSegmentFromDS(pathInfo, fValue, tValue, edge);
                lastIsDs = "DSName".equals(tValue.getVertexClass());
                this.reportInfo.addToTempVarInPrograms(currentVarRid);
                continue;
            }
            Set dflows = (Set)edge.info("nodeORID");
            OrientElement dfEl = this.dbg.getElement(dflows.iterator().next());
            boolean isDf = dfEl.getLabel().equals("DataFlow");
            if (isDf || dfEl.getLabel().equals("Variable")) {
                String[] off;
                String impactType;
                String fChildName;
                String dirEdge = (String)edge.info("redefDir");
                String redefEdgeRid = (String)edge.info("redefEdge");
                OrientVertex fChildV = null;
                fChildV = isDf ? ((OrientEdge)dfEl).getVertex(this.forward ? Direction.OUT : Direction.IN) : (redefEdgeRid != null ? this.dbg.getEdge((Object)redefEdgeRid).getVertex("Direct Redefine".equals(dirEdge) ? Direction.OUT : Direction.IN) : this.dbg.getVertex((Object)fValue.id()));
                String fChildVId = fChildV.getId().toString();
                String fPrgName = (String)fValue.getContext("programName");
                if (fPrgName == null) {
                    fPrgName = (String)tValue.getContext("programName");
                }
                if (currentVarRid != null && currentVarRid.equals(fChildVId)) {
                    currentVarRid = this.processToNode(pathInfo, null, null, (Vertex)fChildV, edge, tValue, dfEl);
                } else if (currentVarRid != null) {
                    fChildName = null;
                    if ("Variable".equals(fValue.getVertexClass())) {
                        impactType = this.computeImpactType(fChildVId, currentVarRid);
                        fChildName = Utils.translateOffToVarChild((Vertex)fChildV, fValue, false);
                        if (fChildName == null) {
                            off = ((String)((Map)edge.info(IMPACT)).get(dfEl.getId().toString())).split(COMMA);
                            fChildName = Utils.getDisplayNameForVariable((String)fChildV.getProperty(NAME), null, 0, Integer.valueOf(off[0]), Integer.valueOf(off[1]));
                        }
                        this.addToPathInfo(pathInfo, fChildName, (Vertex)fChildV, impactType, fChildVId);
                        this.reportInfo.addToTempVarInPrograms(fChildVId);
                    }
                    currentVarRid = this.processToNode(pathInfo, fChildName, fPrgName, (Vertex)fChildV, edge, tValue, dfEl);
                } else {
                    fChildName = null;
                    if ("Variable".equals(fValue.getVertexClass()) && !fChildVId.equals(fValue.id())) {
                        impactType = this.computeImpactType(fChildVId, fValue.id());
                        fChildName = Utils.translateOffToVarChild((Vertex)fChildV, fValue, false);
                        if (fChildName == null) {
                            off = ((String)((Map)edge.info(IMPACT)).get(dfEl.getId().toString())).split(COMMA);
                            fChildName = Utils.getDisplayNameForVariable((String)fChildV.getProperty(NAME), null, 0, Integer.valueOf(off[0]), Integer.valueOf(off[1]));
                        }
                        String fName = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, fValue, fValue.getVertexClass(), true, true);
                        this.addToPathInfo(pathInfo, fName, fPrgName, fChildVId, fChildName, (Vertex)fChildV, impactType, fChildVId);
                        this.reportInfo.addToTempVarInPrograms(fChildVId);
                        currentVarRid = this.processToNode(pathInfo, null, null, null, edge, tValue, dfEl);
                    } else {
                        fChildName = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, fValue, fValue.getVertexClass(), true, false);
                        currentVarRid = this.processToNode(pathInfo, fChildName, fPrgName, (Vertex)fChildV, edge, tValue, dfEl);
                    }
                }
            } else if (dfEl.getLabel().equals("varParam")) {
                currentVarRid = this.processInternalCall(edge, currentVarRid, fValue, tValue, pathInfo, dfEl);
            } else if (edge.info("return stmt from internal call") != null) {
                currentVarRid = this.processReturnStmt(edge, currentVarRid, fValue, tValue, pathInfo, dfEl);
            } else if (dfEl.getLabel().equals(ACTUAL_PARAM_USAGE_INFO)) {
                currentVarRid = this.processCall(edge, currentVarRid, fValue, tValue, pathInfo, dfEl);
            } else if (dfEl.getLabel().equals("DDCard")) {
                String dsListableName = Utils.getDSListableName(tValue.getVertexName());
                String jobInfo = this.getJobInfo(dfEl.getId().toString());
                String name = Messages.getString(ReportPathHandler.class, "name.concat", new String[]{dsListableName, jobInfo});
                this.addToPathInfo(pathInfo, name, (Vertex)dfEl, Messages.getString(ReportPathHandler.class, "ddcard.lbl", new String[]{fValue.getVertexName()}), name);
                lastIsDs = true;
            }
            this.makePathToMissingPrg(pathInfo, tNode);
        }
        this.reportInfo.addToPathsInfo(pathInfo, lastIsDs);
        this.internallCalls.clear();
    }

    private String getJobInfo(String ddcardRid) {
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select $s.name as step, $s.in('Steps')[0].name as jobName, $s.in('Steps')[0].member as jobMember from @@@@@EZLEGACY@@@@ \nlet $s = in('UsesDD')[0]".replace("@@@@@EZLEGACY@@@@", ddcardRid))).execute(new Object[0]);
        Iterator iterator = ret.iterator();
        String info = null;
        if (iterator.hasNext()) {
            OrientElement oe = (OrientElement)iterator.next();
            String jobName = (String)oe.getProperty("jobName");
            String jobMember = (String)oe.getProperty("jobMember");
            if (jobMember != null && !jobMember.isEmpty() && !jobMember.equals(jobName)) {
                jobName = String.valueOf(jobName) + "(" + jobMember + ")";
            }
            info = String.valueOf(jobName) + "/" + oe.getProperty("step");
        }
        return info;
    }

    public void makePathToMissingPrg(List<String[]> pathInfo, Node node) {
        Set missingPrg = (Set)node.value().getContext("MISSING_PRG_CALLS");
        if (missingPrg != null) {
            for (String rid : missingPrg) {
                OrientVertex dfEl = this.dbg.getVertex((Object)rid);
                Edge usesAPEdge = (Edge)dfEl.getEdges(Direction.IN, new String[]{"UsesAP"}).iterator().next();
                Vertex callV = usesAPEdge.getVertex(Direction.OUT);
                Iterator paramProxyIt = dfEl.getVertices(Direction.OUT, new String[]{"ActualParameter"}).iterator();
                if (!paramProxyIt.hasNext()) continue;
                Vertex paramProxyV = (Vertex)paramProxyIt.next();
                Iterator prgProxyIt = paramProxyV.getVertices(Direction.OUT, new String[]{"ParameterOf"}).iterator();
                Iterator fromVarIt = dfEl.getVertices(Direction.OUT, new String[]{"APDefinedBy"}).iterator();
                if (prgProxyIt.hasNext() && fromVarIt.hasNext()) {
                    Vertex prgProxyV = (Vertex)prgProxyIt.next();
                    ArrayList pathInfoClone = (ArrayList)((ArrayList)pathInfo).clone();
                    String toPrgRid = String.valueOf(prgProxyV.getId());
                    String toPrgName = (String)prgProxyV.getProperty(NAME);
                    OrientVertex fromVarV = (OrientVertex)fromVarIt.next();
                    Pair<String, String> fPairCb = ReportPathHandler.getCBNameForVar(fromVarV);
                    String fromPrgRid = (String)fPairCb.getFirst();
                    String fromPrgName = (String)fPairCb.getSecond();
                    this.addToPathInfo(pathInfoClone, node.value().getVertexName(), fromPrgName, node.value().id(), String.valueOf(toPrgName) + PRG_LBL, callV, CALLED_PRG_LBL, toPrgRid);
                    String[] stringArray = new String[11];
                    stringArray[0] = fromPrgRid;
                    stringArray[1] = fromPrgName;
                    stringArray[2] = toPrgRid;
                    stringArray[3] = toPrgName;
                    stringArray[4] = "1";
                    stringArray[5] = String.valueOf(fromVarV.getId());
                    stringArray[6] = (String)fromVarV.getProperty(NAME);
                    stringArray[8] = NA_LBL;
                    this.reportInfo.addToTempProgCallsInfo(stringArray);
                    this.reportInfo.addProxyToPrograms(prgProxyV);
                    this.reportInfo.addToPrograms((Vertex)this.dbg.getVertex((Object)fromPrgRid));
                    this.reportInfo.addToPathsInfo(pathInfoClone, false);
                    continue;
                }
                L.debug("not enough information; skip call" + rid);
            }
        }
    }

    private String makeSegmentFromDS(List<String[]> pathInfo, Value fValue, Value tValue, Link edge) {
        String fPrgName;
        String fName = this.processDS(fValue);
        String fvRid = fValue.id();
        String tName = null;
        String lastid = tValue.id();
        if ("DSName".equals(tValue.getVertexClass())) {
            lastid = tName = this.processDS(tValue);
        } else {
            tName = tValue.getVertexName();
        }
        String dfImpactType = (String)edge.info("link");
        Set dflows = (Set)edge.info("nodeORID");
        OrientVertex stmtV = null;
        if (dflows != null) {
            OrientElement dfEl = this.dbg.getElement(dflows.iterator().next());
            stmtV = (OrientVertex)((OrientVertex)dfEl.getProperty(FROM_USAGE)).getVertices(Direction.IN, new String[0]).iterator().next();
            dfImpactType = (String)stmtV.getProperty(TYPE);
        }
        if ((fPrgName = (String)fValue.getContext("programName")) == null) {
            fPrgName = (String)tValue.getContext("programName");
        }
        this.addToPathInfo(pathInfo, fName, fPrgName, fvRid, tName, (Vertex)stmtV, dfImpactType, lastid);
        return tValue.id();
    }

    public String processDS(Value fValue) {
        OrientVertex dsV = this.dbg.getVertex((Object)fValue.id());
        Vertex ddV = (Vertex)dsV.getVertices(Direction.IN, new String[]{"MappedTo"}).iterator().next();
        Vertex stepV = (Vertex)ddV.getVertices(Direction.IN, new String[]{"UsesDD"}).iterator().next();
        Vertex jobV = (Vertex)stepV.getVertices(Direction.IN, new String[]{"Steps"}).iterator().next();
        String dsListableName = Utils.getDSListableName(fValue.getVertexName());
        String type = Utils.getNodeLabel(fValue.getVertexClass(), true);
        String jobInfo = Messages.getString(ReportPathHandler.class, "job.concat", new String[]{(String)jobV.getProperty(NAME), (String)stepV.getProperty(NAME)});
        String fName = Messages.getString(ReportPathHandler.class, "name.concat", new String[]{Messages.getString(ReportPathHandler.class, "name.concat", new String[]{dsListableName, jobInfo}), type});
        return fName;
    }

    private String processReturnStmt(Link edge, String currentVarRid, Value fValue, Value tValue, List<String[]> pathInfo, OrientElement dfEl) {
        if (!this.forward) {
            Vertex callStmt;
            OrientVertex fv = this.dbg.getVertex((Object)fValue.id());
            if (currentVarRid != null && !currentVarRid.equals(fValue.id())) {
                String impactType = this.computeImpactType(fValue.id(), currentVarRid);
                this.addToPathInfo(pathInfo, fValue.getVertexName(), (Vertex)fv, impactType, fValue.id());
                this.reportInfo.addToTempVarInPrograms(fValue.id());
            }
            String fName = fValue.getVertexName();
            Pair<String, String> fPairCb = ReportPathHandler.getCBNameForVar(fv);
            OrientVertex tv = this.dbg.getVertex((Object)tValue.id());
            Pair<String, String> tPairCb = ReportPathHandler.getCBNameForVar(tv);
            Set varParams = (Set)edge.info("contextVarParams");
            Vertex vertex = callStmt = varParams != null ? this.searchCallStmt((String)varParams.iterator().next()) : null;
            if (callStmt == null) {
                callStmt = this.dbg.getVertex(tPairCb.getFirst());
            }
            String retLbl = Messages.getString(ReportPathHandler.class, "return.lbl", new String[]{(String)tPairCb.getSecond()});
            this.addToPathInfo(pathInfo, fName, (String)fPairCb.getSecond(), fValue.id(), retLbl, callStmt, (String)callStmt.getProperty(TYPE), null);
            this.addToPathInfo(pathInfo, tValue.getVertexName(), (Vertex)((OrientVertex)dfEl), (String)dfEl.getProperty(TYPE), tValue.id());
            this.reportInfo.addToTempVarInPrograms(tValue.id());
            currentVarRid = tValue.id();
        } else if (currentVarRid != null) {
            OrientVertex fv = this.dbg.getVertex((Object)fValue.id());
            Pair<String, String> fPairCb = ReportPathHandler.getCBNameForVar(fv);
            OrientVertex tv = this.dbg.getVertex((Object)tValue.id());
            Pair<String, String> tPairCb = ReportPathHandler.getCBNameForVar(tv);
            String tName = tValue.getVertexName();
            if ("varParam".equals(edge.info("isVarOrExprParamFromInternalCall"))) {
                OrientVertex retStmtV = (OrientVertex)dfEl;
                String cbName = (String)((Vertex)retStmtV.getVertices(Direction.OUT, new String[]{SIN_CB}).iterator().next()).getProperty(NAME);
                String varParam = (String)edge.info("VARPARAM");
                Vertex callStmtV = varParam != null ? this.searchCallStmt(varParam) : null;
                String retLbl = Messages.getString(ReportPathHandler.class, "return.lbl", new String[]{cbName});
                this.addToPathInfo(pathInfo, retLbl, (Vertex)retStmtV, (String)dfEl.getProperty(TYPE), null);
                this.addToPathInfo(pathInfo, tName, callStmtV, (String)callStmtV.getProperty(TYPE), tValue.id());
            } else {
                Vertex callStmt;
                String retLbl = Messages.getString(ReportPathHandler.class, "return.lbl", new String[]{(String)fPairCb.getSecond()});
                this.addToPathInfo(pathInfo, retLbl, (Vertex)((OrientVertex)dfEl), (String)dfEl.getProperty(TYPE), null);
                Set varParams = (Set)edge.info("contextVarParams");
                Vertex vertex = callStmt = varParams != null ? this.searchCallStmt((String)varParams.iterator().next()) : null;
                if (callStmt == null) {
                    callStmt = this.dbg.getVertex(tPairCb.getFirst());
                }
                this.addToPathInfo(pathInfo, (String)tPairCb.getSecond(), callStmt, FUNCCALL_LBL, (String)tPairCb.getFirst());
                this.addToPathInfo(pathInfo, tName, (Vertex)tv, FORM_PAR_LBL, tValue.id());
            }
            this.reportInfo.addToTempVarInPrograms(tValue.id());
            currentVarRid = tValue.id();
        } else {
            L.warn("return statement cannot be first segment on the path");
        }
        return currentVarRid;
    }

    private Vertex searchCallStmt(String varParamOrExpPramRid) {
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select @rid as stmt from (traverse in() from @@@@@EZLEGACY@@@@ ) where @class = 'Statement'".replace("@@@@@EZLEGACY@@@@", varParamOrExpPramRid))).execute(new Object[0]);
        Iterator iterator = ret.iterator();
        OrientVertex callStmt = null;
        if (iterator.hasNext()) {
            callStmt = this.dbg.getVertex(((OrientElement)iterator.next()).getProperty(STMT));
        } else {
            L.warn("return stmt couldn't find call statement; use instead procedure definition {}", (Object)varParamOrExpPramRid);
        }
        return callStmt;
    }

    private String processCall(Link edge, String currentVarRid, Value fValue, Value tValue, List<String[]> pathInfo, OrientElement dfEl) {
        boolean reverseCallDirection = false;
        if (edge.info("reverse impact direction") != null) {
            reverseCallDirection = (Boolean)edge.info("reverse impact direction");
        }
        boolean isReverse = this.forward && reverseCallDirection || !this.forward && !reverseCallDirection;
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select $scall.@rid.asString() as fromId, $scall.name as fromName, $param.out('VinCB')[0].@rid.asString() as toId,  $pCalled.name as toName,  out('APDefinedBy')[0].@rid.asString() as fromVId, out('APDefinedBy')[0].name as fromVName,  $param.@rid.asString() as toVId, $param.name as toVName  from @@@@@EZLEGACY@@@@ let $scall = in('UsesAP')[0].out('SinCB')[0].in('HasCB')[0].out('HasCB')[ordinalNumber = 1],  $param = out('ActualParameter')[0].out('ProxyFor')[0],  $pCalled = out('ActualParameter')[0].out('ParameterOf')[0]".replace("@@@@@EZLEGACY@@@@", dfEl.getId().toString()))).execute(new Object[0]);
        Iterator iterator = ret.iterator();
        Edge usesAPEdge = (Edge)((OrientVertex)dfEl).getEdges(Direction.IN, new String[]{"Uses"}).iterator().next();
        Vertex callV = usesAPEdge.getVertex(Direction.OUT);
        OrientVertex fv = this.dbg.getVertex((Object)fValue.id());
        OrientVertex tv = this.dbg.getVertex((Object)tValue.id());
        if (isReverse) {
            if (iterator.hasNext()) {
                OrientElement oe = (OrientElement)iterator.next();
                int voff = (Integer)fValue.getContext("memOffset");
                int varIOff = (Integer)fValue.getContext("impactedOffset");
                int varISize = (Integer)fValue.getContext("impactedSize");
                String soff = String.valueOf(voff + varIOff);
                String eoff = String.valueOf(varISize);
                this.reportInfo.addToTempProgCallsInfo(new String[]{(String)oe.getProperty(TO_ID), (String)oe.getProperty(TO_NAME), (String)oe.getProperty(FROM_ID), (String)oe.getProperty(FROM_NAME), "!1", (String)oe.getProperty(TO_V_ID), (String)oe.getProperty(TO_V_NAME), (String)oe.getProperty(FROM_V_ID), (String)oe.getProperty(FROM_V_NAME), soff, eoff});
            }
            String fPrgName = (String)fValue.getContext("programName");
            String tPrgName = (String)tValue.getContext("programName");
            if (currentVarRid != null && !currentVarRid.equals(fValue.id())) {
                String impactType = this.computeImpactType(fValue.id(), currentVarRid);
                this.addToPathInfo(pathInfo, fValue.getVertexName(), (Vertex)fv, impactType, fValue.id());
                this.reportInfo.addToTempVarInPrograms(fValue.id());
            }
            String fName = fValue.getVertexName();
            this.addToPathInfo(pathInfo, fName, fPrgName, fValue.id(), fPrgName, (Vertex)fv, PRG_DEF_LBL, null);
            this.addToPathInfo(pathInfo, tPrgName, callV, CALL_PRG_LBL, null);
            this.addToPathInfo(pathInfo, tValue.getVertexName(), (Vertex)tv, CALL_PAR_LBL, tValue.id());
        } else {
            if (iterator.hasNext()) {
                OrientElement oe = (OrientElement)iterator.next();
                int voff = (Integer)fValue.getContext("memOffset");
                int varIOff = (Integer)fValue.getContext("impactedOffset");
                int varISize = (Integer)fValue.getContext("impactedSize");
                String soff = String.valueOf(voff + varIOff);
                String eoff = String.valueOf(varISize);
                this.reportInfo.addToTempProgCallsInfo(new String[]{(String)oe.getProperty(FROM_ID), (String)oe.getProperty(FROM_NAME), (String)oe.getProperty(TO_ID), (String)oe.getProperty(TO_NAME), "1", oe.getProperty(FROM_V_ID).toString(), (String)oe.getProperty(FROM_V_NAME), oe.getProperty(TO_V_ID).toString(), (String)oe.getProperty(TO_V_NAME), soff, eoff});
            }
            String fPrgName = (String)fValue.getContext("programName");
            String tPrgName = (String)tValue.getContext("programName");
            Pair<String, String> tCBPair = ReportPathHandler.getCBNameForVar(tv);
            String tPrgRid = tCBPair != null ? (String)tCBPair.getFirst() : null;
            String tName = tValue.getVertexName();
            if (currentVarRid != null && !currentVarRid.equals(fValue.id())) {
                String impactType = this.computeImpactType(fValue.id(), currentVarRid);
                this.addToPathInfo(pathInfo, fValue.getVertexName(), (Vertex)fv, impactType, fValue.id());
                this.reportInfo.addToTempVarInPrograms(fValue.id());
            }
            this.addToPathInfo(pathInfo, fValue.getVertexName(), fPrgName, fValue.id(), tPrgName, callV, CALLED_PRG_LBL, tPrgRid);
            this.addToPathInfo(pathInfo, tName, (Vertex)tv, PRG_ARG_LBL, tValue.id());
        }
        currentVarRid = tValue.id();
        this.reportInfo.addToTempVarInPrograms(tValue.id());
        return currentVarRid;
    }

    private String processInternalCall(Link edge, String currentVarRid, Value fValue, Value tValue, List<String[]> pathInfo, OrientElement dfEl) {
        boolean reverseCallDirection = false;
        if (edge.info("reverse impact direction") != null) {
            reverseCallDirection = (Boolean)edge.info("reverse impact direction");
        }
        boolean isReverse = this.forward && reverseCallDirection || !this.forward && !reverseCallDirection;
        Set dflows = (Set)edge.info("nodeORID");
        OrientVertex vpV = (OrientVertex)dfEl;
        for (String vpRid : dflows) {
            if (!this.internallCalls.contains(vpRid)) continue;
            vpV = this.dbg.getVertex((Object)vpRid);
            break;
        }
        Vertex callExpV = (Vertex)vpV.getVertices(Direction.IN, new String[]{HAS_VAR_PARAM}).iterator().next();
        Vertex codeBlockV = (Vertex)callExpV.getVertices(Direction.OUT, new String[]{CALLED_BLOCK}).iterator().next();
        Vertex callStmt = this.searchCallStmt(String.valueOf(vpV.getId()));
        if (callStmt == null) {
            callStmt = codeBlockV;
        }
        String cbRid = String.valueOf(codeBlockV.getId());
        String cbName = (String)codeBlockV.getProperty(NAME);
        OrientVertex fv = this.dbg.getVertex((Object)fValue.id());
        Pair<String, String> fPairCb = ReportPathHandler.getCBNameForVar(fv);
        OrientVertex tv = this.dbg.getVertex((Object)tValue.id());
        Pair<String, String> tPairCb = ReportPathHandler.getCBNameForVar(tv);
        if (isReverse) {
            if (currentVarRid != null && !currentVarRid.equals(fValue.id())) {
                String impactType = this.computeImpactType(fValue.id(), currentVarRid);
                this.addToPathInfo(pathInfo, fValue.getVertexName(), (Vertex)fv, impactType, fValue.id());
                this.reportInfo.addToTempVarInPrograms(fValue.id());
            }
            String fName = fValue.getVertexName();
            this.addToPathInfo(pathInfo, fName, (String)fPairCb.getSecond(), fValue.id(), cbName, codeBlockV, PROC_DEF_LBL, null);
            this.addToPathInfo(pathInfo, (String)tPairCb.getSecond(), callStmt, CALL_PROC_LBL, null);
            this.addToPathInfo(pathInfo, tValue.getVertexName(), (Vertex)tv, ACT_PAR_LBL, tValue.id());
            this.reportInfo.addToTempVarInPrograms(tValue.id());
        } else {
            if (currentVarRid == null) {
                String fName = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, fValue, fValue.getVertexClass(), true, true);
                this.addToPathInfo(pathInfo, fName, (String)fPairCb.getSecond(), fValue.id(), cbName, callStmt, CALLLED_PROC_LBL, cbRid);
                this.reportInfo.addToTempVarInPrograms(fValue.id());
            } else {
                if (!currentVarRid.equals(fValue.id())) {
                    String impactType = this.computeImpactType(fValue.id(), currentVarRid);
                    this.addToPathInfo(pathInfo, fValue.getVertexName(), (Vertex)fv, impactType, fValue.id());
                    this.reportInfo.addToTempVarInPrograms(fValue.id());
                }
                this.addToPathInfo(pathInfo, cbName, callStmt, CALLLED_PROC_LBL, cbRid);
            }
            this.addToPathInfo(pathInfo, tValue.getVertexName(), (Vertex)tv, FORM_PAR_LBL, tValue.id());
            this.reportInfo.addToTempVarInPrograms(tValue.id());
        }
        currentVarRid = tValue.id();
        return currentVarRid;
    }

    public static Pair<String, String> getCBNameForVar(OrientVertex fv) {
        Vertex cbV = (Vertex)fv.getVertices(Direction.OUT, new String[]{VIN_CB}).iterator().next();
        return new Pair((Object)String.valueOf(cbV.getId()), (Object)((String)cbV.getProperty(NAME)));
    }

    private String processToNode(List<String[]> pathInfo, String fName, String fPrgName, Vertex fChildV, Link edge, Value tValue, OrientElement dfEl) {
        String currentVarRid = null;
        boolean isDf = dfEl.getLabel().equals("DataFlow");
        if ("DDNameProxy".equals(tValue.getVertexClass())) {
            Vertex fuinfo = (Vertex)dfEl.getProperty(this.forward ? TO_USAGE : FROM_USAGE);
            String type = Utils.getNodeLabel(tValue.getVertexClass(), false);
            Vertex ddProxyV = (Vertex)fuinfo.getVertices(Direction.OUT, new String[]{RESOURCE_LINK}).iterator().next();
            String ddProxyRid = String.valueOf(ddProxyV.getId());
            OrientVertex stmtV = (OrientVertex)((OrientVertex)dfEl.getProperty(FROM_USAGE)).getVertices(Direction.IN, new String[0]).iterator().next();
            String dfImpactType = (String)stmtV.getProperty(TYPE);
            String lbl = Messages.getString(ReportPathHandler.class, "name.concat", new String[]{(String)fuinfo.getProperty("localName"), type});
            this.addToPathInfo(pathInfo, fName, fPrgName, String.valueOf(fChildV.getId()), lbl, (Vertex)stmtV, dfImpactType, ddProxyRid);
        } else {
            String dfImpactType;
            String tChildName = null;
            String dirEdge = (String)edge.info("redefDir");
            String redefEdgeRid = (String)edge.info("redefEdge");
            OrientEdge redefEdge = isDf || redefEdgeRid == null ? null : this.dbg.getEdge((Object)redefEdgeRid);
            OrientVertex tChildV = null;
            tChildV = isDf ? ((OrientEdge)dfEl).getVertex(this.forward ? Direction.IN : Direction.OUT) : (redefEdgeRid != null ? redefEdge.getVertex("Direct Redefine".equals(dirEdge) ? Direction.IN : Direction.OUT) : this.dbg.getVertex((Object)tValue.id()));
            String tChildVId = tChildV.getId().toString();
            OrientVertex stmtV = null;
            stmtV = isDf ? (OrientVertex)((OrientVertex)dfEl.getProperty(FROM_USAGE)).getVertices(Direction.IN, new String[0]).iterator().next() : (redefEdge != null ? ("Direct Redefine".equals(dirEdge) ? redefEdge.getVertex(Direction.OUT) : tChildV) : tChildV);
            String string = isDf ? (String)stmtV.getProperty(TYPE) : (dfImpactType = redefEdgeRid != null ? COLOCATED_LBL : PARENT_OF_LBL);
            if ("Variable".equals(tValue.getVertexClass())) {
                boolean hasP = !tChildVId.equals(tValue.id());
                String tVarParent = null;
                if (hasP) {
                    tChildName = Utils.translateOffToVarChild((Vertex)tChildV, tValue, false);
                    if (tChildName == null) {
                        String[] off = ((String)((Map)edge.info(IMPACT)).get(dfEl.getId().toString())).split(COMMA);
                        tChildName = Utils.getDisplayNameForVariable((String)tChildV.getProperty(NAME), null, 0, Integer.valueOf(off[2]), Integer.valueOf(off[3]));
                    } else {
                        tVarParent = tValue.getVertexName();
                        this.reportInfo.addToVarParent(tChildVId, tVarParent);
                    }
                } else {
                    tChildName = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, tValue, tValue.getVertexClass(), true, false);
                }
                this.reportInfo.addToTempVarInPrograms(tChildVId);
                currentVarRid = tChildVId;
            } else {
                tChildName = Utils.getTSNodeName((OrientExtendedGraph)this.dbg, tValue, tValue.getVertexClass(), true, false);
                tChildName = Messages.getString(ReportPathHandler.class, "name.concat", new String[]{tChildName, Utils.getNodeLabel(tValue.getVertexClass(), true)});
                currentVarRid = null;
            }
            String fChildRid = fChildV != null ? String.valueOf(fChildV.getId()) : null;
            this.addToPathInfo(pathInfo, fName, fPrgName, fChildRid, tChildName, (Vertex)stmtV, dfImpactType, tChildVId);
        }
        return currentVarRid;
    }

    private void addToPathInfo(List<String[]> pathInfo, String sName, Vertex sV, String impactType, String sId) {
        if (pathInfo != null && pathInfo.size() > 0) {
            String[] previous = pathInfo.get(pathInfo.size() - 1);
            String previousName = previous[4];
            String previousRid = previous[9];
            this.addToPathInfo(pathInfo, previousName, null, previousRid, sName, sV, impactType, sId);
        }
    }

    private void addToPathInfo(List<String[]> pathInfo, String fName, String fPrgName, String fvRid, String sName, Vertex sV, String impactType, String tVarId) {
        boolean usePrevious;
        boolean bl = usePrevious = fName == null;
        if (usePrevious) {
            this.addToPathInfo(pathInfo, sName, sV, impactType, tVarId);
        } else {
            String[] info = null;
            if (sV != null) {
                TextSelectionInFile stsf = Utils.computeSourceInfoForVertex(sV);
                String[] stringArray = new String[10];
                stringArray[0] = fName;
                stringArray[1] = fPrgName;
                stringArray[3] = fvRid;
                stringArray[4] = sName;
                stringArray[5] = String.valueOf(stsf.getBounds()[0]);
                stringArray[6] = stsf.getFileName();
                stringArray[7] = Utils.getProgTypeDescription(stsf.getPrgType());
                stringArray[8] = impactType;
                stringArray[9] = tVarId;
                info = stringArray;
            } else {
                String[] stringArray = new String[10];
                stringArray[0] = fName;
                stringArray[1] = fPrgName;
                stringArray[3] = fvRid;
                stringArray[4] = sName;
                stringArray[8] = impactType;
                stringArray[9] = tVarId;
                info = stringArray;
            }
            pathInfo.add(info);
        }
    }

    private String computeImpactType(String fRid, String tRid) {
        String rel;
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select 'Redefines' as relation from ( traverse both('Redefines') from  @@@@@EZLEGACY@@@@) where @rid = ".replace("@@@@@EZLEGACY@@@@", fRid).concat(tRid))).execute(new Object[0]);
        String lbl = null;
        Iterator iterator = ret.iterator();
        if (iterator.hasNext()) {
            rel = (String)((OrientElement)iterator.next()).getProperty(RELATION);
            lbl = Messages.getString(ReportPathHandler.class, rel);
        }
        if (lbl == null || lbl.isEmpty()) {
            ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select 'ChildOf' as relation from (traverse out('ChildOf') from  @@@@@EZLEGACY@@@@ ) where @rid = ".replace("@@@@@EZLEGACY@@@@", fRid).concat(tRid))).execute(new Object[0]);
            iterator = ret.iterator();
            if (iterator.hasNext()) {
                rel = (String)((OrientElement)iterator.next()).getProperty(RELATION);
                lbl = Messages.getString(ReportPathHandler.class, rel);
            } else {
                lbl = PARENT_OF_LBL;
            }
        }
        return lbl;
    }
}

