/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact;

import com.ez.graphs.viewer.odb.impact.ReportPathHandler;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportInfo {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportInfo.class);
    private static final String VAR_PRG_QUERY = "select @rid as vId, in('HasV')[0].@rid as pId from variable where @rid in ";
    private static final String VAR_CB_QUERY = "select @rid as vId, out('VinCB')[0].@rid as pId from variable where @rid in ";
    private OrientBaseGraph dbg;
    private Map<String, List<List<String[]>>> pathsInfo = new HashMap<String, List<List<String[]>>>();
    private List<String[]> progCallsInfo = new ArrayList<String[]>();
    private List<String[]> tempProgCallsInfo = new ArrayList<String[]>();
    private Map<String, List<Pair<String, String>>> varsInPrograms = new HashMap<String, List<Pair<String, String>>>();
    private Set<String> tempVarsInPrograms = new HashSet<String>();
    private List<String[]> finalVariables = new ArrayList<String[]>();
    private Map<String, String[]> tempFinalVariables = new HashMap<String, String[]>();
    private Map<String, Map<String, Set<String>>> resourceMap = new HashMap<String, Map<String, Set<String>>>();
    private Map<String, String[]> dsDetails = new HashMap<String, String[]>();
    private List<String[]> programs = new ArrayList<String[]>();
    private Set<String> uniqueFinalVar = new HashSet<String>();
    private Set<String> uniqueProgramIds = new HashSet<String>();
    private Map<String, String> varToParents = new HashMap<String, String>();

    public ReportInfo(OrientBaseGraph dbg) {
        this.dbg = dbg;
    }

    private Map<String, String> addToVarInPrograms(Set<String> tempVarsInProgramIds) {
        Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(VAR_CB_QUERY.concat(tempVarsInProgramIds.toString()))).execute(new Object[0]);
        HashMap<String, String> varToPrg = new HashMap<String, String>();
        for (OrientElement oe : ret) {
            String vRid;
            Pair pair;
            Vertex vV = (Vertex)oe.getProperty("vId");
            Vertex pV = (Vertex)oe.getProperty("pId");
            String pid = pV.getId().toString();
            this.addToPrograms(pV);
            List<Pair<String, String>> list = this.varsInPrograms.get(pid);
            if (list == null) {
                list = new ArrayList<Pair<String, String>>();
                this.varsInPrograms.put(pid, list);
            }
            if (!list.contains(pair = new Pair((Object)(vRid = String.valueOf(vV.getId())), (Object)((String)vV.getProperty("name"))))) {
                list.add((Pair<String, String>)pair);
            }
            varToPrg.put(vRid, (String)pV.getProperty("name"));
        }
        return varToPrg;
    }

    public void addToVarParent(String vRid, String varParentName) {
        this.varToParents.put(vRid, varParentName);
    }

    public void addToTempVarInPrograms(String vId) {
        this.tempVarsInPrograms.add(vId);
    }

    public void addToPrograms(Vertex pV) {
        String pid = pV.getId().toString();
        if (!this.uniqueProgramIds.contains(pid)) {
            TextSelectionInFile tsf = Utils.computeSourceInfoForVertex(pV);
            String path = tsf.getFileName();
            String language = Utils.getProgTypeDescription(tsf.getPrgType());
            String startRow = String.valueOf(tsf.getBounds()[0]);
            this.programs.add(new String[]{(String)pV.getProperty("name"), pid, path, language, startRow});
            this.uniqueProgramIds.add(pid);
        }
    }

    public void addProxyToPrograms(Vertex pV) {
        String pid = pV.getId().toString();
        if (!this.uniqueProgramIds.contains(pid)) {
            String[] stringArray = new String[5];
            stringArray[0] = (String)pV.getProperty("name");
            stringArray[1] = pid;
            this.programs.add(stringArray);
            this.uniqueProgramIds.add(pid);
        }
    }

    public boolean addToFinalVariables(Vertex v, String name, String parentName, String prgName) {
        String id = v.getId().toString();
        boolean added = this.uniqueFinalVar.contains(id);
        if (!added) {
            TextSelectionInFile tsf = Utils.computeSourceInfoForVertex(v, true);
            String defSource = tsf.getFileName();
            String language = Utils.getProgTypeDescription(tsf.getPrgType());
            String startRow = String.valueOf(tsf.getBounds()[0]);
            this.finalVariables.add(new String[]{name, parentName, id, defSource, language, startRow, prgName, String.valueOf(tsf.getProperty("isProgramSource"))});
            this.uniqueFinalVar.add(id);
            added = true;
        }
        return added;
    }

    private void addToFinalVariables(String vId, String[] info) {
        boolean added = this.uniqueFinalVar.contains(vId);
        if (!added) {
            OrientVertex v = this.dbg.getVertex((Object)vId);
            TextSelectionInFile tsf = Utils.computeSourceInfoForVertex((Vertex)v, true);
            String defSource = tsf.getFileName();
            String language = Utils.getProgTypeDescription(tsf.getPrgType());
            String startRow = String.valueOf(tsf.getBounds()[0]);
            info[3] = defSource;
            info[4] = language;
            info[5] = startRow;
            info[7] = String.valueOf(tsf.getProperty("isProgramSource"));
            this.finalVariables.add(info);
            this.uniqueFinalVar.add(vId);
        }
    }

    public boolean addToTempFinalVariables(String varId, String name, String parentName, String prgName) {
        if (!this.tempFinalVariables.containsKey(varId)) {
            String[] stringArray = new String[8];
            stringArray[0] = name;
            stringArray[1] = parentName;
            stringArray[2] = varId;
            stringArray[6] = prgName;
            this.tempFinalVariables.put(varId, stringArray);
            return true;
        }
        return false;
    }

    public void addToResourceResults(String vertexClass, String vertexId, String prgRid) {
        Map<String, Set<String>> resourceToPrgMap = this.resourceMap.get(vertexClass);
        if (resourceToPrgMap == null) {
            resourceToPrgMap = new HashMap<String, Set<String>>();
            this.resourceMap.put(vertexClass, resourceToPrgMap);
        }
        if (prgRid != null) {
            Set<String> prgs = resourceToPrgMap.get(vertexId);
            if (prgs == null) {
                prgs = new HashSet<String>();
                resourceToPrgMap.put(vertexId, prgs);
            }
            prgs.add(prgRid);
        }
    }

    public void addToDsSet(String[] dsInfo) {
        String dsID = dsInfo[0];
        if (!this.dsDetails.containsKey(dsID)) {
            this.dsDetails.put(dsID, dsInfo);
        }
    }

    public void addToTempProgCallsInfo(String[] pCallInfo) {
        this.tempProgCallsInfo.add(pCallInfo);
    }

    private void addToProgCallsInfo() {
        this.progCallsInfo.addAll(this.tempProgCallsInfo);
    }

    public void addToPathsInfo(List<String[]> pathInfo, boolean lastIsDS) {
        if (pathInfo.size() == 0) {
            return;
        }
        String[] last = pathInfo.get(pathInfo.size() - 1);
        String id = last[last.length - 1];
        this.addToProgCallsInfo();
        Map<String, String> varToPrg = this.addToVarInPrograms(this.tempVarsInPrograms);
        List<List<String[]>> paths = this.pathsInfo.get(id);
        if (paths == null) {
            paths = new ArrayList<List<String[]>>();
            this.pathsInfo.put(id, paths);
        }
        paths.add(pathInfo);
        String rid = last[9];
        if (!lastIsDS) {
            OrientVertex v;
            String cls;
            if (rid == null) {
                L.warn("rid is null; path will be not printed");
            }
            if (!"Variable".equals(cls = (String)(v = this.dbg.getVertex((Object)rid)).getProperty("@class")) && !"ProgramProxy".equals(cls)) {
                String cbRid = null;
                if (last[3] != null) {
                    Pair<String, String> pair = ReportPathHandler.getCBNameForVar(this.dbg.getVertex((Object)last[3]));
                    cbRid = (String)pair.getFirst();
                }
                this.addToResourceResults(cls, rid, cbRid);
            }
        } else {
            String[] stringArray = new String[5];
            stringArray[0] = rid;
            stringArray[1] = rid;
            this.addToDsSet(stringArray);
        }
        for (String[] sgPath : pathInfo) {
            String vrid = sgPath[9];
            if (vrid == null || !varToPrg.containsKey(vrid) || this.tempFinalVariables.containsKey(vrid)) continue;
            OrientVertex v = this.dbg.getVertex((Object)vrid);
            this.addToTempFinalVariables(vrid, (String)v.getProperty("name"), this.varToParents.get(vrid), varToPrg.get(vrid));
        }
        for (String vId : this.tempFinalVariables.keySet()) {
            this.addToFinalVariables(vId, this.tempFinalVariables.get(vId));
        }
    }

    private Map<String, Map<String[], Set<String>>> computeAllResourceMap() {
        Map<String, Map<String[], Set<String>>> allResMap = this.computeResourceDetails(this.resourceMap);
        if (!this.dsDetails.isEmpty()) {
            if (allResMap == null) {
                allResMap = new HashMap<String, Map<String[], Set<String>>>();
            }
            HashMap<String[], Object> dsM = new HashMap<String[], Object>();
            allResMap.put("EXT_TYPE_DATASET", dsM);
            for (String[] dsdet : this.dsDetails.values()) {
                dsM.put(dsdet, null);
            }
        }
        return allResMap;
    }

    private Map<String, Map<String[], Set<String>>> computeResourceDetails(Map<String, Map<String, Set<String>>> resourceMap) {
        if (resourceMap.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String[], Set<String>>> resourceResults = new HashMap<String, Map<String[], Set<String>>>();
        for (String resType : resourceMap.keySet()) {
            Map<String, Set<String>> resourceMapPerType = resourceMap.get(resType);
            Set<String> resourceSet = resourceMapPerType.keySet();
            HashMap<String[], Set<String>> map = (HashMap<String[], Set<String>>)resourceResults.get(resType);
            if (map == null) {
                map = new HashMap<String[], Set<String>>();
                String resTypeAsInt = Utils.getResTypeAsInt(resType);
                resourceResults.put(resTypeAsInt, map);
            }
            if ("SQLFieldProxy".equals(resType)) {
                Vertex vv;
                HashSet<String> withDef = new HashSet<String>();
                Iterable ret = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL("select @rid as resRid, name, @class as resClass, $si[0].sLine as sLine, $si[0].in.full as full, $si[0].in.type.asString() from @@@@@EZLEGACY@@@@ let $si = out('FieldOf')[0].in('SIResourceLink')[0].outE('SourceInfo')  where $si.size() > 0 ".replace("@@@@@EZLEGACY@@@@", resourceSet.toString()))).execute(new Object[0]);
                for (OrientElement oe : ret) {
                    vv = (Vertex)oe.getProperty("resRid");
                    String vRid = String.valueOf(vv.getId());
                    String path = (String)oe.getProperty("full");
                    String type = (String)oe.getProperty("type");
                    if (path != null) {
                        path = path.replace("|", "\\");
                    }
                    String line = oe.getProperty("sLine") != null ? String.valueOf(oe.getProperty("sLine")) : null;
                    map.put(new String[]{vRid, Utils.getTSNodeName(vv), path, line, Utils.getProgTypeDescription(type)}, resourceMapPerType.get(vRid));
                    withDef.add(vRid);
                }
                for (String resid : resourceSet) {
                    if (withDef.contains(resid)) continue;
                    vv = this.dbg.getVertex((Object)resid);
                    String[] stringArray = new String[5];
                    stringArray[0] = resid;
                    stringArray[1] = Utils.getTSNodeName(vv);
                    map.put(stringArray, resourceMapPerType.get(resid));
                }
                continue;
            }
            for (String resid : resourceSet) {
                OrientVertex vv = this.dbg.getVertex((Object)resid);
                TextSelectionInFile tsf = Utils.computeSourceInfoForVertex((Vertex)vv);
                String path = tsf != null ? tsf.getFileName() : null;
                String line = tsf != null ? String.valueOf(tsf.getBounds()[0]) : null;
                String type = tsf != null ? Utils.getProgTypeDescription(tsf.getPrgType()) : null;
                map.put(new String[]{resid, Utils.getTSNodeName((Vertex)vv), path, line, type}, resourceMapPerType.get(resid));
            }
        }
        return resourceResults;
    }

    public Object buildInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("pathsInfo", this.pathsInfo);
        result.put("finalVariables", this.finalVariables);
        result.put("progCallsInfo", this.progCallsInfo);
        result.put("varsInProgramsInfo", this.varsInPrograms);
        result.put("programs", this.programs);
        Map<String, Map<String[], Set<String>>> allResMap = this.computeAllResourceMap();
        result.put("resourceResults", allResMap);
        return result;
    }

    public boolean containsPathTo(String id) {
        boolean alreadyAddedAPath = this.pathsInfo.keySet().contains(id);
        L.debug("path will be ignored because exists another path that reaches node with id {}", (Object)id);
        return alreadyAddedAPath;
    }
}

