/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact;

import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.viewer.odb.analysis.wizard.ExcludedResourcesFromImpactGraph;
import com.ez.graphs.viewer.odb.impact.ImpactBaseModelAnalysis;
import com.ez.graphs.viewer.odb.impact.ReportInfo;
import com.ez.graphs.viewer.odb.impact.ReportPathHandler;
import com.ez.graphs.viewer.odb.impact.ToDSExpander;
import com.ez.graphs.viewer.odb.impact.model.INodeExpander;
import com.ez.graphs.viewer.odb.impact.model.IStopTest;
import com.ez.graphs.viewer.odb.impact.model.Impact;
import com.ez.graphs.viewer.odb.impact.model.ImpactGraph;
import com.ez.graphs.viewer.odb.impact.model.Link;
import com.ez.graphs.viewer.odb.impact.model.MGUtil;
import com.ez.graphs.viewer.odb.impact.model.Node;
import com.ez.graphs.viewer.odb.impact.model.PathHandler;
import com.ez.graphs.viewer.odb.impact.model.disk.DiskGraph;
import com.ez.graphs.viewer.odb.impact.model.mem.MemGraph;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.ImpactModelObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.preferences.Utils;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientExtendedGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactBaseModelJob
extends AbstractAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactBaseModelJob.class);
    private ImpactGraph ig;
    private File dbFile = null;
    private Properties metadata = null;
    private PrintWriter impactResPW = null;
    protected OrientBaseGraph dbg;
    protected Properties env;

    public ImpactBaseModelJob(String name) {
        super(name);
    }

    public ImpactBaseModelJob(EZEntityID id) {
        super(Messages.getString(ImpactBaseModelJob.class, "jobname"));
    }

    public GraphInfo getGraphInfo() {
        return null;
    }

    public void buildComponents(Composite parent) {
    }

    public void init() {
    }

    public void markAsDirty() {
    }

    public boolean isDirty() {
        return false;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(ImpactBaseModelJob.class, "collectingData.taskName"));
        L.debug("start impact analysis {} ", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
        this.processInputs((IProgressMonitor)pmonitor.newChild(100));
        return Status.OK_STATUS;
    }

    private void processInputs(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)300);
        monitor.setTaskName(Messages.getString(ImpactBaseModelJob.class, "compute.taskName"));
        Properties env = (Properties)this.analysis.getContextValue("env");
        try {
            this.impact(env, (IProgressMonitor)monitor.newChild(300));
        }
        catch (IOException e) {
            L.error("while generating model", (Throwable)e);
        }
        monitor.setWorkRemaining(0);
    }

    private void impact(Properties env, IProgressMonitor pmonitor) throws IOException {
        boolean ignoreCancel;
        boolean continueWithReport;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
        boolean onDisk = Boolean.parseBoolean(System.getProperty("impactOnDisk", "true"));
        ImpactGraph ig = this.createImpactGraph(onDisk, false, null, this.impactResPW);
        OrientExtendedGraph graph = this.createOrientGraph(env);
        String outFile = env.getProperty("impact.outFile");
        BufferedWriter out = null;
        if (outFile != null) {
            out = new BufferedWriter(new FileWriter(outFile));
        }
        List resources = this.analysis.getContextListValue("resource_name_key");
        int maxLvl = (Integer)this.analysis.getContextValue("max cycles");
        boolean forward = (Boolean)this.analysis.getContextValue("direction");
        String program = (String)this.analysis.getContextValue("program");
        String resType = (String)this.analysis.getContextValue("res_type");
        List varIds = this.analysis.getContextListValue("var_ids_key");
        Map dalRes = (Map)this.analysis.getContextValue("dal_ids_key");
        Map bmsProxyRes = (Map)this.analysis.getContextValue("bmsproxy_ids_key");
        Map resRids = null;
        if (dalRes != null) {
            resRids = dalRes;
        } else if (bmsProxyRes != null) {
            resRids = bmsProxyRes;
        }
        String filePath = (String)this.analysis.getContextValue("excludeResFromFile");
        HashMap<String, List<?>> excludedRes = null;
        if (filePath != null) {
            excludedRes = ExcludedResourcesFromImpactGraph.readExcludedResFromFile(filePath);
        }
        boolean bl = continueWithReport = (ignoreCancel = new Impact(graph, out).doImpact(ig, new ToDSExpander(graph, forward), forward, maxLvl, resType, resources, program, varIds, resRids, false, this.dbFile, excludedRes, this.metadata, (IProgressMonitor)monitor.newChild(100))) || !monitor.isCanceled();
        if (continueWithReport) {
            ImpactModelObjectType impObj = new ImpactModelObjectType();
            List anTypeList = EZWorkspace.getInstance().getSpecificAnalysisType((EZObjectType)impObj);
            if (anTypeList != null) {
                EZAnalysisType anType = (EZAnalysisType)anTypeList.get(0);
                EZAnalysis analysisRep = anType.getImplementorInstance();
                ReportInfo reportInfo = new ReportInfo(this.dbg);
                ReportPathHandler ph = new ReportPathHandler(this.dbg, ig, reportInfo, forward);
                for (Node n : ig.getStartNodes()) {
                    this.makePaths(n.getId(), forward, ph, continueWithReport, (IProgressMonitor)monitor.newChild(100));
                }
                analysisRep.addContextValue("showResults", (Object)Boolean.TRUE);
                ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
                analysisRep.addContextValue("PROJECT_INFO", (Object)ezsourcePrj);
                analysisRep.addContextValue("input_project_names", (Object)ezsourcePrj.getName());
                analysisRep.setInputs(this.analysis.getContextListValue("input_list"));
                analysisRep.addContextValue("REPORT_INFO", reportInfo.buildInfo());
                analysisRep.addContextValue("forward", (Object)forward);
                analysisRep.addContextValue("res_type", (Object)resType);
                analysisRep.addContextValue("partialData", (Object)ignoreCancel);
                analysisRep.addContextValue("max cycles", (Object)maxLvl);
                analysisRep.addContextValue("excludedResources", excludedRes);
                if ("variable".equalsIgnoreCase(resType)) {
                    analysisRep.addContextValue("variableName", this.analysis.getContextValue("resource_name_key"));
                } else if ("dataset".equalsIgnoreCase(resType)) {
                    analysisRep.addContextValue("dataset", this.analysis.getContextValue("resource_name_key"));
                } else if ("sqlField".equalsIgnoreCase(resType)) {
                    analysisRep.addContextValue("sqlField", this.analysis.getContextValue("resource_name_key"));
                }
                ImpactBaseModelAnalysis ibma = (ImpactBaseModelAnalysis)this.analysis;
                analysisRep.addContextValue("analysis_hash_key", (Object)ibma.hash(ibma.toString()));
                analysisRep.addContextValue("impact_graph", (Object)ig);
                analysisRep.execute();
            }
        }
        if (this.impactResPW != null) {
            this.impactResPW.close();
        } else {
            L.info("the impact-results.imx wasn't created for this impact graph.");
        }
    }

    private void makePaths(Long firstNodeLong, boolean forward, PathHandler ph, boolean continueWithReport, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ArrayList<Long> startList = new ArrayList<Long>();
        startList.add(firstNodeLong);
        INodeExpander expOffs = new INodeExpander(){

            @Override
            public List<Pair<Long, Set<String>>> expand(ImpactGraph ig, boolean forward, Link startEdge, Node toExpand, Set<String> orids) {
                List<Long> nextEdges;
                List<Long> list = nextEdges = forward ? toExpand.out(1) : toExpand.in(1);
                if (startEdge == null || startEdge.info("impact") == null || !"Variable".equals(toExpand.value().getVertexClass())) {
                    ArrayList<Pair<Long, Set<String>>> ret = new ArrayList<Pair<Long, Set<String>>>();
                    Iterator<Long> iterator = nextEdges.iterator();
                    while (iterator.hasNext()) {
                        Long lId;
                        Link link = ig.getLink(lId = iterator.next());
                        Map soffMap = (Map)link.info("impact");
                        ret.add((Pair<Long, Set<String>>)new Pair((Object)lId, soffMap != null ? soffMap.keySet() : null));
                    }
                    return ret;
                }
                Map soffMap = (Map)startEdge.info("impact");
                ArrayList<Pair<Long, Set<String>>> rs = new ArrayList<Pair<Long, Set<String>>>();
                for (long lId : nextEdges) {
                    Link link = ig.getLink(lId);
                    Map offMap = (Map)link.info("impact");
                    HashSet<String> filteredOrids = new HashSet<String>();
                    for (String ckey : orids) {
                        String[] cim = ((String)soffMap.get(ckey)).split(",");
                        ArrayList<Integer> clist = new ArrayList<Integer>();
                        int i = 1;
                        while (i <= Integer.valueOf(cim[3])) {
                            clist.add(Integer.valueOf(cim[2]) + i);
                            ++i;
                        }
                        for (String key : offMap.keySet()) {
                            String[] im = ((String)offMap.get(key)).split(",");
                            ArrayList<Integer> list2 = new ArrayList<Integer>();
                            int i2 = 1;
                            while (i2 <= Integer.valueOf(im[1])) {
                                list2.add(Integer.valueOf(im[0]) + i2);
                                ++i2;
                            }
                            if (Collections.disjoint(clist, list2)) continue;
                            filteredOrids.add(key);
                        }
                    }
                    if (filteredOrids.isEmpty()) continue;
                    rs.add((Pair<Long, Set<String>>)new Pair((Object)lId, filteredOrids));
                }
                return rs;
            }
        };
        IStopTest stopTester = new IStopTest(){

            @Override
            public boolean shouldStop(Node node) {
                return false;
            }

            @Override
            public boolean handlePathOnNoExpand() {
                return true;
            }
        };
        MGUtil.uniquePathDepthFirst(startList, this.ig, true, ph, null, 1, stopTester, expOffs, null, null, continueWithReport, (IProgressMonitor)monitor.newChild(100));
    }

    protected File createDBFile() {
        File dbFile = null;
        String temp = Utils.getTemporaryFolder();
        String impResFileName = null;
        try {
            File base = new File(temp, "ig");
            base.mkdirs();
            File f = File.createTempFile("inst-", Long.toString(-System.currentTimeMillis()), base);
            f.delete();
            f.mkdirs();
            dbFile = new File(f, "ig");
            impResFileName = String.valueOf(f.getAbsolutePath()) + File.separator + "impact-results.imx";
        }
        catch (Exception e) {
            L.error("could not create temporary file in " + temp, (Throwable)e);
            throw new IllegalStateException("could not create necessary temporary folders in " + temp, e);
        }
        this.setImpactResultsFile(impResFileName);
        return dbFile;
    }

    protected void setImpactResultsFile(String impResFileName) {
        try {
            this.impactResPW = new PrintWriter(new FileWriter(impResFileName));
        }
        catch (IOException ex) {
            System.out.println("ioex when opening impact-results.imx file");
            L.warn("ioex when opening impact-results.imx file", (Throwable)ex);
        }
    }

    public ImpactGraph createImpactGraph(boolean onDisk, boolean loadFromDisk, String modelFile, PrintWriter impactResPW) {
        AtomicInteger diskCount = (AtomicInteger)this.analysis.getContextValue("disk_count");
        if (diskCount == null) {
            diskCount = new AtomicInteger();
            diskCount.set(0);
            this.analysis.addContextValue("disk_count", (Object)diskCount);
        }
        diskCount.incrementAndGet();
        if (this.ig != null) {
            throw new IllegalStateException("impact graph already instantiated");
        }
        if (onDisk) {
            if (loadFromDisk) {
                this.metadata = (Properties)this.analysis.getContextValue("metadata");
                try {
                    File f = (File)this.analysis.getContextValue("tempfile");
                    this.dbFile = new File(f, "ig");
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not continue without necessary temporary folders", e);
                }
            } else {
                this.metadata = null;
                this.dbFile = this.createDBFile();
            }
            this.ig = new DiskGraph(loadFromDisk, this.dbFile, impactResPW);
        } else {
            this.ig = new MemGraph();
        }
        return this.ig;
    }

    public OrientExtendedGraph createOrientGraph(Properties env) {
        if (this.dbg != null) {
            throw new IllegalStateException("graph already instantiated");
        }
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        this.env = env;
        return this.dbg;
    }
}

