/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.impact;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.graphs.viewer.odb.analysis.wizard.ImpactInputsFilter;
import com.ez.graphs.viewer.odb.impact.ImpactBaseModelJob;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceSQLFieldTableIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceVariableIDSg;
import com.ez.workspace.preferences.Utils;
import com.ez.workspace.utils.FileUtils;
import com.ibm.ad.internal.PasswordUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpactBaseModelAnalysis
extends AbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ImpactBaseModelAnalysis.class);
    public static final String LOAD_MODEL_FILE_KEY = "loadModelFile";
    public static final String TEMPFILE_KEY = "tempfile";
    public static final String METADATA_KEY = "metadata";
    private ImpactBaseModelJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (ImpactBaseModelJob)wk.getJob(id, ImpactBaseModelJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_IMPACT_BASE_MODEL_ANALYSIS;
    }

    public boolean scopeIsShared() {
        return false;
    }

    public void setInputs(List inputs) {
        ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
        if (inputs != null) {
            String prjName = null;
            for (Object inpObj : inputs) {
                if (inpObj instanceof EZSourceProjectInputType) {
                    prjName = ((EZSourceProjectInputType)inpObj).getName();
                    this.addContextValue("input_list", inputs);
                    ProjectInfo pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                    this.addContextValue("PROJECT_INFO", pi);
                    continue;
                }
                EZEntityID entity = ((EZObjectType)inpObj).getEntID();
                list.add(entity);
                if (entity != null) {
                    ProjectInfo pi = ((EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)).getProjectInfo();
                    this.addContextValue("PROJECT_INFO", pi);
                    prjName = pi.getName();
                }
                if (entity.getSegment(EZSourceVariableIDSg.class) == null) continue;
                this.addContextValue("targetSelectionOption", "enterVariableName");
            }
            if (!list.isEmpty()) {
                this.addContextValue("input_list", list);
            }
            this.addContextValue("input_project_names", prjName);
        }
    }

    protected void continueAnalysisForLocal() {
        this.prepareInputs();
        super.continueAnalysisForLocal();
    }

    private void prepareInputs() {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.error("graphDB is not configured!");
        } else {
            String host = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
            String port = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
            String value = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
            String odbUser = value != null ? value : "";
            value = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
            String odbPass = value != null ? value : "";
            odbPass = PasswordUtils.decrypt((String)odbPass);
            ProjectInfo ezsourcePrj = (ProjectInfo)this.getContextValue("PROJECT_INFO");
            String connection = "remote:" + host + ":" + port + "/" + ezsourcePrj.getName();
            L.debug("orientdb connection:{} with user {}", (Object)connection, (Object)odbUser);
            Properties env = new Properties();
            env.put("gdb.connection", connection);
            env.put("db", "EZ_" + ezsourcePrj.getName());
            env.put("gdb.user", odbUser);
            env.put("gdb.pass", odbPass);
            this.addContextValue("env", env);
            File f = (File)this.getContextValue(LOAD_MODEL_FILE_KEY);
            if (f != null) {
                env.put(LOAD_MODEL_FILE_KEY, f.getAbsolutePath());
            } else {
                List inputEntities = this.getContextListValue("inputEntities");
                String resourceType = (String)this.getContextValue("res_type");
                if (inputEntities != null) {
                    ArrayList<String> resNames = new ArrayList<String>();
                    for (EZEntityID id : inputEntities) {
                        EZSourceDatasetIDSg sg;
                        String name = null;
                        if ("dataset".equals(resourceType)) {
                            sg = (EZSourceDatasetIDSg)id.getSegment(EZSourceDatasetIDSg.class);
                            name = sg.getDatasetName();
                        } else if ("sqlField".equals(resourceType)) {
                            sg = (EZSourceSQLFieldTableIDSg)id.getSegment(EZSourceSQLFieldTableIDSg.class);
                            name = String.valueOf(sg.getSQLTableName()) + ":" + sg.getSQLFieldName();
                        } else if ("sqlTable".equals(resourceType)) {
                            sg = (EZSourceSQLTableIDSg)id.getSegment(EZSourceSQLTableIDSg.class);
                            name = sg.getSQLTableName();
                        } else if ("dalFile".equals(resourceType)) {
                            sg = (EZSourceDALIDSg)id.getSegment(EZSourceDALIDSg.class);
                            name = sg.getDALName();
                        } else if ("screen".equals(resourceType)) {
                            sg = (EZSourceScreenIDSg)id.getSegment(EZSourceScreenIDSg.class);
                            name = sg.getScreenName();
                        } else if ("cobolprogram".equals(resourceType)) {
                            sg = (EZSourceProgramIDSg)id.getSegment(EZSourceProgramIDSg.class);
                            name = sg.getProgramName();
                        } else if ("include".equals(resourceType)) {
                            sg = (EZSourceIncludeIDSg)id.getSegment(EZSourceIncludeIDSg.class);
                            name = sg.getIncludeName();
                        }
                        if (name == null) continue;
                        resNames.add(name);
                    }
                    this.addContextValue("resource_name_key", resNames);
                }
                env.put("res_type", resourceType);
                env.put("max cycles", this.getContextValue("max cycles"));
                env.put("direction", this.getContextValue("direction"));
                if (this.getContextValue("program") != null) {
                    env.put("program", this.getContextValue("program"));
                }
            }
            boolean loadFromDisk = false;
            String modelPath = (String)env.get(LOAD_MODEL_FILE_KEY);
            if (modelPath != null) {
                loadFromDisk = true;
            }
            if (loadFromDisk) {
                this.loadMetadata(modelPath);
            }
        }
    }

    private void loadMetadata(String modelPath) {
        String temp = Utils.getTemporaryFolder();
        try {
            Properties metadata;
            File ff;
            block14: {
                File base = new File(temp, "ig");
                base.mkdirs();
                ff = File.createTempFile("inst-", Long.toString(-System.currentTimeMillis()), base);
                ff.delete();
                ff.mkdirs();
                boolean ok = FileUtils.unZipIt((String)modelPath, (String)ff.getAbsolutePath());
                if (!ok) {
                    throw new IllegalStateException("impact model " + modelPath + " could not be read");
                }
                metadata = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = new FileInputStream(new File(ff, "metadata.properties"));
                        metadata.load(is);
                        this.putMetadataInAnalysis(metadata);
                    }
                    catch (IOException e) {
                        L.error("could not read metadata", (Throwable)e);
                        try {
                            is.close();
                        }
                        catch (Exception e2) {
                            L.error("could not close stream", (Throwable)e2);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        L.error("could not close stream", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (Exception e) {
                    L.error("could not close stream", (Throwable)e);
                }
            }
            this.addContextValue(METADATA_KEY, metadata);
            this.addContextValue(TEMPFILE_KEY, ff);
        }
        catch (Exception e) {
            L.error("could not create temporary file in {} ", (Object)temp, (Object)e);
            throw new IllegalStateException("could not create necessary temporary folders in " + temp, e);
        }
    }

    private void putMetadataInAnalysis(Properties metadata) {
        String val = metadata.getProperty("direction.forward");
        if (val == null) {
            L.warn("no direction is set!");
        } else {
            this.addContextValue("direction", Boolean.parseBoolean(val));
        }
        val = metadata.getProperty("max.level");
        if (val == null) {
            L.warn("no maxLevel is set!");
        } else {
            this.addContextValue("max cycles", Integer.parseInt(val));
        }
        val = metadata.getProperty("resourceType");
        if (val == null) {
            L.info("no resourceType is set!");
        } else {
            this.addContextValue("res_type", val);
        }
        val = metadata.getProperty("programName");
        if (val == null) {
            L.debug("no program is set!");
        } else {
            this.addContextValue("program", val);
        }
        ArrayList<String> resNames = new ArrayList<String>();
        int nr = Integer.valueOf(metadata.getProperty("resources.nr"));
        int i = 0;
        while (i < nr) {
            resNames.add(metadata.getProperty("resource." + i));
            ++i;
        }
        this.addContextValue("resource_name_key", resNames);
    }

    public boolean filterInputs() {
        boolean ret = false;
        InputsFilter iFilter = this.getInputsFilter();
        if (iFilter != null) {
            ret = iFilter.filter((AbstractAnalysis)this);
        }
        return ret;
    }

    protected InputsFilter getInputsFilter() {
        ImpactInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        L.debug("start for impact graph on resources.");
        if (inputs != null && inputs.size() >= 1) {
            iFilter = new ImpactInputsFilter(inputs, (ProjectInfo)this.getContextValue("PROJECT_INFO"));
        }
        return iFilter;
    }

    public boolean equals(Object obj) {
        ImpactBaseModelAnalysis a2;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        boolean ret = obj instanceof ImpactBaseModelAnalysis;
        if (ret && (a2 = (ImpactBaseModelAnalysis)((Object)obj)) != null) {
            byte[] a2HashKey = (byte[])a2.getContextValue("analysis_hash_key");
            byte[] hashKey = (byte[])this.getContextValue("analysis_hash_key");
            boolean isEqual = true;
            int i = 0;
            while (i < hashKey.length) {
                if (a2HashKey[i] != hashKey[i]) {
                    isEqual = false;
                    break;
                }
                ++i;
            }
            ret = isEqual;
        }
        return ret;
    }

    public String toString() {
        return "ImpactBaseModelAnalysis [ PROJECT_INFO=" + this.getContextValue("PROJECT_INFO") + "," + "resource_name_key" + "=" + this.getContextListValue("resource_name_key") + "," + "max cycles" + "=" + this.getContextValue("max cycles") + "," + "direction" + "=" + this.getContextValue("direction") + "," + "program" + "=" + this.getContextValue("program") + "," + "res_type" + "=" + this.getContextValue("res_type") + "," + "var_ids_key" + "=" + this.getContextListValue("var_ids_key") + "," + "dal_ids_key" + "=" + this.getContextListValue("dal_ids_key") + "," + "bmsproxy_ids_key" + "=" + this.getContextValue("bmsproxy_ids_key") + "," + "excludeResFromFile" + "=" + this.getContextValue("excludeResFromFile") + " ]";
    }

    public byte[] hash(String analysisContext) {
        byte[] byteHash = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            md.update(analysisContext.getBytes());
            byteHash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            L.error("Error:", (Throwable)e);
        }
        return byteHash;
    }

    protected void verifyLicenseForLocal() {
        this.continueAnalysisForLocal();
    }
}

