/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.datasetflow;

import com.ez.gdb.core.collectors.ODBDatasetCollector;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.datasetflow.SelectDatasetsAndDirectionPage;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class DatasetFlowInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    boolean isForReport = false;

    public DatasetFlowInputsFilter() {
        this(false);
    }

    protected DatasetFlowInputsFilter(boolean forReport) {
        this.isForReport = forReport;
    }

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = this.getWizardTitle();
        wizard.setWindowTitle(wizardName);
        String pageTitle = Messages.getString(DatasetFlowInputsFilter.class, "resourcesPage.title");
        String pageDesc = Messages.getString(DatasetFlowInputsFilter.class, "resourcesPage.description");
        SelectDatasetsAndDirectionPage selectDatasetsAndDirectionPage = this.isForReport ? new SelectDatasetsAndDirectionPage("programs page") : new SelectDatasetsAndDirectionPage("programs page", pageTitle, pageDesc, true, false, true);
        selectDatasetsAndDirectionPage.setErrMsgNoResource(Messages.getString(DatasetFlowInputsFilter.class, "err.message"));
        selectDatasetsAndDirectionPage.setLeftGroupLabel(Messages.getString(DatasetFlowInputsFilter.class, "av.object.type"));
        selectDatasetsAndDirectionPage.setRightGroupLabel(Messages.getString(DatasetFlowInputsFilter.class, "sel.object.type"));
        selectDatasetsAndDirectionPage.setShowAppendixValue(this.isForReport);
        PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        ODBDatasetCollector datasetCollector = new ODBDatasetCollector();
        selectDatasetsAndDirectionPage.setResourcesCollector((ResourcesCollector)datasetCollector);
        wizard.addPage((IWizardPage)selectDatasetsAndDirectionPage);
        if (!this.isForReport && System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        } else {
            SelectDatasetsAndDirectionPage selectExcludedDatasetsPage = new SelectDatasetsAndDirectionPage("Datasets to be excluded", null, Messages.getString(DatasetFlowInputsFilter.class, "excludeDatasetsPage.description"), false, false, false);
            selectExcludedDatasetsPage.setLeftGroupLabel(Messages.getString(DatasetFlowInputsFilter.class, "av.object.type"));
            selectExcludedDatasetsPage.setRightGroupLabel(Messages.getString(DatasetFlowInputsFilter.class, "sel.object.type"));
            selectExcludedDatasetsPage.setErrMsgNoResource(Messages.getString(DatasetFlowInputsFilter.class, "err.message"));
            wizard.addPage((IWizardPage)selectExcludedDatasetsPage);
        }
        return wizard;
    }

    protected String getWizardTitle() {
        return Messages.getString(DatasetFlowInputsFilter.class, "wizard.title");
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            ArrayList<EZEntityID> inputsList = new ArrayList<EZEntityID>();
            HashSet<String> inputNames = new HashSet<String>();
            ProjectInfo projectName = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectName);
            for (BaseMainframeResource4GUI inpt : selected) {
                VSAMInput vsi = (VSAMInput)inpt.getObject();
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                Integer dsID = vsi.getResourceID();
                String dsMemberName = ((MultipleVSAMInput)vsi).getMemberName();
                Integer generationNumber = vsi.getGenerationNumber();
                EZSourceDatasetIDSg dsIdSg = new EZSourceDatasetIDSg(vsi.getName(), dsID, dsMemberName, generationNumber);
                entity.addSegment((EZSegment)dsIdSg);
                inputsList.add(entity);
                inputNames.add(dsIdSg.getDatasetName());
            }
            analysis.addContextValue("input_list", inputsList);
            analysis.addContextValue("inputs name string", inputNames);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        }
    }
}

