/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.datasetflow;

import com.ez.graphs.viewer.odb.datasetflow.DSFlowResults;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.utils.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.datasetflow.DSFlowEdgeLegendInfo;
import com.ez.mainframe.gui.datasetflow.DSFlowNodeLegendInfo;
import com.ez.mainframe.gui.graphs.GraphRestrictionsLegendInfo;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphRestrictionsLegendInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFlowTSGraphBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSFlowTSGraphBuilder.class);
    private ProjectInfo project;
    private TSEGraphManager graphManager;
    Map<String, Set<TSNode>> outForGISV;
    private static final String DS_NAME_VERTEX_CLASS = "DSName";
    private Map<String, TSENode> dsNodes = new HashMap<String, TSENode>();
    Set<String> inputs;
    private TSEGraph graph;
    private Set<IGraphNodeLegendInfo> nodeTypesSetForLegend;
    Set<IGraphRestrictionsLegendInfo> restrictionTypesSetForLegend;
    private Set<IGraphEdgeLegendInfo> edgeTypesSetForLegend;
    private boolean is4Report = false;

    public DSFlowTSGraphBuilder(Runnable stopCode, TSEGraphManager gManager) {
        this.graphManager = gManager;
    }

    public DSFlowTSGraphBuilder(Runnable stopCode) {
        this(stopCode, (TSEGraphManager)new AnalysisGraphManager());
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
    }

    public boolean fillTSGraph(Set<String> inputDSNames, DSFlowResults flowResults, TSEGraph graph, IProgressMonitor pmonitor) {
        this.is4Report = true;
        return this.fillTSGraph(inputDSNames, flowResults, graph, null, pmonitor);
    }

    public boolean fillTSGraph(Set<String> inputDSNames, DSFlowResults flowResults, TSEGraph graph, Map<String, Set<TSNode>> inventoryNodes, IProgressMonitor pmonitor) {
        Map<String, Set<String>> backresults;
        boolean hasResults = false;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(DSFlowTSGraphBuilder.class, "monitor.subtask.creating"));
        this.outForGISV = inventoryNodes;
        this.graph = graph;
        this.inputs = new HashSet<String>(inputDSNames);
        Map<String, Set<String>> results = flowResults.fwResults;
        if (results != null && !results.isEmpty()) {
            hasResults = flowResults.hasResults(inputDSNames, true, false, this.is4Report);
            if (hasResults) {
                long start = System.currentTimeMillis();
                L.debug("start forward cg ts build");
                this.doDSFlowgraph(results, true, flowResults, (IProgressMonitor)monitor.newChild(100));
                L.debug("end forward tsBuild in {} ms", (Object)(System.currentTimeMillis() - start));
            }
            results = null;
        }
        if ((backresults = flowResults.bkwResults) != null && !backresults.isEmpty()) {
            hasResults = flowResults.hasResults(inputDSNames, false, true, this.is4Report);
            if (hasResults) {
                long start = System.currentTimeMillis();
                L.debug("start back cg ts build");
                this.doDSFlowgraph(backresults, false, flowResults, (IProgressMonitor)monitor.newChild(100));
                L.debug("end backward tsBuild in {} ms", (Object)(System.currentTimeMillis() - start));
            }
            backresults = null;
        }
        if (!monitor.isCanceled()) {
            Map<String, Map<String, Pair<Set<Object[]>, Integer>>> infoMap = flowResults.getDetails(true);
            if (infoMap == null || infoMap.isEmpty()) {
                infoMap = flowResults.getDetails(false);
            }
            for (String dsid : infoMap.keySet()) {
                this.getOrCreateTSNode(dsid, flowResults);
            }
        }
        L.debug("graph nodes size: {}", (Object)graph.numberOfNodes());
        L.debug("graph edges size: {}", (Object)graph.numberOfEdges());
        return hasResults;
    }

    private void doDSFlowgraph(Map<String, Set<String>> results, boolean isForward, DSFlowResults flowResults, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        for (String dsName : results.keySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            TSENode ds1Node = this.getOrCreateTSNode(dsName, flowResults);
            if (results.get(dsName) == null) continue;
            for (String dsName2 : results.get(dsName)) {
                TSENode ds2Node = this.getOrCreateTSNode(dsName2, flowResults);
                TSEEdge edge = null;
                edge = isForward ? Utils.getOrCreateEdge(this.graphManager, ds1Node, ds2Node) : Utils.getOrCreateEdge(this.graphManager, ds2Node, ds1Node);
                edge.setAttribute("Color", (Object)DSFlowEdgeLegendInfo.DATA_FLOW.getTSEColor());
                if (this.is4Report) continue;
                this.edgeTypesSetForLegend.add((IGraphEdgeLegendInfo)DSFlowEdgeLegendInfo.DATA_FLOW);
            }
        }
    }

    private TSENode getOrCreateTSNode(String dsid, DSFlowResults flowResults) {
        TSENode dsTSNode = this.dsNodes.get(dsid);
        if (dsTSNode == null) {
            dsTSNode = (TSENode)this.graph.addNode();
            String lbl = Utils.getNodeLabel(DS_NAME_VERTEX_CLASS, true);
            String listableDSName = Utils.getDSListableName(dsid);
            dsTSNode.setName((Object)listableDSName);
            this.dsNodes.put(dsid, dsTSNode);
            if (this.inputs.contains(dsid)) {
                dsTSNode.setAttribute("Fill_Color", (Object)DSFlowNodeLegendInfo.INPUT_DATASET.getTSEColor());
                dsTSNode.setAttribute("Rounded_Rectangle", (Object)"Rounded_Rectangle");
                if (!this.is4Report) {
                    this.nodeTypesSetForLegend.add((IGraphNodeLegendInfo)DSFlowNodeLegendInfo.INPUT_DATASET);
                }
            } else {
                dsTSNode.setAttribute("Fill_Color", (Object)DSFlowNodeLegendInfo.DATASET.getTSEColor());
                if (!this.is4Report) {
                    this.nodeTypesSetForLegend.add((IGraphNodeLegendInfo)DSFlowNodeLegendInfo.DATASET);
                }
            }
            if (flowResults.fwToMark != null && flowResults.fwToMark.contains(dsid) || flowResults.bkwToMark != null && flowResults.bkwToMark.contains(dsid)) {
                dsTSNode.setAttribute("node is not expanded, but can be expanded, in callgraph", (Object)Boolean.TRUE);
                dsTSNode.setAttribute("expandable node", (Object)true);
                if (!this.is4Report) {
                    this.restrictionTypesSetForLegend.add((IGraphRestrictionsLegendInfo)GraphRestrictionsLegendInfo.LIMIT_RESTRICTION);
                }
            }
            if (flowResults.excluded != null && flowResults.excluded.contains(dsid)) {
                dsTSNode.setAttribute("node with restrictions, in callgraph ", (Object)Boolean.TRUE);
                dsTSNode.setAttribute("restricted node in callgraph", (Object)true);
                if (!this.is4Report) {
                    this.restrictionTypesSetForLegend.add((IGraphRestrictionsLegendInfo)GraphRestrictionsLegendInfo.PATTERN_RESTRICTION);
                }
            }
            if (!this.is4Report) {
                Collection<Pair<Set<Object[]>, Integer>> p;
                Pair fullName = com.ez.gdb.core.utils.Utils.splitDSid((String)dsid);
                dsTSNode.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.TRUE);
                Utils.setPropertiesViewerForDatasets(dsTSNode, (String)fullName.getFirst(), (String)fullName.getSecond(), "", Messages.getString(DSFlowTSGraphBuilder.class, "dataset.resource.type"));
                Map<String, Map<String, Pair<Set<Object[]>, Integer>>> tmp = flowResults.getDetails(true);
                if (tmp == null || tmp.isEmpty()) {
                    tmp = flowResults.getDetails(false);
                }
                Map<String, Pair<Set<Object[]>, Integer>> infoMap = tmp != null ? tmp.get(dsid) : null;
                Collection<Pair<Set<Object[]>, Integer>> collection = p = infoMap != null ? infoMap.values() : null;
                if (p != null && !p.isEmpty()) {
                    Pair<EZObjectType, EZSegment> pair;
                    EZObjectType inputType;
                    Object[] info = (Object[])((Set)p.iterator().next().getFirst()).iterator().next();
                    if (info != null && (inputType = (EZObjectType)(pair = Utils.makeDatasetInput(dsid, (Integer)info[0], (String)info[1], (String)info[2])).getFirst()) != null) {
                        EZEntityID entity = new EZEntityID();
                        entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.project));
                        entity.addSegment((EZSegment)pair.getSecond());
                        inputType.setEntID(entity);
                        dsTSNode.setAttribute("APPLICABLE_INPUT", (Object)inputType);
                        inputType.addProperty("dataset from File Control Table, FCT", (Object)Boolean.FALSE);
                    }
                    if (this.outForGISV != null) {
                        this.putEntryInGraphInventory(lbl, (TSNode)dsTSNode);
                    }
                }
            }
        }
        return dsTSNode;
    }

    private void putEntryInGraphInventory(String lbl, TSNode node) {
        Set<TSNode> nodes = this.outForGISV.get(lbl);
        if (nodes == null) {
            nodes = new HashSet<TSNode>();
            this.outForGISV.put(lbl, nodes);
        }
        nodes.add(node);
    }

    public void setProject(ProjectInfo ezsourcePrj) {
        this.project = ezsourcePrj;
    }

    public void setEdgeTypes4Legend(Set<IGraphEdgeLegendInfo> edgeTypesForLegend) {
        this.edgeTypesSetForLegend = edgeTypesForLegend;
    }

    public void setNodeTypes4Legend(Set<IGraphNodeLegendInfo> nodeTypesForLegend) {
        this.nodeTypesSetForLegend = nodeTypesForLegend;
    }

    public TSEGraphManager getGraphManager() {
        return this.graphManager;
    }

    public void dispose() {
        this.clean();
        this.graphManager.dispose();
    }

    public void clean() {
        if (this.outForGISV != null) {
            this.outForGISV.clear();
            this.outForGISV = null;
        }
        if (this.inputs != null) {
            this.inputs.clear();
            this.inputs = null;
        }
        if (this.dsNodes != null) {
            this.dsNodes.clear();
        }
        if (this.nodeTypesSetForLegend != null) {
            this.nodeTypesSetForLegend.clear();
            this.nodeTypesSetForLegend = null;
        }
        if (this.edgeTypesSetForLegend != null) {
            this.edgeTypesSetForLegend.clear();
            this.edgeTypesSetForLegend = null;
        }
        this.graph = null;
    }

    public void setRestrictionNodes4Legend(Set<IGraphRestrictionsLegendInfo> restrictionTypesSetForLegend) {
        this.restrictionTypesSetForLegend = restrictionTypesSetForLegend;
    }
}

