/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.datasetflow;

import com.ez.internal.utils.Pair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFlowResults {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSFlowResults.class);
    public Map<String, Set<String>> fwResults;
    public Map<String, Set<String>> bkwResults;
    private Map<String, Map<String, Pair<Set<Object[]>, Integer>>> fwDetails;
    private Map<String, Map<String, Pair<Set<Object[]>, Integer>>> bkwDetails;
    public Set<String> fwToMark;
    public Set<String> bkwToMark;
    public Set<String> excluded = new HashSet<String>();

    public DSFlowResults() {
        this.fwResults = new HashMap<String, Set<String>>();
        this.bkwResults = new HashMap<String, Set<String>>();
        this.fwDetails = new HashMap<String, Map<String, Pair<Set<Object[]>, Integer>>>();
        this.bkwDetails = new HashMap<String, Map<String, Pair<Set<Object[]>, Integer>>>();
    }

    public void clear() {
        if (this.fwResults != null) {
            this.fwResults.clear();
            this.fwResults = null;
        }
        if (this.bkwResults != null) {
            this.bkwResults.clear();
            this.bkwResults = null;
        }
        if (this.fwDetails != null) {
            this.fwDetails.clear();
            this.fwDetails = null;
        }
        if (this.bkwDetails != null) {
            this.bkwDetails.clear();
            this.bkwDetails = null;
        }
        if (this.fwToMark != null) {
            this.fwToMark.clear();
            this.fwToMark = null;
        }
        if (this.bkwToMark != null) {
            this.bkwToMark.clear();
            this.bkwToMark = null;
        }
        if (this.excluded != null) {
            this.excluded.clear();
            this.excluded = null;
        }
    }

    public boolean isEmpty() {
        return !(this.fwResults != null && !this.fwResults.isEmpty() || this.bkwResults != null && !this.bkwResults.isEmpty());
    }

    public boolean hasResults(Set<String> inputDSNames, boolean forward, boolean backward, boolean forReport) {
        boolean ret = false;
        String inpt = inputDSNames.iterator().next();
        if (forward) {
            boolean bl = ret = this.fwResults != null && !this.fwResults.isEmpty();
            if (ret && forReport) {
                boolean bl2 = ret = this.fwResults.size() != 1 || !this.fwResults.keySet().equals(inputDSNames) || !this.fwResults.get(inpt).isEmpty();
            }
        }
        if (!(!backward || forward && ret)) {
            boolean bl = ret = this.bkwResults != null && !this.bkwResults.isEmpty();
            if (ret && forReport) {
                ret = this.bkwResults.size() != 1 || !this.bkwResults.keySet().equals(inputDSNames) || !this.bkwResults.get(inpt).isEmpty();
            }
        }
        return ret;
    }

    public void storeData(String nodeName, Object[] data, String previousNodeName, boolean forward) {
        Map<String, Map<String, Pair<Set<Object[]>, Integer>>> tmpDetails = forward ? this.fwDetails : this.bkwDetails;
        Map<String, Pair<Set<Object[]>, Integer>> v = tmpDetails.get(nodeName);
        Pair value = null;
        Set<Object[]> chains = null;
        if (v == null) {
            chains = new HashSet();
            value = new Pair(chains, (Object)new Integer(1));
            v = new HashMap<String, Pair<Set<Object[]>, Integer>>();
            v.put(previousNodeName, (Pair<Set<Object[]>, Integer>)value);
            tmpDetails.put(nodeName, v);
        } else {
            value = v.get(previousNodeName);
            if (value == null) {
                chains = new HashSet();
                value = new Pair(chains, (Object)new Integer(1));
                v.put(previousNodeName, (Pair<Set<Object[]>, Integer>)value);
            } else {
                chains = (Set)value.getFirst();
            }
        }
        if (chains == null) {
            L.debug("no chains for: {}, previous={}", (Object)nodeName, (Object)previousNodeName);
            chains = new HashSet();
            value.setFirst(chains);
        }
        boolean addIt = true;
        for (Object[] tmp : chains) {
            boolean bl = addIt = !Arrays.equals(tmp, data);
            if (!addIt) break;
        }
        if (addIt) {
            boolean isNull;
            boolean bl = isNull = data[3] == null && data[4] == null && data[5] == null;
            if (isNull) {
                boolean found = false;
                block1: for (Object[] tmp : chains) {
                    int i = 0;
                    while (i < 3) {
                        Object o1 = tmp[i];
                        Object o2 = data[i];
                        if (o1 != null && o2 != null) {
                            if (!o1.equals(o2)) {
                                found = false;
                                continue block1;
                            }
                            found = true;
                        } else {
                            found = o1 == null && o2 == null;
                        }
                        ++i;
                    }
                }
                boolean bl2 = addIt = addIt && !found;
            }
        }
        if (addIt) {
            chains.add(data);
        }
    }

    public boolean containsKey(String dsid, boolean forward) {
        return forward ? this.fwDetails.containsKey(dsid) : this.bkwDetails.containsKey(dsid);
    }

    public Map<String, Map<String, Pair<Set<Object[]>, Integer>>> getDetails(boolean forward) {
        return forward ? this.fwDetails : this.bkwDetails;
    }
}

