/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.datasetflow;

import com.ez.graphs.viewer.odb.datasetflow.DSFlowResults;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.graphs.viewer.odb.utils.DatasetUtils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFlowModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSFlowModel.class);
    private static final String USES_DD_EDGE = "UsesDD";
    private static final String MAPPED_TO_EDGE = "MappedTo";
    private static final String NODES_TO_MARK = "ezToMark";
    private static final String qry1 = "select in('ContextOf').in('InContext').out('ProxyFor').@rid.asString() as x from JCLPGM where @rid = EZ_MARKER1 ";
    private static final String qry2 = "select count(*) as c from ( select $a.prgRid as u from EZ_MARKER1 \n let $a = in('ResourceLink')[bRead= EZ_MARKER2 ] unwind u) where u in EZ_MARKER3 ";
    private static final String qry3 = "select name from Program where @rid in EZ_MARKER1 and  @rid in (  select in('ResourceLink')[bRead = EZ_MARKER2 ].in('Uses').in('HasS') from EZ_MARKER3 ) ";
    private OrientBaseGraph dbg;
    private Set<String> inputDSNames;
    private Set<String> excludedDSNames;
    private com.ez.mainframe.model.Direction direction;
    private Integer limitObj;
    DSFlowResults flowResults = new DSFlowResults();
    boolean is4Report = false;
    private boolean generateAllChains = false;
    long T1 = 0L;
    long T2 = 0L;
    long T3 = 0L;
    long T4 = 0L;
    long T5 = 0L;
    long maxT3 = 0L;
    long maxEdges = 0L;
    boolean isFakeStep = false;
    protected boolean markOnlyExpandable = false;
    private boolean showTemporaryDatasets = false;

    public DSFlowModel(OrientBaseGraph dbg, Set<String> inputDSNames, Set<String> excludedDSNames, com.ez.mainframe.model.Direction direction, Integer limitObj) {
        this.dbg = dbg;
        this.inputDSNames = inputDSNames != null ? new HashSet<String>(inputDSNames) : null;
        this.excludedDSNames = excludedDSNames != null ? new HashSet<String>(excludedDSNames) : null;
        this.direction = direction;
        this.limitObj = limitObj;
    }

    public DSFlowResults doFlow(SubMonitor pmonitor) {
        boolean backward;
        long t1 = System.currentTimeMillis();
        this.showTemporaryDatasets = PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
        boolean forward = com.ez.mainframe.model.Direction.doForward((com.ez.mainframe.model.Direction)this.direction);
        if (forward) {
            Map<String, Set<String>> results = this.doDatasetFlow(true, pmonitor.newChild(50));
            Set<String> toMark = results.remove(NODES_TO_MARK);
            if (toMark != null) {
                this.flowResults.fwToMark = toMark;
            }
            this.flowResults.fwResults = results;
        }
        if ((backward = com.ez.mainframe.model.Direction.doBackward((com.ez.mainframe.model.Direction)this.direction)) && !pmonitor.isCanceled()) {
            Map<String, Set<String>> results = this.doDatasetFlow(false, pmonitor.newChild(50));
            Set<String> toMark = results.remove(NODES_TO_MARK);
            if (toMark != null) {
                this.flowResults.bkwToMark = toMark;
            }
            this.flowResults.bkwResults = results;
        }
        L.info("doFlow() total time: {}; T1={}, T2={}, T3={}, T4={}, T5={} ({})", new Object[]{System.currentTimeMillis() - t1, this.T1, this.T2, this.T3, this.T4, this.T5, this.T1 + this.T2 + this.T3 + this.T4 + this.T5});
        L.trace("maxT3={} for {} edges", (Object)this.maxT3, (Object)this.maxEdges);
        return this.flowResults;
    }

    private Map<String, Set<String>> doDatasetFlow(boolean forward, SubMonitor pmonitor) {
        HashSet<String> allDSNames = new HashSet<String>();
        HashSet<String> dsNames = new HashSet<String>();
        dsNames.addAll(this.inputDSNames);
        HashSet<String> toMark = new HashSet<String>();
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>();
        if (this.limitObj == null || this.limitObj > 0) {
            int count = 0;
            while (!(pmonitor.isCanceled() || dsNames.isEmpty() || this.limitObj != null && count >= this.limitObj)) {
                toMark.removeAll(dsNames);
                pmonitor.setWorkRemaining(100);
                long start = System.currentTimeMillis();
                L.info("start forward {} level {} with inputs {}", new Object[]{forward, count, dsNames});
                pmonitor.subTask(Messages.getString(DSFlowModel.class, "monitor.subtask.building.data", new String[]{String.valueOf(count)}));
                Set<String> localDSNames = this.getDSInJob(this.dbg, forward, dsNames, results, false, pmonitor.newChild(90));
                if (!pmonitor.isCanceled()) {
                    allDSNames.addAll(dsNames);
                    dsNames.clear();
                    for (String dsName : localDSNames) {
                        if (allDSNames.contains(dsName)) continue;
                        boolean isExcluded = false;
                        boolean addIt = false;
                        if (this.excludedDSNames == null) {
                            addIt = true;
                        } else if (!this.excludedDSNames.contains(dsName)) {
                            addIt = true;
                        } else {
                            isExcluded = true;
                        }
                        if (addIt) {
                            dsNames.add(dsName);
                        }
                        if (!isExcluded) continue;
                        this.flowResults.excluded.add(dsName);
                    }
                    toMark.addAll(dsNames);
                    L.info("executed forward={}, level {} in {} miliseconds", new Object[]{forward, ++count, System.currentTimeMillis() - start});
                    continue;
                }
                L.info("execution canceled at level {}", (Object)count);
                break;
            }
        }
        if (!toMark.isEmpty() && this.limitObj != null) {
            L.debug("computes to mark expandeble nodes");
            results.put(NODES_TO_MARK, toMark);
            if (this.markOnlyExpandable) {
                HashMap<String, Set<String>> tmpresults = new HashMap<String, Set<String>>();
                this.isFakeStep = true;
                this.getDSInJob(this.dbg, forward, toMark, tmpresults, true, pmonitor.newChild(10));
                toMark.clear();
                toMark.addAll(tmpresults.keySet());
                this.isFakeStep = false;
            }
        }
        pmonitor.setWorkRemaining(0);
        L.trace("direction forward={}, toMark={}", (Object)forward, toMark);
        return results;
    }

    private Set<String> getDSInJob(OrientBaseGraph dbg, boolean forward, Set<String> dsNames, Map<String, Set<String>> results, boolean forMarkOnly, SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        boolean detailsStorageFw = forward;
        if (!this.is4Report) {
            detailsStorageFw = true;
        }
        HashSet<String> ret = this.isFakeStep ? null : new HashSet<String>();
        String temporaryDatasetsCondition = this.showTemporaryDatasets ? " " : " isTemp = 'false' and ";
        String markNo = String.join((CharSequence)",", Collections.nCopies(dsNames.size(), "?"));
        String query = "select dsid , in('MappedTo')[0].@rid.asString() as ddcard, generation, sid from DSName \n whereTEMP_DATASET_CONDIDTIONdsid in list ( AD_IN_LIST )";
        L.trace("executed query {}", (Object)query);
        Iterable ible = (Iterable)dbg.command((OCommandRequest)new OCommandSQL(query.replace("TEMP_DATASET_CONDIDTION", temporaryDatasetsCondition).replace("AD_IN_LIST", markNo))).execute(new Object[]{dsNames});
        HashMap<Pair, Boolean> cache = new HashMap<Pair, Boolean>();
        HashMap ctxCache = new HashMap();
        OCommandRequest req2 = null;
        OCommandRequest req3 = null;
        String dsIdToSkip = null;
        for (OrientVertex v : ible) {
            Iterable ddcardsInStep;
            Vertex stepV;
            Edge proxyForE;
            String jclPgmRid;
            if (monitor.isCanceled()) break;
            String dsid = (String)v.getProperty("dsid");
            if (dsIdToSkip != null && dsIdToSkip.equals(dsid)) continue;
            String ddcardRid = (String)v.getProperty("ddcard");
            OrientVertex ddcardV1 = dbg.getVertex((Object)ddcardRid);
            monitor.subTask(Messages.getString(DSFlowModel.class, "monitor.subtask.processing", new String[]{Utils.escapeMetaCharacters((String)dsid)}));
            boolean storeIt = true;
            if (this.is4Report) {
                Pair<Set<Object[]>, Integer> value;
                Map<String, Pair<Set<Object[]>, Integer>> res = this.flowResults.getDetails(detailsStorageFw).get(dsid);
                Pair<Set<Object[]>, Integer> pair = value = res != null ? res.get("") : null;
                if (value != null) {
                    storeIt = false;
                }
            } else {
                boolean bl = storeIt = !this.flowResults.containsKey(dsid, detailsStorageFw);
            }
            if (storeIt) {
                String generation = (String)v.getProperty("generation");
                Integer sid = (Integer)v.getProperty("sid");
                String ddName = (String)ddcardV1.getProperty("name");
                this.addDSInfo(dsid, sid, generation, ddName, detailsStorageFw);
            }
            if ((jclPgmRid = (String)(proxyForE = (Edge)ddcardV1.getEdges(Direction.IN, new String[]{"ProxyFor"}).iterator().next()).getProperty("jclPgmRid")) == null) continue;
            OrientVertex jclPgmV = dbg.getVertex((Object)jclPgmRid);
            String execPgmName = (String)jclPgmV.getProperty("name");
            if (!DatasetUtils.isUtility(execPgmName)) {
                boolean hasContext = jclPgmV.countEdges(Direction.IN, new String[]{"ContextOf"}) > 0L;
                long t1 = 0L;
                if (hasContext) {
                    Object result;
                    HashSet<String> prgRids = (HashSet<String>)ctxCache.get(jclPgmRid);
                    if (prgRids == null) {
                        prgRids = new HashSet<String>();
                        t1 = System.currentTimeMillis();
                        String qry1_ = qry1.replace("EZ_MARKER1", jclPgmRid);
                        OCommandRequest req1_ = dbg.command((OCommandRequest)new OCommandSQL(qry1_));
                        Iterable iter = (Iterable)req1_.execute(new Object[0]);
                        for (OrientVertex r : iter) {
                            OrientVertex elem = r;
                            String prgs = (String)elem.getProperty("x");
                            if (prgs == null || prgs.length() <= 2) continue;
                            String str = prgs.substring(1, prgs.length() - 1);
                            Object object = result = str.split(", ");
                            int n = ((String[])result).length;
                            int n2 = 0;
                            while (n2 < n) {
                                String p = object[n2];
                                if (!prgRids.contains(p)) {
                                    prgRids.add(p);
                                }
                                ++n2;
                            }
                        }
                        long t2 = System.currentTimeMillis();
                        long t = t2 - t1;
                        this.T1 += t;
                        ctxCache.put(jclPgmRid, prgRids);
                    }
                    boolean foundFirst = false;
                    Vertex ddNameProxy = proxyForE.getVertex(Direction.OUT);
                    boolean alreadyProcessed = false;
                    Pair pair = new Pair((Object)ddNameProxy.getId().toString(), prgRids);
                    Boolean p = (Boolean)cache.get(pair);
                    boolean bl = alreadyProcessed = p != null;
                    if (alreadyProcessed) {
                        foundFirst = p;
                    } else {
                        t1 = System.currentTimeMillis();
                        String qry2_ = qry2.replace("EZ_MARKER1", ddNameProxy.getId().toString()).replace("EZ_MARKER2", forward ? "1" : "2").replace("EZ_MARKER3", ((Object)prgRids).toString());
                        req2 = dbg.command((OCommandRequest)new OCommandSQL(qry2_));
                        Iterable iter = (Iterable)req2.execute(new Object[0]);
                        result = iter.iterator();
                        while (result.hasNext()) {
                            OrientVertex vv = (OrientVertex)result.next();
                            Long count = (Long)vv.getProperty("c");
                            if (count <= 0L) continue;
                            foundFirst = true;
                        }
                        cache.put(pair, foundFirst);
                        long t2 = System.currentTimeMillis();
                        long t = t2 - t1;
                        this.T2 += t;
                    }
                    if (!foundFirst || monitor.isCanceled()) continue;
                    Integer sLine = this.getLine((Vertex)ddcardV1);
                    Vertex stepV2 = (Vertex)ddcardV1.getVertices(Direction.IN, new String[]{USES_DD_EDGE}).iterator().next();
                    Iterable ddcardsInStep2 = stepV2.getVertices(Direction.OUT, new String[]{USES_DD_EDGE});
                    HashMap pgmCache = new HashMap();
                    t1 = System.currentTimeMillis();
                    long b = ((OrientVertex)stepV2).countEdges(Direction.OUT, new String[]{USES_DD_EDGE});
                    for (Vertex vx : ddcardsInStep2) {
                        if (monitor.isCanceled()) break;
                        boolean out = false;
                        OrientVertex ddcardv2 = (OrientVertex)vx;
                        if (!ddcardv2.getId().toString().equals(ddcardRid)) {
                            Vertex ddNameProxy2 = (Vertex)ddcardv2.getVertices(Direction.IN, new String[]{"ProxyFor"}).iterator().next();
                            HashSet<String> pgmNames = (HashSet<String>)pgmCache.get(ddNameProxy2);
                            if (pgmNames == null) {
                                pgmNames = new HashSet<String>();
                                String qry3_ = qry3.replace("EZ_MARKER2", forward ? "2" : "1").replace("EZ_MARKER3", ddNameProxy2.getId().toString());
                                String qry3__ = qry3_.replace("EZ_MARKER1", ((Object)prgRids).toString());
                                req3 = dbg.command((OCommandRequest)new OCommandSQL(qry3__));
                                Iterable iter = (Iterable)req3.execute(new Object[0]);
                                for (OrientVertex ovx : iter) {
                                    String execPgmName2 = (String)ovx.getProperty("name");
                                    pgmNames.add(execPgmName2);
                                }
                                pgmCache.put(ddNameProxy2, pgmNames);
                            }
                            String stepRid = stepV2.getId().toString();
                            Iterator iterator = pgmNames.iterator();
                            while (iterator.hasNext()) {
                                String pgm;
                                execPgmName = pgm = (String)iterator.next();
                                boolean found = this.processSecondDS(dsid, ddcardv2, ret, results, execPgmName, stepRid, sLine, detailsStorageFw);
                                if (!forMarkOnly || !found) continue;
                                results.put(dsid, null);
                                out = true;
                                dsIdToSkip = dsid;
                                break;
                            }
                        }
                        if (out) break;
                    }
                    long t2 = System.currentTimeMillis();
                    long t = t2 - t1;
                    this.maxT3 = Math.max(this.maxT3, t);
                    this.maxEdges = this.maxT3 == t ? b : this.maxEdges;
                    this.T3 += t;
                    pgmCache.clear();
                    continue;
                }
                t1 = System.currentTimeMillis();
                L.debug("execpgm {} without a PGMContext", (Object)execPgmName);
                String ddcardName1 = (String)ddcardV1.getProperty("name");
                if (DatasetUtils.isInputForUnknownPgm(forward, ddcardName1)) {
                    Integer sLine = this.getLine((Vertex)ddcardV1);
                    stepV = (Vertex)ddcardV1.getVertices(Direction.IN, new String[]{USES_DD_EDGE}).iterator().next();
                    String stepRid = stepV.getId().toString();
                    ddcardsInStep = stepV.getVertices(Direction.OUT, new String[]{USES_DD_EDGE});
                    for (Vertex vx : ddcardsInStep) {
                        if (monitor.isCanceled()) break;
                        OrientVertex ddcardv2 = (OrientVertex)vx;
                        String ddcardName2 = (String)ddcardv2.getProperty("name");
                        if (ddcardv2.getId().toString().equals(ddcardV1.getId().toString()) || !DatasetUtils.arePairForUnknownPgm(forward, ddcardName1, ddcardName2)) continue;
                        boolean found = this.processSecondDS(dsid, ddcardv2, ret, results, execPgmName, stepRid, sLine, detailsStorageFw);
                        if (!forMarkOnly || !found) continue;
                        results.put(dsid, null);
                        dsIdToSkip = dsid;
                        break;
                    }
                }
                long t2 = System.currentTimeMillis();
                long t = t2 - t1;
                this.T4 += t;
                continue;
            }
            long t1 = System.currentTimeMillis();
            String ddcardName1 = (String)ddcardV1.getProperty("name");
            L.debug("{} is a utility! Verify ddcard {}", (Object)execPgmName, (Object)ddcardName1);
            int idxCard1 = DatasetUtils.getSpecial(ddcardName1);
            if (!monitor.isCanceled() && DatasetUtils.verifyUtilityDDCard(forward, idxCard1)) {
                Integer sLine = this.getLine((Vertex)ddcardV1);
                stepV = (Vertex)ddcardV1.getVertices(Direction.IN, new String[]{USES_DD_EDGE}).iterator().next();
                String stepRid = stepV.getId().toString();
                ddcardsInStep = stepV.getVertices(Direction.OUT, new String[]{USES_DD_EDGE});
                boolean found = false;
                for (Vertex vx : ddcardsInStep) {
                    if (monitor.isCanceled()) break;
                    OrientVertex ddcardv2 = (OrientVertex)vx;
                    if (ddcardv2.getId().toString().equals(ddcardV1.getId().toString())) continue;
                    String ddcardName2 = (String)ddcardv2.getProperty("name");
                    int idxCard2 = DatasetUtils.getSpecial(ddcardName2);
                    int type = forward ? idxCard1 : idxCard2;
                    int cType = forward ? idxCard2 : idxCard1;
                    try {
                        if (!DatasetUtils.arePair(type, cType)) continue;
                        found = this.processSecondDS(dsid, ddcardv2, ret, results, execPgmName, stepRid, sLine, detailsStorageFw);
                        if (!forMarkOnly || !found) continue;
                        results.put(dsid, null);
                        dsIdToSkip = dsid;
                        break;
                    }
                    catch (Exception exception) {
                        L.debug("ddcard1={} and ddcard2={} are not pair in utility {}", new Object[]{ddcardName1, ddcardName2, execPgmName});
                    }
                }
                if (!monitor.isCanceled() && !found && (DatasetUtils.is(100, idxCard1) || DatasetUtils.is(500, idxCard1))) {
                    if (!forward) {
                        L.warn("wrong direction for type {}", (Object)idxCard1);
                    }
                    String dsid2 = "Printer";
                    if (ret != null) {
                        ret.add(dsid2);
                    }
                    Object[] data = null;
                    if (this.is4Report) {
                        Object[] objectArray = new Object[6];
                        objectArray[3] = execPgmName;
                        objectArray[4] = stepV.getId();
                        objectArray[5] = sLine;
                        data = objectArray;
                    }
                    this.putToResults(results, dsid, dsid2, null, null, data, detailsStorageFw);
                    results.put(dsid, null);
                }
            }
            long t2 = System.currentTimeMillis();
            long t = t2 - t1;
            this.T5 += t;
        }
        cache.clear();
        req2 = null;
        req3 = null;
        return ret;
    }

    private int getLine(Vertex ddcardV1) {
        int ret = 0;
        if (((OrientVertex)ddcardV1).countEdges(Direction.OUT, new String[]{"SourceInfo"}) == 0L) {
            L.warn("source info not found for ", (Object)ddcardV1.getId().toString());
        } else {
            ret = (Integer)((Edge)ddcardV1.getEdges(Direction.OUT, new String[]{"SourceInfo"}).iterator().next()).getProperty("sLine");
        }
        return ret;
    }

    private boolean processSecondDS(String dsid, OrientVertex ddcardv2, Set<String> ret, Map<String, Set<String>> results, String execPgmName, String stepRid, Integer lineInJob, boolean forward) {
        boolean has;
        boolean found = false;
        boolean bl = has = ddcardv2.countEdges(Direction.OUT, new String[]{MAPPED_TO_EDGE}) > 0L;
        if (has) {
            Vertex dsName22 = null;
            for (Vertex dsName22 : ddcardv2.getVertices(Direction.OUT, new String[]{MAPPED_TO_EDGE})) {
                if (!this.showTemporaryDatasets && ((Boolean)dsName22.getProperty("isTemp")).booleanValue()) continue;
                found = true;
                break;
            }
            if (!found) {
                return found;
            }
            String dsid2 = (String)dsName22.getProperty("dsid");
            if (ret != null) {
                ret.add(dsid2);
            }
            Object[] data = null;
            if (this.is4Report) {
                Object[] objectArray = new Object[6];
                objectArray[3] = execPgmName;
                objectArray[4] = stepRid;
                objectArray[5] = lineInJob;
                data = objectArray;
            } else {
                data = new Object[6];
            }
            this.putToResults(results, dsid, dsid2, dsName22, (String)ddcardv2.getProperty("name"), data, forward);
        }
        return found;
    }

    private void addDSInfo(String dsid, Object[] data, String previous, boolean forward) {
        this.flowResults.storeData(dsid, data, previous, forward);
    }

    private void addDSInfo(String dsid, Integer sid, String generation, String ddName, boolean forward) {
        Object[] objectArray = new Object[7];
        objectArray[0] = sid;
        objectArray[1] = generation;
        objectArray[2] = ddName;
        this.addDSInfo(dsid, objectArray, "", forward);
    }

    private void putToResults(Map<String, Set<String>> results, String dsid, String dsid2, Vertex dsNameV, String ddName, Object[] data, boolean forward) {
        Set<String> dsids2 = results.get(dsid);
        if (dsids2 == null) {
            dsids2 = new HashSet<String>();
            results.put(dsid, dsids2);
        }
        if (!this.isFakeStep) {
            dsids2.add(dsid2);
            String generation = null;
            Integer sid = null;
            if (dsNameV != null) {
                generation = (String)dsNameV.getProperty("generation");
                sid = (Integer)dsNameV.getProperty("sid");
            }
            if (data != null) {
                data[0] = sid;
                data[1] = generation;
                data[2] = ddName;
                boolean storeIt = true;
                if (this.is4Report) {
                    Pair value;
                    Map<String, Pair<Set<Object[]>, Integer>> v = this.flowResults.getDetails(forward).get(dsid2);
                    Pair pair = value = v != null ? v.get(dsid) : null;
                    if (value == null) {
                        value = new Pair(null, (Object)1);
                        if (v == null) {
                            v = new HashMap<String, Pair<Set<Object[]>, Integer>>();
                            this.flowResults.getDetails(forward).put(dsid2, v);
                        }
                        v.put(dsid, (Pair<Set<Object[]>, Integer>)value);
                    } else {
                        boolean countIt = true;
                        for (Object[] o : (Set)value.getFirst()) {
                            boolean bl = countIt = !Arrays.equals(o, data);
                            if (!countIt) break;
                        }
                        if (countIt) {
                            Integer no = (Integer)value.getSecond();
                            value.setSecond((Object)(no + 1));
                        }
                        storeIt = this.generateAllChains;
                    }
                } else {
                    boolean bl = storeIt = !this.flowResults.containsKey(dsid2, forward);
                }
                if (storeIt) {
                    L.trace("{} to {} = {}", new Object[]{dsid, dsid2, Arrays.toString(data)});
                    this.addDSInfo(dsid2, data, dsid, forward);
                } else {
                    L.trace("{} not stored from {} to {}", new Object[]{Arrays.toString(data), dsid, dsid2});
                }
            }
        }
    }

    public void dispose() {
        this.clean();
        if (this.flowResults != null) {
            this.flowResults.clear();
            this.flowResults = null;
        }
    }

    public void clean() {
        if (this.inputDSNames != null) {
            this.inputDSNames.clear();
            this.inputDSNames = null;
        }
        if (this.excludedDSNames != null) {
            this.excludedDSNames.clear();
            this.excludedDSNames = null;
        }
    }

    public static Set<String> prepareInputs(Collection<VSAMInput> inputs) {
        if (inputs == null) {
            return null;
        }
        HashSet<String> inputDSNames = new HashSet<String>();
        for (VSAMInput vsamInput : inputs) {
            String dsid = vsamInput.getName();
            String memberName = vsamInput.getMemberName();
            if (memberName != null && !memberName.isEmpty()) {
                dsid = dsid.concat("|").concat(memberName);
            }
            inputDSNames.add(dsid);
        }
        return inputDSNames;
    }

    public void setReportCongfigs(boolean is4Report, boolean generateAllChains) {
        this.is4Report = is4Report;
        this.generateAllChains = this.is4Report ? generateAllChains : false;
    }

    public void setMarkOnlyExpandable(boolean markOnlyExpandable) {
        this.markOnlyExpandable = markOnlyExpandable;
    }

    public void setShowTemporaryDatasets(boolean showTemporaryDatasets) {
        this.showTemporaryDatasets = showTemporaryDatasets;
    }
}

