/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectSingleFromListPage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectVariablePage
extends SelectSingleFromListPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SelectVariablePage.class);
    boolean filled = false;
    List<Integer> indexes = null;
    private Button filterRegExprBtn;

    public SelectVariablePage(String pageName) {
        super(pageName);
    }

    protected void createFiltersArea(Composite page) {
        this.filterComp = new Composite(page, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 5;
        gl.horizontalSpacing = 1;
        gl.marginLeft = -5;
        gl.marginRight = -5;
        gl.marginTop = 10;
        this.filterComp.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterComp.setLayoutData((Object)gd);
        Label lblImg = new Label(this.filterComp, 0);
        lblImg.setImage(findBackgrGif);
        gd = new GridData();
        gd.widthHint = 15;
        lblImg.setLayoutData((Object)gd);
        this.txtFilter = new Text(this.filterComp, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.txtFilter.setLayoutData((Object)gd);
        this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SelectVariablePage.this.filterItems();
            }
        });
        this.filterRegExprBtn = new Button(this.filterComp, 2);
        this.filterRegExprBtn.setText("(.)*");
        this.filterRegExprBtn.setToolTipText(Messages.getString(SelectVariablePage.class, "reg.expr.tooltip"));
        gd = new GridData();
        this.filterRegExprBtn.setLayoutData((Object)gd);
        this.filterRegExprBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SelectVariablePage.this.filterItems();
            }
        });
        this.createSpinner();
        this.lblFilter = new Label(this.filterComp, 131072);
        gd = new GridData();
        gd.widthHint = 35;
        gd.horizontalAlignment = 0x1000008;
        this.lblFilter.setLayoutData((Object)gd);
    }

    protected boolean checkFilter(String target, String pattern) {
        boolean res;
        block6: {
            boolean useRegEx = this.filterRegExprBtn.getSelection();
            res = false;
            if (pattern == null || target == null) {
                res = false;
            }
            if (useRegEx) {
                try {
                    Pattern.compile(pattern);
                    if (pattern.isEmpty()) {
                        res = true;
                        break block6;
                    }
                    res = Pattern.matches(pattern, target);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.txtFilter.setForeground(Display.getCurrent().getSystemColor(3));
                }
            } else {
                return super.checkFilter(target, pattern);
            }
        }
        return res;
    }

    public void fillPage() {
        ((PrepareReportWizard)this.getWizard()).runLongOperation(new PrepareReportWizard.LongOperation(){

            public void runOperation(IProgressMonitor pmonitor) throws Exception {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
                SelectVariablePage.this.getData(null, (IProgressMonitor)monitor.newChild(100));
                monitor.done();
            }

            public Wizard getWizard() {
                return SelectVariablePage.this.wizard;
            }
        });
        this.init();
        if (this.indexes != null) {
            for (int idx : this.indexes) {
                this.listControl.select(idx);
            }
        }
    }

    public void forceFillPage() {
        this.filled = false;
        this.fillPage();
    }

    protected void init() {
        super.init();
        this.indexes = null;
        ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
        this.setPageComplete(false);
    }

    protected void selectValue(int[] indexes) {
        boolean pageComplete = true;
        if (indexes.length > 0) {
            ArrayList<SelectSingleFromListPage.ListItem> sel = new ArrayList<SelectSingleFromListPage.ListItem>();
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                SelectSingleFromListPage.ListItem selItem = (SelectSingleFromListPage.ListItem)this.items.get(index);
                if (selItem.getObject() != null) {
                    sel.add(selItem);
                }
                L.debug("selected: " + selItem.getListText());
                ++n2;
            }
            if (!sel.isEmpty()) {
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, sel);
                this.setMessage(null);
            } else {
                pageComplete = false;
            }
        } else {
            pageComplete = false;
        }
        this.setPageComplete(pageComplete);
    }

    protected void selectValue(int index) {
        if (index != -1) {
            String message = this.checkSelectionOK(index);
            if (message != null) {
                this.listControl.deselectAll();
                this.setMessage(message, 2);
                index = -1;
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, null);
            } else {
                SelectSingleFromListPage.ListItem selItem = (SelectSingleFromListPage.ListItem)this.items.get(index);
                ArrayList<SelectSingleFromListPage.ListItem> list = new ArrayList<SelectSingleFromListPage.ListItem>();
                list.add(selItem);
                ((PrepareReportWizard)this.getWizard()).set(this.selectionKey, list);
                this.setMessage(null);
                L.debug("selected: " + selItem.getListText());
            }
        }
        this.setPageComplete(index != -1);
    }

    protected void createListOfInputs(Composite page) {
        this.listControl = new org.eclipse.swt.widgets.List(page, 2818);
        this.listControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = SelectVariablePage.this.listControl.getSelectionIndices();
                SelectVariablePage.this.selectValue(indexes);
            }
        });
    }
}

