/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.odb.analysis.wizard;

import com.ez.graphs.viewer.odb.analysis.wizard.ImpactGraphWizard;
import com.ez.graphs.viewer.odb.internal.Messages;
import com.ez.mainframe.projects.utils.ProjectUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadModelPage
extends WizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LoadModelPage.class);
    private File selectedFile = null;
    private String selectedPrj = null;
    private String selectedPrjVersion = null;
    private String selectedPrjUUID = null;
    private String filesPath = System.getProperty("user.home");
    private List fileList = null;
    private Composite properties = null;
    private String prjName = null;
    private String prjVersion = null;
    private String prjUUID = null;

    public LoadModelPage(String pageName, String prjName) {
        super(pageName);
        this.prjName = prjName;
        this.setTitle(Messages.getString(LoadModelPage.class, "page.title"));
        this.setDescription(Messages.getString(LoadModelPage.class, "page.description"));
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        page.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        page.setLayoutData((Object)gd);
        Composite folderArea = this.createFolderArea(page);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        folderArea.setLayoutData((Object)gd);
        Composite selectionArea = this.createSelectionArea(page);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        selectionArea.setLayoutData((Object)gd);
        this.updateFolder(new File(this.filesPath));
        this.setControl((Control)page);
    }

    private Composite createFolderArea(final Composite parent) {
        Composite folderArea = new Composite(parent, 2048);
        GridLayout gl = new GridLayout(3, false);
        folderArea.setLayout((Layout)gl);
        Label locLabel = new Label(folderArea, 0);
        locLabel.setText(Messages.getString(LoadModelPage.class, "location.label"));
        GridData gd = new GridData(32);
        locLabel.setLayoutData((Object)gd);
        final Text location = new Text(folderArea, 2048);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        location.setLayoutData((Object)gd);
        location.setText(this.filesPath);
        location.setEditable(false);
        location.setEnabled(false);
        Button browseButton = new Button(folderArea, 8);
        browseButton.setText(Messages.getString(LoadModelPage.class, "browse.button.name"));
        gd = new GridData(32);
        gd.grabExcessVerticalSpace = true;
        browseButton.setLayoutData((Object)gd);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File f;
                LoadModelPage.this.filesPath = location.getText();
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                dialog.setFilterPath(LoadModelPage.this.filesPath);
                dialog.setMessage(Messages.getString(LoadModelPage.class, "chooseImpactFolder.message"));
                dialog.setText(Messages.getString(LoadModelPage.class, "chooseImpactFolder.title"));
                String directory = dialog.open();
                if (directory != null && (f = new File(directory)).exists() && f.isDirectory()) {
                    LoadModelPage.this.filesPath = directory;
                    location.setText(LoadModelPage.this.filesPath);
                    LoadModelPage.this.updateFolder(f);
                }
            }
        });
        String[] infos = ProjectUtils.getPrjVersion((String)this.prjName);
        this.prjVersion = infos != null && infos.length > 0 ? infos[0] : null;
        this.prjUUID = infos != null && infos.length > 0 ? infos[1] : null;
        return folderArea;
    }

    private Composite createSelectionArea(Composite parent) {
        Composite selectionArea = new Composite(parent, 2048);
        GridLayout gl = new GridLayout(2, true);
        selectionArea.setLayout((Layout)gl);
        this.fileList = new List(selectionArea, 2564);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.fileList.setLayoutData((Object)gd);
        this.fileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] sel = LoadModelPage.this.fileList.getSelection();
                String fName = null;
                if (sel.length > 0) {
                    fName = sel[0];
                }
                LoadModelPage.this.updateProperties(fName);
            }
        });
        this.properties = this.createPropertiesArea(selectionArea);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.properties.setLayoutData((Object)gd);
        return selectionArea;
    }

    private void createProperty(String title, String value) {
        Label t = new Label(this.properties, 0);
        t.setText(title);
        t.setLayoutData((Object)new GridData(1));
        Text v = new Text(this.properties, 2048);
        v.setEditable(false);
        v.setText(value == null ? "" : value);
        v.setLayoutData((Object)new GridData(768));
    }

    private Composite createPropertiesArea(Composite parent) {
        Composite propertiesArea = new Composite(parent, 2048);
        GridLayout gl = new GridLayout(2, false);
        propertiesArea.setLayout((Layout)gl);
        return propertiesArea;
    }

    private void updateFolder(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            String[] files = folder.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".im");
                }
            });
            if (files == null || files.length == 0) {
                this.fileList.removeAll();
                this.setErrorMessage(Messages.getString(LoadModelPage.class, "chooseImpactFolder.noModel.error"));
                this.updateProperties(null);
            } else {
                this.setErrorMessage(null);
                this.fileList.setItems(files);
            }
        } else {
            this.fileList.removeAll();
            this.setErrorMessage(Messages.getString(LoadModelPage.class, "chooseImpactFolder.noFolder.error"));
            this.updateProperties(null);
        }
    }

    private void updateProperties(String fName) {
        final String f = fName;
        Job j = new Job(Messages.getString(LoadModelPage.class, "updateProperties.jobName")){

            public IStatus run(IProgressMonitor pmonitor) {
                final Properties p = LoadModelPage.this.loadProperties(LoadModelPage.this.filesPath, f, pmonitor);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control[] controlArray = LoadModelPage.this.properties.getChildren();
                        int n = controlArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control c = controlArray[n2];
                            c.dispose();
                            ++n2;
                        }
                        if (p.size() > 0) {
                            LoadModelPage.this.selectedFile = new File(LoadModelPage.this.filesPath, f);
                            LoadModelPage.this.selectedPrj = p.getProperty("prjName");
                            LoadModelPage.this.selectedPrjVersion = p.getProperty("prjVersion");
                            LoadModelPage.this.selectedPrjUUID = p.getProperty("prjAvatar");
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.project.label"), LoadModelPage.this.selectedPrj);
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.startImpactDate.label"), p.getProperty("startImpactDate"));
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.buildNumber.label"), LoadModelPage.this.selectedPrjVersion);
                            String propertyValue = p.getProperty("max.level");
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.level.label"), propertyValue.equalsIgnoreCase("0") ? Messages.getString(LoadModelPage.class, "property.level.unlimited.text") : propertyValue);
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.forward.label"), p.getProperty("direction.forward"));
                            LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.resourceType.label"), p.getProperty("resourceType"));
                            int resnr = Integer.parseInt(p.getProperty("resources.nr", "0"));
                            int i = 0;
                            while (i < resnr) {
                                LoadModelPage.this.createProperty(Messages.getString(LoadModelPage.class, "property.inputResource.label"), p.getProperty("resource." + i));
                                ++i;
                            }
                        } else {
                            LoadModelPage.this.selectedFile = null;
                            LoadModelPage.this.selectedPrj = null;
                            LoadModelPage.this.selectedPrjVersion = null;
                            LoadModelPage.this.selectedPrjUUID = null;
                        }
                        ((ImpactGraphWizard)LoadModelPage.this.getWizard()).set("loadModelFile", LoadModelPage.this.selectedFile);
                        LoadModelPage.this.properties.layout();
                        LoadModelPage.this.doSetPageComplete();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void doSetPageComplete() {
        if (this.selectedFile != null && this.prjName.equals(this.selectedPrj) && this.prjVersion.equals(this.selectedPrjVersion) && this.prjUUID.equals(this.selectedPrjUUID)) {
            this.setErrorMessage(null);
        } else if (this.selectedFile != null) {
            if (this.prjUUID.equals(this.selectedPrjUUID)) {
                this.setErrorMessage(Messages.getString(LoadModelPage.class, "buildVersionNotMatch.error.message", new String[]{this.prjName, this.prjVersion}));
            } else {
                this.setErrorMessage(Messages.getString(LoadModelPage.class, "projectNotMatch.error.message", new String[]{this.prjName, this.prjVersion}));
            }
        }
        this.setPageComplete(true);
    }

    private Properties loadProperties(String folder, String file, IProgressMonitor pmonitor) {
        Properties p;
        block23: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            monitor.setTaskName(Messages.getString(LoadModelPage.class, "readingProperties.taskName", new String[]{file}));
            p = new Properties();
            ZipFile zip = null;
            InputStream is = null;
            if (folder == null || file == null) {
                return p;
            }
            File f = new File(folder, file);
            if (f.exists() && f.isFile()) {
                try {
                    try {
                        zip = new ZipFile(f);
                        ZipEntry ze = zip.getEntry("metadata.properties");
                        if (ze != null && (is = zip.getInputStream(ze)) != null) {
                            p.load(is);
                        }
                    }
                    catch (Exception e) {
                        L.error("could not open file" + file, (Throwable)e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e2) {
                                L.error("could not close impact model property stream", (Throwable)e2);
                            }
                        }
                        if (zip == null) break block23;
                        try {
                            zip.close();
                        }
                        catch (IOException e3) {
                            L.error("could not close impact model file " + file, (Throwable)e3);
                        }
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            L.error("could not close impact model property stream", (Throwable)e);
                        }
                    }
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException e) {
                            L.error("could not close impact model file " + file, (Throwable)e);
                        }
                    }
                }
            }
        }
        return p;
    }
}

